// MIT License

// Copyright (c) 2019-2021 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x3
//!HOOK MAIN
//!BIND MAIN
//!SAVE conv2d_tf
//!WIDTH MAIN.w
//!HEIGHT MAIN.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (MAIN_texOff(vec2(x_off, y_off)))
vec4 hook() {
    vec4 result = mat4(-0.17498326, -0.14677401, -0.43065637, 0.10841958, 0.24096319, -0.008683959, -0.29844064, 0.3567803, 0.43360776, 0.11304715, -0.0802437, 0.190904, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, -1.0);
    result += mat4(0.24688073, 0.086462855, 0.05716678, -0.1739644, 0.3236298, 0.23382919, 0.20481811, -0.022618154, -0.336325, -0.21624258, -0.18736486, -0.14936537, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, 0.0);
    result += mat4(0.38230455, 0.410552, 0.34809712, 0.2510045, 0.30689523, 0.09889703, -0.26991332, 0.1108426, 0.5083409, 0.2854462, -0.1912902, 0.40354714, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, 1.0);
    result += mat4(0.46870667, -0.03530456, 0.13705169, -0.11884997, -0.0772201, 0.17073877, 0.03287621, -0.14975251, -0.18155691, 0.14545092, -0.1584816, 0.051269397, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, -1.0);
    result += mat4(-0.5830986, -0.009166566, 0.54358304, -0.4545001, -0.27541155, 0.6697277, -0.29205534, -0.61038095, -0.64781004, 0.32052672, 0.14704794, -0.6479083, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, 0.0);
    result += mat4(-0.04402336, 0.05461938, -0.18035333, 0.5464947, 0.21475682, -0.6899343, 0.49390903, 0.62440956, 0.75365967, -0.26500008, 0.59187347, 0.10037025, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, 1.0);
    result += mat4(-0.25319895, -0.1764162, -0.22574338, 0.03075524, -0.29618785, -0.491323, 0.008427114, -0.363144, -0.17214127, -0.11891048, -0.19321653, -0.13424487, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, -1.0);
    result += mat4(0.17425235, 0.07049646, -0.1759216, 0.05697634, -0.39496303, 0.35450256, -0.09984144, 0.15470548, -0.03375828, 0.06442114, 0.14598753, 0.46114844, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, 0.0);
    result += mat4(-0.19262458, -0.17141157, -0.11393742, -0.07778959, -0.006366565, -0.16713034, 0.2135569, 0.23494779, -0.37996295, -0.2767951, -0.1515432, -0.110363424, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, 1.0);
    result += vec4(0.010385515, 0.011541315, -0.002942497, -0.00020902864);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x3
//!HOOK MAIN
//!BIND MAIN
//!SAVE conv2d_tf1
//!WIDTH MAIN.w
//!HEIGHT MAIN.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (MAIN_texOff(vec2(x_off, y_off)))
vec4 hook() {
    vec4 result = mat4(0.8031736, -0.1500194, -0.23398483, -0.060760673, 0.5049785, -0.099199474, -0.035531044, 0.0310586, -0.0310334, 0.15932913, 0.08973915, 0.08766925, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, -1.0);
    result += mat4(-0.2187303, 0.20974335, 0.016500302, 0.15386087, 0.2381243, -0.176845, -0.003643712, 0.08195259, 0.18417378, -0.18228108, 0.19170114, -0.3758241, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, 0.0);
    result += mat4(0.4429508, -0.025832538, -0.021855514, 0.11322045, -0.08459551, -0.17815724, -0.19924322, -0.03736318, -0.22390507, -0.50430673, -0.13770194, 0.03014482, 0.0, 0.0, 0.0, 0.0) * go_0(-1.0, 1.0);
    result += mat4(-0.15976174, 0.31052437, 0.2498092, -0.29137832, -0.10121105, 0.35164458, 0.4901633, -0.35297948, -0.2569739, -0.14258477, 0.12585007, -0.2552164, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, -1.0);
    result += mat4(-0.5260107, -0.8547037, 0.92173797, 0.37817466, -0.4162576, 0.10989847, 0.26875922, 0.8614761, 0.069195434, 0.045593478, 0.03790176, 0.7332446, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, 0.0);
    result += mat4(0.14287843, -0.283008, -0.28487602, -0.13313514, -0.019538656, -0.02361782, 0.28037757, -0.10543745, 0.1586713, 0.12037641, 0.24249536, 0.2524637, 0.0, 0.0, 0.0, 0.0) * go_0(0.0, 1.0);
    result += mat4(-0.037178896, 0.23858358, -0.18704462, -0.13747689, 0.07629898, 0.2710832, -0.71619016, -0.09074896, 0.30446374, -0.0052702115, -0.27990812, -0.1392364, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, -1.0);
    result += mat4(-0.086045384, 0.695562, -0.23519892, -0.23438415, 0.16208446, 0.2172693, -0.16647956, -0.3718635, 0.024940055, 0.5650778, 0.20409326, -0.13530363, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, 0.0);
    result += mat4(-0.19389555, -0.028506106, -0.35060602, 0.22244014, 0.055054635, -0.17651209, -0.19871834, -0.02667603, -0.1402023, -0.02455308, -0.57856905, -0.2174221, 0.0, 0.0, 0.0, 0.0) * go_0(1.0, 1.0);
    result += vec4(0.02648044, -0.0017647704, -0.016136197, 0.0011179475);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_tf
//!BIND conv2d_tf1
//!SAVE conv2d_2_tf
//!WIDTH conv2d_tf.w
//!HEIGHT conv2d_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.14656883, -0.044076134, -0.40314636, -0.08023388, 0.12564746, -0.21633625, -0.0210282, -0.19231434, -0.019945038, 0.020343186, -0.007134301, 0.013607319, 0.07334655, -0.050848506, 0.0011201366, 0.26975143) * go_0(-1.0, -1.0);
    result += mat4(-0.043205153, -0.13764456, -0.5368405, -0.04096279, 0.009450832, 0.23953767, -0.022408254, -0.124040656, 0.53450584, 0.02690831, 0.39857075, 0.42423433, 0.014167992, 0.055189077, -0.038074926, 0.12800713) * go_0(-1.0, 0.0);
    result += mat4(-0.05354771, -0.06626498, 0.0092389295, 0.100637995, 0.05051714, -0.0033487207, -0.0076860636, 0.013058279, 0.10727092, -0.31131467, 0.058990292, 0.46365786, 0.08736531, 0.038865663, -0.008022449, -0.067517675) * go_0(-1.0, 1.0);
    result += mat4(-0.25327486, -0.0041089035, 0.04877498, -0.36375836, 0.0003920389, -0.09273049, 0.016388323, 0.11530572, -0.14216854, 0.07370458, -0.27584067, -0.34536567, 0.0848517, -0.1954229, -0.22656868, -0.13531597) * go_0(0.0, -1.0);
    result += mat4(0.7035245, 0.1131446, 0.1833189, 0.63726306, -0.20649737, 0.14149575, -0.084267326, 0.020898562, -0.026810758, -0.17932594, -0.08032681, 0.07790513, -0.01148237, -0.19930641, 0.33902612, -0.013703277) * go_0(0.0, 0.0);
    result += mat4(-0.2862842, 0.01491211, -0.30474076, 0.19604082, 0.21565811, 0.29193363, 0.024934597, -0.17113955, 0.26136434, -0.12819171, 0.3874644, -0.30533502, 0.004006889, -0.07340657, -0.04817435, -0.013651047) * go_0(0.0, 1.0);
    result += mat4(-0.14331155, -0.09605764, -0.06941299, -0.09740676, 0.0059936745, -0.27215815, -0.31393203, 0.17594862, 0.045626156, 0.060231503, 0.10607796, -0.030635068, 0.15021041, -0.19662435, -0.14648037, 0.028361326) * go_0(1.0, -1.0);
    result += mat4(0.25090003, -0.2845429, -0.30109838, -0.070956856, -0.08051349, -0.07526823, 0.13524723, 0.14151429, -0.1232367, 0.08824123, 0.28804728, 0.31701297, 0.014839836, -0.09193038, 0.30188346, -0.07903937) * go_0(1.0, 0.0);
    result += mat4(0.21150468, 0.13863595, -0.2624825, 0.1652623, -0.026336774, -0.45599234, 0.015901498, 0.23009071, 0.19700526, -0.11013044, 0.19850798, -0.19702299, 0.060643747, -0.03162518, -0.18272553, 0.24863112) * go_0(1.0, 1.0);
    result += mat4(0.16361383, 0.0028921412, 0.18107067, 0.0720563, 0.06378758, -0.09442821, -0.3054202, 0.06843394, 0.20913927, -0.17700543, 0.14682317, 0.21683829, 0.02948067, -0.34866366, -0.04474257, -0.011365872) * go_1(-1.0, -1.0);
    result += mat4(0.008512374, 0.19717449, 0.4456541, -0.15356806, -0.24209222, 0.12543896, -0.18232138, 0.012759448, 0.052473016, 0.17268041, 0.25826934, -0.16848944, 0.10150518, -0.30244592, 0.38495708, -0.2090818) * go_1(-1.0, 0.0);
    result += mat4(-0.07227807, -0.10066125, -0.1090768, 0.13579647, 0.023154313, 0.079166815, -0.20014893, -0.21884407, 0.09634875, -0.22551452, 0.20771019, 0.16381831, -0.23455033, 0.12578821, -0.43342614, -0.23609087) * go_1(-1.0, 1.0);
    result += mat4(-0.11084086, -0.03875876, -0.17912252, -0.24158017, 0.070904315, 0.21862641, 0.02659038, -0.36572614, 0.06265698, 0.32029516, 0.12044166, 0.18424052, 0.050192874, 0.15095103, 0.13794746, -0.111053675) * go_1(0.0, -1.0);
    result += mat4(-0.11362966, 0.5249116, 0.27814335, -0.023295242, 0.022581467, 0.3195408, -0.06865207, -0.13818301, 0.18826036, 0.21182717, -0.30241874, 0.02916674, -0.19999875, 0.8222055, -0.2981789, -0.31122693) * go_1(0.0, 0.0);
    result += mat4(0.058648925, -0.39456168, -0.36158726, 0.4050607, 0.0609484, 0.01624418, -0.2699451, 0.25976416, 0.31131884, 0.18382475, 0.12856431, 0.3285595, 0.4798488, -0.26074353, 0.78901637, -0.071622506) * go_1(0.0, 1.0);
    result += mat4(-0.038631868, -0.20723929, 0.045573164, 0.10398485, 0.20236868, 0.14958549, 0.18842755, -0.23352885, 0.18624173, 0.2800279, 0.23280786, -0.12909916, -0.037398554, 0.1557195, -0.04866289, -0.13633357) * go_1(1.0, -1.0);
    result += mat4(-0.15441336, 0.0968205, -0.32649723, -0.021546176, -0.10667603, 0.18065608, 0.017242601, 0.027690934, -0.23079967, 0.093206555, -0.11170116, 0.19002458, -0.352287, 0.008375842, 0.2459501, -0.09389683) * go_1(1.0, 0.0);
    result += mat4(0.2130623, -0.4781421, -0.53600657, 0.44947717, -0.018234696, -0.17257519, -0.063182175, 0.22729957, -0.037309792, 0.13939567, -0.013829814, -0.20586358, 0.052985236, -0.04452726, 0.1880475, 0.096934296) * go_1(1.0, 1.0);
    result += mat4(0.026266143, -0.03171053, 0.2277772, 0.01093641, -0.007701242, 0.115488306, 0.029304042, 0.33619022, 0.14467055, 0.075788446, -0.076583475, -0.051929206, 0.02211152, 0.031270072, -0.075583085, -0.20198274) * go_2(-1.0, -1.0);
    result += mat4(-0.010648877, 0.21413183, 0.24339998, -0.22960022, -0.16156821, -0.45364898, -0.105244495, -0.07713787, -0.31945667, -0.097204186, -0.2457385, 0.04241939, -0.16228637, 0.13461526, 0.009693403, -0.13537757) * go_2(-1.0, 0.0);
    result += mat4(0.058250688, 0.007912516, -0.071061306, 0.01889538, -0.14592043, -0.10374761, 0.07840785, 0.008756123, -0.045008816, 0.05261628, -0.2615482, -0.01929421, -0.23048545, 0.010220507, -0.16385053, 0.031251106) * go_2(-1.0, 1.0);
    result += mat4(-0.03350765, 0.0737811, -0.09780837, -0.031780828, -0.1919008, 0.36382285, 0.19377235, -0.2797014, -0.12267188, 0.023496462, 0.38848102, -0.010005188, -0.09733866, 0.51535326, 0.47232744, 0.0073942994) * go_2(0.0, -1.0);
    result += mat4(-0.27284998, 0.14916854, -0.25612846, -0.029941292, 0.18539569, -0.43832946, -0.119871736, 0.044226155, -0.106426276, 0.05740293, -0.046056107, -0.17616963, -0.52316684, 0.33400205, -0.08133327, 0.0948221) * go_2(0.0, 0.0);
    result += mat4(0.32683802, -0.26026967, 0.19948171, -0.011760837, -0.30256173, -0.45944482, 0.051236197, 0.84710604, -0.08078167, 0.2675028, -0.27241448, 0.27764642, 0.13335843, 0.068502, -0.033614077, 0.19930291) * go_2(0.0, 1.0);
    result += mat4(0.07075588, 0.029963106, 0.055358, 0.042518128, -0.1441339, 0.42236832, 0.1387107, -0.40421516, 0.02318193, -0.36765453, -0.21558793, 0.21393713, 0.31122518, -0.3358225, -0.4967671, 0.46344024) * go_2(1.0, -1.0);
    result += mat4(-0.28364134, 0.19475235, 0.42310834, 0.060645495, -0.14013693, -0.049322303, -0.09870014, 0.23229486, -0.033104394, -0.37716264, -0.18488638, 0.17441164, -0.24427529, -0.26787207, -0.16721556, -0.10374529) * go_2(1.0, 0.0);
    result += mat4(-0.3376618, -0.09682554, 0.3423445, 0.047880173, 0.3354013, -0.21854481, -0.40352795, 0.1841921, 0.008460585, -0.03459756, -0.22880521, 0.35112804, -0.01764322, -0.16448145, 0.107058726, -0.28482538) * go_2(1.0, 1.0);
    result += mat4(-0.032480888, 0.0034003556, -0.032999255, 0.16414961, 0.098690405, 0.0887987, 0.32215804, -0.002440519, -0.16814353, 0.0029867117, -0.28380692, 0.060728613, 0.15944195, 0.16642234, 0.110365815, 0.22413619) * go_3(-1.0, -1.0);
    result += mat4(-0.088509634, 0.047311794, -0.30038288, -0.27227867, 0.41235012, 0.23889793, 0.7280631, 0.13555974, -0.08230139, 0.09955461, -0.13654864, 0.0314745, -0.275061, -0.10253638, -0.34706068, 0.03781376) * go_3(-1.0, 0.0);
    result += mat4(0.09819424, -0.017704371, -0.031446967, 0.061441656, -0.110502265, -0.19236599, 0.2783733, 0.12798637, -0.047672354, -0.018956421, -0.17555775, -0.018790504, 0.43967727, -0.62039405, 0.08790998, 0.4353703) * go_3(-1.0, 1.0);
    result += mat4(-0.019217307, 0.14623284, 0.015177701, 0.15983194, -0.106374666, -0.0131188845, 0.033161264, 0.41326195, 0.052029386, -0.11639186, -0.026856689, -0.020853983, -0.024652582, -0.12368135, -0.39344305, 0.17345576) * go_3(0.0, -1.0);
    result += mat4(-0.047131967, -0.28568837, 0.4201909, -0.28901812, -0.13973507, 0.03312194, -0.16265458, -0.10710893, 0.21189946, -0.32837728, 0.12424836, -0.30587387, 0.036961686, -0.8623908, 0.3661179, -0.1692949) * go_3(0.0, 0.0);
    result += mat4(0.1143412, 0.07707313, 0.3981437, -0.17059685, -0.094056316, -0.27234176, 0.12281097, -0.16966031, -0.1512859, -0.0524175, 0.1654043, 0.13700214, -0.3156236, -0.27636334, -0.52670264, 0.9250529) * go_3(0.0, 1.0);
    result += mat4(0.16162306, -0.15842794, -0.06699449, 0.059618954, 0.06798694, -0.060685594, -0.14878511, 0.17194197, -0.05110082, -0.12152871, -0.2020905, 0.09337634, 0.0602552, -0.07327089, 0.07043988, 0.15926042) * go_3(1.0, -1.0);
    result += mat4(-0.10312201, -0.13890414, -0.07694594, -0.29262447, 0.0597966, -0.228, -0.00046558332, 0.09373052, 0.2520174, -0.2992283, -0.01796473, -0.052195024, 0.09554047, -0.25678295, -0.38657847, 0.16130428) * go_3(1.0, 0.0);
    result += mat4(0.21114396, -0.64854, -0.52819866, -0.67061704, 0.05760163, -0.121914886, 0.05448798, -0.1352843, 0.007051261, 0.065677196, -0.09763541, 0.032613076, -0.17908493, -0.7194699, -0.6342276, 0.031814635) * go_3(1.0, 1.0);
    result += vec4(0.051319666, 0.019196881, 0.0759832, 0.050857317);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_tf
//!BIND conv2d_tf1
//!SAVE conv2d_1_tf
//!WIDTH conv2d_tf.w
//!HEIGHT conv2d_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(0.10187621, 0.11053595, 0.14810364, -0.18582201, 0.16617906, -0.011798966, 0.09280227, 0.13307849, -0.044728525, 0.10914104, 0.075626835, -0.10416733, -0.094498746, -0.06870642, -0.07571491, 0.04897303) * go_0(-1.0, -1.0);
    result += mat4(0.33485547, 0.03678466, -0.29866266, -0.048795477, -0.010474432, -0.10252797, 0.036609326, -0.013254512, -0.14475596, 0.011886287, 0.11828754, -0.13557065, -0.28870094, -0.17330378, 0.044048756, -0.019826433) * go_0(-1.0, 0.0);
    result += mat4(0.105582856, -0.039765045, 0.0818729, 0.09955303, 0.023201315, 0.09243788, 0.07389467, -0.012808492, 0.0492865, 0.19755632, -0.06548781, 0.08533675, -0.013952, 0.017339202, -0.20518751, -0.054678205) * go_0(-1.0, 1.0);
    result += mat4(-0.26653445, 0.04810761, -0.23108084, -0.19818014, 0.23671885, 0.016349426, 0.0045669116, 0.077428445, -0.140711, 0.11972277, 0.101062275, -0.18716832, -0.190941, -0.34035257, -0.09143259, 0.04359683) * go_0(0.0, -1.0);
    result += mat4(-0.14573975, 0.23356283, -0.3772715, -0.22460096, -0.053278442, 0.069576025, 0.05169695, 0.17249753, 0.028048603, -0.25471392, -0.09931249, 0.2095619, 0.22173007, 0.38787642, -0.30738685, 0.01936576) * go_0(0.0, 0.0);
    result += mat4(0.081078954, -0.16813248, 0.1542311, 0.17158946, -0.15383756, 0.025605323, 0.2360881, -0.14753577, -0.016537111, 0.048651446, -0.35849985, 0.01651406, 0.17044473, 0.13180882, 0.324054, -0.18812656) * go_0(0.0, 1.0);
    result += mat4(-0.15537027, -0.08164218, 0.049979087, -0.31885874, -0.15126401, -0.14352658, 0.18948728, 0.020951044, 0.054829888, -0.18936221, -0.22699763, 0.14384085, 0.055476833, -0.011031805, -0.23653851, 0.02768591) * go_0(1.0, -1.0);
    result += mat4(-0.34108123, -0.28492066, 0.50347435, 0.0034134283, 0.041766707, 0.12375689, -0.08600751, 0.22726676, 0.10521852, 0.16621545, 0.038216297, 0.029870255, 0.07065742, -0.03542451, 0.38924676, -0.117774665) * go_0(1.0, 0.0);
    result += mat4(-0.19437145, -0.01827461, 0.15408134, -0.14991991, 0.13832837, 0.0668659, 0.092678316, 0.05341174, 0.21633142, 0.09575402, -0.111060366, -0.00874764, -0.21256353, -0.052944425, 0.16459747, 0.07091838) * go_0(1.0, 1.0);
    result += mat4(0.022236984, 0.19067548, 0.049743406, 0.05148808, 0.23003219, 0.08688227, 0.030773275, -0.059972208, -0.039038613, 0.21701579, -0.11092254, -0.10850967, -0.17777155, -0.20399293, -0.006843039, 0.24139926) * go_1(-1.0, -1.0);
    result += mat4(-0.07928885, -0.011657496, -0.03982505, -0.031084592, -0.09403157, -0.13860224, 0.15166754, 0.1279725, -0.084909394, 0.18945958, 0.055481352, -0.24365151, -0.04130202, 0.105171725, -0.47306657, -0.2218246) * go_1(-1.0, 0.0);
    result += mat4(-0.06171395, 0.0029490888, 0.055825688, -0.01362009, 0.045571987, -0.04197536, -0.024671398, -0.11600467, 0.02611751, -0.06675449, 0.38841903, 0.109969236, 0.1846224, -0.22673915, -0.11488994, -0.18271959) * go_1(-1.0, 1.0);
    result += mat4(-0.08073766, -0.1512685, 0.09596278, 0.061552938, -0.23016383, 0.044725727, -0.1058148, -0.09081257, 0.25391936, 0.13075152, 0.1153331, 0.035533328, 0.14628118, 0.053434838, -0.061957166, -0.11092296) * go_1(0.0, -1.0);
    result += mat4(0.004972408, 0.26720062, -0.0014180156, -0.15569477, 0.08964792, 0.39218047, -0.113748655, -0.20653862, -0.0182982, -0.009456181, 0.096566215, 0.19871894, -0.45192167, -0.19494532, 0.5282211, -0.033234302) * go_1(0.0, 0.0);
    result += mat4(0.11633487, 0.055492207, -0.09550419, 0.019721292, 0.05191187, 0.110391244, 0.13541168, 0.108687185, -0.3231262, -0.071254596, 0.12103068, -0.063508354, 0.16086432, 0.22202429, -0.2793211, -0.059888415) * go_1(0.0, 1.0);
    result += mat4(0.09845572, -0.11364447, -0.06817361, 0.20479278, 0.008171668, -0.10222864, -0.12512983, 0.11285637, 0.2092848, 0.12593135, -0.054839488, 0.1560058, 0.109415986, -0.04229047, -0.21525817, 0.10153635) * go_1(1.0, -1.0);
    result += mat4(-0.26443723, 0.18267378, 0.2874903, -0.15007962, 0.23901714, -0.039331976, -0.4055973, 0.18869716, 0.060133275, -0.030050457, -0.16689767, -0.024223989, 0.43243858, -0.004281818, -0.5925553, 0.08473984) * go_1(1.0, 0.0);
    result += mat4(-0.11769163, -0.6005158, -0.0700652, 0.0062212353, -0.022391787, 0.08070833, 0.10332995, 0.100591965, 0.1680161, 0.1209537, -0.11606606, -0.0032385625, -0.30508906, -0.11541758, 0.27825746, 0.18774803) * go_1(1.0, 1.0);
    result += mat4(-0.06629365, -0.14032914, -0.2580204, 0.18303558, -0.1916567, 0.029803488, -0.12213443, -0.07165115, 0.012936617, -0.11358297, -0.19138688, 0.10422416, 0.18062063, 0.14369549, 0.10535131, -0.036331207) * go_2(-1.0, -1.0);
    result += mat4(-0.23739359, -0.14102252, 0.16535138, -0.055494435, 0.11510639, -0.02530117, 0.13571805, -0.11962709, 0.14311576, -0.11346015, -0.053082045, 0.23039193, 0.2412315, 0.34595123, -0.057626486, 0.1273758) * go_2(-1.0, 0.0);
    result += mat4(-0.031894613, 0.04056866, -0.14806709, -0.061261263, -0.05113628, -0.150074, -0.05885426, 0.025318084, -0.028839143, -0.14976048, -0.061418023, -0.10849576, 0.10669465, 0.025044547, 0.13002798, 0.033596892) * go_2(-1.0, 1.0);
    result += mat4(0.31830126, -0.109857574, 0.022382054, 0.19084917, -0.21992075, -0.06509279, 0.04586319, -0.10979886, 0.07565896, 0.008375114, -0.025531407, 0.112079956, 0.32532254, 0.39258766, 0.15983114, -0.047324624) * go_2(0.0, -1.0);
    result += mat4(0.06333816, -0.43997836, 0.28480944, -0.037927028, -0.16247569, 0.14209846, -0.5309942, -0.23058164, -0.18387268, 0.3324917, 0.010288075, -0.2516956, -0.42476243, -0.19866063, 0.32058033, 0.052254338) * go_2(0.0, 0.0);
    result += mat4(-0.019851776, 0.17185202, -0.14713249, -0.1373522, 0.23155597, -0.009191596, -0.15395427, 0.24423079, -0.11106813, -0.034888845, 0.17169674, -0.08786573, -0.08697707, -0.28842747, -0.25445274, 0.13578549) * go_2(0.0, 1.0);
    result += mat4(0.2099323, 0.09262897, -0.08977398, 0.30791095, 0.12376861, 0.24654338, -0.097672515, 0.008614657, 0.006388779, 0.076170854, 0.25119394, -0.12392118, 0.3138793, -0.015998395, 0.15131904, -0.3009305) * go_2(1.0, -1.0);
    result += mat4(0.33982292, 0.26557416, -0.3754559, -0.110353656, 0.08402225, -0.053171434, 0.051136248, -0.2696132, -0.14568366, -0.048726343, 0.06216166, 0.018804165, -0.084439, 0.15103953, -0.020082679, 0.15082058) * go_2(1.0, 0.0);
    result += mat4(0.14522389, -0.0462971, -0.10824406, 0.14163211, -0.08392773, -0.22920173, -0.23795773, -0.2580316, -0.22207144, -0.15956368, 0.12665017, -0.08286834, 0.09581649, 0.12603259, -0.15513468, -0.010735423) * go_2(1.0, 1.0);
    result += mat4(0.00818024, -0.15539199, -0.011369519, 0.05717366, -0.25330603, -0.018393422, 0.027386196, 0.121692196, 0.059138533, -0.1631142, 0.10282322, 0.08011751, 0.10027271, 0.255391, 0.010682224, -0.3095357) * go_3(-1.0, -1.0);
    result += mat4(0.117767766, 0.120644994, 0.09232613, -0.018057318, -0.038398392, 0.14537762, -0.016560853, -0.08958423, 0.06743331, -0.23562634, -0.123906426, 0.028323429, -0.09386831, -0.16833909, 0.019829117, -0.08108203) * go_3(-1.0, 0.0);
    result += mat4(0.05462869, -0.031615634, -0.121678494, 0.05315917, -0.012636353, -0.13374922, 0.18577711, 0.0005971412, -0.099537544, -0.060773082, -0.28754288, -0.20077203, -0.15873533, -0.11387871, -0.17841183, -0.120239034) * go_3(-1.0, 1.0);
    result += mat4(0.13845754, 0.223389, -0.20315485, -0.03479761, 0.1806296, 0.057029717, 0.010771242, 0.15245064, -0.0040082, 0.015283898, -0.34807077, 0.078581005, 0.026417086, -0.058825746, 0.07728649, 0.066044815) * go_3(0.0, -1.0);
    result += mat4(-0.13820273, -0.050027788, 0.061389934, 0.11189863, 0.008062022, -0.17326912, 0.18159898, 0.08510656, 0.22065656, 0.3918094, -0.05124615, -0.22959533, 0.85480285, 0.5621734, -0.817405, 0.065126896) * go_3(0.0, 0.0);
    result += mat4(-0.15309735, 0.1396192, 0.16662036, -0.10952867, -0.03473452, -0.08712044, -0.2422528, -0.19236326, 0.49887487, 0.2615184, -0.076631024, 0.16010238, -0.09836315, -0.27126545, 0.17968613, -0.21053861) * go_3(0.0, 1.0);
    result += mat4(-0.18809205, 0.050410215, 0.1418759, -0.2876976, -0.13414268, 0.07458343, 0.096421175, -0.060676426, -0.17345451, -0.13678914, -0.06512698, -0.102106765, -0.12989639, 0.09089589, 0.07377932, -0.07263102) * go_3(1.0, -1.0);
    result += mat4(0.45035192, 0.2393797, -0.045452517, -0.04553052, -0.26037264, -0.021321824, 0.24618645, -0.108074926, -0.030116243, 0.04612789, 0.2273845, -0.07468269, -0.48789972, 0.12628402, 1.0130231, -0.14672706) * go_3(1.0, 0.0);
    result += mat4(0.5591947, -0.0326075, 0.12768768, -0.7916967, 0.023168698, -0.042015456, -0.12410894, -0.033611402, -0.14815444, -0.124497496, 0.08198418, -0.014488041, 0.4252749, -0.20253694, 0.042329047, -0.50953263) * go_3(1.0, 1.0);
    result += vec4(-0.048558664, 0.11006767, -0.074099846, -0.016021004);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x32
//!HOOK MAIN
//!BIND conv2d_tf
//!BIND conv2d_tf1
//!BIND conv2d_2_tf
//!BIND conv2d_1_tf
//!SAVE conv2d_3_tf
//!WIDTH conv2d_tf.w
//!HEIGHT conv2d_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_tf_tex(conv2d_tf_pos)), 0.0))
#define g_1 (max((conv2d_tf1_tex(conv2d_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_tf_tex(conv2d_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_tf1_tex(conv2d_tf1_pos)), 0.0))
#define g_4 (max((conv2d_2_tf_tex(conv2d_2_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_2_tf_tex(conv2d_2_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.26519376, -0.45442572, -0.24128473, 0.56122154, 0.45048368, 0.32492852, -0.14123245, -0.027976234, -0.11764467, -0.47563952, -0.09401533, 0.024141679, -0.19278349, -0.5169275, -0.26203018, 0.04326379) * g_0;
    result += mat4(-0.14198317, 0.18704857, -0.20165806, 0.3868074, 0.26532957, 0.13556235, -0.5872983, 0.13357028, 0.48151335, -0.3750496, 0.020972235, -0.32213062, -0.46967435, 0.10506199, 0.24039303, -0.3906582) * g_1;
    result += mat4(0.10981934, -0.0040414287, -0.0025180888, -0.23061854, -0.6781062, -0.27331296, -0.1538456, 0.31020573, -0.05341261, 0.45214307, 0.23456645, 0.3261386, -0.020520406, 0.46579385, 0.57791334, 0.441774) * g_2;
    result += mat4(0.11475315, 0.18062253, 0.21255025, -0.1963313, -0.22190428, -0.19369084, 0.5878038, -0.051808596, -0.39728877, -0.044071846, 0.0066692936, -0.0066007506, 0.03501876, 0.27602142, 0.11396466, 0.81461775) * g_3;
    result += mat4(-0.44411597, -0.11377309, 0.16160126, 0.47119814, 0.22932883, -0.43011594, 0.01986201, 0.01446102, -0.2783236, -0.07647468, -0.5016725, 0.4227215, 0.31808656, 0.23829709, -0.12855907, -0.15950239) * g_4;
    result += mat4(-0.4784548, -0.042179376, -0.4882858, -0.046462137, -0.21421364, -0.35029694, -0.15496174, 0.11386904, 0.22592051, 0.1590684, 0.49690887, -0.37077406, -0.48519966, -0.14407466, 0.24836525, 0.38462397) * g_5;
    result += mat4(-0.043213595, -0.004892144, 0.29046863, 0.57064444, 0.37136674, -0.5603234, -0.30733815, 0.26740906, 0.016959883, -0.26567596, 0.101653986, 0.34387913, -0.13222592, -0.34239995, 0.32046688, 0.023962379) * g_6;
    result += mat4(-0.2955613, 0.44671535, 0.056253802, -0.6011664, -0.30715483, 0.16890973, 0.041257784, -0.1544008, 0.4653661, -0.22183, -0.23155628, -0.063779, 0.10350268, 0.02045104, -0.22509801, 0.14633855) * g_7;
    result += vec4(-0.00089101185, -0.038285345, 0.023986168, -0.122330956);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x32
//!HOOK MAIN
//!BIND conv2d_tf
//!BIND conv2d_tf1
//!BIND conv2d_2_tf
//!BIND conv2d_1_tf
//!SAVE conv2d_3_tf1
//!WIDTH conv2d_tf.w
//!HEIGHT conv2d_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_tf_tex(conv2d_tf_pos)), 0.0))
#define g_1 (max((conv2d_tf1_tex(conv2d_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_tf_tex(conv2d_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_tf1_tex(conv2d_tf1_pos)), 0.0))
#define g_4 (max((conv2d_2_tf_tex(conv2d_2_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_2_tf_tex(conv2d_2_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.6336626, -0.23328744, 0.054100014, -0.6572063, 0.22899812, 0.47125596, 0.087406546, 0.5788615, -0.24324284, -0.17465535, 0.23223022, -0.4417298, -0.1195797, -0.14119461, -0.2301777, -0.1748931) * g_0;
    result += mat4(0.2554768, -0.0835268, 0.13054265, 0.033940453, -0.22754695, 0.053536188, -0.10300488, -0.10146903, 0.3104604, -0.5024146, 0.089460805, -0.20216464, 0.6033507, 0.12908716, -0.29953086, 0.292064) * g_1;
    result += mat4(0.09586759, -0.037499018, -0.23253569, 0.63889295, 0.18920106, -0.6646685, 0.07218118, -0.61459464, -0.16397415, 0.3131906, -0.39399612, 0.36777702, 0.39545253, 0.030677503, 0.29420745, -0.02527333) * g_2;
    result += mat4(-0.2464485, -0.117239855, -0.13390337, 0.43170166, 0.10044111, -0.13811369, -0.007668335, 0.06387773, -0.11786689, 0.23223364, 0.12805769, 0.06410502, -0.2818576, 0.21286973, 0.17026524, -0.22247931) * g_3;
    result += mat4(0.12590794, 0.25101408, -0.014941272, -0.06091461, -0.106272854, -0.23196393, 0.64016813, 0.0025616125, 0.16706267, 0.008579063, 0.04476896, -0.5403641, -0.011274305, -0.014704461, -0.068788156, 0.47190762) * g_4;
    result += mat4(0.10427173, -0.11386145, -0.6048206, -0.20245847, -0.011730377, -0.0119483, 0.06255473, -0.5017671, -0.07181296, -0.08626898, -0.035322662, 0.42718327, 0.041101683, 0.017210655, -0.07089471, -0.6541289) * g_5;
    result += mat4(-0.43911383, -0.099413894, -0.22120018, -0.3121928, -0.32394376, 0.1159015, 0.04434728, 0.014404674, 0.040322874, 0.06727233, -0.046662346, -0.066591434, -0.004613069, -0.6566657, -0.13442427, -0.081967555) * g_6;
    result += mat4(0.7393613, 0.059159152, 0.21900342, 0.26184326, 0.15656939, -0.05151207, -0.02730003, -0.055701576, -0.50296444, 0.09566756, -0.10248052, -0.39747316, 0.5877897, 0.83397114, -0.07968032, -0.3097048) * g_7;
    result += vec4(-0.010642331, -0.050244823, -0.009665539, 0.26457447);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_3_tf
//!BIND conv2d_3_tf1
//!SAVE conv2d_5_tf
//!WIDTH conv2d_3_tf.w
//!HEIGHT conv2d_3_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_3_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_3_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_3_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_3_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.11527973, 0.18487021, 0.0010509634, -0.3687562, -0.012861112, -0.37319645, -0.31061935, -0.051598914, 0.061436053, -0.2643697, -0.032551475, 0.59398615, 0.17265628, 0.1634019, 0.026527049, -0.0040123775) * go_0(-1.0, -1.0);
    result += mat4(-0.19826698, -0.29437867, 0.15727736, 0.44590214, 0.27655315, 0.28220633, 0.12990361, -0.09000104, -0.26396993, -0.53520125, 0.40639028, 0.7958488, 0.043264065, -0.08110669, -0.28618547, 0.12722827) * go_0(-1.0, 0.0);
    result += mat4(0.26455724, -0.36315665, -0.22116943, 0.049996275, 0.28526706, -0.0045478707, -0.20538875, 0.03192557, 0.04443011, -0.48084733, -0.32755423, 0.0075373487, 0.34481105, 0.04272154, -0.11092845, -0.07401724) * go_0(-1.0, 1.0);
    result += mat4(0.28374255, 0.13204694, 0.041846596, -0.57726663, 1.0038753, 0.42640173, -0.045806255, 0.3795911, 0.52897507, -0.2522673, 0.37759414, 0.158503, 0.111165345, -0.033814687, -0.37906894, 0.14007671) * go_0(0.0, -1.0);
    result += mat4(0.30553007, -0.032092307, 0.6779135, -0.32720757, 0.29837027, 0.13522549, 0.21653146, 0.4553826, -0.22200927, -0.20921928, 0.36475468, 0.27989116, 0.6222863, -0.37027213, 0.06746388, 0.16675332) * go_0(0.0, 0.0);
    result += mat4(0.31677073, -0.37482786, 0.4029838, 0.43627468, 0.32849845, -0.3442297, 0.1752726, 0.37502408, -0.1561963, -0.17489041, 0.7141825, -0.13179696, 0.17682795, 0.052273672, 0.07300372, 0.20322469) * go_0(0.0, 1.0);
    result += mat4(0.07722791, 0.51997215, 0.2052519, -0.6162976, 0.07318059, -0.16653596, -0.0609372, -0.13199529, -0.011298448, -0.066250905, 0.11658636, -0.07317175, -0.068134755, 0.032443475, -0.27242857, 0.26479205) * go_0(1.0, -1.0);
    result += mat4(-0.46400046, 0.34256476, -0.074927844, -0.082626544, 0.38616362, 0.10320202, 0.7306549, -0.41960227, -0.33295953, -0.35537082, 0.040369444, 0.18173583, 0.36835003, -0.078561984, -0.13071333, -0.06847678) * go_0(1.0, 0.0);
    result += mat4(0.0951899, -0.21144655, 0.12174552, 0.09496668, -0.17025085, -0.36465582, 0.20724316, 0.07027979, 0.17988989, -0.16671456, -0.15068638, 0.26715076, 0.022114933, 0.14284599, -0.06316286, 0.017598677) * go_0(1.0, 1.0);
    result += mat4(0.22179046, -0.19104601, 0.10500515, 0.22017653, -0.065115064, -0.027006533, -0.21086605, 0.00932852, -0.6196575, 0.04396425, 0.52487534, 0.61164427, 0.15172893, 0.219877, 0.103516005, -0.103571504) * go_1(-1.0, -1.0);
    result += mat4(0.122733794, 0.19491453, 0.22410785, -0.17341182, -0.18816754, 0.22092234, -0.055087283, -0.14617631, 0.4338981, -0.45366564, -1.4062341, 0.19594707, 0.2178627, 0.016837195, -0.2226328, 0.079190396) * go_1(-1.0, 0.0);
    result += mat4(0.16418308, 0.14917587, 0.35162288, 0.04064204, -0.037038237, 0.06579139, -0.08464511, -0.2156906, 0.22791082, -1.1695892, 0.53665465, -0.77753544, 0.0065266103, 0.15857838, 0.010236925, 0.14953533) * go_1(-1.0, 1.0);
    result += mat4(0.64548135, -0.02291521, -0.14370848, 0.049308565, 0.13637903, 0.14568083, -0.1488358, -0.0038734428, 0.0809154, -0.15466721, -0.06614126, -0.047732286, 0.311668, 0.22075401, 0.26094854, -0.27763176) * go_1(0.0, -1.0);
    result += mat4(0.12075334, -0.23920162, 0.19115442, -0.33920774, 0.15199614, 0.27974042, -0.05022236, -0.15280685, 0.37271795, -0.76389724, -0.56503266, 1.4975219, 0.24002175, -0.12661129, 0.045953903, 0.2102559) * go_1(0.0, 0.0);
    result += mat4(-0.02855315, -0.16729961, -0.27380818, -0.08810453, 0.061245166, 0.27268958, 0.2282609, 0.072155826, -0.65736717, -0.46307757, -0.5473049, 0.50772667, -0.1581774, 0.28763455, -0.1870661, -0.16523343) * go_1(0.0, 1.0);
    result += mat4(0.23464368, 0.25850806, -0.054024473, -0.13788947, -0.24835043, -0.028147692, -0.23022775, 0.11494646, 0.31069988, -0.21450949, 0.40749013, -0.073832974, -0.16241223, 0.15673774, 0.23648019, -0.34203738) * go_1(1.0, -1.0);
    result += mat4(-0.10198349, -0.052500926, 0.02638934, 0.19718044, -0.09078705, 0.07717591, 0.44648582, -0.30146563, -0.10124157, 0.12145466, -0.2133955, 0.16855773, -0.12310728, 0.35327804, -0.44273457, 0.20639896) * go_1(1.0, 0.0);
    result += mat4(0.08033835, 0.0977811, 0.007069267, -0.110171854, -0.008568571, -0.10922981, 0.12048108, -0.0835261, 0.019930357, -0.12652875, 0.02870121, 0.12214532, -0.024486745, 0.3588685, -0.16501926, 0.11914434) * go_1(1.0, 1.0);
    result += mat4(0.24003507, -0.040643565, -0.4267142, 0.34356147, -0.2618635, -0.1550601, -0.18566506, 0.33267352, -0.17584917, -0.24971883, 0.167064, -0.20808934, 0.3197215, 0.19626021, -0.16993162, -0.16976681) * go_2(-1.0, -1.0);
    result += mat4(0.159248, -0.33713767, -0.37823528, 0.25286102, -0.6171255, 0.01159639, 0.08387377, -0.0796005, -0.18405017, -0.11881008, -0.03026552, 0.030733835, 0.17692643, 0.17118043, 0.23938146, -0.40504465) * go_2(-1.0, 0.0);
    result += mat4(0.11274836, -0.023647472, 0.083114825, 0.5222033, -0.07415273, -0.3251913, -0.034298245, -0.07125199, 0.09593269, -0.23062208, -0.3168607, -0.13040248, -0.41249517, 0.39030293, 0.47400078, -0.109306306) * go_2(-1.0, 1.0);
    result += mat4(-0.49999082, 0.012254524, -0.035179958, 0.212335, -0.10354367, -0.19730526, 0.092015326, -0.07317916, -0.21900047, -0.13948579, -0.3228226, -0.22363624, -0.06421761, 0.16125691, 0.38075948, -0.31371582) * go_2(0.0, -1.0);
    result += mat4(-1.0006356, -0.13763155, -0.8414047, -0.051852856, -0.44105098, 0.526086, 0.23091859, -0.6621191, -0.015348964, 0.37972412, -0.24986422, 0.13964157, -0.03184678, 0.25394693, -0.051659737, -0.34171197) * go_2(0.0, 0.0);
    result += mat4(0.14520285, 0.1346628, 0.047271203, 0.64346415, -0.25639483, 0.052174076, 0.28681588, -0.32156095, 0.014350296, 0.028580237, 0.33776954, 0.06681965, -0.27312553, 0.44097883, -0.16519593, -0.7293824) * go_2(0.0, 1.0);
    result += mat4(-0.65626615, -0.20801732, -0.18783297, 0.27998376, -0.51550066, -0.23272751, -0.3744558, 0.11267917, -0.1879591, 0.043539204, -0.17665562, 0.28546363, -0.20627682, 0.33176526, 0.34412766, -0.4310386) * go_2(1.0, -1.0);
    result += mat4(0.51410156, -0.08615402, -0.2396778, -0.027256064, 0.11491742, -0.20842157, 0.3855824, -0.19823207, 0.0062098945, -0.2629099, 0.13158852, -0.08746773, -0.46980307, 0.57169086, -0.13392213, 0.13375558) * go_2(1.0, 0.0);
    result += mat4(0.09988252, 0.19396676, -0.011215926, 0.2714918, 0.07985461, 0.30587563, 0.21915142, -0.14004244, -0.336268, 0.023702772, 0.15740578, -0.06307948, 0.06453276, 0.26978606, 0.45891464, -0.35511568) * go_2(1.0, 1.0);
    result += mat4(-0.33263445, -0.13086738, -0.30128893, 0.03720744, 0.46366304, -0.13430476, -0.26493385, 0.14521147, -0.025578065, -0.043376725, 0.055235144, -0.08467402, 0.12879072, 0.2621278, -0.030150373, -0.079033755) * go_3(-1.0, -1.0);
    result += mat4(-0.15686864, 0.06962337, -0.24032803, 0.05093969, 0.12118379, 0.2144539, 0.21314697, -0.15564163, -0.15193312, -0.15797225, 0.061610706, 0.06689548, 0.42354256, 0.24339569, 0.14413804, -0.08890708) * go_3(-1.0, 0.0);
    result += mat4(0.021830576, -0.0682399, -0.25052184, 0.035374403, -0.0022370394, 0.23796171, 0.40747103, -0.14309348, -0.22325014, 0.12337428, -0.0727028, 0.12374459, -0.24148722, 0.34091887, 0.5052561, -0.13712624) * go_3(-1.0, 1.0);
    result += mat4(-0.583754, -0.10253819, -0.26736188, -0.084894784, 0.7130811, 0.5888696, 0.24837445, 0.20670207, 0.08242887, -0.03090308, 0.24002716, -0.04146999, 0.33550006, -0.006085788, -0.2078999, 0.016955601) * go_3(0.0, -1.0);
    result += mat4(-0.23921615, 1.0534316, -0.29723012, -0.06626253, 0.022887046, -0.6139072, 0.22857629, 0.4203786, -0.02951169, 0.0501039, -0.054740574, -0.15496075, 0.9533812, 0.21038955, 0.33969748, 0.18853404) * go_3(0.0, 0.0);
    result += mat4(-0.13571729, -0.045776337, 0.23663524, 0.1457326, -0.23159564, -0.44608104, -0.35497522, -0.14684997, 0.042379193, 0.16966693, 0.2560789, -0.07091574, 0.010749883, -0.26966086, -0.16322245, 0.095426805) * go_3(0.0, 1.0);
    result += mat4(-0.027934154, -0.25037688, 0.19623838, 0.16128206, 0.21479255, 0.4066385, -0.06756232, -0.19681008, 0.09168842, 0.46935177, -0.059632402, -0.3419115, 0.2789002, 0.012714867, 0.15322958, 0.05255599) * go_3(1.0, -1.0);
    result += mat4(0.2074098, -0.19564646, 0.21713807, -0.29207307, -0.08546043, 0.122562535, -0.5150736, 0.5190804, -0.116998374, 0.17080544, -0.29132518, 0.47585255, -0.14625762, -0.026589578, -0.13111407, 0.03473621) * go_3(1.0, 0.0);
    result += mat4(-0.3399405, 0.063775875, -0.0121724615, 0.13809827, -0.1575877, 0.13529225, -0.28708464, -0.063552216, 0.08623843, 0.034867074, 0.25082812, -0.038863987, 0.08048017, -0.43998414, -0.05038377, -0.20123458) * go_3(1.0, 1.0);
    result += vec4(0.19016464, 0.19431238, -0.073604904, 0.101166695);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_3_tf
//!BIND conv2d_3_tf1
//!SAVE conv2d_4_tf
//!WIDTH conv2d_3_tf.w
//!HEIGHT conv2d_3_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_3_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_3_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_3_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_3_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(0.259803, 0.14121838, -0.3216694, 0.16912009, -0.24997918, -0.024859427, 0.07951931, -0.17898253, 0.14770418, -0.38608834, 0.7155576, -0.008749993, 0.106385805, -0.08190305, 0.06277034, 0.05247095) * go_0(-1.0, -1.0);
    result += mat4(-0.10331291, 0.29847905, -0.20864278, -0.34607938, -0.0629403, 0.24202278, 0.15617771, 0.09471163, 0.29827452, -0.5237911, 0.8446165, -0.038001515, 0.085504964, -0.012998129, -0.12903701, -0.06808485) * go_0(-1.0, 0.0);
    result += mat4(-0.028803846, 0.117718086, 0.11924323, -0.23554896, -0.31169716, 0.2164557, 0.054745417, -0.2886858, 0.34304592, -0.15872054, 0.21533915, 0.23624876, -0.02507208, 0.16001348, -0.14645866, -0.013143789) * go_0(-1.0, 1.0);
    result += mat4(0.12311184, 0.16843726, -0.5478087, 0.036556758, -0.0024939126, -0.12264501, 0.090127975, -0.14638199, -0.33366996, 0.1817309, 0.018728942, -0.025097579, -0.00233696, 0.15182042, -0.072947, -0.15065937) * go_0(0.0, -1.0);
    result += mat4(0.3238381, 0.19316678, 0.23307748, -0.10455285, -0.35405514, -0.06559013, 0.4206979, 0.08059919, -0.26130152, -0.23416454, -0.21285532, 0.07799376, 0.12372864, -0.3774056, 0.022239799, 0.22356819) * go_0(0.0, 0.0);
    result += mat4(0.066345, 0.20370135, -0.01601085, 0.014701113, 0.27098605, 0.25511372, -0.048403386, -0.014162313, 0.11301996, -0.09638182, 0.12047054, -0.010323633, 0.21627729, 0.18377618, -0.12752205, -0.0668105) * go_0(0.0, 1.0);
    result += mat4(0.18890683, -0.21100806, -0.38314816, 0.12188494, -0.09069559, 0.1785706, -0.19502263, -0.22853898, -0.096488185, 0.18105212, -0.0045291157, -0.018952737, 0.14934972, -0.17416078, 0.05363704, -0.17642738) * go_0(1.0, -1.0);
    result += mat4(-0.15392087, 0.13997103, -0.12765433, -0.054465868, 0.0061383434, 0.03424787, -0.08585949, -0.10249745, -0.055375032, -0.047258787, -0.10105776, 0.09468892, 0.32030013, -0.14938186, 0.18287018, 0.007592655) * go_0(1.0, 0.0);
    result += mat4(0.109669484, 0.02212132, 0.038995523, -0.0041161263, -0.12115841, -0.048061926, 0.06674463, -0.33846095, 0.04251217, -0.05917749, 0.17834029, 0.010219928, 0.2690458, 0.09282476, 0.077470005, -0.07310091) * go_0(1.0, 1.0);
    result += mat4(0.4314233, 0.035379685, 0.27331847, 0.19597715, -0.09619968, -0.055907905, 0.07898602, 0.031254813, -0.09366987, -0.37436283, 0.061305135, -0.32644534, -0.16999187, 0.06906536, -0.1228417, -0.09826574) * go_1(-1.0, -1.0);
    result += mat4(0.6059936, -0.10060162, -0.18080838, 0.26205355, 0.033052504, -0.10625297, -0.0038814575, 0.026052764, 0.19484659, -0.24242568, 0.8054419, -0.3437365, -0.010305425, -0.079504244, 0.11879563, -0.14375582) * go_1(-1.0, 0.0);
    result += mat4(0.23313539, -0.026485069, 0.13332158, 0.28462213, -0.19786534, 0.048259735, 0.024113638, 0.23403068, -1.0330093, 0.0059400625, 0.23721488, -1.379481, 0.12166913, -0.07133997, 0.060898513, 0.092720084) * go_1(-1.0, 1.0);
    result += mat4(0.16513251, 0.013819962, -0.009859532, -0.037474833, 0.25651336, -0.131653, 0.03145131, -0.27886832, 0.27808505, -0.099978246, -0.11189488, 0.053313572, 0.11455811, 0.10826371, 0.0017301271, -0.041959) * go_1(0.0, -1.0);
    result += mat4(-0.037442397, 0.061722398, 0.099159, -0.18970016, -0.13042277, 0.16767356, -0.028342545, 0.18715699, 0.22246139, 0.3154743, -0.39717823, 0.26053482, -0.012097491, 0.1746896, 0.3899962, -0.13013846) * go_1(0.0, 0.0);
    result += mat4(-0.14552362, -0.26800197, 0.09035887, 0.24266347, -0.14494316, 0.033814326, -0.06647855, -0.16609156, 0.30540654, 0.037082594, 0.14951941, 0.12753695, -0.045153987, -0.28476146, 0.37640104, -0.04667195) * go_1(0.0, 1.0);
    result += mat4(0.2071077, -0.09297775, -0.04906301, -0.24280597, 0.15925987, -0.05631783, 0.08169953, -0.20124075, 0.23060048, -0.05786468, 0.23959383, 0.1620485, 0.14333409, -0.12757483, -0.1424963, 0.13118197) * go_1(1.0, -1.0);
    result += mat4(-0.101942524, -0.02240319, 0.11718157, -0.13591368, 0.11223302, -0.042933583, -0.07766777, 0.01667011, 0.07462998, 0.020704709, -0.04329035, -0.01358702, 0.13569939, 0.015980164, -0.08001042, 0.13890027) * go_1(1.0, 0.0);
    result += mat4(0.01755685, -0.047599614, 0.06456479, -0.08004052, 0.08108282, 0.06789228, -0.14048836, -0.020240005, 0.039701223, 0.023405846, 0.06305444, -0.046804685, 0.040620867, 0.013529182, -0.094961315, 0.02959053) * go_1(1.0, 1.0);
    result += mat4(-0.053775985, -0.0060494044, 0.14724614, 0.07248909, -0.056616947, 0.0004714896, -0.18737504, -0.15240799, -0.030883765, -0.007487297, -0.0044565946, 0.15024893, -0.16870505, 0.09338804, -0.21873595, -0.14493267) * go_2(-1.0, -1.0);
    result += mat4(-0.045113027, -0.2153715, 0.04520989, 0.26561612, -0.12634845, -0.10975088, -0.3677834, -0.4343602, -0.34146985, 0.29135808, 0.026339425, -0.0995021, 0.012693227, 0.07312179, 0.21671581, 0.11961088) * go_2(-1.0, 0.0);
    result += mat4(0.19766524, -0.31538734, 0.35708517, 0.33092737, 0.027086282, 0.024219114, -0.15289012, -0.18128034, -0.16041638, 0.057314564, 0.079830885, -0.08828221, 0.11828446, -0.13336371, -0.078453206, 0.21232514) * go_2(-1.0, 1.0);
    result += mat4(-0.13100033, -0.24849984, 0.3087074, 0.017271562, -0.17455627, -0.014364008, 0.077686995, -0.015820628, 0.18584616, -0.16705278, -0.3169503, 0.09107534, -0.04958684, -0.008202742, 0.024148908, -0.04654239) * go_2(0.0, -1.0);
    result += mat4(-0.16020702, -0.18623418, -0.29434547, 0.5008317, 0.23796988, -0.11154579, -0.5167728, -0.14195764, 0.15495163, -0.028505204, -0.2105556, 0.22491512, -0.11658545, 0.31665426, 0.35085753, -0.40148884) * go_2(0.0, 0.0);
    result += mat4(0.24866697, -0.3752738, 0.8472619, 0.16663249, -0.25808626, -0.037561346, -0.1440471, -0.107407264, 0.016663626, 0.1599037, -0.31926402, 0.15272903, -0.14700623, -0.05275371, 0.061130624, 0.084672675) * go_2(0.0, 1.0);
    result += mat4(-0.24184473, -0.016008917, 0.040023588, 0.1517675, -0.1339458, 0.009985992, 0.15634708, -0.07649679, 0.0021696684, -0.07027257, -0.07509208, -0.27060902, -0.21299353, 0.12154156, -0.3159698, 0.2511261) * go_2(1.0, -1.0);
    result += mat4(0.19845779, 0.023986215, -0.073409855, 0.0812208, 0.013382121, -0.049414996, -0.12990347, 0.052681953, -0.12787153, -0.100129806, -0.036296804, -0.13915883, -0.24022135, 0.167096, -0.15128131, 0.17779276) * go_2(1.0, 0.0);
    result += mat4(-0.05787442, -0.19698323, 0.13090582, 0.1501304, -0.09954089, -0.008470983, -0.095334776, 0.114635326, -0.16330223, -0.046815667, -0.086304545, -0.15729928, -0.1982723, 0.10607274, -0.25540838, 0.09633669) * go_2(1.0, 1.0);
    result += mat4(-0.25680968, -0.18444876, 0.053333476, 0.10470261, 0.17798793, -0.108659215, 0.1787569, -0.027407814, 0.12637395, -0.038193744, -0.16185284, 0.14068736, 0.092281684, 0.022276353, 0.013779975, 0.026369803) * go_3(-1.0, -1.0);
    result += mat4(-0.17329752, 0.21632285, -0.036964342, 0.30856085, 0.015225849, 0.04158692, -0.010607313, 0.16295516, 0.18873654, 0.24728407, 0.09787, -0.14381099, -0.091119304, 0.12914585, -0.039659716, -0.10700463) * go_3(-1.0, 0.0);
    result += mat4(-0.037163302, 0.05201725, -0.149489, -0.05682234, -0.022634465, -0.074764505, -0.010783339, 0.028970495, -0.045976285, -0.1923207, -0.037494432, -0.13024884, -0.1957353, 0.013454359, -0.30236122, -0.078870796) * go_3(-1.0, 1.0);
    result += mat4(-0.17753989, -0.1549664, 0.08087595, 0.046868976, -0.09354348, 0.22648604, 0.002651186, 0.11890617, -0.0073132347, 0.05030891, -0.08128038, 0.14395374, -0.001108739, -0.030957213, -0.03568773, 0.055131156) * go_3(0.0, -1.0);
    result += mat4(-0.029484594, -0.013036961, -0.31721568, 0.11611545, -0.24111903, -0.33007705, 0.5950326, -0.070911475, -0.04757172, -0.037676062, -0.14590797, 0.076822214, -0.1672743, -0.41848892, 0.39202756, -0.30958134) * go_3(0.0, 0.0);
    result += mat4(0.17605461, 0.12216047, -0.02412872, -0.14132546, -0.052373543, 0.08169531, 0.18497281, 0.074685514, -0.055427983, 0.14018987, -0.11671619, 0.108945735, -0.032986425, 0.11385016, 0.05801377, -0.1457665) * go_3(0.0, 1.0);
    result += mat4(-0.27222672, -0.0074164676, 0.35768685, 0.0074552484, 0.16729778, 0.14860032, -0.3657366, 0.24510175, -0.0621289, -0.0137252435, -0.26145887, 0.0556681, -0.07332952, 0.13122542, -0.020396946, 0.113705456) * go_3(1.0, -1.0);
    result += mat4(0.08118381, -0.06442098, 0.00044297878, 0.13279027, -0.20708169, 0.11252618, -0.033728387, -0.0105973175, -0.2138218, 0.34612998, -0.15597765, 0.18179017, -0.007853463, -0.045547944, 0.22064093, 0.0548327) * go_3(1.0, 0.0);
    result += mat4(-0.10656318, -0.014200068, 0.062040597, -0.037210476, -0.07271065, -0.027337732, -0.14988437, -0.14711551, -0.028843492, -0.0046596485, -0.15023676, 0.08530336, -0.016875269, -0.024734195, 0.055177588, 0.010381644) * go_3(1.0, 1.0);
    result += vec4(-0.021330277, -0.09496422, -0.1339419, 0.012216251);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x40
//!HOOK MAIN
//!BIND conv2d_3_tf
//!BIND conv2d_3_tf1
//!BIND conv2d_5_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!SAVE conv2d_6_tf
//!WIDTH conv2d_3_tf.w
//!HEIGHT conv2d_3_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_3_tf_tex(conv2d_3_tf_pos)), 0.0))
#define g_1 (max((conv2d_3_tf1_tex(conv2d_3_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_3_tf_tex(conv2d_3_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_3_tf1_tex(conv2d_3_tf1_pos)), 0.0))
#define g_4 (max((conv2d_5_tf_tex(conv2d_5_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_5_tf_tex(conv2d_5_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.4756803, -0.16041027, 0.30747655, 0.27719444, 0.33626345, -0.093426555, -0.08751585, -0.025898175, 0.12469858, 0.162526, 0.071950376, 0.36727026, -0.26165214, 0.17652564, -0.081568465, 0.17669047) * g_0;
    result += mat4(0.10045615, -0.47277164, 0.13970673, -0.036603283, 0.10723418, -0.0733819, 0.07046736, 0.04479655, -0.5100679, 0.4051206, -0.3043826, 0.07709692, 0.25090587, -0.5827475, 0.27195984, 0.42297873) * g_1;
    result += mat4(-0.34415862, -0.056642354, -0.32332316, 0.049897127, 0.08399151, 0.683046, -0.16349371, -0.4878456, -0.097749546, 0.7214421, -0.2821467, -0.16691755, 0.3712332, -0.71557045, 0.40365914, 0.37325174) * g_2;
    result += mat4(-0.333854, 0.11971563, -0.26533902, -0.033346854, 0.09896302, -0.19311592, -0.006087015, -0.104003794, 0.05347405, -0.16057043, 0.15876219, 0.1538847, -0.07954591, 0.24062383, -0.025401022, -0.33599105) * g_3;
    result += mat4(0.11794056, -0.0031797416, 0.08360105, 0.12222232, -0.16638078, 0.26014742, -0.047267277, -0.27900735, 0.17616066, -0.12788172, 0.22856903, -0.39034957, -0.36313176, 0.12272574, 0.2235959, -0.31102005) * g_4;
    result += mat4(0.03297161, 0.19597028, -0.068131894, -0.059938233, 0.18935929, -0.12004069, 0.08705267, 0.26411813, -0.021374375, 0.24630849, -0.08980925, 0.15982057, 0.3533297, -0.15414584, -0.19008748, 0.11310849) * g_5;
    result += mat4(-0.4622819, 0.31923467, -0.38989246, 0.5539857, -0.035433546, -0.12729715, -0.0669769, -0.048216928, -0.32078394, 0.26958883, 0.08897814, -0.31043166, 0.26743132, 0.38835636, -0.30535862, -0.22241123) * g_6;
    result += mat4(0.47431698, -0.755935, -0.075302646, 0.27771655, 0.052087527, -0.17221431, 0.0008429987, 0.15527548, -0.04587466, -0.11802989, 0.39905685, -0.07758683, -0.11415051, 0.004637339, -0.19803126, 0.19956517) * g_7;
    result += mat4(0.36277947, -0.13364364, 0.18459712, -0.1705512, -0.46083033, 0.43629453, 0.112646095, -0.18511245, 0.037818372, 0.1220617, -0.22268273, -0.11983507, -0.5432721, -0.2102279, -0.014456884, 0.16428374) * g_8;
    result += mat4(0.22811654, 0.16262956, 0.18411161, 0.49102694, -0.15078211, -0.6144134, -0.11632199, 0.2740543, -0.11322067, -0.16751853, 0.18453367, 0.14305107, 0.36418238, -0.34248996, -0.055178564, 0.37168074) * g_9;
    result += vec4(0.07878663, -0.045328207, -0.07142425, -0.006036755);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x40
//!HOOK MAIN
//!BIND conv2d_3_tf
//!BIND conv2d_3_tf1
//!BIND conv2d_5_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!SAVE conv2d_6_tf1
//!WIDTH conv2d_3_tf.w
//!HEIGHT conv2d_3_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_3_tf_tex(conv2d_3_tf_pos)), 0.0))
#define g_1 (max((conv2d_3_tf1_tex(conv2d_3_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_3_tf_tex(conv2d_3_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_3_tf1_tex(conv2d_3_tf1_pos)), 0.0))
#define g_4 (max((conv2d_5_tf_tex(conv2d_5_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_5_tf_tex(conv2d_5_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.35645446, -0.01804877, -0.53608185, 0.32968932, 0.13975728, -0.1716116, 0.09503091, -0.12088551, 0.30239868, 0.9217966, 0.016221086, -0.26894137, -0.0047026747, 0.54764843, -0.2826915, 0.0016894634) * g_0;
    result += mat4(-0.15123259, 0.2014175, 0.05961645, -0.32386652, -0.25275725, 0.3658508, -0.104193784, -0.02756655, 0.2696138, 0.17608197, 0.17685752, 0.6808081, -0.40293297, 0.48387393, 0.25278264, 0.28291366) * g_1;
    result += mat4(-0.18928573, -0.18908137, 0.47045723, 0.5454373, 0.31339395, -0.0064702537, -0.37307036, -0.37479213, 0.2235379, -0.370863, 0.02827034, 0.024350066, -0.32538193, -0.33686417, 0.8949382, 0.3324315) * g_2;
    result += mat4(-0.17215039, -0.14995, -0.4451278, 0.30758965, 0.21607, 0.08995007, 0.09553425, -0.21233945, -0.14442022, 0.09295349, -0.29228872, -0.3875935, 0.11704046, -0.4206096, 0.35226774, -0.08189522) * g_3;
    result += mat4(-0.12517966, 0.060051568, -0.38888076, 0.08354471, 0.17010468, -0.34286287, -0.06961373, 0.032387406, -0.025718998, -0.1661844, -0.075671494, 0.10289619, -0.28309906, -0.14461538, 0.22726184, 0.4752376) * g_4;
    result += mat4(0.15411675, 0.17533994, 0.3406641, -0.0597274, -0.21072194, 0.1517182, 0.032032263, 0.18653658, 0.20970167, -0.10793765, -0.05335404, -0.095203936, 0.2917104, -0.1170929, -0.11652503, -0.46912733) * g_5;
    result += mat4(-0.272871, 0.07467413, 0.16981912, 0.57318956, 0.35038894, -0.06679483, 0.3777534, -0.01522816, 0.2588504, -0.008976239, 0.31769443, 0.07070477, 0.059302222, 0.28855336, -0.14700443, -0.08605704) * g_6;
    result += mat4(-0.27067363, -0.2191635, -0.2377148, -1.0028448, -0.25673935, 0.10997322, -0.39032057, 0.06524818, 0.5248202, 0.40049195, 0.6711809, 0.2878331, 0.19606547, -0.092196286, 0.27838528, 0.03120515) * g_7;
    result += mat4(0.3029178, -0.027027214, 0.13855064, -0.16550988, 0.2354576, -0.1715326, 0.12981784, 0.5013446, 0.24411377, -0.13030572, -0.08595908, -0.104394995, 0.16794646, -0.044388745, 0.2807999, 0.39108425) * g_8;
    result += mat4(-0.05535261, -0.15662162, 0.14935054, 0.10706811, 0.026958441, -0.15323113, -0.19261432, -0.24361719, -0.2607876, 0.038486157, -0.04509224, 0.18722118, -0.14478058, 0.03614682, -0.12608361, -0.5203596) * g_9;
    result += vec4(-0.17363991, 0.071162574, -0.09289675, 0.013446863);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_6_tf
//!BIND conv2d_6_tf1
//!SAVE conv2d_8_tf
//!WIDTH conv2d_6_tf.w
//!HEIGHT conv2d_6_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_6_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_6_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_6_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_6_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.162897, -0.21250516, -0.11219427, 0.30969706, 0.078927204, -0.14922144, 0.5486932, 0.2884913, 0.07018745, 0.45946357, -0.23759702, -0.18914284, 0.19762751, 0.56881535, -0.2141465, 0.27216902) * go_0(-1.0, -1.0);
    result += mat4(-0.17507325, -0.577772, -0.46351492, 0.09431303, 0.023881523, -0.068162896, -0.0029204858, -0.076631226, -0.07645065, 0.28997856, -0.0349899, 0.087704636, 0.29194608, 0.7767595, 0.17478088, -0.295144) * go_0(-1.0, 0.0);
    result += mat4(0.23039296, -0.000184939, -0.032427344, 0.0926983, -0.4264918, -0.44138262, 0.39098918, -0.0102598835, 0.066287994, 0.15478721, -0.062338993, 0.15079321, 0.120016515, 0.7005824, -0.12260436, 0.090042405) * go_0(-1.0, 1.0);
    result += mat4(0.014269367, 0.21645544, -0.4203915, 0.0077638677, -0.18618487, 0.30165052, 0.6985895, -0.014695781, -0.071353786, -0.49996287, -0.79902583, -0.06343025, 0.291085, 0.28801495, 0.46547806, 0.1311194) * go_0(0.0, -1.0);
    result += mat4(0.17163453, 0.21760814, -0.67896426, 0.1487859, 0.05881719, -0.08391752, 0.44536906, 0.24853623, -0.7685656, 0.45705163, -1.0204223, 0.1884743, -0.3251896, -0.49221343, 0.38116506, -0.09428967) * go_0(0.0, 0.0);
    result += mat4(0.2759429, 0.22141403, -0.13269989, 0.06833041, -0.29562923, -0.26589182, -0.34452415, 0.36388424, -0.3184807, 0.08254464, -0.15477169, 0.03237491, -0.34190834, -0.2777646, -0.15713428, -0.22231084) * go_0(0.0, 1.0);
    result += mat4(-0.36887082, -0.34607458, 0.5719879, 0.09200919, 0.12724651, 0.20281908, 0.39280674, 0.09216231, 0.3126475, -0.0075341803, -0.046779484, 0.10883631, 0.20136468, 0.70330596, -0.024237871, -0.061087623) * go_0(1.0, -1.0);
    result += mat4(-0.08114617, -0.02456657, 0.1287709, 0.5486885, -0.10143632, -0.39116892, 0.24008204, 5.8133483e-05, -0.36640543, -0.52113515, 0.3836287, 0.09541327, 0.01115865, -0.2044513, 0.07734024, -0.29509112) * go_0(1.0, 0.0);
    result += mat4(0.25962162, -0.05327207, -0.28945914, 0.320823, 0.049143463, 0.011241379, 0.004193257, 0.3872085, -0.47137228, -0.44385332, -0.2591483, -0.20189615, 0.08729277, -0.14813553, -0.29911307, 0.0067013856) * go_0(1.0, 1.0);
    result += mat4(0.13526323, 0.6637005, 0.09491454, -0.038491655, -0.5078187, -0.5782128, -1.0748478, 0.18678135, 0.16064858, 0.0795754, 0.116070546, 0.06408978, 0.085641995, -0.39126787, -0.16669247, -0.024058852) * go_1(-1.0, -1.0);
    result += mat4(-0.30658495, -0.08933112, 0.38358685, -0.048228927, 0.050148476, -0.08750905, -0.5015779, 0.4012965, -0.068299964, 0.08993712, 0.03617703, -0.030809006, 0.05144756, -0.7659615, -0.33359128, 0.0054376507) * go_1(-1.0, 0.0);
    result += mat4(-0.24894494, 0.08617524, -0.095747314, 0.14710969, -0.09528072, 0.19016005, 0.060339417, -0.059556015, 0.01127292, -0.021082405, 0.5204205, 0.23831797, -0.035384487, 0.001653611, -0.28902745, -0.0060615037) * go_1(-1.0, 1.0);
    result += mat4(0.2978602, 0.2580722, 0.11472323, -0.06937241, -0.45087403, -0.35747236, -0.38835877, 0.22520676, 0.09162963, 0.50932664, -0.41183934, -0.08526183, -0.043625794, -0.27782285, -0.4119391, -0.339948) * go_1(0.0, -1.0);
    result += mat4(-0.005034612, 0.010024151, 0.55194247, -0.16040643, 0.0072234212, -0.047230296, 0.011222393, -0.017184192, 0.2156304, 0.02429907, 0.41669923, -0.06159069, -0.39241523, 0.009254305, 0.35784644, -0.45379582) * go_1(0.0, 0.0);
    result += mat4(-0.18008694, -0.35366225, 0.12110043, -0.102665015, 0.2763678, -0.61502653, 0.3051717, -0.23991431, 0.6076138, -1.142571, 1.2579885, 0.15013893, -0.13282573, -0.16185799, -0.26278257, 0.044563264) * go_1(0.0, 1.0);
    result += mat4(-0.043284204, -0.1374118, -0.6523209, -0.1682561, -0.002918912, 0.2768846, 0.045174655, -0.046218265, 0.10686049, -0.004872297, 0.04118156, -0.07015327, -0.3329307, 0.19972506, -0.38307762, 0.11627049) * go_1(1.0, -1.0);
    result += mat4(0.09306764, -0.5036807, -0.25358048, -0.033543527, 0.07199686, -0.28982875, -0.022885432, -0.078454, -0.0836088, -0.08261633, 0.38759607, 0.021209864, 0.09516953, -0.1896164, -0.12284774, 0.16532375) * go_1(1.0, 0.0);
    result += mat4(0.27196047, -0.6199637, 0.12209493, -0.0055379267, -0.08997175, -0.0025996822, -0.20710677, 0.15223576, -0.07073166, -0.20732503, -0.044538528, 0.35751408, 0.33849528, -0.14603287, 0.19472563, 0.20992133) * go_1(1.0, 1.0);
    result += mat4(0.018979501, 0.030001618, 0.09530055, -0.22441792, -0.11513775, -0.05383842, 0.042144198, -0.2824055, 0.20338169, 0.9622458, -0.20780474, 0.5217952, 0.11518432, 0.24126045, -0.046675194, -0.07326568) * go_2(-1.0, -1.0);
    result += mat4(-0.13768856, 0.17157272, -0.32123035, -0.08968111, 0.011915078, -0.08129057, -0.71480066, 0.24239756, 0.5093838, 0.29058817, -0.07181868, -0.22533971, 0.24244072, -0.2716092, 0.03331018, 0.008624937) * go_2(-1.0, 0.0);
    result += mat4(0.21304299, 0.5180637, 0.40324917, -0.078679435, 0.17033757, -0.4813804, -0.47702515, -0.017285354, -0.054009005, -0.5853617, -0.5427995, 0.13533083, 0.12440328, -0.6455633, 0.0012186684, 0.031838413) * go_2(-1.0, 1.0);
    result += mat4(0.04057183, -0.27768528, -0.07563423, 0.13400203, -0.03429928, -0.32794374, -0.085426375, -0.3724642, -0.19195397, 0.1349262, -0.2909766, -0.43096116, 0.056601644, 0.5106557, -0.267059, -0.046354882) * go_2(0.0, -1.0);
    result += mat4(0.14343774, -0.29267886, -0.2406526, -0.30307195, -0.10270894, 0.008828463, -1.5378821, 0.017785087, 0.48302534, -0.310974, 1.5381073, 0.08598342, 0.82111055, -0.0049781636, 0.4820726, 0.301231) * go_2(0.0, 0.0);
    result += mat4(0.012052944, -0.090234, 0.52199095, -0.3329521, 0.110252894, 0.2897882, -0.37447298, 0.17326026, 0.18148576, -0.23976558, 0.1848407, 0.5042414, 0.33321953, 0.2712571, 0.18124644, 0.20849751) * go_2(0.0, 1.0);
    result += mat4(0.066107936, 0.035174694, -0.1587501, -0.22672103, 0.012212267, -0.05451626, -0.6004301, 0.013387352, -0.04113352, 0.53583735, -0.15342614, -0.0018758774, 0.09947345, -0.18213694, 0.02965846, -0.044368513) * go_2(1.0, -1.0);
    result += mat4(0.099831305, 0.2666737, -0.12301129, -0.113591194, 0.018106552, 0.290373, 0.1480011, 0.032558106, 0.0024403003, 0.11745559, 0.7669008, -0.18195944, 0.21291047, 0.49549788, -0.04361018, 0.6138144) * go_2(1.0, 0.0);
    result += mat4(-0.24335642, -0.023037815, -0.22853605, -0.49450716, 0.04834612, 0.040727314, 0.36239302, -0.076259434, -0.08173315, 0.14689375, 0.3357786, 0.34003472, -0.11701219, -0.35594055, 0.55640507, 0.3573448) * go_2(1.0, 1.0);
    result += mat4(0.039600838, -0.08580259, -0.25375724, -0.41294497, 0.052295998, 0.34286344, 0.23627926, 0.08080187, 0.0015981429, 0.37459275, -0.11763548, 0.027264152, 0.11372706, 0.34742436, 0.30963847, -0.2995273) * go_3(-1.0, -1.0);
    result += mat4(-0.035936117, -0.42153218, -0.40176156, 0.20363232, 0.22382015, 0.48679677, 0.07365761, -0.20890754, 0.22791456, -0.28418672, -0.17189962, 0.0968373, -0.70834696, -0.41918173, -0.13482817, 0.037949625) * go_3(-1.0, 0.0);
    result += mat4(0.11910686, 0.0473921, 0.37869528, 0.17928337, 0.17311068, 0.21572089, 0.34996882, -0.26002827, -0.014036688, -0.6574892, -0.14409806, -0.06467717, -0.33688435, -0.18185017, 0.04036214, 0.06086553) * go_3(-1.0, 1.0);
    result += mat4(-0.15657301, -0.05661294, -0.36640826, -0.13215317, 0.060342815, 0.19098124, 0.18715985, -0.40765548, 0.090474375, -0.07720432, -0.016231487, 0.0885778, 0.0272616, 0.22065723, 0.1691866, -0.19491237) * go_3(0.0, -1.0);
    result += mat4(-0.13054666, 0.3278881, -1.3170725, -0.4575742, -0.061401486, 0.15868792, 0.2789515, 0.13829961, 0.09607008, -0.7175924, 0.01804374, 0.41284522, 0.044577077, 0.04847126, -0.25607756, -0.02249741) * go_3(0.0, 0.0);
    result += mat4(0.22145797, 0.8114419, -0.17527157, 0.09274125, -0.25224185, 0.2955128, -0.37553602, -0.17377761, -0.9684024, 0.42457148, -0.64265996, 0.10394252, -0.11231096, 0.064703405, 0.42858216, -0.21214609) * go_3(0.0, 1.0);
    result += mat4(0.1910386, -0.0065560606, 0.18119961, -0.026436953, 0.07887997, 0.15127628, -0.11523928, -0.0679343, 0.031198656, 0.16947536, 0.05943052, 0.060350783, 0.32215032, -0.1347014, 0.017390233, -0.06527528) * go_3(1.0, -1.0);
    result += mat4(-0.19811153, -0.033103824, 0.0053317053, 0.008003428, -0.020805335, 0.17872533, -0.3161484, -0.11559199, -0.24902378, -0.2596549, 0.034520704, -0.006125487, 0.13173361, -0.10967251, -0.7860965, -0.035326626) * go_3(1.0, 0.0);
    result += mat4(-0.124631934, 0.21335506, 0.375809, -0.13598146, 0.047685858, 0.14553228, -0.068173625, -0.117949426, 0.07296198, 0.08935096, -0.26368606, 0.29653412, -0.27378097, 0.060699224, -0.09753418, -0.08484599) * go_3(1.0, 1.0);
    result += vec4(-0.009278051, 0.62221414, 0.22868732, 0.14880095);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_6_tf
//!BIND conv2d_6_tf1
//!SAVE conv2d_7_tf
//!WIDTH conv2d_6_tf.w
//!HEIGHT conv2d_6_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_6_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_6_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_6_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_6_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(0.018128054, -0.14104486, -0.027475944, 0.22669935, -2.7264505e-05, 0.14775783, 0.13441783, 0.11450963, -0.09942102, 0.29735768, 0.04839269, -0.14066552, -0.024448555, 0.3104163, -0.03636913, 0.002947356) * go_0(-1.0, -1.0);
    result += mat4(-0.20438337, 0.35419708, 0.037506625, 0.100693576, -0.074241616, -0.15304284, 0.0054191337, -0.12816934, 0.028913809, -0.098240785, 0.5653599, -0.38662913, 0.018716848, 0.0021957273, 0.061397206, -0.111899704) * go_0(-1.0, 0.0);
    result += mat4(-0.18681246, -0.23609419, 0.21475013, 0.051762715, 0.04889926, -0.033886652, 0.26262638, -0.27322114, 0.049140245, 0.3380464, -0.13617653, -0.05796957, 0.080669545, 0.21348572, -0.10067047, -0.0016244814) * go_0(-1.0, 1.0);
    result += mat4(0.025566151, -0.027286734, -0.10856872, 0.108885765, -0.07635088, 0.13037659, 0.2892404, -0.2160093, -0.30649704, 0.34650138, -0.021391464, 0.08717436, -0.02000013, 0.027722841, 0.43060175, -0.04844848) * go_0(0.0, -1.0);
    result += mat4(0.09925131, -0.11167345, -0.14262813, -0.21267861, -0.15972298, -0.1823657, -0.073309824, 0.15542479, 0.005081145, -0.40594074, 0.24862696, 0.19943975, -0.36283687, -0.38990027, 0.4759463, 0.45561194) * go_0(0.0, 0.0);
    result += mat4(-0.13126811, 0.24284562, 0.06109369, -0.15402594, 0.016967572, -0.08234942, -0.053873185, 0.026438333, 0.13412815, -0.10839792, -0.345438, 0.0720746, 0.21260333, -0.15989558, -0.012461376, 0.20363508) * go_0(0.0, 1.0);
    result += mat4(0.09231617, 0.17787862, 0.22783166, 0.09095521, -0.0935426, -0.22921127, 0.2591894, -0.19451278, -0.0046325484, -0.60839254, 0.061737422, -0.024267042, -0.04048761, 0.2450175, 0.14390652, 0.07999217) * go_0(1.0, -1.0);
    result += mat4(-0.09204067, -0.05434134, 0.32136026, -0.053413626, 0.044170942, 0.10284346, 0.10827547, -0.03207593, -0.036979157, -0.37019014, -0.07072617, 0.07745549, 0.026007036, 0.13402742, 0.22873925, -0.09879518) * go_0(1.0, 0.0);
    result += mat4(-0.039409183, -0.15304323, 0.110744946, 0.04479048, 0.073402554, -0.31955537, 0.13518381, 0.09020946, 0.21437532, -0.08866372, 0.062359575, -0.08147204, -0.012339588, 0.038986444, -0.059496317, 0.04353628) * go_0(1.0, 1.0);
    result += mat4(-0.029447578, 0.18052183, 0.026130654, -0.18024941, -0.2357611, 0.92272073, -0.40873498, 0.3829195, -0.049990416, -0.2626007, 0.07313907, -0.20231684, 0.23846717, 0.06304234, -0.072538964, 0.34895507) * go_1(-1.0, -1.0);
    result += mat4(-0.21427542, 0.33398184, 0.19135003, -0.079177245, -0.047564022, 0.25006044, 0.19287021, -0.07119212, -0.0064072064, 0.14020945, -0.15136649, -0.04587045, -0.113710366, 0.05126853, -0.084781885, 0.1418395) * go_1(-1.0, 0.0);
    result += mat4(0.04655672, -0.010115347, 0.18253572, 0.017085062, -0.04543099, 0.08404545, 0.07929449, 0.17069206, -0.045596916, 0.12133366, 0.12615037, -0.11942128, -0.07431312, -0.0975234, 0.17188828, -0.021951154) * go_1(-1.0, 1.0);
    result += mat4(0.013333504, -0.22424631, -0.25461286, -0.09366057, -0.24168679, -0.1413706, -0.084172204, 0.1557298, 0.023721283, 0.18159337, -0.029377997, -0.12690134, -0.07779016, 0.49728185, 0.060146395, 0.17318316) * go_1(0.0, -1.0);
    result += mat4(0.08302447, 0.86936367, -0.17584775, -0.2508983, 0.16770333, 0.106514744, 0.056097895, -0.1516464, -0.04237734, 0.3350473, 0.08797126, 0.053822745, 0.36157215, -0.04365805, -0.20060433, -0.23983552) * go_1(0.0, 0.0);
    result += mat4(0.09215062, 0.0729301, 0.2564446, -0.09456067, -0.04279617, 0.009632537, -0.067693666, 0.07115211, -0.58410543, 0.7954688, -0.6856004, -0.0039867237, 0.05259691, -0.19899113, 0.34015554, -0.1301164) * go_1(0.0, 1.0);
    result += mat4(-0.08229732, 0.22852908, -0.17944984, -0.053203765, 0.01401186, -0.01731911, -0.017196467, 0.017660033, -0.06473575, 0.11841842, -0.09651762, 0.08812678, 0.15789783, 0.41068667, -0.17433365, 0.112683386) * go_1(1.0, -1.0);
    result += mat4(0.19192256, -0.048173536, -0.27452058, -0.086614236, 0.03459962, -0.076093, -0.13129567, 0.10529364, -0.003243667, -0.11558274, 0.15014142, -0.11415493, -0.058378108, -0.23308878, 0.016655494, -0.06092205) * go_1(1.0, 0.0);
    result += mat4(0.053656723, -0.2520498, -0.06450468, 0.14063323, -0.07785553, 0.06996582, 0.043691944, -0.09447727, -0.19854756, 0.08710172, 0.103271045, -0.20072943, -0.10393605, -0.19852036, -0.01656043, 0.19936512) * go_1(1.0, 1.0);
    result += mat4(-0.043692272, -0.15573448, -0.07609012, -0.25906095, 0.042468645, 0.06499704, 0.021691361, -0.14418614, 0.007778065, -0.04098781, 0.16854198, 0.1880123, -0.0024735837, -0.38171276, 0.29813913, -0.13975172) * go_2(-1.0, -1.0);
    result += mat4(0.0786739, -0.13743922, -0.16762766, 0.0551441, -0.16237186, 0.47069517, -0.16434868, 0.38760075, 0.29262593, 0.21078295, 0.1564407, -0.19921672, -0.07819381, 0.045407712, 0.25388238, 0.12049804) * go_2(-1.0, 0.0);
    result += mat4(0.13686253, 0.15139718, -0.14193471, -0.037212268, 0.017021572, -0.13029522, -0.07875422, 0.22883393, -0.117323294, -0.11999564, 0.074406326, 0.029792523, 0.071242705, 0.04940517, 0.27540857, 0.094216466) * go_2(-1.0, 1.0);
    result += mat4(0.05651692, -0.09319446, -0.15223487, -0.16004439, 0.09602424, 0.114855476, 0.13851804, 0.11632249, -0.15697844, -0.03465572, -0.6334014, 0.0043645306, -0.13810518, -0.24692737, -0.13962403, -0.17288178) * go_2(0.0, -1.0);
    result += mat4(-0.1125169, 0.2582768, 0.14571975, 0.3412717, 0.046649273, 0.053606547, -0.5402628, -0.14801335, -0.12299524, 0.79026186, -0.3587726, -0.040698707, 0.18239951, 0.18461016, -0.13213885, -0.6929199) * go_2(0.0, 0.0);
    result += mat4(-0.009360833, 0.22758053, -0.334423, 0.35250792, 0.05025162, -0.1640276, 0.21909785, -0.12123492, -0.33830088, -0.26451996, 0.09280175, -0.18673559, -0.20446195, 0.13918248, 0.09164517, -0.20213476) * go_2(0.0, 1.0);
    result += mat4(-0.03443797, -0.25032473, -0.0018426777, -0.065064386, 0.03455914, 0.022166712, -0.2954429, 0.012212829, -0.0223488, 0.1161553, -0.106024936, 0.028343895, 0.15230536, -0.5538007, -0.24089493, 0.06740007) * go_2(1.0, -1.0);
    result += mat4(0.09501347, -0.0845406, -0.13952151, 0.031915456, 0.05118853, -0.25089842, -0.113984115, 0.08745874, 0.14493734, 0.17449388, 0.037183553, 0.060414817, 0.045083977, -0.50209135, -0.25451177, 0.23309624) * go_2(1.0, 0.0);
    result += mat4(0.08991499, 0.14019197, -0.12056033, -0.05024532, -0.07585356, 0.073596515, 0.017992107, -0.0009288775, -0.17292187, 0.07525249, 0.14620323, -0.058494095, 0.09669742, -0.28342497, 0.10102461, 0.0075472025) * go_2(1.0, 1.0);
    result += mat4(-0.059322756, 0.07296391, -0.22688308, 0.17183779, 0.0921908, -0.18311407, -0.10553935, -0.2998603, -0.05373476, -0.08882287, 0.009316159, -0.09303765, 0.08415284, -0.044707574, 0.07481887, 0.06931905) * go_3(-1.0, -1.0);
    result += mat4(-0.26374707, 0.17429374, -0.54841083, 0.23039351, 0.1550329, -0.0991982, -0.07031106, -0.23306605, -0.076208115, 0.058818877, 0.48602778, -0.116065495, 0.13632986, 0.5399192, -0.088733315, -0.04031161) * go_3(-1.0, 0.0);
    result += mat4(-0.118198454, -0.04607605, -0.10619185, 0.034395956, 0.0023600461, 0.1470174, -0.21100855, -0.024570175, -0.0016899678, 0.1612513, -0.03985272, 0.01355469, 0.30949214, -0.056687307, 0.1295898, 0.031099077) * go_3(-1.0, 1.0);
    result += mat4(-0.37869355, 0.06961967, 0.2779311, 0.3090361, 0.23564096, -0.014765556, -0.097406775, -0.08233581, -0.05444356, -0.056364074, -0.13940345, -0.1710778, 0.053456437, -0.5668305, -0.21371025, -0.11354647) * go_3(0.0, -1.0);
    result += mat4(-0.2009931, -0.46823156, 0.04674297, -0.33720648, -0.48212242, -0.022402052, 0.4083246, 0.3498801, -0.12801081, 0.080993176, 0.12559398, 0.30281347, -0.36876208, -0.19425368, 0.040795308, 0.4358033) * go_3(0.0, 0.0);
    result += mat4(-0.008429336, -0.007929484, -0.21348138, 0.19799937, -0.0032136212, -0.037011284, 0.060586747, -0.012355498, 0.37488303, -0.626778, 0.45391387, -0.030982537, 0.26613617, -0.027296683, -0.094556324, 0.03054091) * go_3(0.0, 1.0);
    result += mat4(-0.0032568173, -0.3056237, 0.0007252052, 0.052250773, -0.05099108, 0.23182255, -0.044636346, 0.08786388, -0.12470104, -0.16238213, 0.16018245, -0.11313074, -0.044513255, -0.2792024, 0.13793966, -0.20955163) * go_3(1.0, -1.0);
    result += mat4(-0.14750522, -0.022307748, -0.15649515, 0.15537989, -0.061475005, 0.19822353, 0.0671258, -0.06628393, -0.04068137, 0.22010179, 0.12955783, -0.0517817, 0.02655539, 0.17269138, -0.1296634, 0.030146338) * go_3(1.0, 0.0);
    result += mat4(0.061146796, 0.31339607, 0.034430694, 0.10376425, 0.03029668, -0.0401898, -0.1825413, 0.06257798, 0.08390942, -0.31551626, 0.010347497, -0.0031549276, 0.21435012, -0.13221692, -0.021980911, -0.1482502) * go_3(1.0, 1.0);
    result += vec4(0.039428633, 0.032666046, 0.16482623, -0.016402772);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x48
//!HOOK MAIN
//!BIND conv2d_6_tf
//!BIND conv2d_6_tf1
//!BIND conv2d_8_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!SAVE conv2d_9_tf
//!WIDTH conv2d_6_tf.w
//!HEIGHT conv2d_6_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_6_tf_tex(conv2d_6_tf_pos)), 0.0))
#define g_1 (max((conv2d_6_tf1_tex(conv2d_6_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_6_tf_tex(conv2d_6_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_6_tf1_tex(conv2d_6_tf1_pos)), 0.0))
#define g_4 (max((conv2d_8_tf_tex(conv2d_8_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_8_tf_tex(conv2d_8_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(0.13591515, 0.21395922, 0.040862843, 0.3054825, -0.088837944, -0.6928339, -0.15643471, 0.13081591, 0.07604966, 0.37446347, -0.34723157, -0.17870799, -0.2037286, -0.106576756, 0.25523958, -0.13762575) * g_0;
    result += mat4(0.21503459, 0.0373132, -0.008046219, -0.18440363, -0.09729587, 0.043958187, 0.23459528, -0.044009138, 0.1686642, -0.1615934, -0.13173419, -0.079085656, -0.07647595, -0.37286422, -0.06148421, 0.015342882) * g_1;
    result += mat4(-0.14785692, -0.2707874, -0.017647093, -0.2908642, 0.5612585, 0.4271698, -0.48191005, 0.11905855, -0.21741737, -0.2821245, 0.29278705, -0.20538986, 0.03150152, 0.03138199, 0.10423793, -0.045527548) * g_2;
    result += mat4(0.31277063, 0.07915742, -0.34087706, 0.39680582, -0.022496004, -0.33672526, -0.111507386, 0.025953399, -0.15757395, 0.11465282, 0.28329894, 0.12420795, -0.36261007, 0.46334505, 0.30303243, -0.03249052) * g_3;
    result += mat4(0.57927984, 0.06878386, -0.24236098, 0.31338137, 0.10464923, -0.07153124, 0.13588428, -0.02373762, -0.19124955, -0.1138502, 0.17388438, 0.01707623, -0.24228282, 0.04736911, 0.6398566, -0.32334659) * g_4;
    result += mat4(-0.54402775, -0.24674532, 0.11212342, -0.09593871, -0.17339998, 0.1323692, -0.1680261, 0.025882099, -0.19121705, 0.1832492, -0.08548955, -0.14068407, 0.13255714, 0.10409962, -0.01394588, 0.22216345) * g_5;
    result += mat4(0.2702694, -0.56255573, -0.5357781, 0.05541389, 0.070275396, -0.08012564, -0.13473864, -0.113696516, 0.06642909, 0.23810093, 0.0728827, -0.17656006, 0.48172018, -0.25749484, -0.1752313, 0.33768335) * g_6;
    result += mat4(0.46950498, 0.059317388, -0.09860531, -0.006304164, -0.4128484, -0.049649406, 0.2954393, -0.190237, -0.20938443, 0.034176145, 0.063109055, 0.07802573, -0.20652357, -0.23180202, -0.11936575, 0.2589604) * g_7;
    result += mat4(0.3843954, -0.08686217, 0.18839231, 0.01876761, -0.03335079, -0.12043262, -0.42323095, -0.02321388, -0.22252762, -0.049455926, 0.2268798, 0.082169, 0.2473631, 0.23347862, 0.002254042, 0.2757807) * g_8;
    result += mat4(0.1020188, -0.037612554, -0.33062017, 0.1570476, 0.19851524, 0.35976177, -0.016449552, 0.22057539, 0.20401593, 0.07004227, -0.062413715, -0.10547836, 0.14671406, -0.3905135, -0.038352408, -0.28926837) * g_9;
    result += mat4(0.4110517, 0.06280497, 0.16709873, -0.49500167, -0.10045096, -0.2238529, 0.012172345, 0.19666891, -0.16135901, 0.017100533, 0.35809904, 0.35188627, 0.20347194, -0.14602524, 0.71737736, 0.14195462) * g_10;
    result += mat4(-0.5236819, 0.4352016, -0.4066126, -0.04252335, 0.1086945, 0.145471, 0.21984594, -0.24670586, -0.07109616, -0.2711473, -0.89353126, -0.3953869, 0.17096898, 0.12978637, -0.42527854, -0.019720567) * g_11;
    result += vec4(-0.027689768, -0.16386859, -0.009289161, 0.09287236);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x48
//!HOOK MAIN
//!BIND conv2d_6_tf
//!BIND conv2d_6_tf1
//!BIND conv2d_8_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!SAVE conv2d_9_tf1
//!WIDTH conv2d_6_tf.w
//!HEIGHT conv2d_6_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_6_tf_tex(conv2d_6_tf_pos)), 0.0))
#define g_1 (max((conv2d_6_tf1_tex(conv2d_6_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_6_tf_tex(conv2d_6_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_6_tf1_tex(conv2d_6_tf1_pos)), 0.0))
#define g_4 (max((conv2d_8_tf_tex(conv2d_8_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_8_tf_tex(conv2d_8_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(0.19380243, 0.020101497, 0.021015864, 0.40521726, 0.038862754, -0.3473658, 0.22289194, -0.2075226, -0.15960178, 0.20686232, -0.19066268, -0.24524036, -0.19289994, -0.6356018, 0.040245753, -0.22887161) * g_0;
    result += mat4(-0.06837712, -0.59243137, 0.08107887, -0.18099897, 0.08890105, -0.20113088, 0.0076543097, -0.28404838, -0.39403212, 0.124420464, 0.07661543, -0.16511264, 0.440653, 0.17841326, -0.40957427, -0.055862557) * g_1;
    result += mat4(-0.052128255, -0.17906874, -0.0063690864, -0.3027001, -0.12118662, 0.5986499, -0.35075194, 0.11334461, -0.13089949, 0.48732534, 0.31238684, 0.0636065, 0.21470545, -0.12680373, 0.20702313, -0.14277203) * g_2;
    result += mat4(-0.13521394, 0.5266374, -0.4765612, 0.32102558, -0.07704129, -0.26604977, 0.36475307, 0.27245706, 0.16729634, -0.04975267, 0.18763311, 0.07594951, -0.20137721, 0.07614109, -0.056586545, 0.35838535) * g_3;
    result += mat4(0.22150421, -0.023909386, -0.30742592, 0.54860467, 0.038963366, -0.47929683, 0.001491465, -0.2016597, 0.14891255, -0.12298715, 0.12770613, 0.16882578, 0.52988553, -0.34417477, -0.11196754, 0.038432673) * g_4;
    result += mat4(0.10892675, 0.15687913, 0.4061297, -0.2549851, -0.12231971, 0.7066191, -0.038577385, 0.1871752, -0.23520122, 0.6384404, -0.04857454, -0.23879313, -0.26810166, -0.08090798, 0.3287431, 0.15214305) * g_5;
    result += mat4(0.16076286, 0.08942198, 0.79264593, -0.5107746, -0.10051664, -0.18325275, 0.31161344, 0.023725776, 0.09911152, 0.1552438, -0.22447744, -0.2995641, 0.27984253, -1.107023, 0.010454479, 0.6606262) * g_6;
    result += mat4(0.041668475, 0.16935597, -0.11855577, 0.2013473, 0.2991738, -0.38238418, 0.17906274, -0.27559698, -0.4381387, 0.39814267, -0.40905684, 0.57992136, 0.2830281, 0.12482517, -0.30402762, 0.47808015) * g_7;
    result += mat4(0.05201121, 0.3396993, -0.04965309, -0.25744373, -0.13495848, -0.120026626, 0.15645088, -0.20658544, 0.414069, -0.03110071, 0.070210315, 0.028046172, -0.17324251, 0.14329922, -0.14353131, 0.028436944) * g_8;
    result += mat4(-0.15607943, 0.98266315, -0.15506491, 0.34884667, -0.16584046, 0.07532187, 0.0062847883, 0.8719761, -0.30521882, -0.34961814, -0.055313803, 0.041199762, 0.2634066, 0.31106153, 0.029962108, -0.017541675) * g_9;
    result += mat4(0.1285044, 0.41011113, 0.16163284, -0.40202442, 0.33554438, -0.2626098, 0.18437132, 0.06627138, 0.26390168, -0.23918642, -0.17191365, -0.16348109, 0.30074367, -0.99079835, 0.60264456, 0.050881945) * g_10;
    result += mat4(0.3971443, -0.034655187, 0.11870823, 0.39984652, -0.45068088, -0.054210827, -0.27554438, -0.16074227, -0.14983663, 0.35434055, 0.42479035, 0.07799301, -0.4260275, 0.66214204, -0.095251344, 0.09080398) * g_11;
    result += vec4(-0.012729538, -0.13335368, 0.14840336, 0.025965473);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_9_tf
//!BIND conv2d_9_tf1
//!SAVE conv2d_11_tf
//!WIDTH conv2d_9_tf.w
//!HEIGHT conv2d_9_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_9_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_9_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_9_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_9_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.22341304, 0.26908797, 0.04134543, 0.06961319, 0.32176727, 0.07702703, 0.03751845, -0.13761088, -0.09979559, 0.06891045, -0.01716057, -0.031486046, -0.016294012, 0.0262252, 0.012725462, -0.054174248) * go_0(-1.0, -1.0);
    result += mat4(0.0758998, 0.044578414, -0.058127478, -0.04941571, 0.1685694, 0.9547572, 0.3217995, 0.04913146, 0.08628588, -0.49687696, 0.05530926, -0.19010891, 0.0077229803, 0.3938303, 0.18076055, -0.048131783) * go_0(-1.0, 0.0);
    result += mat4(0.03656385, 0.23112705, 0.13059878, 0.16223684, -0.2766845, 0.053392846, 0.06446786, 0.19696166, -0.14884388, -0.23103243, -0.07006061, -0.021727445, 0.026394684, -0.31138313, -0.0976933, -0.062459927) * go_0(-1.0, 1.0);
    result += mat4(-0.36985022, -0.3396681, 0.035750575, 0.019713784, 0.10074354, -0.34114882, -0.01150834, -0.1436701, -0.36870074, -0.3272402, -0.03879516, -0.094077155, 0.016875539, 0.23895474, -0.14396004, -0.06785279) * go_0(0.0, -1.0);
    result += mat4(0.057131216, -0.5966212, -0.13011967, -0.3684052, 0.6414469, 0.45823926, 0.043126952, -0.12702179, 0.029217511, 0.43957123, 0.06747733, 0.35508418, -0.13576074, 0.28117993, 0.1785782, 0.20060769) * go_0(0.0, 0.0);
    result += mat4(0.112133466, 0.2773932, -0.047416527, -0.06561597, 0.093935706, 0.032524325, 0.02208551, 0.10400939, -0.0062363064, 0.20578235, 0.124429, 0.045867924, 0.024913216, -0.07508951, -0.1506746, -0.07368737) * go_0(0.0, 1.0);
    result += mat4(0.029188056, 0.13675697, -0.10047892, -0.15162368, 0.11152231, 0.17758776, 0.04638467, -0.15375991, -0.08195171, -0.00092798605, -0.11137887, -0.20476487, -0.06701632, -0.38742077, 0.10833869, 0.07575963) * go_0(1.0, -1.0);
    result += mat4(0.12579612, -0.13082299, 0.022704111, -0.049295194, 0.02813974, 0.06766161, 0.021488592, -0.22899324, -0.13967377, -0.42789128, -0.15561862, -0.13880157, -0.31957027, -0.051553562, -0.15501565, -0.17607704) * go_0(1.0, 0.0);
    result += mat4(-0.014785312, -0.3358245, 0.09859993, 0.17852743, 0.06758491, 0.040827237, -0.014897847, -0.027630018, -0.041637477, -0.10967412, -0.10507281, 0.058183335, -0.01929858, 0.09047934, -0.19679205, -0.16896065) * go_0(1.0, 1.0);
    result += mat4(-0.19059956, 0.059083544, -0.07367043, 0.10374235, -0.12928921, 0.16821185, 0.03542259, 0.07853399, -0.029948441, 0.045060057, 0.10522493, 0.15548709, 0.13417992, 0.12784965, 0.068737574, 0.024369959) * go_1(-1.0, -1.0);
    result += mat4(-0.2539489, -0.15361321, -0.024794202, 0.23387837, -0.021986792, 0.035640705, -0.053465687, 0.041275553, -0.12349385, 0.11599216, -0.12158652, -0.0016647653, 0.03552641, 0.15126309, 0.10521408, 0.022221778) * go_1(-1.0, 0.0);
    result += mat4(-0.09391041, 0.21640098, 0.06468435, 0.021124857, -0.017427467, 0.14731239, 0.0888631, 0.06669842, 0.16802992, -0.042000934, -0.007442969, -0.17762569, -0.106376246, -0.007006815, 0.048836768, 0.07634349) * go_1(-1.0, 1.0);
    result += mat4(-0.08242374, -0.35055616, 0.11752318, 0.06287576, -0.08078838, 0.015269983, 0.07802465, 0.036515962, -0.047435157, -0.23535018, 0.10882656, 0.00760307, 0.20816213, 0.16291322, -0.17480974, -0.09656055) * go_1(0.0, -1.0);
    result += mat4(0.3776239, 0.48836887, 0.046571143, -0.0005301381, 0.111404456, -0.2056147, 0.0976322, -0.07087254, -0.23208277, 0.64508325, 0.029519977, -0.32163903, 0.12203931, 1.2488136, 0.0713469, -0.12589021) * go_1(0.0, 0.0);
    result += mat4(-0.1458724, -0.2927259, -0.11825573, 0.050236594, 0.005908592, 0.009147886, 0.014676971, -0.09960781, -0.031219782, 0.0008116867, -0.16999915, -0.08393424, -0.017762119, 0.15271363, 0.17894958, 0.104973435) * go_1(0.0, 1.0);
    result += mat4(0.15102111, -0.017580042, -0.009878415, 0.09603493, -0.14158034, 0.01766169, 0.026301328, 0.14016923, 0.07513633, 0.12250821, 0.14139763, 0.119470306, 0.056335848, 0.011718554, -0.051952817, -0.1087701) * go_1(1.0, -1.0);
    result += mat4(0.12267096, 0.22258927, -0.23374331, -0.336529, -0.03149633, -0.26095635, 0.00365308, 0.048830956, 0.035902984, -0.04686918, -0.08079191, -0.17013429, 0.0254567, -0.05592242, 0.0968047, 0.07426071) * go_1(1.0, 0.0);
    result += mat4(-0.16953564, 0.074455656, 0.0029755495, 0.20576377, -0.050961535, 0.060958825, 0.014226229, 0.104992926, 0.06942283, 0.29077423, 0.040234245, 0.12337425, -0.012045997, -0.11109262, 0.020255094, 0.08945579) * go_1(1.0, 1.0);
    result += mat4(0.2978639, -0.24613461, -0.083074145, -0.2367985, -0.13995647, -0.21201506, -0.16809967, -0.08163256, 0.22451796, -0.21319884, 0.097241744, 0.17276905, 0.059754357, -0.21800114, 0.016986718, 0.059852242) * go_2(-1.0, -1.0);
    result += mat4(0.10399378, 0.016165858, 0.006949626, -0.00957426, -0.07206657, 0.85400176, -0.069736175, 0.11563255, -0.15550873, 0.21035826, -0.09730208, 0.21803263, -0.029731166, 0.07174115, -0.075019605, 0.06605764) * go_2(-1.0, 0.0);
    result += mat4(0.008660154, -0.1689362, -0.13275097, -0.14157207, -0.06571528, 0.2641335, 0.17738026, 0.016201235, -0.058384545, -0.089386165, -0.10691102, 0.03380599, 0.07696467, 0.010921241, -0.05858657, 0.044599395) * go_2(-1.0, 1.0);
    result += mat4(0.29438433, 0.39757052, -0.12448894, -0.14726874, 0.054101802, 0.19893955, 0.0081761405, -0.030686913, -0.09465847, -0.09517581, 0.0046200817, 0.2743172, 0.18768987, 0.2577441, 0.3185588, -0.0043636197) * go_2(0.0, -1.0);
    result += mat4(0.30364004, 0.45719072, -0.002478791, -0.25550374, 0.044718135, 0.9974692, 0.27661783, 0.38724384, 0.20643012, -0.36335453, 0.04044719, -0.15773767, 0.019318745, -0.015368104, -0.13033883, -0.21446472) * go_2(0.0, 0.0);
    result += mat4(0.17225221, -0.2870429, -0.11031537, -0.20985241, -0.1813215, 0.47034717, 0.19177493, 0.1565604, -0.22090979, -0.1778559, -0.15998572, 0.20591277, -0.27751637, -0.17734572, -0.22385214, 0.2001247) * go_2(0.0, 1.0);
    result += mat4(0.09103924, 0.012440279, -0.11811386, -0.28955194, -0.024203198, -0.014690502, -0.041423846, 0.0062359073, 0.06732812, -0.040848043, -0.0807372, -0.06598595, -0.020464217, 0.35617942, 0.054869782, -0.06990699) * go_2(1.0, -1.0);
    result += mat4(-0.22022852, -0.30250633, -0.008539953, -0.17535509, 0.048545327, -0.06961757, 0.1520779, 0.15551318, 0.145789, 0.41386685, 0.19608185, 0.02285933, 0.19650589, 0.1140758, 0.058065582, 0.06438903) * go_2(1.0, 0.0);
    result += mat4(0.17500387, 0.009752107, -0.08735754, -0.40322778, -0.04718948, -0.1520063, 0.015334469, 0.055586398, -0.06315823, 0.01381341, 0.06333497, 0.20780154, -0.14789844, 0.008873181, 0.20424104, 0.18570045) * go_2(1.0, 1.0);
    result += mat4(0.17809622, -0.054737452, 0.045792647, -0.05761767, 0.1530876, -0.058534857, -0.008100565, 0.036446143, 0.27693272, 0.3004126, -0.1283306, -0.50103384, -0.3350802, 0.09919993, -0.10481551, 0.059236333) * go_3(-1.0, -1.0);
    result += mat4(0.08178473, 0.01796507, 0.045470674, -0.1395204, -0.07053285, -0.15308544, -0.016434597, 0.09957456, 0.07303232, 0.5558379, 0.1058254, -0.12340164, -0.37540868, 0.20688659, 0.11254531, 0.08988308) * go_3(-1.0, 0.0);
    result += mat4(-0.115479395, -0.04145597, -0.02444945, -0.0012505532, -0.016777854, -0.21254961, -0.11969028, -0.10986302, 0.34061527, 0.35168666, 0.19457188, -0.25304377, 0.089430355, -0.13593785, -0.03715568, -0.07161111) * go_3(-1.0, 1.0);
    result += mat4(0.135465, 0.16024914, -0.16819438, -0.076060556, 0.14722055, -0.12402309, -0.091675736, -0.11345004, 0.3370019, 0.21161243, 0.08165217, 0.26650387, 0.11799823, 1.1248134, 0.031586587, 0.40626523) * go_3(0.0, -1.0);
    result += mat4(-0.3881156, 0.075572714, -0.2955678, -0.04820779, -0.14431494, 0.17108414, -0.031334974, 0.14272547, 0.10431918, -0.92185026, -0.550305, -0.09849551, -0.19279402, 0.47034186, 0.38574138, 0.5469418) * go_3(0.0, 0.0);
    result += mat4(0.07301299, -0.1655295, 0.0851716, 0.0349889, 0.037978686, -0.34476924, -0.09894407, -0.09279173, -0.017504893, 0.16626996, 0.23299451, -0.29538614, -0.035250418, 0.102075204, 0.014679606, 0.05283856) * go_3(0.0, 1.0);
    result += mat4(0.082496785, -0.047353677, -0.1036778, -0.014507561, 0.091381975, -0.07229443, -0.03069601, -0.07463806, 0.2173226, 0.061551273, 0.01672064, 0.065622196, 0.1645865, 0.08651663, 0.18979368, 0.2012662) * go_3(1.0, -1.0);
    result += mat4(-0.2116467, -0.26988897, -0.049475558, 0.18609211, -0.08837133, -0.219245, 0.05900789, -0.007832284, -0.028579885, 0.20587349, -0.07297767, -0.19551088, 0.052455146, -0.24630548, 0.12438646, -0.017073039) * go_3(1.0, 0.0);
    result += mat4(0.15815273, -0.13286865, -0.036927793, -0.118895106, 0.06876401, -0.08193885, -0.073907554, -0.17851423, 0.025570622, -0.05206693, 0.0054880823, -0.14550385, 0.031355973, -0.0617539, -0.09522895, 0.007602468) * go_3(1.0, 1.0);
    result += vec4(0.10656278, 0.12657918, 0.16990805, -0.12699938);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_9_tf
//!BIND conv2d_9_tf1
//!SAVE conv2d_10_tf
//!WIDTH conv2d_9_tf.w
//!HEIGHT conv2d_9_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_9_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_9_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_9_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_9_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.07384766, -0.027958225, 0.37361667, -0.082532816, 0.14156812, 0.02939518, 0.22737388, 0.19935979, -0.090212055, 0.04403584, 0.18456662, -0.026585983, 0.22868252, 0.09938934, -0.08726494, -0.115827106) * go_0(-1.0, -1.0);
    result += mat4(-0.09788985, -0.3116416, 0.35298944, -0.08990593, 0.16181462, -0.22193117, -0.5422943, 0.23932208, 0.15739329, -0.06103239, 0.7953177, -0.047183976, 0.21341586, 0.19858226, 0.0016054768, 0.054749873) * go_0(-1.0, 0.0);
    result += mat4(-0.026696216, 0.061291914, -0.35742328, 0.00082715444, 0.10632543, -0.09428293, -0.12645036, -0.043706786, 0.09915236, 0.13788143, 0.15950204, -0.089837976, 0.04461279, -0.054954246, 0.04740199, 0.07014664) * go_0(-1.0, 1.0);
    result += mat4(-0.12016896, 0.16669498, 0.26552972, -0.35876223, 0.045097463, -0.15016092, -0.0988156, -0.416339, -0.0101760905, 0.26459762, 0.31927487, -0.16307381, 0.12096833, -0.06770049, -0.017283063, 0.013299284) * go_0(0.0, -1.0);
    result += mat4(0.15951112, 0.14506923, 0.6747884, -0.24716964, -0.3413045, -0.2017185, -0.9612693, 0.5421329, -0.16023788, 0.32216108, 0.062496744, 0.21633703, 0.004581572, 0.2359334, -0.35295007, 0.09726352) * go_0(0.0, 0.0);
    result += mat4(0.13874753, -0.0063067, -0.14469895, 0.11554976, -0.019183924, -0.04544159, -0.29430693, -0.10431769, 0.15769906, 0.00601582, -0.454376, -0.11790236, 0.16000259, 0.29670846, -0.9759625, 0.31053123) * go_0(0.0, 1.0);
    result += mat4(0.014491841, 0.0074491766, -0.09696308, -0.09127842, -0.03579932, -0.20163259, -0.21284793, -0.261139, 0.24359487, 0.14113441, 0.23983651, -0.16634561, -0.09547295, 0.10859189, 0.13468629, 0.33521304) * go_0(1.0, -1.0);
    result += mat4(0.008276171, 0.12959969, 0.5093179, 0.002464717, 0.016199486, -0.03156574, -0.4428472, -0.10885838, -0.049632378, 0.2476587, 0.07033375, -0.20044556, 0.04982328, 0.19631135, -0.33776414, -0.6421577) * go_0(1.0, 0.0);
    result += mat4(-0.04192616, 0.06393284, 0.07120974, 0.076716706, -0.09867013, -0.13239172, 0.012114291, -0.038557116, 0.029985918, 0.022090917, 0.07777519, 0.008410333, 0.0034299784, 0.062100925, -0.38884223, -0.01593217) * go_0(1.0, 1.0);
    result += mat4(-0.013629574, -0.06545711, 0.14423661, -0.03981215, -0.052800525, -0.058425374, -0.05814048, -0.11337634, 0.05479856, -0.010584571, -0.22650285, 0.056241333, -0.1396656, -0.0010838923, -0.30166936, 0.040658727) * go_1(-1.0, -1.0);
    result += mat4(0.045267094, -0.086306006, -0.05226326, 0.1539859, -0.02723665, -0.13326567, 0.22143897, -0.018399606, 0.12181383, 0.1452545, -0.3973738, -0.10285705, -0.15147118, -0.28072536, 0.4379245, -0.06340889) * go_1(-1.0, 0.0);
    result += mat4(0.14590915, 0.034363795, -0.02217679, 0.15465777, -0.020056443, 0.06256286, 0.00068213895, -0.004845135, 0.10313473, 0.13895464, -0.0957288, 0.10452721, -0.06313026, -0.06739777, 0.16052145, -0.115432285) * go_1(-1.0, 1.0);
    result += mat4(-0.083468825, 0.15143521, 0.19880214, -0.0054416056, -0.1074472, 0.027439727, -0.16624895, -0.026701076, -0.046576414, -0.061388403, 0.34304553, -0.08921803, 0.09399348, -0.043658186, -1.3050584, -0.07285428) * go_1(0.0, -1.0);
    result += mat4(-0.2544287, -0.38059148, 0.7181705, -0.44567156, 0.10387618, 0.06472145, 0.08178852, -0.016514499, -0.1630076, -0.16066378, -0.19193888, -0.24423774, -0.14821364, -0.28755048, -0.1322022, 0.25716448) * go_1(0.0, 0.0);
    result += mat4(0.13228743, 0.24624044, 0.10462062, 0.26341802, 0.035913363, 0.09206641, 0.044785645, 0.010443224, 0.05206244, 0.008345797, -0.32408288, -0.2484674, -0.027154556, 0.0006338974, 0.09008037, 0.027416239) * go_1(0.0, 1.0);
    result += mat4(-0.061936356, -0.07008738, -0.22344092, 0.20339371, 0.03216865, 0.103117235, 0.10232644, 0.10809929, 0.08320763, 0.058004253, -0.06520991, 0.038012277, -0.12916973, -0.1150849, -0.03713365, -0.0886423) * go_1(1.0, -1.0);
    result += mat4(0.3213531, 0.1826207, 0.022152286, 0.025484305, -0.054090437, 0.08160166, 0.13491987, -0.06896833, 0.10781034, 0.08944192, -0.34036443, -0.018937334, -0.18917687, -0.13239872, 0.11581373, -0.038915917) * go_1(1.0, 0.0);
    result += mat4(-0.20916902, 0.08310064, 0.19347866, 0.29880634, -0.007023385, 0.005319598, -0.06649972, 0.03248317, -0.04066817, -0.06176127, -0.41747397, 0.14132817, -0.021392342, -0.021360394, 0.101215124, -0.05375729) * go_1(1.0, 1.0);
    result += mat4(-0.008702178, -0.03840238, 0.13321695, 0.065163925, -0.062342774, -0.030948557, 0.0069512874, -0.2634128, -0.09415655, 0.02985776, 0.021763485, 0.27137864, -0.21608604, -0.19126832, -0.37335086, -0.16941321) * go_2(-1.0, -1.0);
    result += mat4(0.04631249, 0.33492458, -0.6266605, 0.20180638, 0.039800193, -0.14341171, -0.8203481, 0.04878081, 0.008235832, 0.15065777, -0.32971388, 0.1828355, -0.1510293, -0.17637968, 0.125366, -0.06719769) * go_2(-1.0, 0.0);
    result += mat4(-0.014685718, -0.04156494, 0.2728874, -0.106735535, -0.1312142, -0.05991217, 0.15173748, -0.09276527, 0.027946949, 0.12980466, 0.017537035, 0.058945708, -0.11254791, -0.06708247, -0.28308856, -0.058375884) * go_2(-1.0, 1.0);
    result += mat4(0.2220684, -0.19030218, -0.1259754, 0.09647918, -0.20530927, -0.16737363, -0.055208467, -0.067288965, 0.1428622, 0.08903465, 0.494294, 0.28669015, -0.17464463, -0.2190753, 0.13515279, 0.24887499) * go_2(0.0, -1.0);
    result += mat4(-0.24211104, -0.11129136, 0.03340221, 0.49835417, -0.11755811, -0.732711, -0.3876752, 0.6178176, 0.1437329, -0.05131951, -0.16705558, -0.3823752, -0.23198022, -0.27967533, 0.7223488, -0.5565778) * go_2(0.0, 0.0);
    result += mat4(-0.04738433, -0.14606567, 0.22317784, 0.0055712103, -0.064653076, -0.16446865, -0.10802961, -0.10179589, 0.060855757, 0.22762765, -0.037358448, 0.24772792, -0.15458576, -0.0770241, 0.43480682, 0.008342627) * go_2(0.0, 1.0);
    result += mat4(0.117756896, -0.06760757, 0.12629354, -0.13241243, -0.05329636, 0.031004142, 0.19809054, 0.1504123, -0.024029436, -0.011011192, -0.014698134, 0.12855798, 0.027526522, -0.102618076, -0.2597635, -0.23887417) * go_2(1.0, -1.0);
    result += mat4(-0.012681944, 0.088339254, 0.58977854, 0.020116867, -0.30643263, -0.11593101, 0.2829653, -0.060883448, 0.027514484, -0.19997032, -0.12530403, 0.3302542, -0.10344085, -0.0644199, -0.11374762, 0.38778695) * go_2(1.0, 0.0);
    result += mat4(0.073869206, -0.059440095, -0.016326021, -0.08571949, -0.04171866, 0.042949438, 0.13984677, -0.15829174, -0.025245706, 0.0059198164, -0.0432442, 0.20765327, -0.058762096, 0.11539401, 0.036120266, 0.24331446) * go_2(1.0, 1.0);
    result += mat4(0.012567978, 0.07251118, -0.12190053, 0.10283353, 0.088345066, 0.0017397653, -0.2381744, 0.101314925, 0.022791719, -0.043069735, -0.15024713, -0.072577685, 0.19976862, -0.059844784, 0.38824072, 0.0020866133) * go_3(-1.0, -1.0);
    result += mat4(0.27314463, 0.0739519, 0.08960633, 0.03709254, 0.032681584, 0.22859, -0.41635752, -0.07382896, 0.13144481, -0.24017848, 0.07981319, 0.15370876, 0.059314378, 0.29214182, -0.39464346, -0.13867916) * go_3(-1.0, 0.0);
    result += mat4(-0.005685388, -0.039528795, -0.055917054, -0.06578973, 0.020702876, -0.00709528, 0.08486715, -0.0075865295, 0.05714374, -0.27417144, 0.4555885, 0.013780273, 0.05096835, 0.159233, -0.05228782, 0.15794256) * go_3(-1.0, 1.0);
    result += mat4(-0.0010807351, -0.022064442, 0.13078515, 0.11357431, 0.11269685, 0.029679844, 0.14385091, 0.10241993, 0.030162932, -0.016101424, 0.20761637, 0.4683215, 0.03091817, -0.58406824, -0.3438075, 0.3653469) * go_3(0.0, -1.0);
    result += mat4(-0.016927537, 0.13944507, -0.38772225, -0.11645372, -0.1683389, -0.081295304, 0.271328, 0.14980802, 0.47266555, 0.04091753, 0.006903156, -0.00832747, -0.056511678, 0.06924621, -1.0780094, 0.1268596) * go_3(0.0, 0.0);
    result += mat4(-0.21017683, -0.077091806, 0.28906518, 0.022843512, -0.062092084, -0.017447937, 0.25115407, -0.1367289, 0.0021664056, 0.0034106125, 0.5305142, -0.029012429, -0.014483031, 0.05575314, -0.35784876, -0.09252365) * go_3(0.0, 1.0);
    result += mat4(0.008859689, 0.06481962, 0.09483335, 0.18473764, 0.0015982646, -0.06144117, 0.054042596, -0.19934553, -0.20250106, 0.096015476, 0.21697922, 0.6265738, -0.16049659, -0.33120447, 0.27775142, 0.14459921) * go_3(1.0, -1.0);
    result += mat4(-0.11195867, 0.21663944, 0.5021048, 0.04712746, 0.08637696, 0.07792573, 0.23626573, -0.075164914, 0.06574307, -0.16795279, 0.06829719, -0.027584063, -0.015064924, -0.057976205, 0.14589287, -0.15683101) * go_3(1.0, 0.0);
    result += mat4(0.07626267, -0.03523683, 0.106941625, -0.15825523, 0.032598946, 0.038718563, -0.016688785, -0.054390162, 0.05544311, 0.13933052, 0.078817375, -0.10183935, 0.041770034, 0.032732744, 0.062236354, 0.0068387473) * go_3(1.0, 1.0);
    result += vec4(-0.11589812, -0.123082116, -0.003926807, -0.15363532);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x56
//!HOOK MAIN
//!BIND conv2d_9_tf
//!BIND conv2d_9_tf1
//!BIND conv2d_11_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!BIND conv2d_10_tf
//!SAVE conv2d_12_tf
//!WIDTH conv2d_9_tf.w
//!HEIGHT conv2d_9_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_9_tf_tex(conv2d_9_tf_pos)), 0.0))
#define g_1 (max((conv2d_9_tf1_tex(conv2d_9_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_9_tf_tex(conv2d_9_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_9_tf1_tex(conv2d_9_tf1_pos)), 0.0))
#define g_4 (max((conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_12 (max((conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_13 (max(-(conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.25229862, 0.22394362, 0.0050771693, -0.07544911, -0.11078993, -0.14940143, 0.009394699, 0.0110528935, 0.044721916, 0.26324025, -0.046336185, 0.38099283, 0.053437576, -0.07238376, -0.090147175, 0.5568665) * g_0;
    result += mat4(0.036739275, -0.2334262, 0.032853063, 0.24364692, -0.122930475, 0.1975849, -0.01315444, -0.13528247, -0.014283123, 0.057573725, 0.058717266, 0.16260214, 0.03097313, -0.11750414, -0.18610783, -0.23006414) * g_1;
    result += mat4(0.37318927, -0.26915783, 0.035015646, 0.2676218, 0.1748369, 0.094052985, -0.11020892, -0.14514406, 0.004877109, -0.26225975, 0.13958913, -0.16787122, 0.06908459, -0.10446216, -0.028498875, -0.28281447) * g_2;
    result += mat4(0.1980342, 0.021963626, -0.03271427, 0.28889674, 0.043385092, -0.16916741, -0.008713317, 0.00013464666, 0.0819348, 0.0152427135, -0.14862345, -0.15659885, -0.050634, 0.04153691, 0.042288564, 0.00585241) * g_3;
    result += mat4(-0.17560056, 0.3521319, 0.20137301, -0.25535235, 0.030570813, 0.2411823, 0.053508975, -0.34454364, 0.22279017, -0.41471666, -0.15029109, 0.22158626, -0.08751699, -0.09357398, 0.20704596, -0.20073438) * g_4;
    result += mat4(0.15419295, 0.31318265, 0.004593545, 0.78029615, -0.16751337, -0.32214537, -0.44051525, 0.22405408, -0.0064655836, 0.36599794, -0.26032063, 0.1850997, 0.13661511, -0.49070612, -0.34533858, 0.16373816) * g_5;
    result += mat4(0.09806042, 0.36764845, 0.11531638, 0.073847674, -0.16854957, -0.19408809, -0.16800502, -0.12827317, -0.5168489, 0.030958507, -0.03509507, 0.086487584, 0.01842899, -0.10123225, -0.17940263, -0.028054722) * g_6;
    result += mat4(0.21619087, -0.05322262, -0.31423846, 0.37783054, 0.20402598, 0.53124064, -0.012658878, 0.20003271, -0.17958061, -0.37326333, -0.24583863, 0.057008818, -0.13031931, -0.031875104, -0.2130229, 0.44612458) * g_7;
    result += mat4(0.25865164, -0.28258085, 0.09512834, 0.054259088, 0.25939894, 0.38799945, -0.33007956, 0.6692063, -0.22719514, 0.16910313, 0.056874167, 0.016987909, -0.19956954, -0.20683451, -0.19937307, -0.41771019) * g_8;
    result += mat4(0.23592101, -0.15792374, -0.06965535, 0.30855724, -0.22757038, 0.12033792, 0.3199687, 0.2674324, 0.112318985, -0.14153072, -0.13629095, 0.13337436, 0.09185144, 0.24124412, 0.028630963, 0.22709718) * g_9;
    result += mat4(0.44043523, 0.32490492, -0.117098905, 0.38431495, 0.07962198, 0.1517891, 0.22628377, 0.13990402, 0.38505656, -0.014830039, 0.20684186, 0.065970615, -0.054330014, -0.046108313, 0.49422976, 0.13082288) * g_10;
    result += mat4(-0.08174229, -0.013488396, -0.09494761, 0.31210786, -0.14530393, -0.22510533, -0.30971226, -0.17040919, -0.64233893, -0.07164386, -0.20537859, -0.17981663, -0.0060102916, -0.10167985, -0.24380594, 0.36305648) * g_11;
    result += mat4(-0.23301682, -0.19649999, -0.0016176507, 0.7897105, -0.68460715, -0.06446943, -0.5841334, -0.17928797, 0.021772655, 0.46175778, 0.36450028, 0.27175686, -0.03546283, -0.19889158, -0.24603742, -0.090037055) * g_12;
    result += mat4(0.1085313, 0.04249687, 0.13247591, 0.09551512, -0.37197208, 0.3261908, -0.13848339, -0.13538006, 0.13875476, -0.3748712, -0.21430004, 0.09772982, -0.35635203, 0.13196826, -0.09840773, -0.21841893) * g_13;
    result += vec4(0.062238827, 0.069814906, -0.107347876, 0.64385885);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x56
//!HOOK MAIN
//!BIND conv2d_9_tf
//!BIND conv2d_9_tf1
//!BIND conv2d_11_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!BIND conv2d_10_tf
//!SAVE conv2d_12_tf1
//!WIDTH conv2d_9_tf.w
//!HEIGHT conv2d_9_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_9_tf_tex(conv2d_9_tf_pos)), 0.0))
#define g_1 (max((conv2d_9_tf1_tex(conv2d_9_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_9_tf_tex(conv2d_9_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_9_tf1_tex(conv2d_9_tf1_pos)), 0.0))
#define g_4 (max((conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_12 (max((conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_13 (max(-(conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(0.22607668, 0.021170171, -0.06774968, -0.019062893, -0.029051676, 0.029224426, 0.097410545, 0.07505055, 0.17470665, -0.025774082, -0.041022647, 0.07615996, 0.031361237, -0.18075092, -0.01981288, 0.30251572) * g_0;
    result += mat4(-0.2228827, -0.18372375, 0.17952546, 0.031262513, 0.10978829, 0.095414534, -0.11202218, -0.017824037, 0.13419671, -0.056704585, 0.086960495, 0.089463, 0.0436869, 0.1987542, -0.24825421, -0.14668585) * g_1;
    result += mat4(-0.2848745, -0.09242928, 0.24002336, -0.06059541, -0.0066300016, 0.050746392, -0.26092768, -0.060129635, -0.2699064, -0.13927452, 0.3134039, -0.21668927, 0.0028670141, 0.044556674, 0.040246494, -0.26040232) * g_2;
    result += mat4(0.08408219, -0.038882803, -0.08522774, 0.1714629, -0.03067602, -0.10863579, 0.072058044, -0.012343554, -0.0076697394, 0.17840211, -0.2823912, 0.11976201, -0.05657313, 0.092938855, -0.060931504, 0.06991858) * g_3;
    result += mat4(0.09868284, 0.054261737, 0.13327791, -0.14897001, -0.06348394, 0.11385057, 0.09684055, -0.084950894, -0.3038146, -0.08645148, 0.035114545, -0.07148952, -0.15862693, 0.26620075, -0.018059343, 0.35772058) * g_4;
    result += mat4(-0.4964452, -0.32340884, 0.5129584, -0.090460144, 0.28658384, -0.117274396, 0.25311428, 0.119918026, 0.27442876, -0.19332558, -0.40261742, -0.0627285, -0.36318043, -0.07865861, -0.11114984, -0.1290027) * g_5;
    result += mat4(0.42158237, -0.032889403, 0.034080755, 0.25719455, -0.18799819, 0.0981468, 0.22785765, -0.07262642, 0.22532979, -0.09519116, -0.1005627, 0.1767603, -0.100850165, -0.06818755, 0.0059797456, -0.0718568) * g_6;
    result += mat4(0.12787001, -0.20670003, 0.0034799385, -0.024907416, 0.04423561, -0.13276835, -0.102332935, 0.14673741, 0.08700579, 0.08124997, -0.009865786, 0.041748982, -0.076119795, 0.09744985, 0.13542135, 0.12240728) * g_7;
    result += mat4(-0.1702021, 0.18497302, 0.06786661, -0.09040049, 0.15212716, 0.055503774, 0.020584844, 0.24927403, 0.23556694, -0.1571619, -0.02012801, 0.08423509, -0.114376806, -0.04171382, 0.040876187, -0.116261706) * g_8;
    result += mat4(-0.0854133, -0.023111762, 0.3320211, -0.21760856, -0.169973, 0.22671382, 0.4513697, 0.35962802, -0.1499719, 0.24696982, -0.29979527, 0.006662296, 0.20241787, -0.2276791, 0.059445832, 0.18853071) * g_9;
    result += mat4(-0.026398154, 0.124663144, 0.20381314, 0.2053697, 0.010302614, -0.050437275, 0.033807695, 0.014369258, -0.20720173, 0.05919782, 0.008449617, -0.31949872, 0.011598942, -0.0432789, 0.12732887, 0.049919438) * g_10;
    result += mat4(-0.06617085, 0.023928246, 0.1698239, 0.19584818, 0.022199618, -0.0040151025, -0.14364237, -0.06734091, 0.49634683, 0.40206975, -0.023004102, 0.16953272, 0.13243976, -0.47359994, 0.18358715, -0.15007599) * g_11;
    result += mat4(0.03754883, -0.84370553, -0.0057923268, -0.06449944, 0.09488198, -0.09577232, 0.31362334, -0.09768442, 0.15369056, -0.16346063, 0.41194627, 0.10364933, -0.2073915, -0.15944852, -0.57649344, 0.1580545) * g_12;
    result += mat4(-0.3224099, -0.17332473, 0.12429976, -0.12284861, 0.32270268, 0.2888736, -0.20192772, 0.15415959, -0.10240418, 0.09524166, -0.14117688, -0.1239787, 0.0015336396, 0.10390812, 0.20461708, -0.12672688) * g_13;
    result += vec4(0.01866206, -0.01430976, -0.04231479, 0.06331023);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x3x3x16
//!HOOK MAIN
//!BIND conv2d_12_tf
//!BIND conv2d_12_tf1
//!SAVE conv2d_13_tf
//!WIDTH conv2d_12_tf.w
//!HEIGHT conv2d_12_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv2d_12_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_1(x_off, y_off) (max((conv2d_12_tf1_texOff(vec2(x_off, y_off))), 0.0))
#define go_2(x_off, y_off) (max(-(conv2d_12_tf_texOff(vec2(x_off, y_off))), 0.0))
#define go_3(x_off, y_off) (max(-(conv2d_12_tf1_texOff(vec2(x_off, y_off))), 0.0))
vec4 hook() {
    vec4 result = mat4(0.09638616, 0.041973136, 0.032690834, 0.0017506832, 0.035889357, 0.046528358, 0.06497702, 0.06353481, -0.07129311, -0.027845494, 0.003971696, 0.015161773, -0.016153565, -0.02228567, -0.011083082, 0.037676543) * go_0(-1.0, -1.0);
    result += mat4(0.2134379, 0.26289365, 0.1335757, 0.13036838, -0.08787389, -0.106764, -0.048054244, 0.17788094, -0.15528837, -0.11408854, -0.06642222, -0.07838564, -0.09646518, -0.116988175, -0.22729287, -0.11145718) * go_0(-1.0, 0.0);
    result += mat4(0.09568265, 0.006643416, 0.11656759, -0.049414653, 0.14153476, -0.04269765, 0.09150523, 0.26861703, 0.16641477, -0.1080059, 0.22390138, -0.08730618, -0.01928994, -0.06351, -0.0022028533, 0.04301657) * go_0(-1.0, 1.0);
    result += mat4(-0.11731019, -0.040432923, -0.1977298, -0.17696093, -0.09182833, 0.071209684, -0.120773874, 0.021507429, -0.016429326, 0.04448132, 0.0681032, 0.044070866, -0.14647268, 0.008662263, -0.06507026, -0.075289875) * go_0(0.0, -1.0);
    result += mat4(0.5694518, -0.6138523, 0.28939885, -0.06047394, 0.11681902, -0.7026379, 0.20342608, 0.07128985, 0.06697409, 0.2678358, 1.1430641, 0.20436136, -1.6117494, 0.2799715, -0.01652429, -0.16711035) * go_0(0.0, 0.0);
    result += mat4(0.15830286, 0.16772346, -0.03232187, 0.029600514, -0.18494213, -0.25623813, 0.15487063, 0.06255487, -0.058094956, 0.19903323, 0.4756497, 0.6381142, -0.036022857, -0.09470495, 0.046093524, 0.031300675) * go_0(0.0, 1.0);
    result += mat4(-0.38466138, 0.16052443, -0.13819315, -0.059899956, 0.14069949, -0.1297194, 0.105595976, 0.13371274, 0.06298681, -0.038837492, 0.08675327, 0.1501906, 0.031129224, 0.029751344, -0.06775066, -0.047534525) * go_0(1.0, -1.0);
    result += mat4(0.097809926, -0.14269543, -0.14661346, -0.1819761, -0.023082452, 0.19019675, -0.15678905, -0.07669464, -0.07322769, -0.30472377, 0.33603573, 0.22620338, 0.05328552, 0.030486144, -0.037603505, -0.081246674) * go_0(1.0, 0.0);
    result += mat4(-0.15090303, -0.0650902, 0.11741429, -0.003369476, 0.043803368, 0.13717425, -0.038966697, -0.05230889, -0.0042353314, -0.017051768, 0.102879845, 0.044044945, -0.012893164, 0.0152335, 0.015073082, 0.08049258) * go_0(1.0, 1.0);
    result += mat4(-0.07802851, -0.07544602, -0.0039040581, -0.03915584, 0.115673676, -0.024907975, -0.011459969, 0.026098263, 0.043594692, 0.10627707, 0.027093858, 0.051561285, 0.071452856, -0.1758179, 0.28485832, 0.28952092) * go_1(-1.0, -1.0);
    result += mat4(-0.052147392, 0.18546684, 0.19015399, -0.053752594, -0.29468048, 0.010600442, -0.09287294, -0.09246605, 0.17687573, -0.04858957, 0.06478161, -0.0035372626, 0.5927226, 0.38359696, 0.33155236, 0.13010578) * go_1(-1.0, 0.0);
    result += mat4(0.04136322, 0.11806175, 0.19966072, 0.07308716, -0.09563447, -0.064514905, -0.0077517326, 0.11964638, -0.1460613, 0.02240298, 0.014256963, -0.0123070385, 0.1897282, -0.0058207656, 0.040057864, -0.49406672) * go_1(-1.0, 1.0);
    result += mat4(-0.43775788, -0.25118434, -0.3468631, -0.30180287, -0.27033472, -0.0023914252, 0.053275872, -0.021835659, 0.02879347, 0.036559265, 0.044093054, 0.12771723, 0.2702892, -0.2581491, -0.059361164, -0.046974897) * go_1(0.0, -1.0);
    result += mat4(-0.03310008, -0.5622936, 0.5419483, -0.3599514, 0.2634039, 0.3500813, 0.4152074, 0.24876466, -0.2629078, -0.18554081, -0.76194984, -0.54471385, 0.72921526, 0.3316481, -0.20936906, -0.16736485) * go_1(0.0, 0.0);
    result += mat4(0.07884802, 0.16494922, 0.2734585, -0.09396988, -0.14178166, -0.105561115, 0.006780099, 0.063054875, 0.12384575, -0.163967, -0.19682601, -0.1647527, 0.59927565, 0.24755491, -0.29760644, -0.074884824) * go_1(0.0, 1.0);
    result += mat4(-0.186745, 0.21136905, 0.027726538, 0.08498169, 0.009122279, 0.01566938, -0.051473126, 0.014151464, 0.04580383, 0.02071651, 0.14929157, 0.17253524, -0.034080226, 0.07048439, -0.11602547, -0.12655921) * go_1(1.0, -1.0);
    result += mat4(-0.2831727, -0.21816732, -0.37266397, -0.26041594, -0.18912914, -0.13482115, -0.10902061, -0.110694066, -0.20758803, -0.07158453, 0.14401175, 0.1590672, 0.27700564, -0.3202948, -0.23177631, 0.060082316) * go_1(1.0, 0.0);
    result += mat4(0.16861005, -0.13237478, -0.12109852, -0.16306286, 0.032467425, 0.009778175, -0.05084063, 0.02528882, -0.028993038, -0.06119019, 0.0124081755, -0.0819979, -0.2308113, -0.23910572, 0.3170529, 0.22742116) * go_1(1.0, 1.0);
    result += mat4(-0.19654512, 0.037653327, -0.015190324, 0.038381096, 0.034783594, -0.16242851, 0.07052334, 0.0019672879, 0.08069976, 0.090035714, 0.12597767, -0.00065050717, -0.10528094, 0.015088367, -0.045706235, -0.14849594) * go_2(-1.0, -1.0);
    result += mat4(-0.0981129, -0.0044483114, 0.00918156, 0.28903985, 0.23872024, 0.11113565, 0.23359483, 0.21115206, 0.2144387, 0.106830046, 0.03875094, -0.14864162, 0.19366172, 0.21310017, 0.06280982, -0.0581721) * go_2(-1.0, 0.0);
    result += mat4(-0.22814496, -0.08812413, -0.25392863, -0.02752917, 0.05930787, 0.08304853, -0.04027662, -0.010756739, 0.034590207, 0.070662424, 0.15285444, 0.058270697, -0.022838322, 0.024096202, 0.01309858, -0.10489201) * go_2(-1.0, 1.0);
    result += mat4(0.17219496, -0.0066256993, 0.1442649, -0.07291206, 0.34312358, -0.24952441, 0.040031537, 0.18302973, 0.0015231773, 0.24825755, -0.01807878, -0.037405558, 0.21687117, 0.02481246, -0.08312088, -0.14397743) * go_2(0.0, -1.0);
    result += mat4(0.2859165, 0.6145777, 0.060804237, 0.22117847, -0.25534254, 0.3753605, 0.4193899, 0.06387241, -0.13308842, 0.0012660836, -0.055252563, -0.2552111, 0.8831952, -0.16249466, 0.76958305, 0.3658401) * go_2(0.0, 0.0);
    result += mat4(-0.14865848, -0.13086087, 0.17719927, 0.2801542, 0.3776111, 0.20903045, 0.1710449, 0.25524843, 0.11910105, 0.034738105, -0.12101939, -0.22116004, 0.11605619, 0.16838482, -0.07223086, -0.15225673) * go_2(0.0, 1.0);
    result += mat4(0.101802975, -0.12683764, -0.21380596, -0.19243564, 0.017763488, 0.0076850834, -0.0107422285, 0.058099743, 0.03071978, 0.02958345, 0.09209252, -0.012379192, -0.058930825, -0.07321041, -0.09178575, -0.09764888) * go_2(1.0, -1.0);
    result += mat4(0.2205578, -0.053928245, -0.14290524, -0.18790527, 0.002521159, -0.23389481, 0.11274272, 0.17174199, 0.2128134, 0.14586388, 0.08666812, 0.052028902, 0.024853414, -0.027658377, 0.033780072, -0.0045349374) * go_2(1.0, 0.0);
    result += mat4(-0.053073518, 0.12716359, 0.008456044, 0.014315154, 0.01918925, -0.13495505, 0.08007481, 0.08627198, 0.024612406, 0.0021514448, 0.04478567, -0.034171678, 0.0027070146, 0.0149149615, -0.15999815, -0.1866448) * go_2(1.0, 1.0);
    result += mat4(0.040357295, -0.12759757, 0.03543834, -0.029329961, -0.078925595, 0.07807751, 0.08971355, -0.05469623, -0.08630596, -0.11219292, -0.08082983, -0.020131797, -0.04191703, 0.22003745, -0.28878415, -0.132956) * go_3(-1.0, -1.0);
    result += mat4(0.021098461, 0.048261415, -0.121181525, -0.24724431, 0.32716268, 0.03046708, -0.28138334, -0.22871564, -0.15983087, 0.10721642, -0.14833531, -0.115366876, -0.393837, -0.62930757, -0.29534766, 0.02588463) * go_3(-1.0, 0.0);
    result += mat4(-0.03972534, -0.051577512, -0.04452277, -0.12650263, 0.15491997, -0.026459083, 0.009715449, -0.20551588, -0.042652152, 0.119186826, -0.13313279, -0.13183416, -0.20730016, 0.003008999, -0.19962612, 0.1760052) * go_3(-1.0, 1.0);
    result += mat4(0.1724579, -0.3179752, 0.18908302, 0.40730157, 0.44569418, -0.038390577, -0.13144472, -0.18369946, -0.1654486, -0.2106428, -0.084723935, 0.10262653, -0.26097777, 0.15257284, -0.36599034, -0.30871773) * go_3(0.0, -1.0);
    result += mat4(-0.21338613, 0.680362, 0.079820015, 0.6081361, -0.9754953, -0.33735132, -1.2323227, -0.17950675, -0.31327835, 0.4732144, 0.22757599, 0.23051551, -0.8099572, -0.49106973, 0.96547806, 0.30975753) * go_3(0.0, 0.0);
    result += mat4(0.16933723, 0.17994887, -0.38310486, -0.4208871, 0.373761, 0.20749316, -0.080664486, -0.26229286, -0.04797456, 0.28605196, -0.040223103, -0.034632236, -0.5650002, -0.38834664, 0.14565933, 0.1488285) * go_3(0.0, 1.0);
    result += mat4(0.32558438, -0.18572666, 0.049500592, 0.2319145, -0.23547912, 0.2740939, 0.027905073, -0.022077003, 0.10860379, -0.15617043, -0.097419575, -0.11391895, -0.4266203, 0.060962453, -0.12154808, -0.19734453) * go_3(1.0, -1.0);
    result += mat4(-0.07880791, -0.2247225, 0.445858, 0.3889803, 0.14111102, 0.378859, 0.040187526, -0.021096235, 0.04169405, -0.075737596, 0.046068836, 0.11624106, 0.08169536, 0.3022304, -0.24427707, -0.34422734) * go_3(1.0, 0.0);
    result += mat4(0.13501012, -0.07389663, -0.010668981, -0.069029465, 0.06960202, -0.067375034, 0.08431378, 0.04207825, -0.121635035, -0.051126126, -0.1546829, 0.00073073455, -0.20674464, 0.27346626, -0.15771666, -0.024096) * go_3(1.0, 1.0);
    result += vec4(-0.17614856, -0.14261112, 0.14600825, 0.20389698);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x64
//!HOOK MAIN
//!BIND conv2d_12_tf
//!BIND conv2d_12_tf1
//!BIND conv2d_11_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!BIND conv2d_10_tf
//!BIND conv2d_13_tf
//!SAVE conv0ups
//!WIDTH conv2d_12_tf.w
//!HEIGHT conv2d_12_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_1 (max((conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_4 (max((conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_12 (max((conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_13 (max(-(conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_14 (max((conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
#define g_15 (max(-(conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.3378193, 0.013861057, 0.19208853, -0.05050854, 0.08691835, 0.16724123, 0.10351982, -0.40157926, -0.055889476, -0.040115904, -0.13351472, -0.7937818, 0.18700145, 0.109559685, -0.119053595, -0.12651901) * g_0;
    result += mat4(0.05863214, -0.011048432, 0.22007701, -0.21624403, -0.06139813, -0.06766812, 0.022506371, 0.17585056, -0.37994936, -0.018394569, 0.5127985, -0.19700864, -0.07880973, 0.15687309, -0.12574019, -0.19570859) * g_1;
    result += mat4(0.5059051, -0.010676642, -0.47922808, -0.017590942, -0.20583269, -0.10777252, -0.33185184, -0.0025075034, -0.1518394, 0.14268444, 0.005011664, 0.09016961, -0.46011007, -0.09428751, 0.34915137, 0.13334215) * g_2;
    result += mat4(-0.15615676, 0.09427065, 0.006016912, -0.0003997069, 0.16170138, 0.09666374, 0.14158808, -0.23772424, 0.39373854, 0.004074768, -0.28073287, 0.0032489141, 0.23473479, -0.12678933, -0.24589436, -0.21988034) * g_3;
    result += mat4(-0.12682347, 0.033012364, 0.18928578, 0.12523666, 0.12809147, 0.008567846, -0.10653368, -0.03712133, 0.075765386, -0.042196997, 0.039182812, 0.17273012, 0.21258987, 0.039698593, -0.0018848967, -0.07930902) * g_4;
    result += mat4(0.013454855, -0.18023406, -0.49323913, -0.032017395, 0.11903338, -0.043025218, -0.46579728, 0.21894619, -0.21387324, -0.13455649, 0.30638975, 0.3472243, 0.09305909, -0.015791988, 0.071368046, -0.038680866) * g_5;
    result += mat4(0.012506262, 0.09754124, -0.092920735, 0.23061672, 0.08051618, -0.38472125, 0.17626029, 0.009075537, -0.18316247, -0.1338181, 0.2650675, 0.0516641, 0.080453254, 0.22033659, -0.13004474, -0.07781194) * g_6;
    result += mat4(-0.12412428, -0.11978811, 0.06780084, -0.1710261, -0.09355731, 0.31283846, -0.022725523, -0.16437142, -0.11865966, 0.10907317, 0.22463441, 0.017325362, 0.02512185, -0.49577957, 0.2016018, 0.14196795) * g_7;
    result += mat4(0.02570746, 0.22231244, -0.10168496, -0.21518417, -0.0054759895, -0.32655567, -0.34048972, 0.11826245, -0.002854444, -0.11257602, -0.09318273, -0.10332744, 0.078923725, -0.11612356, -0.030546617, -0.12474622) * g_8;
    result += mat4(-0.11420135, -0.24489257, 0.15446539, 0.12646616, -0.07092042, 0.110105604, 0.054362826, 0.07867222, -0.15557991, 0.071640015, 0.21894808, 0.24164975, 0.0062167975, 0.10681122, -0.32373384, 0.06931269) * g_9;
    result += mat4(0.0769479, -0.09528171, -0.38724712, 0.010703831, -0.016925508, -0.018486671, 0.035855293, -0.17932071, -0.078450575, -0.036463127, 0.20942347, 0.060895607, -0.16549253, -0.008952913, 0.20420915, -0.009001661) * g_10;
    result += mat4(0.074243605, 0.015648128, -0.05003613, 0.10121142, -0.0218682, 0.006933849, 0.101385176, 0.16132122, 0.0013466089, 0.14042993, -0.25816667, -0.040413387, -0.19570185, -0.08637437, 0.17934911, 0.24961887) * g_11;
    result += mat4(-0.40401492, -0.16131033, 0.454142, 0.56882274, -0.013024656, -0.04423676, -0.023137214, 0.36117804, -0.0901519, -0.03237353, 0.010538879, -0.033432953, 0.105834074, -0.0549062, 0.05576519, -0.092626475) * g_12;
    result += mat4(-0.0017419134, -0.022569131, 0.027351622, -0.1289159, -0.0823291, -0.020735232, -0.28244564, -0.21001048, -0.048950948, 0.022033915, 0.14678808, -0.010097721, -0.06839686, 0.031720705, 0.11333891, 0.05049834) * g_13;
    result += mat4(-0.2191025, -0.005935159, 0.24627906, 0.058490098, -0.011270337, -0.019233467, -0.17698613, -0.0052346545, 0.2288101, -2.5289672e-05, 0.267102, -0.026019678, -0.17386179, -0.017672652, -0.35420522, 0.2836498) * g_14;
    result += mat4(0.19294678, 0.011570707, -0.34666267, -0.09040537, 0.18127288, 0.10182209, 0.08549184, -0.48737645, -0.040560674, 0.20645715, -0.68665904, -1.3146902, 0.18629448, 0.09806124, 0.09953519, -0.5450951) * g_15;
    result += vec4(-0.24792486, -0.09899526, 0.3761066, 0.022595163);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x64
//!HOOK MAIN
//!BIND conv2d_12_tf
//!BIND conv2d_12_tf1
//!BIND conv2d_11_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!BIND conv2d_10_tf
//!BIND conv2d_13_tf
//!SAVE conv0ups1
//!WIDTH conv2d_12_tf.w
//!HEIGHT conv2d_12_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_1 (max((conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_4 (max((conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_12 (max((conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_13 (max(-(conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_14 (max((conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
#define g_15 (max(-(conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(0.15938057, -0.23559119, -0.28445953, 0.05912659, 0.5229142, -0.02843545, -0.004113748, -0.056947608, 0.1367782, -0.026573306, -0.0056468234, 0.2564603, 0.25593445, 0.08957574, 0.26139608, -0.053708326) * g_0;
    result += mat4(0.1382045, -0.103480555, 0.05831098, 0.000735441, 0.20176832, -0.087079, -0.07839967, -0.0750771, -0.31373122, -0.27509713, -0.23071732, -0.2560584, 0.110963896, -0.052200988, 0.0015331429, -0.30707568) * g_1;
    result += mat4(-0.056460302, 0.2147989, 0.40628514, -0.058157466, -0.17940372, -0.033689886, -0.022241283, -0.0018471872, 0.26578268, -0.098452985, -0.01501511, -0.35676336, -0.07152056, -0.07245194, -0.32194778, 0.03888747) * g_2;
    result += mat4(0.09541087, 0.24680884, -0.045627397, -0.08557985, 0.08790337, 0.10179883, 0.3007415, 0.044102084, 0.1064372, 0.2994135, 0.15280741, 0.2683849, 0.24750276, -0.021364288, -0.004039902, 0.28266376) * g_3;
    result += mat4(-0.26525706, -0.08389754, -0.10918147, -0.06878537, -0.080960914, 0.03737948, 0.107663736, -0.0025957434, -0.10748625, 0.03004828, 0.03505711, 0.075969726, 0.06360464, -0.02740913, 0.025467616, 0.017698402) * g_4;
    result += mat4(-0.2370006, -0.07687027, 0.015225365, 0.17986605, 0.37507248, 0.2088343, 0.17946883, 0.2379337, -0.25194344, 0.035336476, -0.15362923, -0.008527836, 0.045963865, 0.025127884, 0.06973296, 0.063168526) * g_5;
    result += mat4(0.09583503, 0.15350054, -0.15248272, 0.045916792, -0.18339546, -0.29747355, 0.027330166, -0.39461568, 0.095963046, -0.1775004, -0.19221638, -0.15368307, 0.056089737, 0.18232727, 0.03182419, 0.30851522) * g_6;
    result += mat4(-0.053062204, -0.0018095247, -0.04514637, 0.05689337, 0.07561519, 0.17035827, -0.0048587993, 0.38348997, -0.063476466, 0.09454219, 0.03969728, 0.11693653, -0.0012066896, -0.25955358, -0.14428577, -0.19967856) * g_7;
    result += mat4(0.034378257, 0.16030714, 0.05160261, 0.21927983, -0.14469208, 0.041181874, 0.034202367, 0.07983977, 0.22149332, -0.08595994, -0.102985874, -0.07265774, -0.123233125, -0.12819915, 0.08662329, -0.12866889) * g_8;
    result += mat4(-0.1511104, -0.056531575, -0.023363205, -0.1909304, -0.15387732, 0.0671428, -0.15435332, 0.32735124, -0.3293996, 0.055349957, -0.043602336, 0.08102016, 0.200238, 0.13393362, 0.0044564987, 0.16932343) * g_9;
    result += mat4(-0.09768015, 0.09503259, 0.12768175, 0.109941825, 0.006567291, -0.102840215, -0.05611706, -0.06865725, -0.2605998, 0.00585688, -0.035119556, -0.06810342, -0.090756536, -0.079376444, -0.22370447, -0.05727839) * g_10;
    result += mat4(-0.101120085, 0.028628688, 0.07296149, 0.15868604, 0.047761433, 0.07732842, -0.016735386, 0.049528413, 0.45619023, 0.062347047, -0.026208224, 0.046785966, -0.05715451, 0.04459997, -0.13676195, 0.07778552) * g_11;
    result += mat4(-0.051393595, -0.12524572, -0.36763692, 0.039426118, 0.0349489, 0.07154008, -0.12969223, 0.30249006, -0.15237582, -0.06685149, -0.042049125, -0.0065471376, 0.017375907, -0.07143284, -0.018227521, -0.02778629) * g_12;
    result += mat4(-0.048270147, -0.07275859, 0.05502608, -0.034233145, 0.12822276, -0.02580663, -0.035358194, 0.05195595, 0.044340245, 0.04435722, 0.017985033, 0.007126749, -0.052825354, -0.059360538, -0.09412195, 0.060212586) * g_13;
    result += mat4(-0.18645881, -0.04506676, -0.035483524, 0.0063163475, -0.13747677, -0.046985928, 0.0015511635, 0.019160518, -0.4315584, -0.06979354, -0.001936674, 0.0034739177, 0.3490474, 0.15375568, -0.0085117165, 0.017511753) * g_14;
    result += mat4(0.20412005, 0.017221482, 0.08719384, -0.016668927, 0.10308073, -0.1013255, 0.087567665, -0.1004404, 0.9800944, -0.25387812, 0.36526182, -0.21970014, 0.36388537, -0.111629054, 0.21855496, -0.10375334) * g_15;
    result += vec4(-0.14657217, -0.04252579, -0.24773599, 0.13271233);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-4x1x1x64
//!HOOK MAIN
//!BIND conv2d_12_tf
//!BIND conv2d_12_tf1
//!BIND conv2d_11_tf
//!BIND conv2d_1_tf
//!BIND conv2d_4_tf
//!BIND conv2d_7_tf
//!BIND conv2d_10_tf
//!BIND conv2d_13_tf
//!SAVE conv0ups2
//!WIDTH conv2d_12_tf.w
//!HEIGHT conv2d_12_tf.h
//!COMPONENTS 4
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define g_0 (max((conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_1 (max((conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_2 (max(-(conv2d_12_tf_tex(conv2d_12_tf_pos)), 0.0))
#define g_3 (max(-(conv2d_12_tf1_tex(conv2d_12_tf1_pos)), 0.0))
#define g_4 (max((conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_5 (max(-(conv2d_11_tf_tex(conv2d_11_tf_pos)), 0.0))
#define g_6 (max((conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_7 (max(-(conv2d_1_tf_tex(conv2d_1_tf_pos)), 0.0))
#define g_8 (max((conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_9 (max(-(conv2d_4_tf_tex(conv2d_4_tf_pos)), 0.0))
#define g_10 (max((conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_11 (max(-(conv2d_7_tf_tex(conv2d_7_tf_pos)), 0.0))
#define g_12 (max((conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_13 (max(-(conv2d_10_tf_tex(conv2d_10_tf_pos)), 0.0))
#define g_14 (max((conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
#define g_15 (max(-(conv2d_13_tf_tex(conv2d_13_tf_pos)), 0.0))
vec4 hook() {
    vec4 result = mat4(-0.22553514, -0.086349756, -0.07735866, 0.48776403, -0.33010843, 0.28214008, -0.2242988, -0.11439686, -0.14720698, 0.2391116, 0.017813087, 0.4352493, -0.16412133, -0.12791261, -0.019643517, 0.19420698) * g_0;
    result += mat4(-0.9178235, -0.6335296, 0.11146894, -0.0759723, -0.4519685, -0.3007054, 0.014501872, 0.49081457, 0.10673664, 0.035011876, 0.10259641, 0.106546804, 0.5186602, 0.44900152, 0.20597687, -0.39562696) * g_1;
    result += mat4(-0.11399027, -0.19542706, 0.087422565, -0.70140034, -0.41029623, -0.049330976, 0.19682989, 0.22516033, -0.22858454, -0.12200487, -0.14852463, -0.40852943, -0.035900578, 0.1886829, 0.019452838, -0.16703403) * g_2;
    result += mat4(0.077843145, 0.7323388, -0.022324003, 0.09445821, 0.026166735, -0.1790519, 0.086004496, -0.40011314, 0.01210975, -0.053515363, -0.2501869, 0.06671936, -0.71530163, -0.57196116, -0.38604704, 0.5024949) * g_3;
    result += mat4(0.30748057, 0.12223383, 0.059069566, 0.18568543, 0.008148904, 0.009438993, 0.053996127, -0.19665428, 0.38345802, 0.20945628, 0.01368962, -0.2834185, -0.15974379, -0.4628119, -0.18307796, 0.22361058) * g_4;
    result += mat4(0.00833237, -0.10446639, -0.028896136, -0.18917766, -0.24016596, -0.034934085, -0.013062447, 0.079293504, -0.16635038, -0.11056953, 0.2618598, 0.07227063, 0.057050053, 0.013885738, 0.09385356, -0.27068567) * g_5;
    result += mat4(-0.5675842, 0.13328329, -0.0252242, 0.34746942, 0.34712863, 0.13635597, 0.02356317, -0.1617803, -0.16861948, -0.018621348, 0.02680753, 0.30408886, -0.034069773, 0.08948961, -0.057724215, 0.111602895) * g_6;
    result += mat4(-0.03835732, -0.11742271, 0.025922403, 0.24378933, -0.36450952, -0.15091905, 0.1214089, 0.21004228, 0.28717628, 0.17053549, 0.10836553, -0.08449643, 0.17507422, -0.03195037, -0.03947606, 0.050725944) * g_7;
    result += mat4(-0.21257977, -0.0043600267, -0.12929972, -0.233982, -0.26728988, -0.21511734, 0.07835361, -0.24275993, -0.359975, -0.23956355, -0.07852281, 0.40282407, 0.17184453, 0.11672362, 0.0433819, -0.032416925) * g_8;
    result += mat4(0.20235331, 0.16114245, 0.015931258, -0.17612378, 0.2449233, 0.0031623375, -0.2784109, 0.3347522, 0.46005112, 0.20291579, 0.13030154, -0.23390344, -0.39526668, -0.09738018, 0.013237711, 0.15512206) * g_9;
    result += mat4(-0.1434995, -0.12447443, 0.095140964, -0.08841888, -0.05424789, -0.11747197, -0.097216785, 0.12958516, 0.34194428, 0.111434594, -0.02794559, -0.22843723, -0.043816507, -0.16116165, -0.29044297, 0.33768278) * g_10;
    result += mat4(0.39615574, 0.05410518, -0.07885892, -0.22024721, 0.011598219, 0.1446308, 0.11650995, -0.020602686, -0.51892537, 0.14221898, -0.01697185, 0.05188913, 0.07683384, 0.122416414, 0.02296055, 0.2932525) * g_11;
    result += mat4(-0.058334768, -0.12389275, -0.02024463, 0.46323973, 0.17553197, 0.35435143, 0.19796194, 0.06836581, 0.15947883, -0.056819815, -0.091066726, 0.22499265, -0.21629064, -0.22203816, 0.053594038, 0.09816408) * g_12;
    result += mat4(-0.016514458, -0.14323495, 0.017527288, -0.19750872, -0.47891942, -0.073656894, -0.086305656, 0.38173944, 0.1016976, 0.15224999, 0.048396923, -0.19529565, 0.13985658, 0.07292602, 0.06549534, 0.210662) * g_13;
    result += mat4(0.3459035, 0.0071707424, -0.019186711, 0.2527976, 0.29675815, 0.35949966, -0.06114439, -0.02610484, 0.5475115, -0.13828747, 0.019238133, 0.101953685, -0.52718824, 0.017254699, 0.08887026, -0.19507161) * g_14;
    result += mat4(-0.3064509, -0.031613164, 0.040971015, -0.24252266, -0.21725285, -0.35069898, 0.0951283, -0.065222666, -0.98867434, 0.08824426, 0.06094605, -0.21000125, -0.72066385, -0.34141323, 0.049487203, 0.0690126) * g_15;
    result += vec4(0.25545248, -0.112931795, -0.073284395, 0.29349956);
    return result;
}
//!DESC Anime4K-v4.1-Upscale-GAN-x2-(M)-Conv-3x3x3x24
//!HOOK MAIN
//!BIND MAIN
//!BIND conv0ups
//!BIND conv0ups1
//!BIND conv0ups2
//!SAVE MAIN
//!WIDTH conv0ups.w 2 *
//!HEIGHT conv0ups.h 2 *
//!WHEN OUTPUT.w MAIN.w / 1.200 > OUTPUT.h MAIN.h / 1.200 > *
#define go_0(x_off, y_off) (max((conv0ups_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
#define go_1(x_off, y_off) (max((conv0ups1_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
#define go_2(x_off, y_off) (max((conv0ups2_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
#define go_3(x_off, y_off) (max(-(conv0ups_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
#define go_4(x_off, y_off) (max(-(conv0ups1_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
#define go_5(x_off, y_off) (max(-(conv0ups2_texOff(vec2(x_off, y_off) * 0.5)), 0.0))
vec4 hook() {
    vec4 result = mat4(0.009331738, 0.018572107, 0.022010602, 0.0, 0.0039357482, -0.016444422, -0.02944063, 0.0, -0.03631314, -0.056094132, -0.050672945, 0.0, 0.0077923858, -0.023002634, 0.021950275, 0.0) * go_0(-1.0, -1.0);
    result += mat4(-0.015352033, -0.018134398, -0.031076321, 0.0, 0.09254242, 0.07433854, 0.094745025, 0.0, 0.09154548, 0.10833595, 0.084574744, 0.0, -0.06755486, 0.022037052, -0.09424632, 0.0) * go_0(-1.0, 0.0);
    result += mat4(0.019884977, 0.021337362, 0.026944455, 0.0, 0.11712925, 0.021360623, -0.017487818, 0.0, -0.14924358, -0.1149652, -0.12671575, 0.0, 0.012104617, -0.039750118, -0.002691512, 0.0) * go_0(-1.0, 1.0);
    result += mat4(0.00344861, -0.0071971808, -0.011530234, 0.0, 0.039175995, 0.12297611, 0.15838134, 0.0, 0.033669177, 0.018021118, -0.010552058, 0.0, -0.048705686, 0.03920792, -0.00043378037, 0.0) * go_0(0.0, -1.0);
    result += mat4(-0.09026871, -0.09393277, -0.0849584, 0.0, -0.16249315, -0.15300421, -0.1383744, 0.0, -0.10384136, -0.04767781, 0.022754611, 0.0, 0.14949107, 0.06619118, 0.016498014, 0.0) * go_0(0.0, 0.0);
    result += mat4(0.0138111375, 0.0033931104, 0.010171692, 0.0, -0.037168514, -0.029690385, -0.045251988, 0.0, 0.074186325, 0.056937214, 0.06968052, 0.0, -0.057218343, -0.060974367, -0.030270662, 0.0) * go_0(0.0, 1.0);
    result += mat4(-0.0028436058, 0.010812401, 0.012844112, 0.0, 0.050941236, -0.035253663, -0.061899442, 0.0, -0.01614737, 0.01752726, -0.023620276, 0.0, -0.04961744, -0.06673698, 0.039417736, 0.0) * go_0(1.0, -1.0);
    result += mat4(0.042587858, 0.03904053, 0.028782798, 0.0, -0.09807107, -0.01929461, -0.034585416, 0.0, 0.029584344, -0.053522006, 0.0068953806, 0.0, -0.04451219, 0.018451538, -0.029895604, 0.0) * go_0(1.0, 0.0);
    result += mat4(-0.0041629653, 0.0070575047, 0.004515914, 0.0, 0.043267716, 0.0020689464, 0.010954458, 0.0, -0.0013374113, 0.009222025, -0.0272451, 0.0, 0.00645634, -0.037133303, -0.03209227, 0.0) * go_0(1.0, 1.0);
    result += mat4(-0.010575585, -0.00065620174, -0.009598815, 0.0, -0.068592854, -0.06461729, -0.05058234, 0.0, 0.03790364, 0.044340994, 0.049410254, 0.0, -0.009466368, 0.081484325, 0.07265021, 0.0) * go_1(-1.0, -1.0);
    result += mat4(-0.01598744, -0.025267042, -0.010857686, 0.0, 0.0771284, 0.081469566, 0.07138724, 0.0, -0.00555409, -0.006099002, -0.02123016, 0.0, -0.29761449, -0.10614364, -0.1027762, 0.0) * go_1(-1.0, 0.0);
    result += mat4(0.02664693, 0.027294884, 0.019080907, 0.0, 0.010511018, 0.01179118, 0.02403106, 0.0, 0.05436632, 0.07234358, 0.08310484, 0.0, 0.03146414, -0.02122628, -0.021377526, 0.0) * go_1(-1.0, 1.0);
    result += mat4(0.027889153, 0.018621879, 0.025370836, 0.0, -0.14017807, -0.14772555, -0.14436993, 0.0, -0.017539013, -0.028932836, -0.06139342, 0.0, 0.0007456944, -0.00086823467, -0.05282406, 0.0) * go_1(0.0, -1.0);
    result += mat4(-0.0017060362, 0.00777287, 0.003343087, 0.0, 0.20926197, 0.21706305, 0.23307496, 0.0, -0.16601992, -0.183019, -0.139133, 0.0, 0.13933188, -0.013340946, -0.021960167, 0.0) * go_1(0.0, 0.0);
    result += mat4(-0.018459205, -0.023415336, -0.0173199, 0.0, 0.08558963, 0.10207333, 0.06444232, 0.0, -2.5721886e-06, -0.015806457, -0.036833573, 0.0, -0.20488425, -0.009690944, 0.020323949, 0.0) * go_1(0.0, 1.0);
    result += mat4(0.010601256, 0.007344732, 0.0056538777, 0.0, 0.021578439, 0.017345639, 0.0032158173, 0.0, 0.031785835, 0.04436094, 0.05920955, 0.0, 0.23948166, -0.06085234, -0.14597872, 0.0) * go_1(1.0, -1.0);
    result += mat4(0.00777581, 0.012557825, 0.0123206265, 0.0, -0.0691877, -0.0861206, -0.077578135, 0.0, -0.018104369, -0.024902673, -0.036656447, 0.0, 0.10611258, 0.09515675, 0.118361965, 0.0) * go_1(1.0, 0.0);
    result += mat4(0.0021278602, 0.003906813, 0.0016891633, 0.0, -0.06379228, -0.060215514, -0.051921096, 0.0, 0.039505195, 0.052035928, 0.05059492, 0.0, -0.047328927, -0.0066980706, 0.09447027, 0.0) * go_1(1.0, 1.0);
    result += mat4(0.18920127, -0.045531996, -0.044905778, 0.0, 0.013732142, 0.019208554, 0.011500921, 0.0, -0.0040531917, -0.02001873, -0.0023935249, 0.0, -0.033091005, -0.017751431, -0.009764133, 0.0) * go_2(-1.0, -1.0);
    result += mat4(0.15241088, -0.13676398, -0.01825122, 0.0, -0.003517022, -0.004041717, 0.003177141, 0.0, 0.011362495, 0.03685609, 0.008397426, 0.0, -0.08597375, -0.111830845, -0.110682696, 0.0) * go_2(-1.0, 0.0);
    result += mat4(-0.046171717, 0.23827009, -0.119844295, 0.0, 0.005446854, 0.00826863, 0.002206898, 0.0, -0.11165099, -0.14702465, -0.1203897, 0.0, 0.12169146, 0.11585612, 0.10473949, 0.0) * go_2(-1.0, 1.0);
    result += mat4(-0.18456058, 0.13293917, 0.06901046, 0.0, 0.010084839, -0.0006403412, -0.011852079, 0.0, -0.062180433, -0.06781299, -0.08111614, 0.0, -0.02218764, -0.015271581, -0.019768957, 0.0) * go_2(0.0, -1.0);
    result += mat4(0.034135204, -0.20479187, 0.27587336, 0.0, -0.058966126, -0.065613195, -0.056132246, 0.0, 0.07697151, 0.0706985, 0.098771244, 0.0, 0.06747748, 0.10971204, 0.13186967, 0.0) * go_2(0.0, 0.0);
    result += mat4(0.017322296, -0.06730298, 0.07034802, 0.0, 0.013449086, 0.007968637, 0.012679429, 0.0, 0.0902275, 0.11269024, 0.08805874, 0.0, -0.06179092, -0.06705483, -0.13040404, 0.0) * go_2(0.0, 1.0);
    result += mat4(-0.052505482, -0.018989135, 0.03388015, 0.0, -0.068704374, -0.05350174, -0.057223134, 0.0, 0.011537428, 0.017847707, 0.0270268, 0.0, -0.008713432, -0.02698126, -0.017463546, 0.0) * go_2(1.0, -1.0);
    result += mat4(0.15220639, -0.05387876, -0.08352881, 0.0, 0.026893694, 0.027608246, 0.025959803, 0.0, 0.035518423, 0.035180617, 0.01858579, 0.0, -0.021064412, -0.014214504, -0.0051168953, 0.0) * go_2(1.0, 0.0);
    result += mat4(-0.11906418, 0.13103563, -0.06997703, 0.0, 0.005664134, 0.0075536724, 0.009519002, 0.0, -0.025366528, -0.013528652, -0.015087253, 0.0, 0.0071858848, -0.027586544, 0.016723866, 0.0) * go_2(1.0, 1.0);
    result += mat4(0.015307254, 0.02070064, 0.012568325, 0.0, 0.06845904, -0.033312738, -0.0058661965, 0.0, -0.016281582, -0.01631146, -0.021667928, 0.0, -0.012522515, -0.020992521, -0.015833912, 0.0) * go_3(-1.0, -1.0);
    result += mat4(0.04937768, 0.0405066, 0.041023023, 0.0, 0.05503905, -0.13230717, -0.14439866, 0.0, 0.01618014, 0.0122084245, 0.016226485, 0.0, 0.0014116488, 0.011495032, 0.002382562, 0.0) * go_3(-1.0, 0.0);
    result += mat4(-0.04847043, -0.050508745, -0.041216835, 0.0, -0.067119725, -0.0448592, -0.011477939, 0.0, -0.035635237, -0.037191708, -0.034170575, 0.0, -0.016549444, -0.027191242, -0.017883684, 0.0) * go_3(-1.0, 1.0);
    result += mat4(0.034498286, 0.026938718, 0.052970096, 0.0, -0.10511612, -0.13200648, -0.09493861, 0.0, -0.0018118658, -0.0072637545, 0.0043198126, 0.0, -0.038338073, -0.031448375, -0.035546694, 0.0) * go_3(0.0, -1.0);
    result += mat4(0.048043568, 0.057704087, 0.06386534, 0.0, 0.04542113, 0.20604704, 0.2598609, 0.0, 0.049180254, 0.064697154, 0.05789202, 0.0, 0.08370016, 0.08105142, 0.08807082, 0.0) * go_3(0.0, 0.0);
    result += mat4(-0.018156562, 0.008306473, -0.014604633, 0.0, 0.18912326, 0.024388695, -0.08006485, 0.0, 0.009333483, 0.011596536, 0.0056475243, 0.0, 0.027749287, 0.039271932, 0.02655462, 0.0) * go_3(0.0, 1.0);
    result += mat4(-0.030157864, -0.035259083, -0.05771176, 0.0, -0.22293729, 0.0768592, 0.14670776, 0.0, -0.013287718, -0.011300663, -0.01670879, 0.0, -0.009928094, -0.016364388, -0.013879692, 0.0) * go_3(1.0, -1.0);
    result += mat4(-0.013415757, -0.013257486, -0.01940959, 0.0, 0.014077903, 0.05088362, 0.04006286, 0.0, -0.0033998038, -0.0062313867, -0.00833104, 0.0, 0.015246904, 0.017004015, 0.01802002, 0.0) * go_3(1.0, 0.0);
    result += mat4(-0.0016801689, -0.022088053, 0.0031654288, 0.0, 0.027371893, -0.007083684, -0.10904292, 0.0, -0.015408179, -0.01793058, -0.010933266, 0.0, -0.023707654, -0.026440954, -0.025527867, 0.0) * go_3(1.0, 1.0);
    result += mat4(0.009003153, 0.0078040734, 0.037757806, 0.0, 0.054483943, 0.058831017, 0.060899608, 0.0, -0.011133613, -0.01601666, -0.007977876, 0.0, -0.07686641, -0.049250316, -0.045481566, 0.0) * go_4(-1.0, -1.0);
    result += mat4(0.04344093, 0.07054628, 0.037604738, 0.0, -0.0914579, -0.105631486, -0.108511426, 0.0, 0.04426105, 0.0492282, 0.048829302, 0.0, 0.14961997, 0.16839094, 0.16053638, 0.0) * go_4(-1.0, 0.0);
    result += mat4(-0.0032967671, -0.019857304, -0.014145445, 0.0, -0.013525817, 0.001614058, -0.009782301, 0.0, -0.044629153, -0.07325184, -0.07655591, 0.0, -0.08667146, 0.024955297, 0.04591592, 0.0) * go_4(-1.0, 1.0);
    result += mat4(0.04816059, 0.030722216, 0.032487474, 0.0, 0.09684092, 0.10024655, 0.101904154, 0.0, 0.08137448, 0.092595905, 0.1118598, 0.0, 0.0796932, 0.009548236, 0.0013610915, 0.0) * go_4(0.0, -1.0);
    result += mat4(-0.17208904, -0.19137467, -0.17717223, 0.0, -0.10827683, -0.11960323, -0.1204814, 0.0, -0.030430049, -0.019306151, -0.05230355, 0.0, -0.021787236, -0.015395303, -0.093210146, 0.0) * go_4(0.0, 0.0);
    result += mat4(0.04527227, 0.057978027, 0.10569097, 0.0, -0.1015645, -0.12595437, -0.097537845, 0.0, 0.060087565, 0.09157804, 0.060251515, 0.0, 0.05170573, 0.042533275, 0.08233745, 0.0) * go_4(0.0, 1.0);
    result += mat4(-0.01908824, 0.0039797956, -0.015060464, 0.0, 0.008187719, 0.013936167, 0.008152853, 0.0, -0.02618239, -0.056918032, -0.0504624, 0.0, -0.083657, 0.02122987, 0.022906482, 0.0) * go_4(1.0, -1.0);
    result += mat4(0.058020473, 0.08750743, 0.032107625, 0.0, 0.021999976, 0.030119067, 0.03513493, 0.0, 0.06583862, 0.08137626, 0.09867312, 0.0, -0.0021064964, -0.1227668, -0.0912879, 0.0) * go_4(1.0, 0.0);
    result += mat4(0.022279112, -0.012710205, -0.0011416139, 0.0, 0.05606448, 0.066590145, 0.061043978, 0.0, -0.008292685, -0.019583363, -0.006212003, 0.0, -0.053282585, -0.029954918, -0.021437356, 0.0) * go_4(1.0, 1.0);
    result += mat4(0.019198919, 0.020138288, 0.02048463, 0.0, -0.012281223, -0.01964347, -0.010557296, 0.0, 0.00830553, 0.02714052, 0.016606145, 0.0, -0.0047117253, -0.0060619717, 0.0015284229, 0.0) * go_5(-1.0, -1.0);
    result += mat4(-0.01620369, -0.018634152, -0.018486649, 0.0, -0.0037721654, -0.005256878, -0.0032221128, 0.0, 0.048627518, 0.033200823, 0.05459796, 0.0, 0.0064762663, 0.005607537, 0.0014544157, 0.0) * go_5(-1.0, 0.0);
    result += mat4(-0.0049319286, -0.003757374, -0.008033526, 0.0, -0.009529666, -0.01023788, -0.011724289, 0.0, 0.08779079, 0.11368912, 0.10699827, 0.0, 0.014564745, 0.017019482, 0.018130492, 0.0) * go_5(-1.0, 1.0);
    result += mat4(-0.018128838, -0.020529313, -0.021291668, 0.0, 0.022232227, 0.032956265, 0.030233478, 0.0, 0.057042982, 0.052126013, 0.039634123, 0.0, 0.04395578, 0.042147905, 0.047779605, 0.0) * go_5(0.0, -1.0);
    result += mat4(-0.008916549, -0.011398656, -0.006473247, 0.0, 0.07594334, 0.07910866, 0.0726948, 0.0, -0.1670962, -0.17030263, -0.18856722, 0.0, 0.0067814733, 0.01550948, 0.002108076, 0.0) * go_5(0.0, 0.0);
    result += mat4(-0.0020052418, -0.0015789939, 0.0024248413, 0.0, -0.018381692, -0.012541983, -0.016114611, 0.0, -0.054943718, -0.08546223, -0.045788202, 0.0, -0.02116913, -0.02479526, -0.02281286, 0.0) * go_5(0.0, 1.0);
    result += mat4(0.004089441, 0.004577225, 0.009165186, 0.0, -0.023352642, -0.03344756, -0.03359231, 0.0, 0.051127084, 0.055484984, 0.06788994, 0.0, -0.009284511, -0.0026670755, -0.011205212, 0.0) * go_5(1.0, -1.0);
    result += mat4(-0.008048874, -0.003658728, -0.011127851, 0.0, 0.0034879802, 0.014905489, 0.016252292, 0.0, -0.07353042, -0.0754597, -0.09509333, 0.0, 0.009990113, -0.0003871956, 0.0049740863, 0.0) * go_5(1.0, 0.0);
    result += mat4(0.009073377, 0.006138898, 0.006741848, 0.0, -0.009877169, -0.019738095, -0.015525384, 0.0, 0.057441086, 0.06538757, 0.053950094, 0.0, -0.0011834118, 0.0010558038, 0.004649949, 0.0) * go_5(1.0, 1.0);
    result += vec4(-0.008654677, -0.008960475, -0.009207461, 0.0);
    return result + MAIN_tex(MAIN_pos);
}
