// Copyright (C) 2017-2021 igv
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this program.  If not, see <https://www.gnu.org/licenses/>.

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) feature map 1
//!BIND LUMA
//!SAVE FEATURE1
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0158583000302315,0.0481607876718044,0.0216744001954794,0.0327517539262772);
res += vec4(0.0055716447532177,-0.0011689565144479,0.0060354629531503,-0.0038142984267324) * float(LUMA_texOff(vec2(-2,-2)));
res += vec4(-0.0511216484010220,0.0695900619029999,-0.0402262769639492,-0.2699918746948242) * float(LUMA_texOff(vec2(-2,-1)));
res += vec4(0.0568219460546970,0.0143233733251691,0.0573288090527058,0.1329403370618820) * float(LUMA_texOff(vec2(-2,0)));
res += vec4(0.0749029889702797,-0.0856373012065887,0.0275473278015852,0.0870117172598839) * float(LUMA_texOff(vec2(-2,1)));
res += vec4(0.0059168273583055,0.0431331694126129,0.0110861351713538,-0.0060971858911216) * float(LUMA_texOff(vec2(-2,2)));
res += vec4(0.0023135771043599,-0.0356510132551193,-0.0198473632335663,0.1518625020980835) * float(LUMA_texOff(vec2(-1,-2)));
res += vec4(0.0796200335025787,-0.0332430601119995,0.1661894172430038,0.0414402447640896) * float(LUMA_texOff(vec2(-1,-1)));
res += vec4(0.3913435935974121,-0.0070745791308582,-0.3234040439128876,-0.3177863061428070) * float(LUMA_texOff(vec2(-1,0)));
res += vec4(-0.2875826358795166,-0.1528938859701157,-0.0496717989444733,-0.0847533568739891) * float(LUMA_texOff(vec2(-1,1)));
res += vec4(0.0118880448862910,-0.0508498139679432,-0.0021516310516745,0.1032346263527870) * float(LUMA_texOff(vec2(-1,2)));
res += vec4(-0.0703228861093521,-0.1651142090559006,-0.1199417710304260,-0.0288288500159979) * float(LUMA_texOff(vec2(0,-2)));
res += vec4(0.1257767677307129,-0.1048138290643692,0.4004893004894257,-0.0309179127216339) * float(LUMA_texOff(vec2(0,-1)));
res += vec4(-0.7917575240135193,0.3903119266033173,0.3126059174537659,-0.0034788434859365) * float(LUMA_texOff(vec2(0,0)));
res += vec4(0.2019260078668594,0.1287178546190262,-0.6099877953529358,0.2216860502958298) * float(LUMA_texOff(vec2(0,1)));
res += vec4(-0.0255547054111958,0.2735108733177185,0.1398646086454391,-0.0773279890418053) * float(LUMA_texOff(vec2(0,2)));
res += vec4(0.0327996239066124,0.0393296107649803,-0.0118844136595726,-0.0788307189941406) * float(LUMA_texOff(vec2(1,-2)));
res += vec4(-0.0523803792893887,0.2635756731033325,-0.0843483880162239,0.2639326751232147) * float(LUMA_texOff(vec2(1,-1)));
res += vec4(0.4495396912097931,-0.5813834071159363,0.1550076454877853,-0.1014123335480690) * float(LUMA_texOff(vec2(1,0)));
res += vec4(-0.0275334194302559,0.0760609954595566,-0.0728811249136925,-0.0323722735047340) * float(LUMA_texOff(vec2(1,1)));
res += vec4(-0.0302287433296442,-0.0609264522790909,0.0201333332806826,-0.0218520220369101) * float(LUMA_texOff(vec2(1,2)));
res += vec4(-0.0078709209337831,-0.0724855363368988,0.0160489808768034,-0.0519895330071449) * float(LUMA_texOff(vec2(2,-2)));
res += vec4(-0.0093699758872390,-0.0221181977540255,0.0012721448438242,-0.1051536500453949) * float(LUMA_texOff(vec2(2,-1)));
res += vec4(-0.1118478253483772,0.0650174096226692,-0.0050289300270379,0.1248002946376801) * float(LUMA_texOff(vec2(2,0)));
res += vec4(0.0107028540223837,-0.0938652306795120,0.0155469048768282,0.0065242056734860) * float(LUMA_texOff(vec2(2,1)));
res += vec4(0.0103917606174946,-0.0048142350278795,-0.0063812667503953,0.0058583738282323) * float(LUMA_texOff(vec2(2,2)));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) feature map 2
//!BIND LUMA
//!SAVE FEATURE2
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.0035126404836774,-0.1424804031848907,0.0098019242286682,-0.2324347645044327);
res += vec4(-0.0081599559634924,0.0153401214629412,-0.0000884819819476,-0.0041208495385945) * float(LUMA_texOff(vec2(-2,-2)));
res += vec4(0.0348629020154476,-0.0261084530502558,0.1412381976842880,0.0120648415759206) * float(LUMA_texOff(vec2(-2,-1)));
res += vec4(-0.0182201806455851,0.0420538075268269,0.1279103606939316,0.0005762653308921) * float(LUMA_texOff(vec2(-2,0)));
res += vec4(0.0074240369722247,0.0205862484872341,-0.0248792562633753,-0.0096883391961455) * float(LUMA_texOff(vec2(-2,1)));
res += vec4(-0.0147575987502933,-0.0138801140710711,0.0336018688976765,0.0101419175043702) * float(LUMA_texOff(vec2(-2,2)));
res += vec4(-0.0168300196528435,-0.0323963575065136,-0.1103628277778625,0.0184982456266880) * float(LUMA_texOff(vec2(-1,-2)));
res += vec4(0.0336258038878441,0.0090460535138845,0.1413228511810303,0.0213951021432877) * float(LUMA_texOff(vec2(-1,-1)));
res += vec4(-0.2192985862493515,-0.1210875585675240,-0.5916258096694946,0.1427909880876541) * float(LUMA_texOff(vec2(-1,0)));
res += vec4(0.0442710407078266,-0.0331254564225674,0.2450466305017471,0.0069104693830013) * float(LUMA_texOff(vec2(-1,1)));
res += vec4(-0.0385449007153511,-0.0156025458127260,0.0130665311589837,0.0061669168062508) * float(LUMA_texOff(vec2(-1,2)));
res += vec4(0.0162507221102715,0.1013157293200493,0.1922776401042938,-0.0295907501131296) * float(LUMA_texOff(vec2(0,-2)));
res += vec4(0.4103461503982544,-0.2687482833862305,0.2803195714950562,0.2368032187223434) * float(LUMA_texOff(vec2(0,-1)));
res += vec4(0.0594542995095253,1.1106108427047729,-0.0012417822144926,0.6573531627655029) * float(LUMA_texOff(vec2(0,0)));
res += vec4(-0.3231450319290161,-0.0818216651678085,-0.0780772641301155,0.0890857279300690) * float(LUMA_texOff(vec2(0,1)));
res += vec4(0.0311414338648319,0.0114796580746770,-0.0333797559142113,0.0220009069889784) * float(LUMA_texOff(vec2(0,2)));
res += vec4(0.0005678526358679,-0.0108715193346143,-0.1475655883550644,0.0124691976234317) * float(LUMA_texOff(vec2(1,-2)));
res += vec4(0.0859664827585220,-0.0096361991018057,-0.2825120091438293,0.0380329117178917) * float(LUMA_texOff(vec2(1,-1)));
res += vec4(0.0296897795051336,-0.3303853869438171,0.0030247638933361,0.1928089261054993) * float(LUMA_texOff(vec2(1,0)));
res += vec4(-0.1064484789967537,-0.0895809978246689,0.1988810151815414,0.0761259049177170) * float(LUMA_texOff(vec2(1,1)));
res += vec4(-0.0114818075671792,0.0129500832408667,-0.0847826823592186,-0.0188437569886446) * float(LUMA_texOff(vec2(1,2)));
res += vec4(-0.0039359503425658,-0.0073066619224846,0.0316172763705254,0.0056592230685055) * float(LUMA_texOff(vec2(2,-2)));
res += vec4(-0.0143255395814776,-0.0037881892640144,-0.1154748499393463,-0.0094808740541339) * float(LUMA_texOff(vec2(2,-1)));
res += vec4(0.0334111787378788,0.0511705093085766,0.1090561151504517,0.0004155720234849) * float(LUMA_texOff(vec2(2,0)));
res += vec4(-0.0173786189407110,-0.0189253110438585,-0.0971138030290604,-0.0048367069102824) * float(LUMA_texOff(vec2(2,1)));
res += vec4(-0.0020564326550812,-0.0088429925963283,0.0409048907458782,0.0098554128780961) * float(LUMA_texOff(vec2(2,2)));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) feature map 3
//!BIND LUMA
//!SAVE FEATURE3
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0074675981886685,-0.0112727740779519,-0.0078150173649192,0.0054601472802460);
res += vec4(0.0058205719105899,0.0104424925521016,0.0102249477058649,-0.0246734209358692) * float(LUMA_texOff(vec2(-2,-2)));
res += vec4(-0.0504507981240749,-0.0265871956944466,-0.0211575180292130,0.0639910921454430) * float(LUMA_texOff(vec2(-2,-1)));
res += vec4(0.0854370445013046,0.0320916883647442,-0.0444113314151764,0.0667080804705620) * float(LUMA_texOff(vec2(-2,0)));
res += vec4(-0.0717485323548317,0.1007603406906128,0.0549219138920307,0.0006571425474249) * float(LUMA_texOff(vec2(-2,1)));
res += vec4(-0.0096475556492805,-0.0109533462673426,-0.0034293907228857,-0.0298656821250916) * float(LUMA_texOff(vec2(-2,2)));
res += vec4(0.0612395852804184,0.1438739448785782,-0.1342615187168121,0.0005135608371347) * float(LUMA_texOff(vec2(-1,-2)));
res += vec4(-0.1905109286308289,-0.0487579554319382,0.1215000376105309,-0.3903875648975372) * float(LUMA_texOff(vec2(-1,-1)));
res += vec4(-0.1105766519904137,0.1457407474517822,0.3190293610095978,0.3644915223121643) * float(LUMA_texOff(vec2(-1,0)));
res += vec4(0.2406846284866333,-0.1006923243403435,-0.2059815675020218,-0.0087168551981449) * float(LUMA_texOff(vec2(-1,1)));
res += vec4(0.0242295619100332,0.0973422899842262,0.0189558453857899,0.0454756766557693) * float(LUMA_texOff(vec2(-1,2)));
res += vec4(-0.2777403295040131,-0.0261268876492977,0.0557462945580482,0.1156388074159622) * float(LUMA_texOff(vec2(0,-2)));
res += vec4(0.4593666791915894,-0.5746087431907654,0.3516879677772522,0.5441487431526184) * float(LUMA_texOff(vec2(0,-1)));
res += vec4(0.1454727351665497,0.4347074031829834,-0.5649513602256775,-0.2891949117183685) * float(LUMA_texOff(vec2(0,0)));
res += vec4(-0.1971357613801956,-0.0528701394796371,0.1234181076288223,-0.3138715028762817) * float(LUMA_texOff(vec2(0,1)));
res += vec4(-0.0748024880886078,-0.1438121795654297,-0.0849649086594582,-0.0026638933923095) * float(LUMA_texOff(vec2(0,2)));
res += vec4(0.1365336179733276,0.1782812327146530,0.0145155806094408,-0.0544562637805939) * float(LUMA_texOff(vec2(1,-2)));
res += vec4(-0.1609659045934677,0.0399771369993687,-0.2471204251050949,-0.3522113263607025) * float(LUMA_texOff(vec2(1,-1)));
res += vec4(-0.0015608231769875,-0.3023138046264648,-0.0579032227396965,0.0277623422443867) * float(LUMA_texOff(vec2(1,0)));
res += vec4(-0.0035330341197550,0.2225222438573837,0.2519835233688354,0.2358573675155640) * float(LUMA_texOff(vec2(1,1)));
res += vec4(0.0797009617090225,-0.1369067281484604,-0.0032011670991778,-0.1078757569193840) * float(LUMA_texOff(vec2(1,2)));
res += vec4(-0.0340625829994678,-0.0491722412407398,0.0248667076230049,0.0046607558615506) * float(LUMA_texOff(vec2(2,-2)));
res += vec4(0.1101173907518387,0.0255349930375814,-0.0124160917475820,0.0940967351198196) * float(LUMA_texOff(vec2(2,-1)));
res += vec4(-0.1285010129213333,0.0126118278130889,0.1080744639039040,0.0213258527219296) * float(LUMA_texOff(vec2(2,0)));
res += vec4(0.0379831343889236,0.1150698363780975,-0.0470580570399761,-0.0274534691125154) * float(LUMA_texOff(vec2(2,1)));
res += vec4(-0.0675948560237885,-0.0150815304368734,-0.0260353796184063,0.0053928769193590) * float(LUMA_texOff(vec2(2,2)));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) feature map 4
//!BIND LUMA
//!SAVE FEATURE4
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.0231404807418585,0.0264000315219164,-0.0196782369166613,0.0193342305719852);
res += vec4(-0.0002864966227207,-0.0063192103989422,0.0176236815750599,0.0021022548899055) * float(LUMA_texOff(vec2(-2,-2)));
res += vec4(0.0030383218545467,0.0160587038844824,-0.0215296540409327,0.0022535317111760) * float(LUMA_texOff(vec2(-2,-1)));
res += vec4(-0.0327238291501999,0.1294472962617874,0.0004141363606323,-0.0643630251288414) * float(LUMA_texOff(vec2(-2,0)));
res += vec4(-0.0072918534278870,0.0081034628674388,-0.0076351291500032,0.0612725690007210) * float(LUMA_texOff(vec2(-2,1)));
res += vec4(0.0077398689463735,0.0009626992978156,0.0004907781840302,0.0158306453377008) * float(LUMA_texOff(vec2(-2,2)));
res += vec4(0.0169805102050304,0.0017006965354085,-0.0351677052676678,0.0070601841434836) * float(LUMA_texOff(vec2(-1,-2)));
res += vec4(0.0503231473267078,-0.1359812021255493,-0.1726402193307877,0.0505710020661354) * float(LUMA_texOff(vec2(-1,-1)));
res += vec4(0.5929844379425049,-0.4670899212360382,0.1338799595832825,0.0521798394620419) * float(LUMA_texOff(vec2(-1,0)));
res += vec4(-0.0016857853624970,-0.0980291739106178,-0.0766545012593269,-0.1788613498210907) * float(LUMA_texOff(vec2(-1,1)));
res += vec4(0.0055230301804841,0.0227276254445314,0.0062132971361279,-0.0205314252525568) * float(LUMA_texOff(vec2(-1,2)));
res += vec4(-0.0632932260632515,0.0206124242395163,0.0203190892934799,-0.0383010655641556) * float(LUMA_texOff(vec2(0,-2)));
res += vec4(0.3401337563991547,0.0347416475415230,-0.1285047084093094,0.1899463981389999) * float(LUMA_texOff(vec2(0,-1)));
res += vec4(-0.4421386420726776,0.2934384047985077,0.8403331041336060,-0.1730615049600601) * float(LUMA_texOff(vec2(0,0)));
res += vec4(-0.1677902936935425,-0.2289065122604370,-0.0876600667834282,0.3486402034759521) * float(LUMA_texOff(vec2(0,1)));
res += vec4(0.0101460181176662,-0.0013741940492764,-0.0227308031171560,-0.1236668676137924) * float(LUMA_texOff(vec2(0,2)));
res += vec4(0.0416196137666702,-0.0025786985643208,-0.0321756042540073,-0.0049003348685801) * float(LUMA_texOff(vec2(1,-2)));
res += vec4(0.0264755990356207,0.0366033166646957,-0.2230065017938614,-0.2322043776512146) * float(LUMA_texOff(vec2(1,-1)));
res += vec4(-0.3769855499267578,0.3444519937038422,-0.0913550406694412,0.0529095120728016) * float(LUMA_texOff(vec2(1,0)));
res += vec4(0.0496573671698570,0.1734852045774460,-0.1757829487323761,-0.0754000768065453) * float(LUMA_texOff(vec2(1,1)));
res += vec4(0.0092390561476350,0.0240796990692616,0.0486575216054916,0.0034698238596320) * float(LUMA_texOff(vec2(1,2)));
res += vec4(-0.0061075761914253,0.0163863543421030,0.0051472936756909,0.0245978105813265) * float(LUMA_texOff(vec2(2,-2)));
res += vec4(-0.0219590999186039,-0.0549665205180645,0.0169540457427502,0.0773543193936348) * float(LUMA_texOff(vec2(2,-1)));
res += vec4(0.0130640128627419,-0.0906993970274925,0.0318272411823273,0.0213559772819281) * float(LUMA_texOff(vec2(2,0)));
res += vec4(-0.0263035502284765,-0.0683158710598946,0.0060625332407653,-0.0366725400090218) * float(LUMA_texOff(vec2(2,1)));
res += vec4(-0.0033458373509347,0.0166716929525137,-0.0066949445754290,0.0069377254694700) * float(LUMA_texOff(vec2(2,2)));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 1_1
//!BIND FEATURE1
//!BIND FEATURE2
//!BIND FEATURE3
//!BIND FEATURE4
//!SAVE MODEL21
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.2535822391510010,-0.2086673378944397,-0.1971909999847412,-0.0509869605302811);
res += mat4(-0.2771639227867126,-0.0897865369915962,0.2583256959915161,0.1160498261451721,0.0936901941895485,-0.1911094635725021,-0.1356087327003479,-0.2737614214420319,-0.0840661674737930,0.3071749806404114,-0.1382381021976471,0.0401598662137985,0.0078477216884494,-0.2248300164937973,-0.1277811974287033,0.0695948302745819) * FEATURE1_texOff(vec2(-1,-1));
res += mat4(0.1083878129720688,-0.3206554055213928,0.1545115262269974,-0.0320371277630329,-0.1938588172197342,-0.1473862826824188,-0.0282243248075247,-0.1354303658008575,-0.1186024993658066,-0.0809327214956284,-0.0136826746165752,-0.0899777114391327,0.0719721689820290,0.1930700838565826,-0.1158982515335083,0.0772358104586601) * FEATURE2_texOff(vec2(-1,-1));
res += mat4(-0.0439350903034210,-0.3943499624729156,0.2428358793258667,-0.1589881926774979,0.1062002107501030,0.3110131621360779,0.1892369836568832,-0.4146962761878967,0.2854582071304321,-0.1033756285905838,0.2935918271541595,-0.3346719741821289,0.0666174665093422,0.0610550120472908,-0.1994506865739822,-0.2256885766983032) * FEATURE3_texOff(vec2(-1,-1));
res += mat4(0.1148382350802422,-0.4204422533512115,-0.0359638184309006,-0.1530147343873978,-0.0726560875773430,0.2168974876403809,0.3526575863361359,-0.3311845958232880,0.0656990334391594,0.2305561602115631,0.0385423824191093,0.1258286833763123,0.0722775310277939,0.5053561925888062,0.6200680136680603,0.1733734011650085) * FEATURE4_texOff(vec2(-1,-1));
res += mat4(0.2637681365013123,-0.2313590347766876,-0.1710360497236252,-0.4150753617286682,-0.0291996710002422,0.1454502344131470,0.0285777729004622,-0.0749426186084747,-0.0187464319169521,-0.0788161307573318,-0.1390142142772675,0.4122431576251984,-0.0424673929810524,0.0481288805603981,-0.1688672900199890,-0.3983225524425507) * FEATURE1_texOff(vec2(-1,0));
res += mat4(0.0667020902037621,0.2114472687244415,0.1192239969968796,-0.2236148864030838,-0.0777044594287872,-0.2462731599807739,0.2634125351905823,-0.1940607130527496,0.0336417406797409,-0.0972627550363541,-0.2950557470321655,0.2406509518623352,-0.0279604401439428,-0.0602857805788517,-0.0872009843587875,-0.1229272857308388) * FEATURE2_texOff(vec2(-1,0));
res += mat4(0.2794125378131866,-0.4944160580635071,0.4512123167514801,0.2009913176298141,-0.2796518802642822,-0.0334346629679203,-0.0112056173384190,-0.3892775475978851,-0.1192756518721581,0.2117638289928436,-0.4059759974479675,0.2690156698226929,-0.0456493757665157,-0.0304120033979416,-0.2477626502513885,0.4191759228706360) * FEATURE3_texOff(vec2(-1,0));
res += mat4(-0.0039319223724306,-0.0600352995097637,0.4458162486553192,0.1474803835153580,0.0940916240215302,-0.3791440427303314,0.3606577217578888,-0.4092902839183807,0.1703228652477264,-0.1827025562524796,0.0514233745634556,0.4128525555133820,-0.0793079584836960,-0.0907753482460976,0.1223130822181702,-0.1207918524742126) * FEATURE4_texOff(vec2(-1,0));
res += mat4(-0.2494225054979324,0.1870742887258530,0.0837734341621399,-0.2739089429378510,-0.0571023263037205,0.1391844749450684,-0.0675746276974678,0.1305333226919174,-0.0307636223733425,0.4430510401725769,0.0028207190334797,-0.0904692336916924,0.0088010514155030,-0.0354460701346397,0.0043582450598478,0.4011381268501282) * FEATURE1_texOff(vec2(-1,1));
res += mat4(0.0587932765483856,-0.1308003664016724,-0.1161855384707451,0.1607838273048401,0.1059153527021408,-0.1711840778589249,-0.0445863120257854,-0.1130510568618774,0.0448016002774239,0.1559550613164902,-0.0720835253596306,0.0672131329774857,-0.0249006003141403,0.1765320748090744,-0.1224699541926384,0.0470521636307240) * FEATURE2_texOff(vec2(-1,1));
res += mat4(-0.0384641103446484,0.2872657477855682,0.0640715956687927,0.3555822372436523,0.0471152290701866,-0.1418067067861557,-0.1464726030826569,0.3959751725196838,0.2157984673976898,-0.0174972768872976,-0.2503038048744202,0.0358669087290764,-0.0771151334047318,0.3911861777305603,-0.0674204975366592,-0.1664280891418457) * FEATURE3_texOff(vec2(-1,1));
res += mat4(-0.0502385906875134,-0.2417445182800293,-0.2242267578840256,-0.0672638416290283,-0.1355054825544357,-0.3461876213550568,0.4824717044830322,-0.2761393785476685,-0.0341378860175610,-0.0760281234979630,0.4350158274173737,0.4765976667404175,-0.0782985687255859,-0.1459587216377258,-0.0172249134629965,-0.0147242834791541) * FEATURE4_texOff(vec2(-1,1));
res += mat4(-0.2630992829799652,0.2823100388050079,0.0943108573555946,0.4031386077404022,0.0995653420686722,-0.1206451952457428,-0.0305370874702930,0.0642247647047043,0.0560359954833984,0.0542743578553200,0.1328519582748413,0.3271641731262207,0.0286087840795517,-0.0301680061966181,0.4063064754009247,-0.0947660803794861) * FEATURE1_texOff(vec2(0,-1));
res += mat4(0.2625299096107483,0.0842924192547798,0.7629656791687012,-0.2671873569488525,0.2069786489009857,-0.2454696893692017,0.0612405501306057,0.1021422892808914,-0.4223764240741730,0.3173877894878387,0.2887442708015442,0.1909165084362030,-0.1770869791507721,0.1346962451934814,0.1143044829368591,0.0229503251612186) * FEATURE2_texOff(vec2(0,-1));
res += mat4(-0.4152803719043732,0.1540635079145432,-0.2777018547058105,0.6474476456642151,-0.1949630677700043,-0.0181875545531511,0.3886533379554749,0.3629097938537598,-0.3201324343681335,0.4255363047122955,-0.3785362839698792,0.1957572698593140,0.1620309501886368,-0.2288520336151123,-0.0135895386338234,-0.0196984149515629) * FEATURE3_texOff(vec2(0,-1));
res += mat4(0.1041403189301491,-0.1766346842050552,0.4300306439399719,-0.5048146247863770,-0.4282442331314087,0.2367089539766312,-0.0609208792448044,0.0131418621167541,0.0577571578323841,-0.0810485184192657,0.0756059587001801,-0.3013808131217957,0.1408018022775650,0.0530188716948032,0.4606562554836273,-0.3839898407459259) * FEATURE4_texOff(vec2(0,-1));
res += mat4(-0.1521688550710678,-0.0032123478595167,0.3116574883460999,-0.2972046434879303,0.6955487728118896,-0.3735982179641724,0.0215148627758026,0.6849833130836487,0.4760347604751587,-1.0485177040100098,-0.1261294931173325,0.2331533879041672,0.0917195081710815,0.4458359181880951,-0.0091531546786427,0.5207492113113403) * FEATURE1_texOff(vec2(0,0));
res += mat4(-0.1011519357562065,-0.2413177788257599,0.5347595214843750,-0.3520763516426086,1.1230159997940063,-1.1015644073486328,-0.7193110585212708,0.8510805368423462,0.8157641291618347,-0.2430049031972885,0.2581803798675537,-0.4335567951202393,-0.0874094665050507,-0.6334270834922791,-0.6894448399543762,0.0596196018159389) * FEATURE2_texOff(vec2(0,0));
res += mat4(0.2854309976100922,-0.1557229459285736,-0.1809468418359756,-1.3902940750122070,0.6910412311553955,-0.2587812542915344,-0.0482749044895172,0.7059345245361328,0.1759572327136993,-0.1393056362867355,0.5609810352325439,-0.4832382500171661,-0.0000602358450124,-0.2900169491767883,0.3908173143863678,-0.6049022674560547) * FEATURE3_texOff(vec2(0,0));
res += mat4(-0.0872106701135635,-0.1346540600061417,1.4156285524368286,-1.1883758306503296,-0.7596164941787720,0.1885419785976410,-0.5785369277000427,0.9477756023406982,1.5934140682220459,-1.2882608175277710,-1.2094374895095825,1.3799823522567749,0.4614370167255402,-0.0916836485266685,-0.5338310003280640,0.3820723593235016) * FEATURE4_texOff(vec2(0,0));
res += mat4(0.0441628322005272,-0.0834458991885185,-0.0842079296708107,-0.0668803155422211,0.0368445180356503,0.2561661899089813,-0.1183663904666901,-0.0662262961268425,0.0612826459109783,-0.0493311323225498,-0.1413672119379044,-0.0592455714941025,0.0167923998087645,-0.3271788358688354,0.2014455944299698,-0.6534197330474854) * FEATURE1_texOff(vec2(0,1));
res += mat4(-0.4044690728187561,-0.1691768616437912,-0.2559798955917358,0.3357487618923187,0.0253558568656445,-0.1398200690746307,-0.2404493540525436,0.2267729192972183,0.0485114641487598,-0.1099041774868965,0.4590287208557129,0.0762615874409676,-0.0548993311822414,-0.1307289451360703,-0.1234042271971703,-0.0231516994535923) * FEATURE2_texOff(vec2(0,1));
res += mat4(-0.0988199859857559,0.0238037649542093,0.0435022264719009,-0.3168803453445435,-0.1213417872786522,-0.0779432877898216,0.2743633389472961,-0.0408632978796959,0.1799435466527939,-0.2463587224483490,-0.1358537077903748,0.2689833939075470,0.0539833642542362,0.1290988624095917,-0.0515714474022388,0.0580415092408657) * FEATURE3_texOff(vec2(0,1));
res += mat4(-0.0934378430247307,-0.0576035231351852,0.1248585656285286,-0.4788450300693512,-0.0699084699153900,-0.1344984918832779,0.4291284382343292,-0.0945518091320992,0.1735085546970367,-0.3810331225395203,0.2658713161945343,-0.0407779440283775,-0.2733527123928070,-0.2201107889413834,-0.2199274003505707,0.2047093063592911) * FEATURE4_texOff(vec2(0,1));
res += mat4(-0.0567484796047211,0.0829793587327003,-0.4746561646461487,0.0256525389850140,0.0835705399513245,-0.1755325645208359,-0.2114038169384003,-0.1711267083883286,0.1664180457592010,0.1463819295167923,-0.2656275629997253,-0.2758075296878815,0.0265674404799938,-0.1956520974636078,0.0414405986666679,0.0479561910033226) * FEATURE1_texOff(vec2(1,-1));
res += mat4(0.0563601851463318,0.4714728593826294,-0.0800048857927322,-0.1705953329801559,0.2594836354255676,-0.2075097709894180,0.1695188879966736,-0.4107047319412231,-0.0706016868352890,-0.2547818720340729,-0.3957505524158478,-0.2354479134082794,0.0384419634938240,-0.0460053943097591,-0.0207829847931862,-0.0093786139041185) * FEATURE2_texOff(vec2(1,-1));
res += mat4(0.0942042469978333,0.0404988750815392,-0.1232881695032120,-0.2178550660610199,0.1357689797878265,0.0359092727303505,-0.2060291618108749,-0.3273082375526428,0.5002653002738953,-0.1923164129257202,0.4921628534793854,0.2727786898612976,-0.2186055183410645,0.3011177480220795,-0.3585500419139862,0.1814153641462326) * FEATURE3_texOff(vec2(1,-1));
res += mat4(-0.0447341054677963,0.0810466259717941,0.2046322971582413,-0.0233065690845251,0.2438813596963882,-0.5253956913948059,0.1698510050773621,-0.0923427864909172,0.3008512258529663,0.0888842046260834,0.2270209491252899,-0.0200825128704309,0.1317300051450729,-0.0595603473484516,0.1512535065412521,-0.1234729290008545) * FEATURE4_texOff(vec2(1,-1));
res += mat4(-0.2651814818382263,-0.2288072854280472,-0.1599031686782837,0.2945036888122559,-0.5219144225120544,0.2868134975433350,0.0882711112499237,0.1873165518045425,-0.3225394189357758,0.5725277066230774,0.9555261731147766,0.1013209298253059,-0.0960882678627968,0.4585131406784058,-0.4613201320171356,0.0265702158212662) * FEATURE1_texOff(vec2(1,0));
res += mat4(-0.0731972157955170,-0.0449099875986576,0.5571532249450684,-0.1073949784040451,-0.0349713973701000,0.0071747689507902,-0.5417777299880981,-0.1344508528709412,-0.3132073581218719,0.0723055228590965,-0.2280079871416092,-0.0006024244939908,-0.1621860861778259,0.0284414086490870,0.0161129496991634,0.1501607745885849) * FEATURE2_texOff(vec2(1,0));
res += mat4(0.0067174173891544,0.2343200147151947,-0.5080283284187317,0.5312495827674866,0.0454211644828320,0.2897656559944153,-0.1136429458856583,-0.3823511302471161,-0.2790622413158417,-0.3745599091053009,0.0601127929985523,-0.1175373196601868,-0.1063450872898102,-0.0410735420882702,-0.2890635728836060,0.5056386590003967) * FEATURE3_texOff(vec2(1,0));
res += mat4(0.5037181973457336,-1.1170947551727295,-0.5449797511100769,0.3597307205200195,-0.0285126268863678,0.3148215115070343,0.4604218900203705,0.2808663249015808,0.0162206999957561,-0.3732328414916992,-0.5785920023918152,0.1976140588521957,-0.5090074539184570,0.6523973941802979,-0.1632602810859680,-0.1469507217407227) * FEATURE4_texOff(vec2(1,0));
res += mat4(-0.0661215856671333,0.2697862982749939,-0.1526191383600235,0.3426537811756134,-0.0941963717341423,-0.0453732609748840,-0.1661902964115143,0.0029509349260479,-0.1297422945499420,0.3132496774196625,0.0477103367447853,-0.0763362720608711,0.2142441421747208,-0.2151754349470139,0.0798331648111343,0.0610793232917786) * FEATURE1_texOff(vec2(1,1));
res += mat4(-0.0336847305297852,-0.3289247453212738,0.4004055559635162,0.2447433471679688,0.1103943735361099,0.3727104365825653,0.3764447569847107,-0.0454859547317028,0.0884784683585167,0.0267046000808477,-0.3515844941139221,-0.2293561398983002,0.0277891717851162,-0.0138099212199450,0.1696697175502777,0.0516055934131145) * FEATURE2_texOff(vec2(1,1));
res += mat4(0.0018621622584760,0.2604791820049286,0.2717927396297455,0.3943259119987488,-0.0989849790930748,-0.2238094806671143,-0.3049607276916504,0.1484513133764267,-0.4653285443782806,0.4149819910526276,0.2806181013584137,-0.0392659343779087,0.1793054938316345,0.0728375092148781,0.7856308221817017,0.0007568100700155) * FEATURE3_texOff(vec2(1,1));
res += mat4(-0.1371228843927383,-0.4515758156776428,-0.1283617764711380,0.2101248651742935,0.2646862864494324,-0.4533604681491852,0.1065965071320534,0.0693597942590714,0.2889678776264191,0.0214051268994808,0.6909635663032532,0.2163403928279877,0.3420628011226654,-0.2050398141145706,-0.0816402360796928,0.0032103767152876) * FEATURE4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.4853514730930328,0.0194640476256609,0.0559235066175461,0.9239075779914856) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 1_2
//!BIND FEATURE1
//!BIND FEATURE2
//!BIND FEATURE3
//!BIND FEATURE4
//!SAVE MODEL22
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.1381223350763321,-0.0308194756507874,0.1110133975744247,-0.0683282017707825);
res += mat4(-0.2088769525289536,-0.0105850258842111,-0.1151953488588333,0.0346273891627789,-0.3365945518016815,-0.0517612397670746,0.0336230397224426,-0.0372144170105457,0.1981399059295654,0.1342182457447052,-0.1760965287685394,0.2307879626750946,-0.1530198454856873,-0.1098565682768822,0.0360668078064919,-0.0083812475204468) * FEATURE1_texOff(vec2(-1,-1));
res += mat4(-0.1177931874990463,-0.0846288949251175,-0.2833393514156342,-0.1577735990285873,0.1323858946561813,-0.0128489714115858,-0.2080941498279572,-0.0380874052643776,-0.2245622128248215,-0.1485987454652786,0.0010099023347721,-0.1531151384115219,-0.1019563600420952,-0.0452317036688328,0.0589019767940044,0.0121880760416389) * FEATURE2_texOff(vec2(-1,-1));
res += mat4(0.0704127103090286,0.0245257895439863,-0.1575127989053726,0.1349024325609207,-0.1563488990068436,-0.0450201816856861,0.0279316585510969,0.1888295561075211,-0.0059769251383841,0.1732009947299957,0.1763417571783066,0.0518473982810974,0.0620901659131050,-0.0433492250740528,-0.0562263280153275,-0.1273161619901657) * FEATURE3_texOff(vec2(-1,-1));
res += mat4(0.1267730593681335,-0.0329404771327972,0.2025095671415329,0.1193531453609467,0.0728927850723267,0.0823160484433174,0.1572242677211761,0.1716777533292770,0.2288017272949219,-0.2456564903259277,-0.0219315327703953,-0.3694605827331543,0.0219488814473152,-0.1276920139789581,-0.0379748567938805,-0.0840378776192665) * FEATURE4_texOff(vec2(-1,-1));
res += mat4(0.2056158930063248,0.2981309592723846,0.4551208317279816,0.3621589541435242,0.1664001643657684,0.2786794006824493,-0.1290398538112640,0.1190336570143700,0.1758793741464615,-0.0912702158093452,-0.4254598915576935,0.2246738970279694,-0.0261087883263826,0.2550060749053955,-0.0596518293023109,-0.1216617897152901) * FEATURE1_texOff(vec2(-1,0));
res += mat4(-0.0796719565987587,0.0087867546826601,0.3371246457099915,-0.3683475852012634,-0.2284196317195892,0.1553688198328018,0.1120917648077011,-0.0740640237927437,-0.0330910012125969,0.5079706311225891,0.0464495383203030,-0.0281568299978971,0.0377068296074867,0.0486547499895096,-0.0274681914597750,-0.1364037692546844) * FEATURE2_texOff(vec2(-1,0));
res += mat4(0.3227785527706146,0.1808989048004150,0.2177855074405670,0.1488631516695023,0.0276129115372896,-0.0884175524115562,-0.1514154821634293,-0.4444026648998260,-0.2891204059123993,-0.1344766467809677,-0.1440485715866089,-0.4961053133010864,0.1105418205261230,0.1085827052593231,0.0921985581517220,-0.1675277352333069) * FEATURE3_texOff(vec2(-1,0));
res += mat4(-0.1732871979475021,0.4281528890132904,-0.0204508714377880,-0.1851426213979721,-0.1087937057018280,-0.3815968632698059,0.2121615111827850,-0.5234569311141968,0.1071098297834396,0.5851136445999146,-0.1577875763177872,-0.2906306684017181,-0.7021292448043823,0.2255133390426636,-0.1295063495635986,-0.1320244520902634) * FEATURE4_texOff(vec2(-1,0));
res += mat4(-0.1757937669754028,-0.2319357842206955,-0.1836598366498947,0.1259083151817322,0.5745494365692139,-0.0729667767882347,-0.1101969778537750,0.1380585283041000,-0.1041931733489037,-0.3247266709804535,-0.0038968466687948,0.3799381852149963,0.1569617539644241,-0.1585843116044998,0.1072080880403519,-0.0745987668633461) * FEATURE1_texOff(vec2(-1,1));
res += mat4(0.4278232753276825,0.1297351717948914,0.0242699328809977,0.1919889599084854,0.1342368423938751,-0.1163052171468735,0.0549292564392090,-0.0147566581144929,0.1688189953565598,-0.1894697397947311,-0.0977199077606201,0.2842393219470978,0.1062431111931801,-0.0455371215939522,0.0077982707880437,0.0216805879026651) * FEATURE2_texOff(vec2(-1,1));
res += mat4(0.0561123453080654,-0.1753604114055634,-0.1611851602792740,-0.0905591323971748,0.6435936689376831,0.1204528734087944,0.0111874192953110,0.3374686241149902,0.3051860928535461,-0.0780762061476707,0.2443095892667770,-0.2589598298072815,-0.0003057309950236,-0.1137806028127670,-0.1054927855730057,0.0880511328577995) * FEATURE3_texOff(vec2(-1,1));
res += mat4(-0.2937435507774353,0.2320816367864609,0.0320707336068153,-0.0581145994365215,-0.2367461323738098,0.4746437370777130,0.0147240571677685,-0.1799026876688004,-0.0346993468701839,0.0699583739042282,-0.3170774877071381,0.2222882062196732,0.3463763594627380,-0.2493554353713989,0.0534604340791702,0.3099468946456909) * FEATURE4_texOff(vec2(-1,1));
res += mat4(-0.7647771239280701,-0.3693305552005768,0.6674076914787292,-0.2018796503543854,-0.1837627589702606,-0.2026533484458923,-0.2065198272466660,-0.7396225929260254,0.8524928092956543,-0.3777147233486176,0.0014601636212319,-0.0749434828758240,-0.4064617753028870,0.1136885806918144,-0.2240319401025772,0.1771318167448044) * FEATURE1_texOff(vec2(0,-1));
res += mat4(0.0152301695197821,-0.1906797885894775,0.6144173145294189,0.3965292274951935,-0.0969559252262115,-0.0965181961655617,0.2601015865802765,-0.1854272931814194,0.0161584168672562,0.2746478021144867,-0.2444981634616852,0.0295571684837341,-0.0056955255568027,0.0136870443820953,-0.0315799862146378,-0.0970168113708496) * FEATURE2_texOff(vec2(0,-1));
res += mat4(-0.2683302462100983,0.3706904053688049,-0.3019535541534424,-0.7962921857833862,0.1152348443865776,-0.0349015258252621,-0.3777785003185272,-0.2090991586446762,-0.6641592979431152,-0.0305389035493135,-0.7255446314811707,-0.0721698999404907,-0.0974985733628273,0.0589145533740520,-0.3214484453201294,0.1777489185333252) * FEATURE3_texOff(vec2(0,-1));
res += mat4(0.0061144740320742,0.2519157528877258,0.1558316051959991,0.4245251417160034,-0.6843578815460205,0.1966717094182968,-0.4610933661460876,-0.2540432512760162,0.0210541579872370,0.1831053048372269,0.4746453762054443,-0.0526402108371258,-0.0040490669198334,-0.0342687070369720,0.3900658488273621,-0.3303281068801880) * FEATURE4_texOff(vec2(0,-1));
res += mat4(-0.4828728139400482,0.5191280841827393,-1.1391385793685913,-0.7054628133773804,1.0957189798355103,-0.5038015246391296,1.1690396070480347,0.8840553760528564,-1.2126139402389526,-0.1944981217384338,-0.3844216167926788,1.5913034677505493,0.4191325902938843,0.0223961118608713,0.2826472818851471,-0.0871717706322670) * FEATURE1_texOff(vec2(0,0));
res += mat4(-1.4643236398696899,-0.7375335693359375,0.2441195696592331,0.4990673959255219,-0.8329786062240601,-0.3049604892730713,0.9556087851524353,0.2383137643337250,0.5312217473983765,-0.5947279334068298,0.1804114133119583,-0.5788916945457458,0.3507929444313049,-0.0233711879700422,-0.2017675191164017,0.2487143874168396) * FEATURE2_texOff(vec2(0,0));
res += mat4(-0.1819303482770920,-0.5676728487014771,0.2360317111015320,0.0851088836789131,0.3140235841274261,0.1351734697818756,0.0945767760276794,-0.7279174923896790,1.6670336723327637,-0.0221601165831089,-0.0541631169617176,0.5291170477867126,0.5370565652847290,0.3250507712364197,0.2952508032321930,0.7118167877197266) * FEATURE3_texOff(vec2(0,0));
res += mat4(-0.4443428218364716,1.7487819194793701,0.7934173345565796,0.4780461490154266,0.9800529479980469,-0.9448102116584778,-0.9966609477996826,-0.5082603096961975,-0.9662690758705139,-0.1383059471845627,0.5476665496826172,0.8644275665283203,0.2329450398683548,-0.2073891162872314,0.6153110265731812,-0.8020766377449036) * FEATURE4_texOff(vec2(0,0));
res += mat4(1.3168696165084839,0.3006781041622162,0.2233006358146667,-0.7741575837135315,-1.2183657884597778,0.1592453569173813,-0.1303313076496124,-0.5448666214942932,0.0890172719955444,0.0626696199178696,0.4082972407341003,-0.0174469910562038,-0.5905545353889465,-0.1600939035415649,0.1808805614709854,0.4527755379676819) * FEATURE1_texOff(vec2(0,1));
res += mat4(0.2451122701168060,0.0711479261517525,-0.4790588915348053,-0.0287401173263788,-0.6085331439971924,0.0391158387064934,0.1979900598526001,0.6233009099960327,-0.4468613266944885,0.1692452281713486,0.3975573182106018,-0.0298757180571556,-0.0155079197138548,0.0266936160624027,-0.0893321484327316,-0.0689681470394135) * FEATURE2_texOff(vec2(0,1));
res += mat4(-0.0973365902900696,0.2272831350564957,0.0554595254361629,0.6588506102561951,-0.7055286765098572,-0.0497792214155197,-0.0126299904659390,0.3630616366863251,-0.7668600678443909,-0.0601201094686985,0.2889628410339355,0.7213001251220703,-0.5142368078231812,-0.2921136617660522,-0.0372818075120449,0.0245624762028456) * FEATURE3_texOff(vec2(0,1));
res += mat4(-0.6794872283935547,-0.1474942564964294,0.1974916905164719,-0.0832043588161469,0.3203485012054443,-0.1725142896175385,-0.1287368983030319,0.2957201898097992,-0.2809852659702301,-0.2404037415981293,0.3074257671833038,0.1061463952064514,0.3400422930717468,0.1731379330158234,-0.6084728240966797,0.1411322951316833) * FEATURE4_texOff(vec2(0,1));
res += mat4(-0.1315720230340958,-0.1491559147834778,-0.1476573199033737,0.0172325670719147,0.0603457167744637,0.1274620592594147,0.0230694599449635,0.2419043183326721,-0.2473622113466263,0.1825644075870514,-0.0844093039631844,-0.1179033219814301,0.0535174496471882,-0.0359878912568092,0.2790770828723907,0.1150204017758369) * FEATURE1_texOff(vec2(1,-1));
res += mat4(-0.3542392551898956,-0.0167406518012285,-0.0500063747167587,0.1317760497331619,0.2503667771816254,0.0965770110487938,0.0886839926242828,0.2376044392585754,0.3583405613899231,-0.0593837574124336,-0.0855230018496513,-0.0920166969299316,0.0858608484268188,0.0060294447466731,-0.0157861225306988,0.0127252563834190) * FEATURE2_texOff(vec2(1,-1));
res += mat4(0.3226392865180969,0.0865219160914421,-0.1496476382017136,0.1624807566404343,0.3655589520931244,-0.0445664376020432,0.1227211430668831,-0.2220589071512222,-0.2631477713584900,0.0820850655436516,0.5568479895591736,0.0730609148740768,-0.0937359035015106,0.2295248508453369,-0.3294035196304321,-0.2036383599042892) * FEATURE3_texOff(vec2(1,-1));
res += mat4(0.3742868900299072,-0.1802055388689041,-0.0593203529715538,0.1976574063301086,0.8271688222885132,0.0117016453295946,0.5063909292221069,0.2256126701831818,0.1593020707368851,-0.1280505210161209,0.0390553958714008,-0.1892147809267044,0.0888174250721931,-0.1376793980598450,0.5697006583213806,0.2485611587762833) * FEATURE4_texOff(vec2(1,-1));
res += mat4(0.2118279337882996,0.0513114370405674,0.2285705506801605,0.5599109530448914,-0.5099740028381348,0.1410261243581772,-0.3096668720245361,0.7005844116210938,-0.4349140822887421,0.4047641158103943,0.4812763929367065,0.1051402017474174,0.2456628382205963,0.0377773605287075,-0.6833984255790710,-0.3006701469421387) * FEATURE1_texOff(vec2(1,0));
res += mat4(-0.7107729315757751,-0.3105662167072296,-0.2076982706785202,-0.1214028969407082,-0.1795432120561600,0.1798780262470245,-0.0163973346352577,0.1743666827678680,-0.4378082156181335,0.1835298836231232,0.0649149790406227,0.0880983099341393,-0.1403774917125702,-0.0377079211175442,-0.1460157334804535,0.0355062298476696) * FEATURE2_texOff(vec2(1,0));
res += mat4(0.0914793089032173,0.0385615527629852,0.1190174892544746,-0.0553938411176205,-0.4308855831623077,0.1630966216325760,0.3357785642147064,0.0585900247097015,-0.1960757374763489,-0.1455840319395065,-0.3593325614929199,-0.3946797251701355,-0.0507271811366081,-0.2539891600608826,-0.0905557572841644,-0.6227382421493530) * FEATURE3_texOff(vec2(1,0));
res += mat4(0.2614709436893463,0.0061688483692706,0.3611848056316376,-0.1338395625352859,-1.0093911886215210,0.0553577207028866,0.1186351701617241,0.3184973597526550,-0.5891544818878174,-0.1016779243946075,-0.2224645316600800,0.0639321878552437,-0.2353626340627670,0.2742255926132202,-0.9502924680709839,0.7192491292953491) * FEATURE4_texOff(vec2(1,0));
res += mat4(0.3778582513332367,-0.1000494062900543,-0.3470661938190460,0.1308858692646027,-0.0679450184106827,-0.0160419829189777,-0.0135374749079347,-0.0480017438530922,-0.2798678874969482,-0.0037702140398324,-0.1513005942106247,0.1505549550056458,0.5613264441490173,-0.0316404215991497,0.2104064077138901,0.0057972222566605) * FEATURE1_texOff(vec2(1,1));
res += mat4(0.5251657366752625,0.0792712643742561,-0.1533361673355103,0.0648916959762573,0.1299594342708588,-0.0274657960981131,0.2256900221109390,-0.1350511759519577,0.3783259689807892,-0.1323687285184860,-0.1913703531026840,-0.0371813550591469,-0.3229732215404510,0.0125484764575958,0.0712098628282547,0.0355844199657440) * FEATURE2_texOff(vec2(1,1));
res += mat4(-0.1488132029771805,-0.1394258141517639,0.0912211686372757,-0.2606098055839539,-0.0499770082533360,-0.0108409021049738,-0.0542243905365467,-0.0962965711951256,0.7122877240180969,0.2720184922218323,-0.3723897337913513,-0.1091977506875992,0.3245325982570648,-0.0505217276513577,0.5785158276557922,0.2982622087001801) * FEATURE3_texOff(vec2(1,1));
res += mat4(0.1374520808458328,-0.0015341561520472,-0.1311945766210556,0.2911640405654907,-0.3659119606018066,-0.0591222643852234,0.3697520196437836,0.0210731234401464,-0.1840991079807281,0.0390477702021599,0.0259844064712524,0.2170744538307190,-0.0889984294772148,0.0531435646116734,0.2462018877267838,-0.4002745449542999) * FEATURE4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0506038926541805,-1.0047781467437744,-0.4045023024082184,0.9032984972000122) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 1_3
//!BIND FEATURE1
//!BIND FEATURE2
//!BIND FEATURE3
//!BIND FEATURE4
//!SAVE MODEL23
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.1987741589546204,-0.9577525258064270,-0.0384856425225735,-0.1572636365890503);
res += mat4(0.6966392397880554,-0.4640935063362122,0.2297160476446152,-0.0832405164837837,-0.0009435203392059,-0.0578446798026562,-0.1164432391524315,-0.1221262738108635,-0.1412358880043030,-0.0279388818889856,0.0489265844225883,0.0063599492423236,0.2360319495201111,0.0912766307592392,-0.1941773593425751,0.2315690666437149) * FEATURE1_texOff(vec2(-1,-1));
res += mat4(-0.1167130470275879,0.0778460651636124,0.1076761484146118,-0.2353819608688354,0.0524621158838272,-0.0356444679200649,0.2539249062538147,0.2634229958057404,0.2133077681064606,-0.1919374763965607,-0.2158848792314529,0.0518384873867035,0.0609824284911156,-0.1305586248636246,-0.1013210490345955,0.1769250631332397) * FEATURE2_texOff(vec2(-1,-1));
res += mat4(0.1402679532766342,0.2941172719001770,-0.1457418501377106,0.3779373764991760,-0.1932400017976761,-0.2161010503768921,0.0722947195172310,0.0502758324146271,-0.3296416103839874,0.4798662662506104,0.2580823302268982,-0.0627183541655540,0.0147153036668897,0.2626453340053558,0.0540219917893410,0.1939793974161148) * FEATURE3_texOff(vec2(-1,-1));
res += mat4(0.1847409754991531,0.4179320335388184,0.1568926721811295,-0.2688268125057220,0.1841754466295242,-0.1598462462425232,0.1664924770593643,-0.6711257100105286,-0.3222356140613556,-0.3005515038967133,-0.1475231498479843,0.1409637480974197,-0.1211405694484711,-0.4659332334995270,-0.4637466669082642,0.3335506618022919) * FEATURE4_texOff(vec2(-1,-1));
res += mat4(0.5968201160430908,0.0195734798908234,0.2521410584449768,0.1837282180786133,-0.2368906587362289,-0.1613323688507080,0.3105871975421906,-0.5328266620635986,0.6818410158157349,-0.2313661426305771,0.1797828674316406,-0.4353945851325989,0.3843055069446564,0.2114877700805664,-0.3301143646240234,-0.0251296106725931) * FEATURE1_texOff(vec2(-1,0));
res += mat4(0.5452771782875061,0.3973252177238464,-0.2990077137947083,-0.6833023428916931,-0.0103876451030374,-0.2633355557918549,0.2405222356319427,-0.1847756654024124,0.0809822008013725,-0.5386145710945129,0.3198210299015045,0.5242416858673096,-0.0943189039826393,0.1589269340038300,-0.2653484344482422,-0.2556872963905334) * FEATURE2_texOff(vec2(-1,0));
res += mat4(-0.0612921006977558,0.3507350981235504,0.2488755732774734,0.1469088792800903,-0.3519552946090698,-0.2370343953371048,-0.1770581305027008,0.1431888490915298,-0.6166468262672424,-0.1131900474429131,-0.4911212325096130,0.5227483510971069,-0.3461691737174988,0.0986021012067795,0.7038308978080750,-0.3039589524269104) * FEATURE3_texOff(vec2(-1,0));
res += mat4(0.1912881582975388,-0.5830649733543396,0.2136552929878235,0.1866988241672516,-0.5624901652336121,0.2385427057743073,0.1727342009544373,-0.4540549218654633,0.4965006113052368,-0.3204718232154846,-0.1158104166388512,0.5111644268035889,1.0713713169097900,0.1508440226316452,-0.5791803598403931,-0.0009748075972311) * FEATURE4_texOff(vec2(-1,0));
res += mat4(0.9698884487152100,-0.2014376223087311,-0.6689079999923706,0.4241695106029510,-0.0573838278651237,0.1175749525427818,-0.3876985013484955,0.2512328326702118,0.5065176486968994,-0.0682719275355339,-0.3141808807849884,-0.1387684196233749,-0.1143181324005127,-0.0706263333559036,-0.2333269715309143,0.5111127495765686) * FEATURE1_texOff(vec2(-1,1));
res += mat4(-0.5634623765945435,0.0672075673937798,0.2458319514989853,-0.2465665936470032,1.0935126543045044,-0.3243642449378967,0.3043719530105591,0.0064766071736813,0.9648159146308899,0.1759704202413559,-0.1268455684185028,0.0441841222345829,-0.8189800977706909,-0.0071217310614884,-0.0554777421057224,-0.2554271817207336) * FEATURE2_texOff(vec2(-1,1));
res += mat4(-0.1151394397020340,-0.0710884630680084,0.1666608154773712,0.2001230269670486,-0.3966263532638550,0.3185620605945587,0.2014131247997284,-0.6153194308280945,-0.1701968014240265,-0.0540665499866009,0.0967301502823830,-0.1836527884006500,-0.2557096779346466,-0.4019114375114441,-0.4702650904655457,-0.1317474097013474) * FEATURE3_texOff(vec2(-1,1));
res += mat4(-0.3346468508243561,-0.0425257682800293,0.1464348584413528,-0.0702658221125603,-1.1866838932037354,-0.1095336750149727,0.2232391387224197,0.1260936558246613,0.3364435434341431,0.0271857567131519,-0.2763819098472595,-0.2012097984552383,-0.5574805140495300,0.4211027026176453,0.0042814216576517,-0.0079778516665101) * FEATURE4_texOff(vec2(-1,1));
res += mat4(-0.3540650010108948,0.0071619492955506,-0.1938177198171616,0.6681747436523438,-0.8133658766746521,-0.5995404124259949,-0.3652176260948181,0.5787848830223083,-1.1667940616607666,-0.1285391598939896,-0.0541963428258896,0.8525529503822327,0.1709660291671753,-0.2035605609416962,-0.0489438250660896,-0.0194259360432625) * FEATURE1_texOff(vec2(0,-1));
res += mat4(-0.0078989947214723,-0.6119658946990967,-0.2015484124422073,-0.2649651169776917,-0.6429963707923889,0.2694746255874634,-0.4319376945495605,-0.3059541285037994,-0.0497270785272121,0.1026998609304428,-0.0897300168871880,0.1753655374050140,0.2096567898988724,0.2093304544687271,-0.0014726204099134,-0.1757658571004868) * FEATURE2_texOff(vec2(0,-1));
res += mat4(0.4870032668113708,-0.3136315047740936,0.0027699931524694,0.0663692802190781,-0.3052871823310852,0.3439637422561646,-0.1048567295074463,-0.1991288512945175,0.3137850165367126,0.0046365256421268,-0.1638680994510651,-0.4108964502811432,0.0508278496563435,-0.2253065854310989,-0.1633804589509964,0.2289161980152130) * FEATURE3_texOff(vec2(0,-1));
res += mat4(-0.1308068782091141,-0.4817227125167847,-0.0263788085430861,-0.3971874713897705,-0.2506425678730011,0.0695889964699745,-0.2154289782047272,0.5419184565544128,-0.2379133403301239,0.4222696423530579,0.5321872234344482,-0.4691502451896667,0.5537111759185791,0.2836233973503113,-0.0807907357811928,-0.1053616553544998) * FEATURE4_texOff(vec2(0,-1));
res += mat4(-1.3340888023376465,0.1811003237962723,-0.0891653820872307,0.2640296220779419,0.0198112688958645,0.3743432164192200,0.2111666053533554,0.0528086237609386,1.4712600708007812,1.2311338186264038,-0.9427970051765442,-0.6471102833747864,-0.1417239755392075,-0.0687683522701263,0.6658940315246582,-0.2936039566993713) * FEATURE1_texOff(vec2(0,0));
res += mat4(0.6384365558624268,0.9694315791130066,-0.9346356391906738,-1.0230228900909424,-0.5444990992546082,0.7220879793167114,-1.3095484972000122,-0.1715894937515259,-0.1845342367887497,0.2809494435787201,-0.7519769072532654,0.5043348670005798,0.0642623752355576,0.5404297709465027,0.4980618953704834,-0.4332457780838013) * FEATURE2_texOff(vec2(0,0));
res += mat4(0.4064006507396698,-0.1983926743268967,-0.3653252422809601,-0.4969399273395538,0.9744088053703308,-0.4507445096969604,-0.2631619274616241,0.3812571465969086,0.1463315337896347,-0.3806351721286774,-0.1298433393239975,-1.0762634277343750,0.6555476784706116,0.2125965803861618,-0.2418732196092606,-0.7435741424560547) * FEATURE3_texOff(vec2(0,0));
res += mat4(0.5863549113273621,-0.7426007390022278,1.0520230531692505,-0.3021634817123413,1.0178332328796387,0.3958678841590881,-1.2147421836853027,-0.2803310155868530,0.9442859292030334,0.9875133633613586,-1.3295483589172363,0.3140213191509247,-1.2360699176788330,0.0436276197433472,0.8192564249038696,0.9244912862777710) * FEATURE4_texOff(vec2(0,0));
res += mat4(-0.0778036788105965,0.1303569674491882,-0.0946515947580338,0.1500514000654221,-0.8376330137252808,0.0064494702965021,0.4018820524215698,0.3726169466972351,-0.0240886732935905,0.1562727540731430,0.5867211222648621,0.0861321687698364,-0.0752925500273705,0.2072228193283081,0.0571691095829010,-0.3941327631473541) * FEATURE1_texOff(vec2(0,1));
res += mat4(-0.6260624527931213,0.2243167608976364,-0.0777204260230064,-0.0948459953069687,0.1986584663391113,0.0779278427362442,-0.0409294515848160,-0.1123309731483459,-0.5333513021469116,-0.3017018139362335,0.3394177854061127,0.0070442100986838,-1.2051154375076294,0.1886872202157974,0.0150700416415930,0.2271993011236191) * FEATURE2_texOff(vec2(0,1));
res += mat4(-0.1438168585300446,-0.0561682283878326,-0.0726087689399719,-0.1063039004802704,0.8472042083740234,-0.1650467067956924,-0.4323893487453461,0.1089009195566177,-0.2962348163127899,-0.0804210677742958,0.3090696632862091,0.1938772201538086,-0.9304508566856384,0.2099634110927582,-0.2387906461954117,0.4645425677299500) * FEATURE3_texOff(vec2(0,1));
res += mat4(-0.3891402482986450,0.1677001267671585,-0.3542142212390900,0.4825044274330139,-0.7494704127311707,0.0327095612883568,-0.3160547018051147,0.0381647609174252,-0.3395038843154907,-0.0875114798545837,0.1697681397199631,-0.0070069218054414,0.2785872519016266,-0.3053137958049774,-0.4394780993461609,-0.4758984446525574) * FEATURE4_texOff(vec2(0,1));
res += mat4(0.1764032542705536,0.3245241641998291,-0.3035278022289276,-0.0335294082760811,0.0819542557001114,0.0181823037564754,-0.4616291821002960,0.3710139989852905,-0.2668941020965576,0.1378638595342636,-0.3516434729099274,0.2218741774559021,-0.1380484700202942,0.2721910178661346,0.1993634998798370,-0.0507654286921024) * FEATURE1_texOff(vec2(1,-1));
res += mat4(0.1138257235288620,0.0702949985861778,0.0519753210246563,0.0316211394965649,-0.1142372712492943,-0.3463631868362427,-0.1331373304128647,0.0943566113710403,0.1118926182389259,-0.0014000118244439,-0.0389710702002048,-0.2867488861083984,-0.0759893879294395,-0.0621335469186306,0.0294951014220715,0.1627990603446960) * FEATURE2_texOff(vec2(1,-1));
res += mat4(-0.0370159111917019,-0.0134843364357948,-0.0296634603291750,-0.2262785434722900,-0.2126005589962006,0.1114539355039597,-0.3452126085758209,0.4179220199584961,0.1400017142295837,0.1337017863988876,0.1674517989158630,0.6095085144042969,0.1415290385484695,0.1256051212549210,-0.0247143786400557,-0.3213684260845184) * FEATURE3_texOff(vec2(1,-1));
res += mat4(0.2360568046569824,0.0886762887239456,0.2882657349109650,0.0703785941004753,0.0481112562119961,0.1826563030481339,0.2045601755380630,-0.7343208193778992,0.2727248668670654,-0.1472977846860886,0.1000528633594513,0.1027388945221901,0.0052390284836292,-0.1624580770730972,-0.2070121914148331,0.0261196251958609) * FEATURE4_texOff(vec2(1,-1));
res += mat4(0.5196351408958435,-0.1754677295684814,0.0290226303040981,-0.4108504652976990,0.7359254956245422,0.1325557529926300,0.7144725918769836,0.1152682229876518,0.5018915534019470,0.1675622016191483,0.1405982822179794,0.3300459384918213,-0.2479736208915710,0.1644758880138397,-0.2817023694515228,0.3316636085510254) * FEATURE1_texOff(vec2(1,0));
res += mat4(0.8050370812416077,0.5533731579780579,-0.3099412024021149,0.1754989326000214,-0.1735986918210983,0.0404918454587460,0.2438879311084747,-0.2540093660354614,-0.4142113626003265,0.0423586852848530,0.2983778417110443,-0.6657259464263916,-0.0323144160211086,0.1928859353065491,0.0626569986343384,-0.2675825357437134) * FEATURE2_texOff(vec2(1,0));
res += mat4(-0.8682364821434021,0.2794692516326904,0.2730025053024292,0.1207608506083488,0.5389584302902222,0.0149545557796955,-0.1274863481521606,-0.0567482747137547,-0.0887703672051430,0.6914038658142090,-0.3094426095485687,-0.2982452213764191,0.4080916643142700,0.0426792725920677,-0.0051025901921093,0.6209579110145569) * FEATURE3_texOff(vec2(1,0));
res += mat4(0.0917436853051186,-0.0701907053589821,-0.2328515946865082,-0.1792335063219070,0.6472560167312622,-0.0877070501446724,-0.3649670481681824,0.2790137529373169,0.5136012434959412,-0.1430896967649460,0.4229614138603210,0.2363108694553375,0.5988228321075439,0.0732361972332001,0.3804556727409363,-0.6032572984695435) * FEATURE4_texOff(vec2(1,0));
res += mat4(-0.4129971563816071,-0.0148138366639614,0.0773900002241135,-0.3664886355400085,0.7110533118247986,-0.3235684633255005,0.0094040073454380,-0.0542590022087097,-0.1800988018512726,-0.1026054248213768,0.2341964095830917,0.2807213664054871,-0.3103989362716675,-0.6431574821472168,-0.2740025222301483,-0.3599634468555450) * FEATURE1_texOff(vec2(1,1));
res += mat4(0.1131857261061668,-0.3137154579162598,0.3429902195930481,-0.2737554609775543,1.2133983373641968,-0.1039248928427696,-0.0803684666752815,0.0061881896108389,-0.0924719199538231,0.1144402697682381,-0.2670459151268005,-0.1642477959394455,-0.4046771526336670,-0.1048694700002670,-0.0008883008267730,0.0014021961251274) * FEATURE2_texOff(vec2(1,1));
res += mat4(0.1959314346313477,0.0085384212434292,-0.0705676227807999,0.2818849384784698,-0.2752107381820679,0.1570400297641754,0.2566027343273163,0.1972118318080902,0.9400491714477539,-0.2308340966701508,0.0559823065996170,0.0408312715590000,0.3904103934764862,-0.5421842932701111,-0.1970631629228592,-0.1138259097933769) * FEATURE3_texOff(vec2(1,1));
res += mat4(-1.2016843557357788,0.0032943340484053,0.1414308100938797,-0.3150011897087097,-0.5170863270759583,0.1909369528293610,0.1779014021158218,0.0504081510007381,0.1417503207921982,-0.2203383594751358,-0.0287875495851040,-0.0217010006308556,-0.7724525332450867,-0.0255299452692270,0.0156590901315212,-0.1772062629461288) * FEATURE4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.0190296284854412,0.0706401318311691,0.7972527742385864,0.0644450262188911) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 1_4
//!BIND FEATURE1
//!BIND FEATURE2
//!BIND FEATURE3
//!BIND FEATURE4
//!SAVE MODEL24
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.1087156683206558,-0.9075642228126526,-0.0346042588353157,0.1664762347936630);
res += mat4(0.2831370532512665,0.0058452812954783,-0.1289279460906982,0.2047349065542221,-0.4432878494262695,0.4621333479881287,0.4035988152027130,-0.2761998772621155,0.4163680672645569,0.0915144309401512,-0.0111864032223821,-0.4257704913616180,-0.1714486926794052,0.1755180656909943,-0.5092523097991943,0.4639800190925598) * FEATURE1_texOff(vec2(-1,-1));
res += mat4(-0.0974804461002350,-0.0661083459854126,0.2698374986648560,0.4155388474464417,-0.0774852782487869,0.0143058374524117,0.2624184489250183,0.3015262186527252,0.0072107692249119,-0.0115862442180514,-0.1178141161799431,-0.0702119544148445,0.0091381752863526,-0.0762502029538155,-0.0035026811528951,-0.0673689618706703) * FEATURE2_texOff(vec2(-1,-1));
res += mat4(-0.0683186650276184,0.0347410701215267,0.0645584538578987,0.5791540145874023,-0.2505789697170258,0.0295746494084597,0.2193876951932907,-0.2011970281600952,-0.3917951285839081,0.3113734424114227,0.2716041803359985,-0.3423127830028534,-0.2599830925464630,0.2731236815452576,0.1352142393589020,-0.6103169322013855) * FEATURE3_texOff(vec2(-1,-1));
res += mat4(0.1382907032966614,0.1567241251468658,-0.2623529136180878,0.2330288439989090,0.1026417240500450,0.1336921900510788,-0.0960267484188080,-0.4534229338169098,0.2093876749277115,-0.3144259452819824,-0.0117062618955970,0.2396877259016037,-0.0440586656332016,-0.3048300743103027,0.2870889604091644,0.7035214900970459) * FEATURE4_texOff(vec2(-1,-1));
res += mat4(-0.1377581655979156,0.0860724225640297,-0.7544308900833130,-0.7329372763633728,0.0180966202169657,-0.3518326580524445,0.3025939762592316,0.1215278208255768,0.2151169478893280,0.1350875347852707,-0.6827735304832458,0.5395355224609375,-0.0290531590580940,-0.1038386523723602,-0.2184213846921921,-0.9552698135375977) * FEATURE1_texOff(vec2(-1,0));
res += mat4(-0.0563997998833656,-0.2057088613510132,0.1763602644205093,0.8703269958496094,-0.0177724920213223,0.3830640614032745,-0.0683283954858780,0.6795098781585693,0.2762976884841919,0.1239195168018341,-0.4393113255500793,-0.2310952693223953,0.0125381853431463,0.1744433194398880,0.1020421013236046,-0.2529702782630920) * FEATURE2_texOff(vec2(-1,0));
res += mat4(0.2566922307014465,0.4717541038990021,-0.2663963735103607,-0.2526082992553711,-0.1143780574202538,0.2739281058311462,0.0537307523190975,0.3152118325233459,0.3445367217063904,-0.0012370349140838,0.1016864702105522,-0.2253527641296387,-0.0035550640895963,-0.4149434268474579,-0.2514138221740723,0.0322588421404362) * FEATURE3_texOff(vec2(-1,0));
res += mat4(-0.2215952426195145,-0.0110388817265630,-0.2461408078670502,-0.4067878723144531,-0.5773093104362488,0.5065827965736389,-0.6598036289215088,-0.0595017410814762,0.4899374246597290,0.2303059250116348,-0.4807002842426300,0.7196635603904724,0.4076787829399109,-0.0242379792034626,-0.1136177778244019,-0.1848805695772171) * FEATURE4_texOff(vec2(-1,0));
res += mat4(-0.0076391175389290,-0.2041926831007004,0.7404879927635193,0.0289287958294153,0.0456222109496593,0.0330134965479374,0.3433131873607635,-0.0810455009341240,-0.1985356509685516,-0.5179297924041748,0.4881610572338104,0.0078276675194502,0.0087746055796742,-0.1056760698556900,0.2095190286636353,0.7285584807395935) * FEATURE1_texOff(vec2(-1,1));
res += mat4(0.1195456460118294,0.0032121676485986,-0.5120199918746948,-0.5298866033554077,-0.0995549932122231,0.1369630396366119,-0.1829387843608856,0.2486933171749115,-0.0488051250576973,0.2010894566774368,0.2991284132003784,-0.0388986207544804,-0.0002756736357696,-0.1491157859563828,-0.0484132729470730,-0.1802987605333328) * FEATURE2_texOff(vec2(-1,1));
res += mat4(-0.0290505327284336,-0.5906178951263428,0.4409755766391754,0.0070458007976413,0.0482775717973709,0.2681422531604767,-0.1142541691660881,-0.3494954705238342,-0.1452796012163162,-0.1575714498758316,-0.2524724602699280,-0.1038879528641701,0.0732139572501183,0.2315133512020111,0.1530150920152664,0.0840636864304543) * FEATURE3_texOff(vec2(-1,1));
res += mat4(-0.0325694419443607,-0.2112122029066086,0.2012213468551636,0.2090254873037338,0.1002777218818665,0.0359562151134014,0.2956393063068390,-0.0423515550792217,-0.1421563923358917,-0.2423527091741562,0.0935527235269547,0.3131506443023682,-0.0729856491088867,0.0598148182034492,-0.4247841238975525,-0.8078673481941223) * FEATURE4_texOff(vec2(-1,1));
res += mat4(-0.2672279477119446,0.0677437037229538,-0.3512685596942902,-0.1972570568323135,0.0390892066061497,0.0446520186960697,-0.0022914779838175,0.3543418049812317,-0.4907896816730499,-0.3693255484104156,-0.0339384861290455,0.0572401657700539,0.3714402318000793,0.0966239944100380,-0.2475168853998184,0.5476519465446472) * FEATURE1_texOff(vec2(0,-1));
res += mat4(-0.8543110489845276,-0.0671872422099113,-0.0705442354083061,0.1570529192686081,0.0825821384787560,0.2611544132232666,-0.1222487613558769,0.1643241792917252,0.1565754264593124,-0.0417577736079693,0.2425020486116409,0.1290563046932220,0.0018513374961913,0.0828469917178154,0.0405366159975529,-0.0648405849933624) * FEATURE2_texOff(vec2(0,-1));
res += mat4(0.6323528885841370,0.2739350795745850,-0.2666106224060059,-0.7200468182563782,-0.1899063885211945,-0.6205863952636719,0.0421243421733379,0.3463516235351562,0.1843721121549606,-0.2456515282392502,0.4096761643886566,-0.2125853598117828,0.3226993083953857,-0.1005071029067039,-0.4462574124336243,0.1020871326327324) * FEATURE3_texOff(vec2(0,-1));
res += mat4(-0.2349889576435089,-0.0292534027248621,-0.0411632061004639,0.4069747030735016,-0.3070210218429565,-0.4162268042564392,0.4625560045242310,0.5024183392524719,-0.5629498958587646,0.1867086291313171,0.3565312922000885,-0.1979124397039413,-0.2834521234035492,0.2735725045204163,0.3703005015850067,-0.0476065389811993) * FEATURE4_texOff(vec2(0,-1));
res += mat4(-0.1110515445470810,-0.0889210999011993,0.5447590947151184,0.5599544644355774,0.0503268949687481,0.5344191193580627,-0.8062646985054016,-0.0667447745800018,-0.6623851656913757,-0.5459131598472595,1.5236161947250366,-0.0879496559500694,-0.0745205506682396,-0.0589255765080452,1.3849964141845703,-0.6337348222732544) * FEATURE1_texOff(vec2(0,0));
res += mat4(-1.5323712825775146,-0.0780734047293663,0.6519567370414734,0.3739070892333984,0.3757006227970123,0.9047968387603760,-0.0571847669780254,0.4038882553577423,-0.1069322824478149,-0.2172508686780930,0.5056326389312744,1.2829581499099731,-0.1444370597600937,0.5224547386169434,-0.0722906515002251,0.0795549526810646) * FEATURE2_texOff(vec2(0,0));
res += mat4(-0.6640521883964539,0.5300254225730896,-0.0877570062875748,0.4579716026782990,0.8427389264106750,0.1519258320331573,-0.4424907565116882,-1.1069610118865967,-0.5535061359405518,0.0053214239887893,-0.7151303887367249,-0.4114071726799011,-0.5903876423835754,0.1780086755752563,0.5006626248359680,-1.5713576078414917) * FEATURE3_texOff(vec2(0,0));
res += mat4(-0.9901613593101501,0.5854467749595642,-0.4626945555210114,-1.4144535064697266,0.4928303956985474,-0.5428397655487061,0.2632802724838257,0.3861836194992065,1.4645655155181885,0.8884012699127197,-0.5033279061317444,-0.3723740577697754,-0.2988887429237366,0.2345651835203171,-0.5706858038902283,0.6728245615959167) * FEATURE4_texOff(vec2(0,0));
res += mat4(0.3330448865890503,-0.0112070143222809,0.0356724001467228,-0.6474183797836304,0.0812799334526062,0.0869863256812096,-0.3065863847732544,0.4735077917575836,-0.0033763803075999,0.0593322105705738,-0.6203757524490356,-0.5629683732986450,-0.0974204465746880,0.4720092117786407,0.0359686203300953,0.0232102889567614) * FEATURE1_texOff(vec2(0,1));
res += mat4(0.0082539124414325,0.3939676284790039,-0.0776229128241539,-0.2679301202297211,0.0027645381633192,-0.0417950749397278,0.0923903882503510,0.1083738878369331,0.0481295213103294,-0.0261830873787403,-0.1667288690805435,-0.3122136890888214,-0.0156238935887814,0.0977522209286690,0.0455260388553143,0.1199765577912331) * FEATURE2_texOff(vec2(0,1));
res += mat4(0.0047927461564541,-0.2047413140535355,0.1119864657521248,-0.0603350065648556,-0.2410678416490555,-0.0583524815738201,0.5357083678245544,0.2207382619380951,0.0469230078160763,0.5270653963088989,-0.1780998557806015,-0.1674558818340302,0.1456317305564880,-0.0401461794972420,0.0933937430381775,0.6531956195831299) * FEATURE3_texOff(vec2(0,1));
res += mat4(0.0811188220977783,0.1855691522359848,0.5768072009086609,0.6195318102836609,-0.1750047355890274,-0.0456597469747066,0.0544740520417690,0.0523158796131611,-0.1887115687131882,-0.0920856148004532,0.2902313172817230,0.1041692793369293,0.1448101103305817,-0.2443434298038483,0.0036924448795617,-0.2103126198053360) * FEATURE4_texOff(vec2(0,1));
res += mat4(0.2381375432014465,0.0663627311587334,0.2335012406110764,-0.4627820551395416,0.0784997120499611,-0.0597434937953949,-0.4166316390037537,0.0074965548701584,0.3907958269119263,0.1916564106941223,-0.2059002667665482,0.4835616052150726,-0.1457022279500961,-0.1120766475796700,0.2817732691764832,-0.2332912832498550) * FEATURE1_texOff(vec2(1,-1));
res += mat4(0.0222312137484550,-0.0120648341253400,-0.0721819549798965,0.3582895100116730,0.0691022127866745,0.1871034353971481,-0.2465584874153137,0.0685276314616203,-0.2311962693929672,0.1878426522016525,0.2817679941654205,-0.4235020875930786,0.0142014203593135,-0.0222091376781464,-0.0658412203192711,-0.0145346689969301) * FEATURE2_texOff(vec2(1,-1));
res += mat4(-0.3453203439712524,-0.2888496816158295,0.0926567688584328,-0.2852761745452881,0.1101823970675468,0.1956752538681030,-0.2150241434574127,0.1415577530860901,0.0338111296296120,0.2003097236156464,-0.4137915968894958,0.1386701911687851,0.1041650995612144,-0.2015049159526825,0.0317280702292919,-0.1441253572702408) * FEATURE3_texOff(vec2(1,-1));
res += mat4(0.1853863447904587,-0.0027557848952711,0.3130645453929901,-0.2007332146167755,0.1552875041961670,0.2765832543373108,-0.0549829043447971,-0.4224346280097961,0.0121838003396988,-0.3931493163108826,-0.0699725449085236,-0.3622962236404419,0.0923926681280136,-0.0462332814931870,-0.5720705389976501,-0.5957081913948059) * FEATURE4_texOff(vec2(1,-1));
res += mat4(-0.1048749312758446,0.3038594424724579,0.0877718999981880,-0.5723592638969421,0.1507204025983810,-0.2664858698844910,0.4885557293891907,-0.0462419800460339,-0.1107062175869942,-0.0146323684602976,0.0514640919864178,-0.4875652790069580,0.0883469134569168,-0.2287716269493103,-0.0465135686099529,0.2910905480384827) * FEATURE1_texOff(vec2(1,0));
res += mat4(0.0466432012617588,0.0349049381911755,0.1494108885526657,0.1739636659622192,0.0478214323520660,0.2432070374488831,-0.0177862383425236,-0.0793354362249374,-0.1829998195171356,0.1144796311855316,0.0297554768621922,0.2117564082145691,-0.0676111206412315,-0.0684614256024361,0.1142124012112617,-0.0069754370488226) * FEATURE2_texOff(vec2(1,0));
res += mat4(0.1866484284400940,-0.1311591118574142,-0.0755611211061478,-0.1545641869306564,-0.1843944787979126,-0.3941308557987213,0.1287009268999100,-0.5104728937149048,0.0809461697936058,-0.0393850989639759,0.5790613889694214,0.1231456026434898,0.2869783937931061,-0.0183582436293364,-0.0692270994186401,0.2544916272163391) * FEATURE3_texOff(vec2(1,0));
res += mat4(-0.0310170222073793,0.4162579774856567,-0.1859597861766815,-0.5479277968406677,0.3031933009624481,-0.0237672720104456,-0.2337787002325058,-0.4088483750820160,0.3291740715503693,0.3458972871303558,0.2511204481124878,-0.0650157034397125,-0.0741363167762756,0.0105352764949203,0.7500665187835693,-0.0325997248291969) * FEATURE4_texOff(vec2(1,0));
res += mat4(-0.0696199908852577,-0.0312602259218693,-0.3989183604717255,0.0745669603347778,-0.0644938871264458,-0.2105388045310974,-0.0457618758082390,0.1598308533430099,0.0451122224330902,-0.0662788227200508,-0.2538039088249207,0.5548169016838074,0.0271571110934019,-0.0747818723320961,-0.8167809247970581,-0.5255750417709351) * FEATURE1_texOff(vec2(1,1));
res += mat4(0.0454585738480091,0.0796022489666939,0.0746575891971588,-0.2704296708106995,0.0789716318249702,-0.1085990220308304,0.0633433163166046,0.0348055623471737,-0.0633753612637520,0.0536539033055305,-0.4138174951076508,0.0117621375247836,0.0342889316380024,0.0145183121785522,-0.0361714251339436,0.0064807245507836) * FEATURE2_texOff(vec2(1,1));
res += mat4(-0.0557610355317593,-0.2160326540470123,-0.0119402194395661,0.0404285416007042,0.0745694935321808,-0.0587787367403507,-0.2089506536722183,0.3658298552036285,0.0678608715534210,-0.1341597437858582,0.0637727901339531,-0.5492725968360901,-0.0415159165859222,0.1558386832475662,-0.1377484798431396,0.0551406964659691) * FEATURE3_texOff(vec2(1,1));
res += mat4(-0.0351044386625290,-0.3134496510028839,-0.0776799321174622,-0.5582964420318604,-0.1094810813665390,-0.2420932352542877,0.0866121128201485,-0.0139054777100682,-0.0232693497091532,-0.0878517329692841,-0.1818398535251617,-0.1748342961072922,0.0291870851069689,-0.0635103136301041,0.2051592320203781,0.2843922674655914) * FEATURE4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.8224552273750305,0.0907779783010483,-0.8194684386253357,0.7123059630393982) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 2_1
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL1
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.1821142584085464,0.2680435180664062,0.0072256801649928,-0.1534767448902130);
res += mat4(0.1567186117172241,0.1995420008897781,0.3876445293426514,-0.0657437443733215,-0.2419036328792572,-0.0437269136309624,-0.2063243538141251,-0.0750159919261932,0.7670885920524597,0.0008573648519814,-0.1210522502660751,0.0726916193962097,0.1269507706165314,0.0502357371151447,-0.0651772618293762,0.0675387755036354) * MODEL21_texOff(vec2(-1,-1));
res += mat4(-1.3524439334869385,0.3195005059242249,0.1917120516300201,0.1658273935317993,0.0782139450311661,0.0182677172124386,0.0383682511746883,-0.0341160148382187,0.0195416361093521,0.1128480508923531,-0.1998605728149414,0.2079982757568359,-0.2893924117088318,0.0977299958467484,-0.2218614667654037,-0.0945199429988861) * MODEL22_texOff(vec2(-1,-1));
res += mat4(0.0076252417638898,-0.0967269837856293,0.3000745773315430,0.4004792869091034,-0.0856744647026062,0.0516689606010914,-0.0221493914723396,0.0029376018792391,0.4413319826126099,0.0865859538316727,-0.1825978457927704,0.1487386226654053,-0.3030017316341400,0.1085127368569374,-0.0123953092843294,-0.1547867208719254) * MODEL23_texOff(vec2(-1,-1));
res += mat4(-0.8065760731697083,-0.0367696434259415,0.0877586156129837,-0.0537286400794983,-0.0701612755656242,-0.1005082055926323,0.0130320955067873,0.1380047053098679,0.1492499262094498,-0.1195761263370514,-0.1748647242784500,0.1239927485585213,-0.4883742034435272,0.0717922672629356,0.0781278908252716,-0.0129398517310619) * MODEL24_texOff(vec2(-1,-1));
res += mat4(0.0333379022777081,-0.2495142370462418,-0.2084558606147766,0.0531433485448360,0.0851450264453888,-0.2658228576183319,0.1058013588190079,-0.4307983219623566,0.1927942186594009,0.2174018770456314,0.0456488057971001,0.3917725980281830,0.8125612139701843,0.3295940160751343,-0.4563819169998169,-0.0668170005083084) * MODEL21_texOff(vec2(-1,0));
res += mat4(-0.1991187632083893,-0.0398979596793652,-0.1471599936485291,-0.1525022089481354,0.2197243869304657,-0.0161120090633631,-0.0291145816445351,-0.0731005445122719,0.4118004143238068,-0.1268711835145950,0.1246666610240936,0.0325524769723415,-0.4228635430335999,0.0653037428855896,0.9307349920272827,-0.3417280912399292) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.0911106318235397,-0.1293365806341171,0.2490556836128235,-0.2674607336521149,-0.2140632718801498,-0.0961873531341553,-0.0138489585369825,0.1502670645713806,0.2489348948001862,-0.1887987405061722,0.2666619420051575,-0.1154452785849571,0.0820531323552132,-0.0129997190088034,0.0963720157742500,-0.0252925604581833) * MODEL23_texOff(vec2(-1,0));
res += mat4(-1.3609907627105713,-0.0742893442511559,-0.0125409606844187,-0.0056720492430031,0.0778579562902451,0.0618307478725910,0.1911646276712418,0.0333926491439342,0.6612700819969177,-0.0953298956155777,-0.2552929818630219,0.1396622061729431,-0.1745201647281647,0.0346113406121731,0.1850840449333191,0.0185419023036957) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.3591235578060150,0.2359590530395508,-0.2886492311954498,0.0527037158608437,-0.1544393002986908,0.0854820013046265,0.1401815116405487,-0.1968982666730881,-0.1077311411499977,-0.0662739872932434,0.0243663974106312,-0.0608084313571453,-0.1768577247858047,0.0570018291473389,0.2061744332313538,0.0576052591204643) * MODEL21_texOff(vec2(-1,1));
res += mat4(-0.0572265945374966,-0.0552289001643658,0.1011031270027161,0.1035296767950058,-0.0300345961004496,-0.1117853671312332,-0.0263337921351194,0.0094234542921185,0.1769479662179947,-0.0179979670792818,0.1946553289890289,-0.0712494775652885,-0.2151643931865692,-0.0934141129255295,-0.4591092169284821,0.1333216726779938) * MODEL22_texOff(vec2(-1,1));
res += mat4(-0.0737016946077347,-0.1227276995778084,-0.1683048903942108,-0.0236847456544638,0.1358708888292313,0.0047147679142654,-0.0391176939010620,-0.1973716020584106,0.0702386870980263,0.0448955483734608,-0.0558337457478046,-0.0901165679097176,-0.2186353653669357,0.0084573915228248,0.0841164141893387,0.0704563483595848) * MODEL23_texOff(vec2(-1,1));
res += mat4(0.0492553226649761,-0.0671901404857635,0.0388167165219784,-0.0680868476629257,0.1270323693752289,-0.0159644298255444,-0.1079521402716637,0.0222510322928429,0.3358281254768372,-0.1708553582429886,-0.1252177208662033,0.0763640031218529,0.1933518797159195,-0.0705295801162720,-0.3656790852546692,-0.0959990024566650) * MODEL24_texOff(vec2(-1,1));
res += mat4(-0.1263016015291214,0.0133211184293032,0.0842036530375481,0.0142416367307305,-0.1877359002828598,-0.3686734437942505,-0.0018322402611375,0.1556163281202316,-0.2742095887660980,0.1279869675636292,0.1694325655698776,-0.0867729112505913,0.0498056113719940,0.1580689102411270,-0.1015132665634155,-0.1334203332662582) * MODEL21_texOff(vec2(0,-1));
res += mat4(-0.3412644565105438,0.3071808218955994,0.1298775672912598,-0.0151394074782729,-0.1365107297897339,0.0794544816017151,-0.0338835604488850,-0.1141469553112984,0.0488405674695969,-0.1304851919412613,-0.0011596791446209,-0.0413838326931000,-0.1392471194267273,-0.3956683278083801,0.4911434948444366,0.0361462570726871) * MODEL22_texOff(vec2(0,-1));
res += mat4(0.2449082285165787,-0.4345789253711700,0.4849193692207336,0.8864058256149292,-0.2164106816053391,-0.0341735631227493,0.1066467314958572,0.1131146848201752,0.0052013010717928,-0.6583964228630066,0.2482749819755554,-0.2270440012216568,-0.4508041441440582,0.0308938957750797,-0.1488518714904785,-0.3525811433792114) * MODEL23_texOff(vec2(0,-1));
res += mat4(-1.1301820278167725,-0.1139227300882339,-0.0902033075690269,-0.0815369635820389,-0.6447158455848694,0.0044209216721356,0.3049816191196442,-0.1885408312082291,0.2548591196537018,-0.1266584843397141,-0.1311751753091812,0.4100277423858643,0.5975887179374695,0.0288057103753090,-1.0636798143386841,0.0248462166637182) * MODEL24_texOff(vec2(0,-1));
res += mat4(0.2010120749473572,-1.2808847427368164,-0.7578352689743042,0.1681615263223648,-0.1318595111370087,0.2353363186120987,0.0309769660234451,-0.1553873419761658,0.4740163087844849,0.1202724725008011,-0.1335061937570572,-0.1300238966941833,0.5667089819908142,-1.3050092458724976,0.3937561810016632,0.0676776319742203) * MODEL21_texOff(vec2(0,0));
res += mat4(-0.0423373468220234,0.1925407946109772,0.2199071794748306,0.3929440677165985,-0.2842360734939575,-0.0180727411061525,0.1322070807218552,-0.2691322863101959,0.2204505503177643,-0.2613276541233063,0.2861527800559998,0.0240724403411150,0.0266265962272882,-0.0488316640257835,-1.1076385974884033,-0.8230466842651367) * MODEL22_texOff(vec2(0,0));
res += mat4(0.1157649457454681,-0.5262610912322998,-0.4589408934116364,-0.3231031000614166,-0.1873793303966522,0.1040373072028160,-0.0043132947757840,-0.2475142627954483,-0.4760713875293732,1.0741505622863770,0.3271216154098511,0.3974502682685852,-1.2799012660980225,-0.1491752415895462,-0.0626190677285194,0.3458690643310547) * MODEL23_texOff(vec2(0,0));
res += mat4(-1.7880072593688965,-0.2957656979560852,0.2039281576871872,0.8241132497787476,0.4561480879783630,-0.1978895813226700,-0.2962991297245026,-0.4750007390975952,0.2250721603631973,-0.2444366663694382,-0.1919652819633484,0.3538269996643066,-0.2579703032970428,-0.0596731863915920,0.4506496787071228,-0.0758553668856621) * MODEL24_texOff(vec2(0,0));
res += mat4(-0.2363123893737793,-0.2024950683116913,0.4612375795841217,0.0570622235536575,0.0881865248084068,-0.0166694410145283,0.2792043387889862,0.4196121394634247,-0.1977110058069229,-0.2585518658161163,-0.1096482425928116,-0.1421143114566803,-0.3357407450675964,0.4351834952831268,0.0629108995199203,0.0411290898919106) * MODEL21_texOff(vec2(0,1));
res += mat4(-0.0054646912030876,-0.0600186586380005,0.0738468095660210,0.1228874176740646,0.2729446589946747,0.1031413972377777,-0.0801865309476852,-0.0856407806277275,0.1911747008562088,0.1428168565034866,0.0383216328918934,-0.0306113492697477,0.3450233936309814,0.0242073778063059,-0.1353743970394135,0.2545643746852875) * MODEL22_texOff(vec2(0,1));
res += mat4(0.1516852378845215,0.1281777173280716,0.0495800264179707,0.0709310695528984,0.4112361371517181,-0.1296079009771347,-0.0835521146655083,-0.0831478238105774,0.3761658966541290,-0.0807763114571571,-0.3550937175750732,0.1545328646898270,-0.1909658759832382,0.3049871027469635,-0.2306296229362488,0.5257671475410461) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.5683341622352600,-0.2224640548229218,-0.1304718255996704,-0.3179947435855865,-0.2497202455997467,0.0933883860707283,-0.0180351864546537,0.3762677609920502,0.4063305258750916,-0.1836601644754410,-0.1099256500601768,0.1693253517150879,0.0693730935454369,-0.1310130953788757,0.5590953826904297,-0.0960289835929871) * MODEL24_texOff(vec2(0,1));
res += mat4(-0.0448128581047058,0.0955501049757004,-0.0131698353216052,-0.0220590531826019,-0.1163260191679001,-0.1044962033629417,0.2927580773830414,0.0900845080614090,-0.0908898562192917,-0.0140993846580386,-0.1200544610619545,0.0472135804593563,-0.2083983272314072,0.0617266818881035,-0.1182451546192169,0.0665644034743309) * MODEL21_texOff(vec2(1,-1));
res += mat4(-0.0803786739706993,0.0827859640121460,0.0072462079115212,-0.2093681544065475,-0.1504998654127121,0.1586733907461166,0.0233440455049276,-0.0907380953431129,0.2275118231773376,-0.0361422561109066,-0.1722713708877563,0.0016444522188976,-0.0094037437811494,-0.0401315316557884,0.1533747762441635,0.2347405254840851) * MODEL22_texOff(vec2(1,-1));
res += mat4(-0.0795541778206825,-0.0415713526308537,-0.5099042057991028,-0.0149333784356713,-0.2474434971809387,-0.0654927119612694,-0.0335343852639198,0.1252077370882034,-0.1952859163284302,0.1456465572118759,-0.0701137110590935,0.0986037403345108,-0.2069234102964401,-0.1180571690201759,-0.0970456451177597,-0.1523316949605942) * MODEL23_texOff(vec2(1,-1));
res += mat4(-0.2704406976699829,-0.1032495945692062,0.0287192743271589,-0.1506863534450531,-0.0400577299296856,0.2502267658710480,-0.0014179557329044,-0.1011240780353546,0.0739094018936157,-0.1213546693325043,-0.1125583201646805,0.3609499037265778,-0.3276679813861847,0.1689044237136841,0.2304164320230484,-0.0001931495644385) * MODEL24_texOff(vec2(1,-1));
res += mat4(-0.1978055983781815,0.1357314586639404,0.1586758643388748,-0.0945459157228470,-0.4273775219917297,0.2047612667083740,0.0722427740693092,-0.3048678040504456,0.6182712316513062,-0.1360633820295334,-0.0148682333528996,-0.0552632026374340,0.0355981625616550,0.0679149776697159,0.4708693623542786,-0.0924237072467804) * MODEL21_texOff(vec2(1,0));
res += mat4(0.1895539909601212,0.0620631873607635,0.1083511039614677,0.0031299949623644,0.0098341582342982,0.1454111188650131,-0.0994552299380302,0.2133522182703018,0.4204807877540588,0.1561957448720932,0.0839771330356598,0.0947130024433136,-0.2763549685478210,0.4134998917579651,-0.3971848785877228,-0.0562333762645721) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.1201812475919724,-0.0794004648923874,0.2589171230792999,-0.2570854723453522,-0.0500254817306995,-0.1267163306474686,0.0093950657173991,0.2073075473308563,-0.1715992838144302,-0.5256302356719971,-0.0471544377505779,-0.2598889470100403,0.3023664951324463,-0.3980978429317474,0.1450010985136032,-0.1947911083698273) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.6694424748420715,-0.0984072983264923,-0.0158487502485514,-0.0387963205575943,-0.0327408984303474,-0.1224467456340790,-0.2588094174861908,-0.4945738017559052,-0.0965986251831055,-0.2402145564556122,-0.1900290995836258,0.4495627582073212,0.3433674573898315,0.1855849176645279,0.2503889203071594,0.2258707880973816) * MODEL24_texOff(vec2(1,0));
res += mat4(-0.1427439004182816,0.0232400503009558,0.0614709183573723,-0.0313369631767273,-0.2033404409885406,0.1010737940669060,-0.3053102195262909,-0.1093115955591202,0.1278154850006104,0.0462433546781540,0.2780232727527618,0.1207928806543350,-0.0630893185734749,0.1609147638082504,-0.3244910240173340,0.0420972406864166) * MODEL21_texOff(vec2(1,1));
res += mat4(0.0540682710707188,0.0489707849919796,0.1434160768985748,-0.0263705123215914,0.3189105987548828,-0.0194563362747431,-0.0015234283637255,-0.1185838729143143,-0.1406057775020599,-0.0664507374167442,0.1184594258666039,0.0576133131980896,-0.0515225417912006,-0.1751619428396225,0.5659244060516357,-0.1315055191516876) * MODEL22_texOff(vec2(1,1));
res += mat4(0.0292246416211128,-0.0583971366286278,0.0184998158365488,-0.0616783015429974,-0.1326405405998230,0.0737697705626488,0.0509051755070686,-0.1636607348918915,0.0829640030860901,0.0984901785850525,-0.0760249570012093,-0.0393353812396526,0.1848428100347519,0.0810922980308533,-0.0835731029510498,-0.1527970433235168) * MODEL23_texOff(vec2(1,1));
res += mat4(0.1098753735423088,-0.1152176111936569,-0.0297945626080036,-0.0429614298045635,0.3004037737846375,-0.0118061201646924,0.0696947872638702,0.2093984186649323,0.1215613707900047,-0.1341927945613861,-0.0733395144343376,0.1597006767988205,0.1582593768835068,-0.1383092254400253,-0.3920480310916901,0.0803317874670029) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0138328820466995,0.6884090304374695,-0.3778789639472961,0.0335069037973881) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 2_2
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL2
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.1488664448261261,-0.3665277659893036,0.2105678319931030,0.2431615889072418);
res += mat4(-0.0209767278283834,-0.3804727494716644,0.0663711279630661,0.1559448540210724,-0.7823102474212646,0.0327561274170876,0.0540102683007717,-0.1310726553201675,0.1931789815425873,-0.1646288931369781,0.1219010725617409,0.0445458665490150,0.0016282304422930,0.0971931293606758,0.1857922673225403,-0.1043798327445984) * MODEL21_texOff(vec2(-1,-1));
res += mat4(0.4213770925998688,0.4195652604103088,-0.7362828254699707,-0.0048468001186848,0.0455092750489712,0.0810072496533394,0.0412613227963448,0.1747123897075653,-0.1279432028532028,-0.1154062822461128,-0.1147719696164131,-0.3269986212253571,-0.1911139041185379,0.0527008846402168,-0.0984842479228973,-0.1479913443326950) * MODEL22_texOff(vec2(-1,-1));
res += mat4(-0.0879788175225258,-0.3954658508300781,0.2055625319480896,0.3015489578247070,0.1120360046625137,-0.1616907417774200,0.0821904093027115,-0.0118853077292442,-0.0370529182255268,0.0719115212559700,-0.1579851806163788,-0.3017398118972778,-0.0244198907166719,0.0105502773076296,-0.0938296243548393,0.0975423976778984) * MODEL23_texOff(vec2(-1,-1));
res += mat4(-0.0093844309449196,0.0437207221984863,0.0675221458077431,0.1927775293588638,0.2635573446750641,0.2475218921899796,0.0567236356437206,0.0603825785219669,0.1537563800811768,0.0857703611254692,0.2134899497032166,-0.4813969731330872,-0.1290699839591980,0.2495704889297485,0.2372044026851654,-0.0117452535778284) * MODEL24_texOff(vec2(-1,-1));
res += mat4(0.4083919525146484,0.1783591061830521,-0.0956984385848045,-0.2499091178178787,-1.7284232378005981,-0.4100556671619415,0.1243892982602119,0.0198476538062096,0.2060415297746658,-0.0525438860058784,-0.1886686235666275,-0.0174900069832802,-0.2235226035118103,-0.3373796939849854,-0.2612507343292236,-0.0146219292655587) * MODEL21_texOff(vec2(-1,0));
res += mat4(0.1432350128889084,0.5602362751960754,-0.5797067284584045,0.2074658870697021,0.0187970548868179,0.0178430322557688,0.0442645438015461,0.0339028500020504,-0.4133535623550415,-0.0538620986044407,0.0512013956904411,0.2325866669416428,0.0893165320158005,-0.3604934513568878,-0.1180035024881363,0.0262325238436460) * MODEL22_texOff(vec2(-1,0));
res += mat4(0.2469130605459213,0.4839991331100464,0.2031589746475220,-0.2946717739105225,-0.1321040540933609,-0.2264211177825928,0.2053416073322296,0.0078430837020278,0.1857969164848328,-0.2007324248552322,0.0725167244672775,0.1926081627607346,0.2548782527446747,0.0827651545405388,0.2406112551689148,-0.0407047085464001) * MODEL23_texOff(vec2(-1,0));
res += mat4(0.0828146636486053,0.0865400582551956,0.1932517141103745,0.2175391018390656,0.1142690703272820,0.1374290436506271,0.0615031346678734,-0.0207381490617990,0.1915358901023865,-0.0319920741021633,0.0051920590922236,-0.9361169934272766,0.0073183747008443,0.1199636980891228,-0.0483770743012428,-0.1557808965444565) * MODEL24_texOff(vec2(-1,0));
res += mat4(0.0676551461219788,0.0048673334531486,-0.1837492138147354,0.4258618056774139,-0.5135343074798584,-0.3120350241661072,-0.0071885827928782,-0.0406319499015808,-0.2463573515415192,0.1431833654642105,0.1748166233301163,-0.0105671910569072,-0.0699452683329582,0.1292552053928375,-0.0014936180086806,0.0179299116134644) * MODEL21_texOff(vec2(-1,1));
res += mat4(0.2675818502902985,0.2416653037071228,-0.2863791882991791,0.2014812082052231,0.0785021260380745,0.0527739636600018,0.0860331654548645,-0.0324266068637371,-0.1051566079258919,0.1046611443161964,-0.0194833986461163,-0.3063759803771973,-0.0681753531098366,-0.0490408688783646,0.2593856453895569,0.2360491454601288) * MODEL22_texOff(vec2(-1,1));
res += mat4(0.0276840645819902,-0.1336680799722672,0.0120388455688953,0.0228763688355684,-0.0438108332455158,-0.0796145349740982,-0.0109203783795238,-0.0991106778383255,0.0081140063703060,-0.1780876815319061,0.0395902618765831,0.3544999063014984,0.3345801234245300,0.2487742155790329,0.1700582355260849,0.2577689290046692) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.0195066519081593,-0.0057190088555217,-0.0528206415474415,0.0456047132611275,0.2927095592021942,-0.0287597328424454,-0.0689215958118439,-0.0735881552100182,0.2405999749898911,0.0682441517710686,0.0884225219488144,-0.7075817584991455,-0.0792603269219398,0.0144493831321597,-0.0936887264251709,0.0407843478024006) * MODEL24_texOff(vec2(-1,1));
res += mat4(0.2638292014598846,0.1321179270744324,-0.3282649219036102,0.1449954211711884,-0.1059715524315834,-0.4213337600231171,0.0888387262821198,0.0785648524761200,0.5093721151351929,0.2934474349021912,0.2116974741220474,0.1434847712516785,0.0233318489044905,0.0169317442923784,-0.3048302829265594,0.3552511930465698) * MODEL21_texOff(vec2(0,-1));
res += mat4(-0.0006108223460615,-0.8525040149688721,0.2292312681674957,0.0670521706342697,0.1908545941114426,0.1113816425204277,0.0131995510309935,0.4049734771251678,-0.1704349219799042,-0.1992454230785370,0.1286296993494034,-0.4365665912628174,0.5170667171478271,-0.2130605578422546,-0.3376957476139069,0.2425667643547058) * MODEL22_texOff(vec2(0,-1));
res += mat4(2.6007122993469238,-0.4045737981796265,0.2440708875656128,-0.6878179907798767,-0.1587067693471909,-0.0362795069813728,-0.2442864775657654,-0.1149008274078369,-0.0489179715514183,-0.0458397902548313,0.1453526914119720,0.3821898400783539,-0.2518219053745270,0.0271638035774231,0.1576943546533585,-0.0347718335688114) * MODEL23_texOff(vec2(0,-1));
res += mat4(-0.2895047068595886,-0.2282049357891083,0.2446162104606628,0.1061088964343071,0.0080963568761945,-0.0599781461060047,-0.3279895484447479,0.0812600925564766,0.1272254437208176,0.0560115240514278,-0.1846324354410172,-0.9808861017227173,-0.1482340842485428,0.8221842646598816,0.0221485923975706,0.0719476789236069) * MODEL24_texOff(vec2(0,-1));
res += mat4(0.0339426398277283,0.5930976867675781,0.2564468383789062,0.1119002699851990,0.8898367881774902,-0.6156752109527588,0.1269108504056931,-0.2929377555847168,1.0610867738723755,-0.3349628746509552,-0.4281881153583527,0.0377563461661339,-0.2603005468845367,-0.3311541676521301,1.0532506704330444,-0.7641850113868713) * MODEL21_texOff(vec2(0,0));
res += mat4(0.2146379500627518,0.2676785290241241,-0.7391330599784851,0.1521523594856262,-0.2685771882534027,0.2021048963069916,0.0981994196772575,0.2597109377384186,-0.4331949949264526,0.3671139180660248,-0.1601590961217880,-0.2596710324287415,-0.1365760862827301,0.3456763625144958,0.0260859876871109,0.1499751359224319) * MODEL22_texOff(vec2(0,0));
res += mat4(-0.4414543509483337,0.1875744611024857,-0.6906532049179077,0.1743199676275253,-0.6289122104644775,-0.4084732234477997,0.3361287415027618,-0.0457460992038250,0.5822556614875793,0.5126429796218872,0.3484890460968018,-1.2192883491516113,0.4538821578025818,-0.0073624793440104,-0.2771317660808563,-0.2402551472187042) * MODEL23_texOff(vec2(0,0));
res += mat4(-1.3552881479263306,-0.0462988875806332,-0.9949124455451965,0.3322547674179077,-0.6281521320343018,-1.0690743923187256,0.0267870500683784,0.0392859280109406,0.3305831849575043,-0.0056408219970763,-0.1609006524085999,-1.7105754613876343,-0.3269245028495789,-1.0086795091629028,-0.4690948128700256,0.4611120522022247) * MODEL24_texOff(vec2(0,0));
res += mat4(0.2988446652889252,0.3127099275588989,0.0188631992787123,-0.1760921627283096,-0.1780847012996674,-0.4430866837501526,-0.2036319524049759,-0.1021577641367912,-0.8201317191123962,0.1630726456642151,-0.0020800509955734,0.0576628297567368,0.1705153137445450,-0.1894215494394302,0.0107206311076880,0.1925764083862305) * MODEL21_texOff(vec2(0,1));
res += mat4(0.2376920729875565,0.3652732074260712,-0.2681298553943634,-0.0732383355498314,0.1779675185680389,0.0073725385591388,0.1464152187108994,0.2233835905790329,-0.0569469146430492,-0.1233587786555290,0.0616926848888397,-0.1734538525342941,-0.0847201347351074,0.0654263123869896,-0.4428806006908417,-0.0111119458451867) * MODEL22_texOff(vec2(0,1));
res += mat4(-0.1337117999792099,-0.0917584300041199,-0.3312341570854187,0.1923831552267075,-0.4488549530506134,0.0056631849147379,-0.1590194851160049,0.0815478563308716,0.1391742974519730,0.0849350765347481,0.2781904041767120,-0.0765718370676041,0.3601172864437103,-0.0282259564846754,-0.4200063049793243,0.0093057192862034) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.4692421853542328,-0.0067639327608049,-0.8812321424484253,0.1007703617215157,0.1055886894464493,-0.1098278909921646,-0.2009087353944778,-0.0958641320466995,0.2970055639743805,0.0348862037062645,0.0272636990994215,-0.9529185891151428,0.1262121647596359,0.1741883754730225,0.0202931892126799,-0.2663290202617645) * MODEL24_texOff(vec2(0,1));
res += mat4(0.1469807624816895,0.1303935497999191,0.0896321758627892,-0.2362475395202637,0.0948089957237244,-0.0777317211031914,0.2014655768871307,-0.2769223749637604,0.0730939731001854,0.0609405860304832,0.1171776428818703,0.0423140898346901,0.1374751031398773,0.0574923083186150,-0.1033022776246071,-0.0672734901309013) * MODEL21_texOff(vec2(1,-1));
res += mat4(0.3127930760383606,0.0793014988303185,-0.0861674025654793,-0.1551166921854019,-0.0192798860371113,-0.1602066755294800,0.3099381327629089,0.3853404819965363,0.0630520731210709,-0.2478599399328232,0.1548751145601273,0.1398821473121643,-0.0075504593551159,-0.3303685188293457,0.0874341651797295,-0.5678073763847351) * MODEL22_texOff(vec2(1,-1));
res += mat4(0.8626602888107300,0.6299208402633667,0.3481609225273132,-0.3566454052925110,0.2352108210325241,0.0871835052967072,-0.1579112708568573,-0.1360978931188583,-0.0546774789690971,0.0105291418731213,0.1289151459932327,-0.2137751281261444,-0.5862585902214050,-0.1872048676013947,0.1039593741297722,-0.1749892830848694) * MODEL23_texOff(vec2(1,-1));
res += mat4(0.0250483658164740,0.0839775055646896,-0.0152837857604027,0.0708492994308472,0.0369295068085194,0.1913179159164429,0.0859351307153702,0.2727108597755432,0.2288390547037125,0.0523356795310974,0.0111408699303865,-0.8543776273727417,0.1787012219429016,0.0148324538022280,-0.0245518311858177,0.1681433320045471) * MODEL24_texOff(vec2(1,-1));
res += mat4(-0.0239319372922182,-0.4354290962219238,-0.2683517038822174,-0.1997521072626114,0.4122439026832581,0.1550730317831039,-0.3221629261970520,-0.1298160254955292,0.0950022935867310,0.2507815361022949,-0.0881524011492729,-0.0639841631054878,0.2319356501102448,-0.6966038346290588,-0.0397054664790630,0.4412520229816437) * MODEL21_texOff(vec2(1,0));
res += mat4(0.1208788603544235,-0.0198400486260653,0.0076595889404416,0.2348303049802780,-1.1361124515533447,-0.4350675642490387,0.0239142440259457,0.3064677715301514,-0.3484390974044800,-0.5301837325096130,0.1611283421516418,0.2733446359634399,-0.2087745666503906,-0.0077716144733131,-0.3304704725742340,0.0962273627519608) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.0936548337340355,-0.0465661548078060,-0.5533027648925781,0.0699570327997208,-0.4536454379558563,-0.2327289283275604,-0.0652478486299515,0.0300565119832754,-0.2186639010906219,-0.0268815066665411,-0.1598256528377533,0.1521155685186386,0.0351926349103451,0.0382955521345139,-0.0934746935963631,-0.0356465578079224) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.5175559520721436,-0.2126751840114594,-0.8077430129051208,0.1647069752216339,-0.6812220811843872,0.4328734874725342,0.1401884406805038,-0.0622220039367676,0.1508309245109558,0.1850917786359787,-0.3344543278217316,-1.2550662755966187,0.1219360232353210,0.0785530507564545,0.3424720764160156,0.1394288837909698) * MODEL24_texOff(vec2(1,0));
res += mat4(0.1494058966636658,-0.0262660067528486,0.1069759577512741,-0.1044483631849289,0.1752733886241913,-0.1177315935492516,-0.1014335229992867,0.0606800317764282,-0.1761364489793777,-0.2150237411260605,-0.0211684145033360,-0.0490109845995903,0.0894560739398003,0.1764076948165894,0.0660840347409248,-0.2252688407897949) * MODEL21_texOff(vec2(1,1));
res += mat4(0.1909719705581665,0.2775556147098541,0.0468198619782925,0.1209030076861382,0.2390864342451096,0.0357237868010998,0.0170792061835527,0.3361988067626953,0.0989573746919632,-0.0619680508971214,-0.0968791320919991,0.2800474464893341,0.1319000422954559,-0.1231441274285316,0.0501711182296276,0.0618691183626652) * MODEL22_texOff(vec2(1,1));
res += mat4(-0.1873787045478821,-0.2900189459323883,-0.1443230956792831,-0.0696712806820869,0.0206835996359587,0.1998709142208099,-0.2105196118354797,0.1657706499099731,0.0755774602293968,-0.0921563357114792,-0.0388352870941162,0.0177477933466434,-0.0317857898771763,-0.0110247610136867,0.4244059026241302,-0.2647388577461243) * MODEL23_texOff(vec2(1,1));
res += mat4(-0.0794162675738335,-0.0399710051715374,-0.6511958837509155,0.0573051460087299,-0.2584303915500641,-0.1717665195465088,-0.0519161112606525,-0.2069894224405289,0.0579880736768246,-0.0119817890226841,-0.0570329166948795,-0.8578505516052246,0.4742889106273651,0.0761649161577225,-0.0809451341629028,0.2192245572805405) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0941418558359146,0.3569962680339813,0.1796773225069046,0.1741173118352890) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 2_3
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL3
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.0066682859323919,0.1202210560441017,0.3046946525573730,0.2505163252353668);
res += mat4(0.0290132965892553,-0.0188452024012804,-0.1533977836370468,-0.1067951619625092,0.1700883209705353,0.0818259268999100,0.0889855772256851,-0.1758281886577606,-0.0270557105541229,-0.1933409571647644,-0.1522650718688965,-0.0245281904935837,-0.0318037793040276,0.0060473526827991,-0.0713956132531166,-0.0529519394040108) * MODEL21_texOff(vec2(-1,-1));
res += mat4(-0.1215844452381134,-0.1604707986116409,-0.2217374145984650,0.4647205770015717,0.0720433965325356,0.0238498337566853,0.2154294699430466,-0.8106933832168579,-0.0166082810610533,0.0123423933982849,0.2943998873233795,0.2643729746341705,0.2178313732147217,-0.1877526938915253,-0.1607087999582291,0.0817975848913193) * MODEL22_texOff(vec2(-1,-1));
res += mat4(0.0348120294511318,-0.1505140215158463,0.0392659530043602,-0.0591855719685555,-0.0842739567160606,-0.0755315199494362,-0.0566308349370956,0.1370046138763428,-0.0768655911087990,0.0127081945538521,0.0006222645752132,0.0295355357229710,0.0345451831817627,-0.0244563166052103,-0.0628556981682777,-0.2384018152952194) * MODEL23_texOff(vec2(-1,-1));
res += mat4(0.0132616572082043,-0.0431224741041660,0.1906826943159103,0.1017528772354126,0.0688100457191467,-0.0935687795281410,0.3243868649005890,-0.0203835107386112,0.0052955681458116,0.0479177162051201,0.1202547252178192,-0.1763626188039780,-0.0186099298298359,0.0209609139710665,0.3737168312072754,-0.1119295731186867) * MODEL24_texOff(vec2(-1,-1));
res += mat4(0.5388159751892090,-0.2135659754276276,-0.2266898304224014,-0.2475482523441315,0.1198944225907326,-0.4396203756332397,-0.3164595961570740,-0.4326503574848175,0.1382073909044266,0.2324950248003006,0.3956564962863922,0.1629193872213364,0.2198685258626938,0.0606291443109512,-0.2473667860031128,0.1646345555782318) * MODEL21_texOff(vec2(-1,0));
res += mat4(-0.2376261204481125,-0.3529677093029022,-0.9142848849296570,0.1806028783321381,-0.1755564510822296,-0.1039216816425323,0.1525559425354004,-1.3849759101867676,-0.0138412853702903,-0.1475173383951187,-0.0225327052175999,-0.2495775520801544,-0.2196561694145203,-0.1701721996068954,0.5651873350143433,-0.1366901248693466) * MODEL22_texOff(vec2(-1,0));
res += mat4(0.1812306195497513,0.2870511710643768,-0.8379774689674377,-0.3259818851947784,0.0109941521659493,0.0240284819155931,0.0813926085829735,-0.2351125031709671,-0.0976382493972778,-0.2823610603809357,-0.2308166474103928,0.2114551961421967,0.0991419255733490,-0.0750869885087013,-0.1149587109684944,0.1740831583738327) * MODEL23_texOff(vec2(-1,0));
res += mat4(0.1131239160895348,-0.0061346525326371,-1.4211069345474243,-0.4551773071289062,-0.0855798870325089,-0.0124564077705145,-0.2818833887577057,-1.0334341526031494,-0.0967212393879890,0.1651065349578857,0.0023735912982374,0.1059542447328568,-0.0494578145444393,0.2192097008228302,-0.0975484251976013,0.0254097152501345) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.4793096184730530,-0.3400304615497589,0.0551011599600315,-0.3136283159255981,0.0980083495378494,0.0143072502687573,-0.0419476479291916,0.1841769665479660,-0.0337203964591026,0.0428854264318943,-0.1797774732112885,-0.0146793983876705,-0.1857822090387344,-0.0159035604447126,0.1136668846011162,-0.0135319530963898) * MODEL21_texOff(vec2(-1,1));
res += mat4(-0.1619209200143814,-0.3122106194496155,-0.1499443352222443,0.3182814419269562,0.1222203820943832,-0.1094487309455872,-0.1626464426517487,-0.2342467904090881,0.3386610448360443,0.2449438124895096,0.2991871237754822,0.6013329029083252,-0.0282594580203295,0.0483290478587151,-0.3856660127639771,0.0446886047720909) * MODEL22_texOff(vec2(-1,1));
res += mat4(0.0056901825591922,0.0512946397066116,-0.1859404593706131,0.1390966922044754,0.1050675287842751,0.1182925850152969,-0.0403152741491795,0.0605711564421654,0.1724978089332581,-0.0263700466603041,0.0577792413532734,-0.0812572687864304,-0.2954929471015930,0.0696404129266739,-0.1038054004311562,-0.1730726063251495) * MODEL23_texOff(vec2(-1,1));
res += mat4(0.0609802417457104,0.3091067373752594,-1.2640422582626343,-0.0934868305921555,0.0553861148655415,0.1677501052618027,-0.1159948334097862,0.0338112302124500,-0.1220021098852158,-0.0119204642251134,0.4659876823425293,-0.1226724609732628,0.0620302595198154,0.0658627673983574,-0.1589452624320984,-0.1176110357046127) * MODEL24_texOff(vec2(-1,1));
res += mat4(0.1108018830418587,-0.0295175444334745,0.1724258214235306,0.1165243387222290,-0.1271227449178696,-0.0690366327762604,0.0256086662411690,-0.0561957322061062,0.1214720308780670,-0.1521558165550232,-0.3580622076988220,-0.2178569287061691,-0.0343545377254486,-0.0489014983177185,-0.0935015529394150,-0.3787882030010223) * MODEL21_texOff(vec2(0,-1));
res += mat4(-0.2200368344783783,-0.0983062386512756,0.1177969723939896,0.2765811085700989,0.0608604773879051,-0.0291329734027386,0.3812954127788544,-1.2877732515335083,-0.1201128140091896,-0.3451268374919891,0.2535594403743744,0.5281679630279541,-0.4405971169471741,-0.1572794616222382,0.2344320267438889,0.0894578993320465) * MODEL22_texOff(vec2(0,-1));
res += mat4(-0.0361681021749973,0.5539910793304443,0.5104171037673950,0.3096115291118622,-0.0892805382609367,0.0291877482086420,0.0916282385587692,0.2968068122863770,0.0921689122915268,0.2749517261981964,-0.4967111945152283,-0.1605041027069092,0.0680588185787201,-0.1536256372928619,-0.4558827877044678,0.5897802114486694) * MODEL23_texOff(vec2(0,-1));
res += mat4(-0.0047689182683825,-0.2312191873788834,0.0009415594977327,0.2574448585510254,0.1399297416210175,-0.0306464172899723,0.4498404860496521,-0.2827948927879333,-0.0281588006764650,-0.0402123257517815,0.5185984373092651,0.3226799964904785,0.0689876750111580,0.1460169106721878,-0.5434475541114807,-0.5083435177803040) * MODEL24_texOff(vec2(0,-1));
res += mat4(-0.2525883018970490,0.1703216880559921,-0.4818914532661438,0.4096133112907410,-0.2682815790176392,0.3717361688613892,0.3698177039623260,0.2319176048040390,-0.0655022040009499,0.4077894985675812,0.2445998191833496,-0.0773120895028114,0.5059666633605957,0.8733859658241272,-0.4637008309364319,0.2281443625688553) * MODEL21_texOff(vec2(0,0));
res += mat4(0.0117727974429727,-0.3128577470779419,-0.2089310139417648,0.5525887012481689,-0.0280407276004553,-0.2635460495948792,-0.4444211721420288,-2.3140270709991455,0.1044904366135597,-0.4133822619915009,0.5928612947463989,-0.2180936783552170,1.1765084266662598,0.5144562721252441,0.4285456836223602,-0.4101267755031586) * MODEL22_texOff(vec2(0,0));
res += mat4(0.6317111849784851,-0.2674438357353210,-0.4763470888137817,0.2370125800371170,-0.3426514565944672,0.6665347814559937,-0.1387838274240494,0.2744057476520538,-0.4305954575538635,-0.4799051582813263,0.2968683242797852,-0.2656145393848419,-0.0720861256122589,-0.2917108535766602,-0.2012223005294800,0.4298218786716461) * MODEL23_texOff(vec2(0,0));
res += mat4(0.7652570605278015,-0.4442400932312012,-1.9730776548385620,-0.4957124590873718,-0.4321589171886444,-0.1306711137294769,-0.3108777999877930,0.1393012106418610,-0.3097234070301056,-0.1121014952659607,-0.1184069886803627,0.0876741930842400,-0.2437544167041779,-1.0382152795791626,0.3805285692214966,0.3978357017040253) * MODEL24_texOff(vec2(0,0));
res += mat4(-0.2273610830307007,-0.1658958941698074,-0.2111845761537552,-0.1289273947477341,0.2267702966928482,0.0840075314044952,-0.1557343006134033,-0.1759068369865417,0.3195409774780273,-0.2773442268371582,-0.3100412487983704,-0.1754461228847504,-0.3303289711475372,-0.3503413498401642,0.2393816858530045,-0.1590999513864517) * MODEL21_texOff(vec2(0,1));
res += mat4(-0.3217451274394989,-0.1748124808073044,0.3970140218734741,0.2459747195243835,-0.1000586524605751,-0.0321493037045002,-0.3445504605770111,-0.4839210212230682,0.2975541353225708,0.2202562689781189,0.6160834431648254,0.2920646071434021,-0.3151476979255676,-0.1247873678803444,-0.4011890888214111,0.0199267379939556) * MODEL22_texOff(vec2(0,1));
res += mat4(-0.1417886763811111,0.0123265227302909,-0.2584630250930786,-0.0164458341896534,0.3121669590473175,0.0723152831196785,-0.0524155721068382,0.0893669053912163,0.3630716502666473,0.7337093949317932,-0.4140587449073792,0.0647370442748070,-0.5781412720680237,0.7325563430786133,0.7431692481040955,-0.0231557507067919) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.0520879700779915,-0.0348345451056957,-1.5661777257919312,0.3947445154190063,0.1748250424861908,-0.1960754543542862,-0.2971701025962830,-0.0221235621720552,-0.1597236245870590,0.0704871267080307,0.0796882435679436,-0.1891844868659973,0.1158331558108330,0.0322225056588650,0.0540029183030128,-0.1276303082704544) * MODEL24_texOff(vec2(0,1));
res += mat4(0.0334619022905827,0.0928742587566376,-0.1305006146430969,-0.0028848932124674,-0.0838772431015968,-0.0054304334335029,0.1435932815074921,0.1332150846719742,0.0396108888089657,0.0999704077839851,-0.0642382949590683,-0.1394932121038437,-0.0994569361209869,-0.1198409125208855,0.1582884788513184,0.2221760302782059) * MODEL21_texOff(vec2(1,-1));
res += mat4(-0.1408305019140244,-0.0921994820237160,0.2596518695354462,0.1239631921052933,0.0281823500990868,0.1066832020878792,-0.0844504386186600,-0.0636380910873413,0.0503867603838444,0.0480992868542671,0.2414136976003647,0.2044187188148499,-0.1391227096319199,0.0104366149753332,-0.0188095178455114,0.1703838258981705) * MODEL22_texOff(vec2(1,-1));
res += mat4(0.0029042097739875,-0.2371903955936432,0.3780680000782013,-0.5323799848556519,0.0140476590022445,-0.1495406031608582,0.2071592658758163,-0.0084102991968393,-0.2589507997035980,-0.0764100030064583,-0.0055115716531873,-0.0274913627654314,-0.0275828577578068,-0.0740682631731033,-0.2882716059684753,-0.4000352919101715) * MODEL23_texOff(vec2(1,-1));
res += mat4(0.0340863130986691,-0.0282875075936317,0.3615622520446777,-0.0057205650955439,0.1357596814632416,-0.0411523021757603,-0.1364872008562088,-0.0118581736460328,-0.1352293491363525,-0.0483191721141338,0.1568620949983597,0.0946996882557869,-0.0662061497569084,-0.0988727882504463,0.4928822815418243,0.2401342391967773) * MODEL24_texOff(vec2(1,-1));
res += mat4(-0.1097468510270119,0.1942698657512665,0.0040931529365480,-0.0400064811110497,-0.3087880611419678,-0.2598313987255096,-0.0051750377751887,-0.0650142654776573,0.1402599811553955,0.2281410545110703,0.1578211188316345,0.1005987673997879,0.1452177911996841,0.0173886064440012,0.1351331919431686,0.2313813120126724) * MODEL21_texOff(vec2(1,0));
res += mat4(0.1577404886484146,-0.0305066294968128,0.2379322499036789,0.0308942031115294,0.0830573365092278,-0.3151981532573700,-0.3253603279590607,0.2475974857807159,0.0443270653486252,-0.0193476825952530,0.1386305242776871,-0.0373829044401646,-0.2579297125339508,-0.1532946974039078,0.2150248140096664,0.4174665212631226) * MODEL22_texOff(vec2(1,0));
res += mat4(0.1439764350652695,0.3407106995582581,-0.0615493319928646,0.0023591942153871,0.2019049525260925,-0.3147303462028503,0.1363119632005692,-0.2246542721986771,0.1331851333379745,0.0677685439586639,0.1401423066854477,-0.1164609342813492,-0.0428065992891788,-0.1498794257640839,0.3509467840194702,-0.4461643397808075) * MODEL23_texOff(vec2(1,0));
res += mat4(0.1535163968801498,-0.1193488463759422,-0.1260807812213898,0.3858011662960052,-0.0790592283010483,0.6075788736343384,-0.3078390657901764,-0.1092664450407028,-0.3794676065444946,-0.0701059028506279,0.3518251180648804,0.5549364686012268,0.0932475775480270,0.3079295456409454,-0.1271117478609085,0.2804728448390961) * MODEL24_texOff(vec2(1,0));
res += mat4(-0.0260474067181349,-0.0398008786141872,0.1998758912086487,-0.1780950576066971,0.0013479664921761,-0.0123051870614290,-0.0901704356074333,-0.1598365753889084,-0.0321404710412025,0.1329830288887024,0.0247267540544271,0.0441971644759178,-0.0566960573196411,0.0255114361643791,0.0987359061837196,-0.1076177731156349) * MODEL21_texOff(vec2(1,1));
res += mat4(-0.1944607496261597,0.0444287993013859,0.2728273272514343,-0.1345956027507782,-0.2663154602050781,0.0077556986361742,-0.1447391659021378,0.1522699445486069,0.1935738772153854,0.0280280169099569,0.2472678124904633,0.2790086269378662,0.1250506043434143,0.1299894750118256,0.0860879197716713,-0.2023737132549286) * MODEL22_texOff(vec2(1,1));
res += mat4(0.0107089392840862,0.0757343471050262,0.0578177720308304,0.1139081716537476,-0.0010778970317915,0.0142402015626431,-0.0777464210987091,0.0163372829556465,0.0894660502672195,0.0048105982132256,0.0235740207135677,-0.1469545364379883,-0.2090159952640533,0.0983165726065636,0.0136493127793074,-0.2945146560668945) * MODEL23_texOff(vec2(1,1));
res += mat4(-0.1292741000652313,-0.1052215844392776,-0.1081540435552597,0.0396977886557579,-0.3071779310703278,-0.1655648797750473,-0.1314524263143539,0.1864617764949799,-0.1990943998098373,0.0167746078222990,0.1467040926218033,-0.1280262768268585,0.0534911192953587,0.0058396384119987,-0.0083683151751757,0.3378030657768250) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.0175827611237764,0.7972076535224915,0.0112308701500297,0.0626640766859055) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 2_4
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL4
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.2618981599807739,-0.0272141322493553,0.1978147178888321,0.1838742196559906);
res += mat4(0.3203423619270325,-0.2375466823577881,-0.2311870753765106,-0.1404046118259430,-0.1116818562150002,0.0169112384319305,0.0177364815026522,0.1829731315374374,0.2324923574924469,-0.1492699533700943,-0.0345585308969021,-0.0732511207461357,-0.0768176317214966,-0.1181547865271568,-0.0554209016263485,-0.0583907887339592) * MODEL21_texOff(vec2(-1,-1));
res += mat4(0.0807724073529243,-0.2254235148429871,0.6873410344123840,-0.1763365268707275,-0.1449452489614487,0.0189746413379908,0.2269700616598129,0.0883083790540695,0.0470402911305428,0.6898033022880554,0.1623040437698364,0.1642086803913116,-0.4184429645538330,0.0878895595669746,0.0678840875625610,0.2335358411073685) * MODEL22_texOff(vec2(-1,-1));
res += mat4(0.2088841348886490,0.7400224208831787,0.3838779926300049,-0.8565384149551392,-0.0261555053293705,0.2415239810943604,0.0058844261802733,0.0311756990849972,-0.0710533335804939,-0.0517776943743229,-0.2189657688140869,-0.1773550063371658,0.1505380868911743,0.0705150812864304,-0.0917380228638649,0.0854334831237793) * MODEL23_texOff(vec2(-1,-1));
res += mat4(-0.0700366571545601,0.1746245324611664,0.0463343597948551,0.0256793927401304,-0.0146809378638864,-0.1434955447912216,0.2785597741603851,0.2305340021848679,0.1221156194806099,-0.0462324805557728,0.0756224319338799,0.0408317334949970,-0.0351550802588463,-0.1952673196792603,0.1835533678531647,-0.2333324849605560) * MODEL24_texOff(vec2(-1,-1));
res += mat4(-1.2905079126358032,-0.0528796203434467,0.3968045711517334,-0.4772018492221832,-0.0381646603345871,-0.0249421130865812,-0.1307162493467331,0.1164818927645683,0.4554768502712250,-0.1476756036281586,-0.1412851959466934,-0.0609309300780296,-0.0039473162032664,0.4662524461746216,-0.0444753281772137,0.3187219202518463) * MODEL21_texOff(vec2(-1,0));
res += mat4(0.1611919701099396,-1.3754422664642334,0.0417292863130569,-0.3652147352695465,-0.7307597994804382,-0.0057830205187201,0.0941176116466522,-0.0242457669228315,-1.2055057287216187,0.8820493221282959,0.2724837958812714,0.4328245222568512,0.0721918717026711,-0.0722622349858284,0.1880809962749481,-0.1931017041206360) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.0464881993830204,-0.4977321922779083,0.2844241857528687,-0.1416633129119873,0.2688022851943970,-0.2087855488061905,-0.2219491153955460,0.0513183288276196,0.0243211444467306,0.2198460698127747,0.0974607467651367,0.3570106625556946,0.0461267605423927,0.0820912569761276,0.0386747866868973,0.2782809138298035) * MODEL23_texOff(vec2(-1,0));
res += mat4(-0.2263965904712677,0.0119835119694471,0.3215164542198181,0.1319056749343872,-0.9058688282966614,-0.4233278334140778,0.1065735742449760,-0.4460813105106354,-0.0695195719599724,-0.2787844240665436,0.1991541534662247,0.0922988504171371,0.0297270491719246,0.1954278051853180,0.0062130275182426,0.0696197226643562) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.1804848313331604,-0.5613523125648499,-0.4550373852252960,-0.5635682344436646,-0.1632910370826721,0.1187769919633865,-0.3213490247726440,-0.2689736485481262,0.0472449734807014,0.1680916845798492,0.0901900678873062,0.2972181141376495,0.0242962017655373,0.1103710904717445,0.1173390373587608,-0.0270986035466194) * MODEL21_texOff(vec2(-1,1));
res += mat4(0.2393277436494827,-0.5017011761665344,0.2169336676597595,0.2137065231800079,-0.3550960719585419,-0.1301461160182953,0.2405073046684265,-0.0257033314555883,-0.1141087263822556,0.2353459596633911,0.5700230598449707,0.3301207125186920,-0.0793050453066826,0.0170175842940807,-0.3630143404006958,0.3265556097030640) * MODEL22_texOff(vec2(-1,1));
res += mat4(0.1285964548587799,0.1330558210611343,-0.0416678972542286,0.0528282448649406,0.0764098763465881,0.0281098093837500,-0.0382813438773155,0.0310887284576893,0.1230183392763138,-0.2056455612182617,-0.0828496888279915,-0.1691433936357498,0.0903539285063744,-0.1575526893138885,-0.0784928575158119,0.3540493845939636) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.1338908225297928,-0.0003932896070182,0.3739605545997620,-0.0032687252387404,-0.1752334982156754,0.0500757656991482,0.0544755123555660,-0.0904007703065872,0.1839655041694641,-0.1541325151920319,0.2571626305580139,0.2349375635385513,-0.0411910004913807,-0.0948274806141853,-0.0947207584977150,-0.0618695616722107) * MODEL24_texOff(vec2(-1,1));
res += mat4(-0.1735517233610153,-0.1884111762046814,0.2472496628761292,0.1157463118433952,0.2316774278879166,0.0809216573834419,0.2136737406253815,0.4023383557796478,-0.2456857562065125,-0.2026455104351044,-0.0837441384792328,0.0047799651511014,-0.0416668429970741,-0.2348129898309708,0.1912510395050049,0.1240000128746033) * MODEL21_texOff(vec2(0,-1));
res += mat4(0.0986720994114876,0.2302175909280777,-0.5095402002334595,-0.5116504430770874,-0.0159094277769327,-0.2062777131795883,0.2209034711122513,0.1478719562292099,-0.0936135649681091,-0.1403303742408752,-0.5889059305191040,-0.2721848487854004,0.1495044529438019,-0.1733209639787674,-0.1109227463603020,0.1321036368608475) * MODEL22_texOff(vec2(0,-1));
res += mat4(0.1583139151334763,0.4662604928016663,0.0749393254518509,1.1870090961456299,0.0149827850982547,0.0499051921069622,0.1296198964118958,-0.4785905480384827,-0.0083293160423636,0.2108646929264069,0.0510768666863441,0.2132322490215302,-0.2477501034736633,-0.0111771719530225,-0.0363363474607468,0.2452402263879776) * MODEL23_texOff(vec2(0,-1));
res += mat4(0.0317361131310463,0.0770889744162560,0.1376695781946182,0.0397783927619457,0.0544366426765919,-0.3385850191116333,0.1112513169646263,0.3020723164081573,0.0754054486751556,0.2211898416280746,-0.0396015644073486,0.0286546442657709,-0.4639288783073425,0.0985592380166054,-0.1409995257854462,0.3716880381107330) * MODEL24_texOff(vec2(0,-1));
res += mat4(0.5109571218490601,0.9223093390464783,0.1859842389822006,0.2396878600120544,0.2978311181068420,-0.1416329145431519,-0.2947293519973755,-1.4947435855865479,-0.4519229531288147,0.8225970268249512,0.3091182112693787,-0.9985001087188721,0.1723853051662445,0.5456789731979370,-0.2690940797328949,0.8217062354087830) * MODEL21_texOff(vec2(0,0));
res += mat4(0.1589053571224213,-0.4827378392219543,-0.4693800210952759,-0.8193519711494446,-0.6941610574722290,-1.5228459835052490,-0.7820520997047424,-0.6704961061477661,-0.2171749472618103,-0.8324849009513855,-2.2413654327392578,-1.5074603557586670,-0.2572051286697388,0.1064953729510307,-0.0056538027711213,-0.5387867093086243) * MODEL22_texOff(vec2(0,0));
res += mat4(0.0391535386443138,-1.4287612438201904,0.2699595987796783,-0.6650040149688721,-0.0988853499293327,0.4216991662979126,0.0637140348553658,0.2098554670810699,-0.8102505207061768,-0.3652212917804718,0.3275896906852722,-0.3590414524078369,-0.2724997997283936,-0.0883407741785049,-0.2451451420783997,-0.8137302994728088) * MODEL23_texOff(vec2(0,0));
res += mat4(0.1246679127216339,-0.0300861652940512,0.0997866913676262,-0.6487255692481995,0.3512567579746246,0.8345553874969482,0.7273539900779724,0.4227346777915955,0.2933959662914276,-0.1051366180181503,-0.1759402155876160,-0.0114844748750329,0.4016981720924377,0.4352439641952515,-0.0182086061686277,0.3906862735748291) * MODEL24_texOff(vec2(0,0));
res += mat4(-0.0691076219081879,0.7181659340858459,-0.3326966464519501,0.2068112790584564,0.0007111207232811,0.5322738885879517,0.2143927067518234,0.9343239665031433,-0.0955833941698074,-0.0449995249509811,-0.0059315729886293,-0.5656683444976807,0.0783866345882416,-0.0487202554941177,-0.1274579018354416,-0.6693290472030640) * MODEL21_texOff(vec2(0,1));
res += mat4(0.0910984128713608,0.0079865092411637,-0.0134474486112595,0.1073060110211372,-0.1281730532646179,-0.5945880413055420,-0.1750696748495102,-0.0824373885989189,-0.1921980082988739,-0.2417781800031662,-1.2219647169113159,-0.3861470818519592,-0.0197522863745689,-0.0422438420355320,0.1084365025162697,0.4388374388217926) * MODEL22_texOff(vec2(0,1));
res += mat4(-0.0405590273439884,0.3364722132682800,0.0340287163853645,0.5000361800193787,0.0451833792030811,0.7587022185325623,0.3476577103137970,0.1372276842594147,-0.2742692530155182,0.0497781559824944,0.1567011475563049,-0.1736435443162918,0.0604428462684155,0.0313023664057255,0.1569791436195374,0.0404267311096191) * MODEL23_texOff(vec2(0,1));
res += mat4(0.0518231056630611,-1.0536848306655884,-0.2377561777830124,-1.3607717752456665,-0.3254396021366119,0.0689994841814041,-0.0591381192207336,0.3321301639080048,0.1006338670849800,0.0672427713871002,0.2957704961299896,0.3493945896625519,-0.0940009951591492,-0.2684634625911713,0.5259480476379395,0.2820456326007843) * MODEL24_texOff(vec2(0,1));
res += mat4(0.0506687946617603,-0.0672884061932564,-0.0947070345282555,-0.0711966156959534,0.0949534848332405,0.1151713877916336,0.1201184391975403,-0.0314808450639248,-0.0706284120678902,-0.1123861744999886,0.1360195577144623,-0.1103572621941566,0.1085182130336761,0.0715388208627701,-0.2147644609212875,-0.1271135061979294) * MODEL21_texOff(vec2(1,-1));
res += mat4(0.1458884179592133,-0.0483437515795231,0.1487196981906891,-0.1635223925113678,0.0468507856130600,0.2004905343055725,-0.1661941856145859,-0.1715333908796310,0.0405882000923157,0.1016650348901749,-0.3222144246101379,0.0014929913450032,0.1783287972211838,0.1605405360460281,-0.3112948536872864,-0.2211681008338928) * MODEL22_texOff(vec2(1,-1));
res += mat4(-0.3449542224407196,-0.2643767893314362,-1.2442095279693604,-0.0055516464635730,-0.0290109291672707,-0.0531168505549431,-0.0100549366325140,-0.0421273186802864,0.0406958609819412,-0.1173181459307671,-0.0954332947731018,0.0343313068151474,-0.1324431598186493,-0.0029157740063965,0.0493107922375202,0.2932595610618591) * MODEL23_texOff(vec2(1,-1));
res += mat4(0.0597545318305492,0.0579895004630089,0.0330565869808197,0.0266821533441544,0.2274957150220871,-0.1440460830926895,0.0706733837723732,0.1258082687854767,-0.0238740332424641,0.1669197678565979,0.2824452519416809,0.1991728842258453,0.2431868016719818,-0.0821011215448380,-0.0380413234233856,-0.2547401785850525) * MODEL24_texOff(vec2(1,-1));
res += mat4(-0.0514334328472614,-0.1075393334031105,0.6129282116889954,0.3304093182086945,0.0418562963604927,-0.3380452394485474,-0.1095468625426292,-1.1982278823852539,-0.0091031938791275,-0.3492802083492279,-0.0715793222188950,0.0283715836703777,0.1627623736858368,-0.2478841841220856,-0.1275325268507004,0.0753507539629936) * MODEL21_texOff(vec2(1,0));
res += mat4(0.0710584446787834,-0.0795726478099823,0.1102423667907715,0.1615608930587769,0.0400473400950432,-0.1247625201940536,-0.8664048910140991,-1.4803600311279297,0.0598112307488918,0.2241897135972977,-1.6030251979827881,-0.1858558803796768,-0.0049995915032923,-0.2061183005571365,0.0831907689571381,-0.3442726135253906) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.1566273719072342,-0.3271358907222748,-0.4640483856201172,-0.2436946779489517,-0.0301623810082674,-0.4387421607971191,-0.4622590243816376,-0.1521215885877609,0.0995048359036446,0.2005099803209305,0.0182304996997118,0.1740360558032990,-0.2895718812942505,0.3530801534652710,-0.4486841559410095,-0.9784322381019592) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.0021386719308794,0.1484365910291672,-0.2306481152772903,-0.2454898208379745,-0.0255514066666365,0.0938307866454124,-0.0233576018363237,0.2101462483406067,0.1627648919820786,0.1235651299357414,0.0506546199321747,0.0221781507134438,0.4662755429744720,-0.2199778258800507,-0.6283662915229797,0.0379081666469574) * MODEL24_texOff(vec2(1,0));
res += mat4(-0.0182653721421957,0.1785921901464462,0.1522493362426758,0.1736439168453217,-0.0319013446569443,0.1207593083381653,-0.3337399065494537,0.4353213012218475,0.0712353736162186,0.1208399757742882,-0.1030251830816269,0.0402180440723896,-0.1057578176259995,-0.1592700779438019,0.0997642651200294,-0.5390369296073914) * MODEL21_texOff(vec2(1,1));
res += mat4(0.0597565993666649,0.1085522696375847,0.1351424455642700,0.1795979589223862,0.0740121901035309,-0.4540854692459106,-0.4426850378513336,-0.3672344982624054,0.0618441253900528,-0.0444655306637287,-0.5309899449348450,-0.3420858085155487,0.1326380372047424,0.0735115706920624,0.3639954626560211,0.5657085180282593) * MODEL22_texOff(vec2(1,1));
res += mat4(-0.0113841835409403,-0.1627709716558456,0.0593168660998344,-0.1079842969775200,0.0340214520692825,-0.2508184015750885,-0.1898239850997925,0.0072992448695004,-0.1270765513181686,0.0241425670683384,-0.1750517189502716,0.0232428964227438,-0.1698446720838547,0.0585229583084583,0.4057764112949371,-0.0506146699190140) * MODEL23_texOff(vec2(1,1));
res += mat4(-0.0771756023168564,0.0903209969401360,0.0408543720841408,-0.5892044901847839,0.0189124587923288,0.5071246027946472,0.0599331595003605,-0.0512724369764328,0.0913599580526352,0.0496477931737900,0.1396266967058182,0.1325918883085251,0.2898302078247070,-0.1028916388750076,0.0570955872535706,-0.3936383128166199) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0671599730849266,0.2514712214469910,0.0454521626234055,-0.1015913039445877) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 3_1
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!SAVE MODEL21
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0939240753650665,0.1070799157023430,-0.4192370474338531,-0.2009796947240829);
res += mat4(0.1766631752252579,-0.1148459315299988,0.1303748786449432,0.1874862164258957,0.0400640964508057,0.0249448716640472,0.0479296818375587,-0.0451686643064022,0.0400613583624363,0.0721665620803833,0.0162833929061890,0.1299638748168945,-0.1976952701807022,0.1583755314350128,-0.0451218150556087,0.0093258330598474) * MODEL1_texOff(vec2(-1,-1));
res += mat4(-0.0646747574210167,-0.1131666302680969,0.0774783194065094,-0.1875849664211273,0.1489513665437698,0.0614610463380814,0.0551691800355911,-0.2633447945117950,-0.1215979605913162,0.1179030388593674,0.1464152485132217,0.1342537403106689,-0.1263999640941620,0.0371266864240170,-0.0571325086057186,-0.0951198637485504) * MODEL2_texOff(vec2(-1,-1));
res += mat4(0.1455701142549515,0.0904433131217957,0.1709385812282562,0.0677307099103928,-0.0468935593962669,-0.0356049574911594,-0.1504066586494446,-0.0919781476259232,-0.0795241743326187,0.0195050779730082,-0.0061774053610861,-0.0350675992667675,0.1814181804656982,0.0052565839141607,0.1122208908200264,-0.0216086618602276) * MODEL3_texOff(vec2(-1,-1));
res += mat4(0.2275224328041077,-0.1887758970260620,-0.0591825507581234,-0.0255115255713463,0.1821129769086838,-0.0972185358405113,0.1868964433670044,0.0663591623306274,-0.0951612070202827,-0.1931359469890594,-0.1538779437541962,-0.0970020219683647,0.0220909640192986,-0.0459185689687729,-0.2080574631690979,0.0792068094015121) * MODEL4_texOff(vec2(-1,-1));
res += mat4(0.1789263337850571,-0.0923565179109573,0.0234071612358093,0.2566697895526886,-0.3969378173351288,0.1525186449289322,-0.1570488065481186,-0.1292294859886169,-0.0078855939209461,0.0073424843139946,-0.0253147967159748,0.0776322335004807,-0.3640538454055786,0.0294748172163963,-0.1845595240592957,0.0254504717886448) * MODEL1_texOff(vec2(-1,0));
res += mat4(0.2526902258396149,0.0658242180943489,0.2199242413043976,-0.2072209119796753,0.1815013438463211,0.3576187491416931,0.1445612013339996,-0.3206026256084442,0.1072679534554482,-0.1361077874898911,0.0916604697704315,0.3789470791816711,0.0989762768149376,-0.0294604822993279,0.0581037811934948,0.0445599481463432) * MODEL2_texOff(vec2(-1,0));
res += mat4(-0.0093334335833788,0.1357327103614807,0.0280408691614866,0.1034970134496689,-0.2703523635864258,0.1945694833993912,-0.1136413291096687,-0.0291410721838474,-0.0401322692632675,0.0878827199339867,-0.0686209499835968,-0.0557576827704906,0.1943955570459366,0.1612215936183929,0.1887363791465759,0.0070634381845593) * MODEL3_texOff(vec2(-1,0));
res += mat4(0.3716565668582916,-0.3613735139369965,0.0844924449920654,0.0343478210270405,0.2465848028659821,-0.0314175374805927,0.2159696966409683,0.1732785403728485,-0.0862246528267860,-0.0265530031174421,-0.1918380260467529,-0.1378531157970428,-0.1230628266930580,0.2098480761051178,-0.3888647556304932,-0.2004205882549286) * MODEL4_texOff(vec2(-1,0));
res += mat4(-0.2449404895305634,0.0653455182909966,0.0135820396244526,0.1158687770366669,-0.0626734495162964,-0.1324901431798935,0.0122612882405519,0.0722110792994499,-0.0592312589287758,0.0290565639734268,-0.0977197289466858,0.0284935012459755,0.1286304742097855,-0.0964016020298004,0.0769306123256683,-0.0453671775758266) * MODEL1_texOff(vec2(-1,1));
res += mat4(0.0851763933897018,-0.0065216314978898,0.0767411142587662,-0.1651934087276459,-0.0391551367938519,0.0352120287716389,0.0193297695368528,0.0492741614580154,0.4617889821529388,0.1350731998682022,0.1599364131689072,0.3893656432628632,-0.0166238248348236,0.0806706696748734,0.0505172014236450,-0.1259910613298416) * MODEL2_texOff(vec2(-1,1));
res += mat4(0.0700512304902077,-0.0141933942213655,0.2592144608497620,0.0921078026294708,-0.1485483944416046,-0.0075393421575427,-0.1429287344217300,0.0355093553662300,0.0583429560065269,0.1349573731422424,0.0837503075599670,-0.0213678143918514,0.1826371997594833,0.1823416054248810,0.1543735116720200,-0.0142616210505366) * MODEL3_texOff(vec2(-1,1));
res += mat4(0.0473574660718441,-0.0411762557923794,0.0556247085332870,0.0216518286615610,-0.0571878999471664,0.0466939695179462,0.0007601453689858,-0.0309802722185850,0.0881771817803383,-0.1278077661991119,0.0275780353695154,0.0055053601972759,0.0258457921445370,0.0533790476620197,0.0462624691426754,-0.0727247446775436) * MODEL4_texOff(vec2(-1,1));
res += mat4(-0.1539228558540344,0.0128557216376066,-0.2806452810764313,0.2308432459831238,0.0992715358734131,-0.1948739886283875,0.2201962172985077,-0.2213711440563202,-0.1619242280721664,0.0522838011384010,0.1370293647050858,0.0646882131695747,0.1614316850900650,0.0388166792690754,0.2212044149637222,-0.0348678305745125) * MODEL1_texOff(vec2(0,-1));
res += mat4(0.0057150884531438,-0.3920969069004059,-0.1632852852344513,-0.4735216796398163,-0.2241761088371277,0.1111730188131332,-0.1845528185367584,0.2525207400321960,0.2744160592556000,0.0427548661828041,0.0471794493496418,0.1975667774677277,-0.1709664016962051,-0.0968290343880653,-0.0364571139216423,-0.0123703358694911) * MODEL2_texOff(vec2(0,-1));
res += mat4(0.3471515178680420,0.0035508037544787,-0.0242346487939358,-0.2053472548723221,0.0366874001920223,-0.1820769309997559,-0.1406559646129608,-0.4743737578392029,0.2084551602602005,-0.0934072062373161,-0.0095417900010943,-0.0922358036041260,0.1286945492029190,-0.1099522709846497,-0.0111708277836442,0.0115120420232415) * MODEL3_texOff(vec2(0,-1));
res += mat4(-0.2889384031295776,0.0593274906277657,-0.2738704979419708,-0.1730263084173203,-0.3150477707386017,0.0824517607688904,-0.5353992581367493,0.3430648148059845,-0.0943045169115067,0.0704220905900002,-0.3742286264896393,0.1915865242481232,-0.1212448105216026,-0.1403315663337708,-0.2767850458621979,0.0417246297001839) * MODEL4_texOff(vec2(0,-1));
res += mat4(-0.2087233811616898,0.1168561428785324,0.0238043814897537,0.2219242900609970,0.5486283898353577,-1.1923955678939819,0.7928161621093750,-0.3067701756954193,-0.2462628632783890,0.1201698333024979,-0.0080536343157291,-0.1661250889301300,0.4892369508743286,-0.1491003781557083,0.6520683765411377,-0.9978116750717163) * MODEL1_texOff(vec2(0,0));
res += mat4(0.0986968204379082,0.1483289748430252,-0.4946940541267395,0.5676410198211670,-0.1753920614719391,-0.0350872278213501,-0.6812604665756226,-0.1051912903785706,0.2388358712196350,-0.2064633965492249,0.0954692140221596,0.3972575068473816,0.0277511160820723,-0.1490469276905060,-0.1304923892021179,-0.0849914923310280) * MODEL2_texOff(vec2(0,0));
res += mat4(0.3919466137886047,0.2604148387908936,-0.1364194452762604,-0.3725306987762451,0.6220794320106506,0.0711414515972137,0.0487920157611370,0.8275957107543945,0.2210596054792404,0.0889535248279572,-0.1202557981014252,-0.2345736026763916,0.5414448380470276,-0.0852774530649185,-0.0166040845215321,0.4876805841922760) * MODEL3_texOff(vec2(0,0));
res += mat4(-1.1044557094573975,-0.1582177132368088,0.2023978829383850,-0.2040194123983383,-0.5193357467651367,0.5642085671424866,-1.0636546611785889,0.4562705457210541,-0.1209019646048546,0.0562094524502754,-0.3072849214076996,0.3943085670471191,0.1958889365196228,-0.1018345132470131,-0.3185061514377594,-0.1533579230308533) * MODEL4_texOff(vec2(0,0));
res += mat4(0.1175472810864449,-0.0106185721233487,0.0317506045103073,-0.0582309067249298,-0.2228898108005524,-0.0492197163403034,0.1172570735216141,-0.0781362503767014,-0.2347405254840851,0.0250689368695021,-0.0337609052658081,0.0258333384990692,-0.2739647924900055,-0.0703237727284431,-0.0301027502864599,-0.1310820728540421) * MODEL1_texOff(vec2(0,1));
res += mat4(0.0788076817989349,-0.1156876161694527,-0.1305500864982605,-0.4772673845291138,-0.1036096736788750,-0.0186788085848093,-0.0497039295732975,-0.0562514178454876,-0.4980307519435883,0.3032779097557068,-0.2864224612712860,-0.2571246623992920,-0.2961620986461639,0.2024095952510834,-0.2083405703306198,-0.0262568816542625) * MODEL2_texOff(vec2(0,1));
res += mat4(0.3185229003429413,-0.1336676329374313,0.0055090165697038,-0.0625768750905991,0.0301016960293055,-0.1402244716882706,0.2638555169105530,0.2491406500339508,0.0175193380564451,0.3635352849960327,0.2369791567325592,-0.0125836068764329,0.3937492072582245,0.1693996936082840,-0.0088062463328242,0.2431912273168564) * MODEL3_texOff(vec2(0,1));
res += mat4(-0.2064793109893799,-0.1411489397287369,-0.3089267611503601,-0.1338297426700592,0.1840019971132278,-0.1287958025932312,0.1202731803059578,-0.2698229253292084,-0.1723199039697647,0.1201079860329628,-0.0454297512769699,0.0911703184247017,0.1651924252510071,-0.0695007964968681,-0.0951692461967468,0.0140034575015306) * MODEL4_texOff(vec2(0,1));
res += mat4(-0.0351636521518230,-0.3665920197963715,-0.1235053911805153,0.1023030504584312,-0.0568292252719402,-0.1067840829491615,-0.1690988391637802,-0.1293577402830124,0.1123710498213768,0.0593810230493546,0.0756259411573410,-0.0498257279396057,0.2800794541835785,-0.1813902258872986,0.3736729621887207,0.0055663096718490) * MODEL1_texOff(vec2(1,-1));
res += mat4(-0.0052344598807395,-0.0827632471919060,-0.1968964040279388,-0.1781204640865326,0.1491862088441849,0.0471050664782524,0.2822955846786499,0.0341789536178112,0.0792400613427162,0.0593985691666603,0.0653597190976143,0.0306967999786139,-0.2650067508220673,-0.1417366117238998,-0.0618015266954899,-0.1712649762630463) * MODEL2_texOff(vec2(1,-1));
res += mat4(-0.1884882450103760,-0.0646363869309425,0.1265687942504883,-0.0198807623237371,0.1710745990276337,-0.1991294920444489,0.2257161587476730,0.0990899652242661,-0.0123038114979863,-0.0604469887912273,0.0861879140138626,0.0514908321201801,0.0632287636399269,-0.0564893335103989,-0.2878070771694183,0.1281028836965561) * MODEL3_texOff(vec2(1,-1));
res += mat4(0.1748222410678864,0.1559326499700546,0.2274629622697830,-0.2599287927150726,-0.1274228245019913,0.1170183941721916,0.0254840347915888,0.3059220910072327,-0.4317791461944580,-0.2744959294795990,-0.3259294927120209,-0.0761090889573097,-0.1382412314414978,-0.2113056033849716,0.1788181811571121,0.2996733188629150) * MODEL4_texOff(vec2(1,-1));
res += mat4(0.0582458488643169,-0.2011986672878265,-0.1032724976539612,0.0572311282157898,-0.2976129949092865,0.1335859149694443,-0.1642884314060211,0.0469525307416916,0.1173821613192558,0.0175531003624201,0.0590624660253525,-0.0186468325555325,-0.2939463555812836,-0.0627523511648178,-0.0904852002859116,0.0437535047531128) * MODEL1_texOff(vec2(1,0));
res += mat4(-1.0379866361618042,-0.0779533982276917,-0.4585119783878326,-0.2419675886631012,-0.1771658360958099,0.2385675758123398,0.4636667668819427,0.2159792035818100,-0.0779691860079765,-0.0443072207272053,0.1458922326564789,0.1625780165195465,-0.0606213472783566,0.2021027803421021,-0.0766457915306091,-0.0725013092160225) * MODEL2_texOff(vec2(1,0));
res += mat4(-0.1223943233489990,0.0499060340225697,0.2337128371000290,0.0877007842063904,-0.4041709005832672,0.0202713161706924,0.4482367634773254,-0.0970616489648819,-0.2139305770397186,-0.0016079441411421,-0.0643812268972397,-0.1715632826089859,-0.1512379497289658,-0.0972021818161011,-0.4451365768909454,0.1773481220006943) * MODEL3_texOff(vec2(1,0));
res += mat4(0.1889666616916656,0.1565265655517578,-0.0462163686752319,-0.2980217635631561,-0.2271247357130051,0.2018182426691055,0.0352049097418785,-0.0071235750801861,-0.7249425053596497,-0.1264755576848984,-0.8086061477661133,0.0717744827270508,-0.2927641272544861,0.1403367966413498,0.3376818597316742,0.1329329758882523) * MODEL4_texOff(vec2(1,0));
res += mat4(0.0950300097465515,0.0221716705709696,0.0456663332879543,-0.1242675408720970,0.2974790930747986,0.1077141836285591,0.0673227831721306,0.0374278537929058,-0.0262136477977037,-0.0091568045318127,-0.0168234482407570,0.1881603151559830,-0.0118044698610902,0.0741767808794975,-0.0131553094834089,0.0480604358017445) * MODEL1_texOff(vec2(1,1));
res += mat4(-0.1107144579291344,0.0098598729819059,-0.0693243071436882,-0.1960892528295517,-0.0331989787518978,0.1361626088619232,-0.0834455564618111,0.0961192920804024,-0.0686278939247131,0.0854749158024788,0.1144494563341141,-0.0621937587857246,-0.2368322759866714,0.0297667793929577,-0.1093277558684349,-0.0013569450238720) * MODEL2_texOff(vec2(1,1));
res += mat4(-0.2876231670379639,-0.0896124094724655,-0.2461586445569992,0.0163489244878292,0.0424887128174305,0.0044482382945716,0.1063006594777107,0.0976624488830566,0.2709029614925385,0.1093918979167938,-0.2742790877819061,0.2572947144508362,-0.0381617844104767,-0.0245694518089294,-0.0991176888346672,0.1488055735826492) * MODEL3_texOff(vec2(1,1));
res += mat4(0.0107373334467411,0.1041472703218460,0.0299074444919825,-0.1995789408683777,-0.0317324884235859,0.0384061299264431,-0.0420682542026043,-0.0465260408818722,-0.1401028484106064,0.1354913264513016,0.0475854165852070,-0.1428409367799759,-0.3365491628646851,-0.1023249477148056,0.1386373341083527,0.2461400628089905) * MODEL4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.0454893484711647,0.6504164338111877,-0.0375871248543262,-0.3642866313457489) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 3_2
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!SAVE MODEL22
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.2766854465007782,-0.0856682732701302,0.4891575574874878,0.0358843207359314);
res += mat4(-0.3082252144813538,0.1421664655208588,-0.0411954857409000,0.1205241158604622,0.2738791704177856,-0.0431190282106400,0.1191648468375206,0.0376528576016426,-0.3940974771976471,-0.0540972277522087,-0.9005880355834961,0.1463838368654251,0.0659264847636223,0.1836163252592087,0.0197399482131004,0.0815236419439316) * MODEL1_texOff(vec2(-1,-1));
res += mat4(-0.0152115318924189,0.1181607842445374,-0.1681683808565140,-0.0840278565883636,-0.2195560038089752,0.2071736305952072,-0.0520277246832848,-0.2059306502342224,0.0841627866029739,0.1697496175765991,0.0743092000484467,-0.1171413883566856,-0.5985020399093628,0.3979639410972595,-0.3463142216205597,0.0510277226567268) * MODEL2_texOff(vec2(-1,-1));
res += mat4(-0.0469058454036713,-0.1439702361822128,0.0587836243212223,0.0072227055206895,-0.0203045327216387,-0.1439272016286850,-0.0913980677723885,0.2590387761592865,0.0427818670868874,0.1357506066560745,0.0856071859598160,0.2076624184846878,-0.2039159387350082,0.2199477702379227,-0.0665217041969299,0.1113462895154953) * MODEL3_texOff(vec2(-1,-1));
res += mat4(0.6119036078453064,-0.2367514520883560,-0.0474185831844807,-0.0738599747419357,0.2150397002696991,-0.1425740569829941,-0.2506031095981598,-0.0127827581018209,0.0595776550471783,0.1329316347837448,0.0184186585247517,-0.1671197712421417,-0.4632082581520081,-0.0973000228404999,0.0642428249120712,-0.1473356187343597) * MODEL4_texOff(vec2(-1,-1));
res += mat4(-0.1912296116352081,-0.0609239228069782,-0.1602058261632919,-0.0227724649012089,-0.4201372563838959,0.4554587304592133,-0.0227187257260084,-0.0378096066415310,0.1912428140640259,0.0682459622621536,-1.0177114009857178,0.3858880996704102,-0.0226255208253860,0.2118644565343857,0.1322475522756577,-0.2449918538331985) * MODEL1_texOff(vec2(-1,0));
res += mat4(-0.2439029216766357,-0.0880997478961945,-0.1612567901611328,-0.4472371041774750,-0.1740748286247253,-0.0585206896066666,-0.0657029673457146,-0.0897132232785225,0.0199276376515627,0.1176935732364655,-0.1753555536270142,-0.0216708388179541,-0.5421268939971924,0.2451691776514053,0.2713908851146698,-0.1808403730392456) * MODEL2_texOff(vec2(-1,0));
res += mat4(0.0636586472392082,-0.0982676669955254,-0.2402346730232239,-0.0729618296027184,-0.0778831765055656,0.0221842341125011,0.0728839635848999,0.0256734061986208,-0.0296111032366753,0.0160355139523745,0.1967004984617233,-0.0364510081708431,-0.1154832020401955,0.0664381235837936,-0.1580185890197754,-0.1150302141904831) * MODEL3_texOff(vec2(-1,0));
res += mat4(-0.1614706814289093,-0.3007177114486694,-0.0077538061887026,0.1562442332506180,-0.0116249406710267,-0.0763486921787262,-0.0728502124547958,0.1449433118104935,0.1028612777590752,-0.0802665725350380,0.0317276343703270,0.3957915306091309,-0.0113516477867961,-0.2576089501380920,-0.0250909272581339,-0.3440415263175964) * MODEL4_texOff(vec2(-1,0));
res += mat4(-0.0721431076526642,0.0617929846048355,0.0236721988767385,-0.1713178306818008,0.0801177248358727,-0.0077098137699068,-0.1302033662796021,0.1205692663788795,-0.1801013350486755,0.3740012347698212,-0.4390102922916412,0.2259115278720856,-0.0943693146109581,0.0032138365786523,-0.1379340589046478,-0.0831489339470863) * MODEL1_texOff(vec2(-1,1));
res += mat4(-0.0361295416951180,-0.0423301756381989,0.0237964522093534,-0.0884843170642853,-0.0765647217631340,0.0764393284916878,-0.2291554659605026,0.0330178700387478,0.1890143007040024,-0.3994705080986023,0.1141545847058296,-0.3930031657218933,-0.1419301927089691,-0.0915622636675835,-0.5227252840995789,0.0471889413893223) * MODEL2_texOff(vec2(-1,1));
res += mat4(0.0244284309446812,-0.0262696258723736,0.1562546193599701,-0.0066187661141157,-0.1507112234830856,0.1415329426527023,-0.0896876007318497,0.0598894916474819,0.0509236603975296,0.0035465008113533,-0.0006597613682970,0.1432638168334961,0.0633045285940170,0.0205333437770605,-0.1529020816087723,0.0278088022023439) * MODEL3_texOff(vec2(-1,1));
res += mat4(-0.0013071940047666,-0.1215862557291985,0.1564798504114151,0.0205783136188984,-0.1420968621969223,0.1075428128242493,0.0872842520475388,0.0079967444762588,-0.0594218485057354,-0.1015119478106499,-0.1151336580514908,0.0227370969951153,0.1221681982278824,0.1577650308609009,-0.0548945218324661,-0.1438567042350769) * MODEL4_texOff(vec2(-1,1));
res += mat4(-0.6033390164375305,-0.2823020517826080,0.0765986815094948,-0.0168070066720247,0.1330042928457260,0.3693281412124634,0.0154768042266369,-0.1817414015531540,-0.1879704594612122,0.1986478865146637,-1.2290372848510742,0.2091535180807114,-0.2778144180774689,-0.2049327790737152,-0.0833392888307571,0.1576944887638092) * MODEL1_texOff(vec2(0,-1));
res += mat4(-0.2492198497056961,-0.0573792122304440,0.0536363571882248,-0.0028804065659642,-0.6152865886688232,-0.2403887361288071,-0.3645218312740326,0.0169817730784416,-0.4057780504226685,-0.0315363407135010,0.3864345550537109,0.0341531969606876,0.3265593349933624,-0.4443338215351105,-0.5211750864982605,0.2147141098976135) * MODEL2_texOff(vec2(0,-1));
res += mat4(0.0928920134902000,0.1127678453922272,-0.2038836181163788,-0.0687354058027267,-0.4012863636016846,0.0305966697633266,-0.2824791967868805,0.3182746767997742,-0.2477563768625259,-0.1787149608135223,-0.1280913800001144,-0.2693536281585693,-0.2007386982440948,0.2500161826610565,-0.1692083477973938,0.2201835960149765) * MODEL3_texOff(vec2(0,-1));
res += mat4(0.4433092176914215,-0.2782422900199890,0.1955523788928986,0.0446265041828156,0.2695930600166321,0.4516450762748718,-0.0869306996464729,0.2080718427896500,-0.3609630167484283,-0.2756880223751068,-0.0572468861937523,0.0923518687486649,-0.2521983087062836,-0.0607448406517506,-0.1430182605981827,-0.0809801742434502) * MODEL4_texOff(vec2(0,-1));
res += mat4(-0.5648784637451172,-0.0078862020745873,-0.0799404531717300,-0.3679954111576080,0.3843144178390503,-0.7055245637893677,-0.8288373947143555,0.1270771771669388,-0.0056138485670090,0.4444505274295807,-1.0627838373184204,0.0743907466530800,0.5623774528503418,0.1460260748863220,0.2430976182222366,-0.4247787296772003) * MODEL1_texOff(vec2(0,0));
res += mat4(-0.1028358787298203,-0.7443224191665649,-0.2842544615268707,-0.7112095952033997,0.5257666110992432,-0.4121195673942566,-0.2406257987022400,0.3721483945846558,-0.0295912455767393,-0.0090005975216627,0.3495620191097260,-0.3244813084602356,0.1984122097492218,-0.1381660550832748,0.1999670416116714,-0.1392254829406738) * MODEL2_texOff(vec2(0,0));
res += mat4(-0.2189147621393204,-0.3101506233215332,-0.3582707047462463,0.6731706261634827,-0.0630217045545578,-0.7331262230873108,0.0304036866873503,-0.2192881107330322,-0.3842722773551941,-0.1572354137897491,-0.1318689137697220,-0.1704041659832001,-0.4817813038825989,-0.1687027812004089,-0.3037893474102020,-0.3955264985561371) * MODEL3_texOff(vec2(0,0));
res += mat4(-0.0350833274424076,0.1781712621450424,0.4963554143905640,-0.5230069756507874,-0.0323612317442894,-0.2684666216373444,-0.0216306671500206,-0.5467779636383057,0.1643877923488617,-0.3850797414779663,-0.0079383878037333,-0.4840333759784698,-0.4436331093311310,-0.0161991715431213,-0.2919921576976776,-0.6045735478401184) * MODEL4_texOff(vec2(0,0));
res += mat4(0.0631479918956757,-0.0759769305586815,0.1899980753660202,-0.7697417736053467,0.0048485705628991,0.2741712033748627,-0.0055032907985151,0.2066910862922668,-0.1501127332448959,0.3565596938133240,-0.8306923508644104,0.1663600057363510,0.0771821588277817,0.0152697730809450,0.0880215913057327,0.0921067818999290) * MODEL1_texOff(vec2(0,1));
res += mat4(-0.1451108753681183,-0.4456967115402222,0.0038733964320272,0.1149310395121574,0.1009142324328423,0.2150571495294571,0.0943882092833519,-0.0743561014533043,0.1195020973682404,0.5845862030982971,0.0343878380954266,-0.3899781107902527,-0.4041344523429871,0.3338281214237213,-0.0199393369257450,0.0934275463223457) * MODEL2_texOff(vec2(0,1));
res += mat4(0.2694981694221497,0.1683813631534576,-0.0827538445591927,-0.9855439066886902,0.1228355169296265,0.1367452442646027,-0.1180073469877243,-0.3259690999984741,-0.3450045883655548,-0.1005374863743782,-0.1464527249336243,-0.1674241274595261,0.1783515959978104,-0.4858917295932770,-0.2419071942567825,-0.1595151573419571) * MODEL3_texOff(vec2(0,1));
res += mat4(0.1846605837345123,0.2596315443515778,0.2425408214330673,0.3251174986362457,0.0843155756592751,0.2367650866508484,-0.2045378684997559,0.0772629603743553,-0.2504093647003174,-0.0491534061729908,0.0135239763185382,0.3528170585632324,0.1446651220321655,-0.0448730662465096,-0.0475514978170395,-0.2215046882629395) * MODEL4_texOff(vec2(0,1));
res += mat4(0.3496626913547516,-0.0416278280317783,0.1267942488193512,0.1846652030944824,0.0825802311301231,-0.0858073681592941,-0.1442968696355820,0.0075921313837171,-0.2857237756252289,0.2616439759731293,-0.5992080569267273,0.1289489418268204,0.1400072127580643,0.1107556670904160,0.2755304872989655,0.1546024233102798) * MODEL1_texOff(vec2(1,-1));
res += mat4(0.0377431400120258,0.0305332988500595,0.0120427943766117,0.0411608815193176,0.2350389063358307,0.1466522365808487,0.0528812482953072,0.1578131765127182,0.1993547379970551,0.0172306522727013,-0.1550423502922058,0.1076474338769913,-0.2865282297134399,0.3427429795265198,0.0945115536451340,0.2316128164529800) * MODEL2_texOff(vec2(1,-1));
res += mat4(-0.0609900802373886,-0.0944926515221596,-0.2119262367486954,-0.0069179581478238,0.0360044389963150,0.1666931211948395,0.2129596620798111,0.2629804313182831,-0.1959801316261292,0.0509368106722832,-0.0875207930803299,-0.1775096058845520,0.3542068898677826,0.1606763750314713,0.0899846851825714,0.0402658544480801) * MODEL3_texOff(vec2(1,-1));
res += mat4(0.1717642992734909,-0.2124918401241302,0.0481774210929871,-0.0357615984976292,0.0568622574210167,0.0519891344010830,-0.2438391298055649,-0.0353425256907940,0.0392028875648975,-0.0987027660012245,-0.0311603695154190,-0.0224185455590487,0.4272132813930511,0.1244610548019409,0.0514792986214161,0.0763168707489967) * MODEL4_texOff(vec2(1,-1));
res += mat4(-0.0818905532360077,-0.2310486733913422,0.0471217706799507,-0.0838337242603302,0.0181213170289993,0.0821879133582115,-0.0322279706597328,0.0799539163708687,-0.1965402066707611,0.2742959260940552,-0.7167144417762756,0.0575326457619667,0.0642850175499916,-0.1227741986513138,-0.0497060939669609,-0.2855891585350037) * MODEL1_texOff(vec2(1,0));
res += mat4(0.2123161703348160,-0.2346035838127136,0.1092509478330612,0.1562874168157578,0.1066971719264984,0.2767858505249023,-0.3046181797981262,-0.0273845475167036,-0.3696175813674927,-0.0598086304962635,-0.1019269675016403,-0.0927008464932442,-0.1281058192253113,0.3493737280368805,-0.3503416180610657,-0.3022629022598267) * MODEL2_texOff(vec2(1,0));
res += mat4(-0.0880725234746933,0.2408671975135803,-0.1795619726181030,0.1810989826917648,0.1211275905370712,0.4736292362213135,0.0064709093421698,-0.3257658183574677,-0.3594385087490082,0.0024678865447640,0.0314037911593914,-0.0911884680390358,-0.0311477817595005,-0.1242813691496849,-0.1627479493618011,0.3381403386592865) * MODEL3_texOff(vec2(1,0));
res += mat4(-0.0876098796725273,0.2889081239700317,0.2039415985345840,-0.0505445413291454,-0.1711472421884537,0.3027215301990509,0.1295015215873718,0.2873072326183319,0.1006578281521797,-0.3762693107128143,0.0244721211493015,-0.2519020438194275,-0.1871100217103958,0.1793846189975739,-0.2067656368017197,-0.3798410892486572) * MODEL4_texOff(vec2(1,0));
res += mat4(0.0071486891247332,0.0327866934239864,-0.0724201947450638,-0.3820834457874298,0.0678572282195091,0.0313744433224201,-0.0951966121792793,-0.0104408366605639,-0.2017306685447693,0.2389510869979858,-0.8141521811485291,0.0672826170921326,0.1411330401897430,-0.1417368054389954,0.1756392568349838,0.1432631909847260) * MODEL1_texOff(vec2(1,1));
res += mat4(-0.0169192869216204,0.0134304529055953,-0.0439525134861469,0.0853186175227165,-0.0271293148398399,0.0552158914506435,-0.4424555599689484,-0.0221184864640236,0.1248477473855019,-0.1369054317474365,0.2032888382673264,0.4237955808639526,-0.1370280236005783,0.0774284079670906,-0.3221918344497681,0.0986522659659386) * MODEL2_texOff(vec2(1,1));
res += mat4(-0.0016994937323034,-0.3168563842773438,-0.2978757619857788,-0.1239660754799843,0.1501535922288895,0.0411236807703972,-0.3058364391326904,0.0213185362517834,-0.1830658763647079,-0.3084793984889984,-0.0796889662742615,-0.1118396595120430,0.0839603170752525,-0.0018456405960023,-0.2057147920131683,0.0484040603041649) * MODEL3_texOff(vec2(1,1));
res += mat4(0.3530099093914032,-0.2546278834342957,0.4894405007362366,-0.0462108962237835,0.0373030193150043,-0.0540172420442104,-0.1831854879856110,-0.0725690498948097,-0.1877104043960571,0.3815770149230957,0.0154178757220507,0.0679738372564316,0.2268005311489105,-0.0374227240681648,-0.1764841973781586,0.3064631521701813) * MODEL4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.1011536195874214,-0.0269211996346712,-0.0399007871747017,0.1815684139728546) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 3_3
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!SAVE MODEL23
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0096962312236428,-0.1828956305980682,-0.3072965741157532,0.3628412187099457);
res += mat4(0.0966185852885246,-0.6135466098785400,0.1222296357154846,-0.1271366775035858,-0.0659370869398117,0.1779254078865051,-0.0182557422667742,0.0037988279946148,-0.0624240785837173,-0.0021543647162616,-0.0371171571314335,0.0114635583013296,-0.0971337482333183,-0.3905356526374817,0.0018126725917682,-0.0468830652534962) * MODEL1_texOff(vec2(-1,-1));
res += mat4(0.0238531120121479,-0.6746900081634521,0.1587852537631989,-0.0541999749839306,0.1455587893724442,0.1401162594556808,0.0800143107771873,0.0067800586111844,-0.1083246991038322,0.4153499007225037,-0.0090921055525541,0.1080789342522621,0.0504096634685993,-0.5217405557632446,-0.0277403518557549,0.0075404588133097) * MODEL2_texOff(vec2(-1,-1));
res += mat4(-0.1730122119188309,-0.2118499428033829,0.0321336425840855,0.0257543101906776,0.0492732115089893,-0.0492192357778549,-0.0415452122688293,0.2035491466522217,0.1021632179617882,0.2431710809469223,-0.0390984788537025,0.2217389643192291,0.1717329174280167,-0.2138804644346237,0.0192105397582054,0.1068543791770935) * MODEL3_texOff(vec2(-1,-1));
res += mat4(-0.0713640674948692,-0.7597609758377075,0.0916400700807571,-0.1611132174730301,0.1112890094518661,0.0431755259633064,-0.0392427630722523,0.0301910303533077,-0.0716047734022141,-0.4293081164360046,-0.0941429734230042,-0.0926984921097755,0.3202439546585083,-0.6363947391510010,0.1387458592653275,0.0786793977022171) * MODEL4_texOff(vec2(-1,-1));
res += mat4(0.0061861029826105,-0.2433091551065445,0.2566366493701935,0.0533551722764969,-0.0290800239890814,0.3748449683189392,-0.0315197892487049,-0.5474284887313843,-0.0388411879539490,-0.0617205537855625,0.0158661734312773,0.1277355402708054,-0.1119790449738503,-0.3430351316928864,0.0742595493793488,-0.2360652983188629) * MODEL1_texOff(vec2(-1,0));
res += mat4(0.1328734904527664,-0.4145849347114563,-0.5556353330612183,-0.1917155981063843,-0.0579247437417507,0.0271499268710613,-0.2180203199386597,-0.2175027877092361,-0.0770114809274673,-0.0746197402477264,-0.1473943889141083,0.0477991849184036,-0.0148708047345281,-0.0942263156175613,-0.1056677773594856,-0.3181895613670349) * MODEL2_texOff(vec2(-1,0));
res += mat4(-0.0933884605765343,0.4464295804500580,0.1864062547683716,-0.2428316175937653,0.0091863730922341,0.0066727939993143,0.2278614938259125,0.0407700166106224,-0.0217400901019573,-0.0089303944259882,0.0608105957508087,0.0034453994594514,-0.0575114041566849,-0.3221804797649384,0.1051684170961380,0.0491008646786213) * MODEL3_texOff(vec2(-1,0));
res += mat4(0.0175898224115372,-0.0022226218134165,-0.2113958448171616,0.3449440598487854,-0.1412918716669083,-0.1120014712214470,-0.3145899474620819,0.3299396932125092,0.0570392832159996,0.3087191581726074,-0.0436424948275089,-0.1651565432548523,-0.2497800141572952,-0.4630553722381592,0.1206926479935646,-0.0631397441029549) * MODEL4_texOff(vec2(-1,0));
res += mat4(0.0863930583000183,0.4767310321331024,-0.0583035126328468,0.0486125871539116,0.0731265991926193,-0.0980255678296089,0.1599799990653992,-0.1969169527292252,0.0129284346476197,-0.1523057520389557,0.1927413493394852,0.0369221642613411,0.0267726648598909,0.0085872625932097,-0.2059309929609299,-0.0781255662441254) * MODEL1_texOff(vec2(-1,1));
res += mat4(-0.0053160390816629,-0.0114771798253059,-0.0920668691396713,-0.1277164816856384,0.1347965002059937,-0.1123904660344124,0.2623544931411743,0.1807247251272202,-0.1826624423265457,0.0890938192605972,-0.2081806659698486,-0.0265102572739124,-0.2511420249938965,-0.3642075955867767,-0.1960840672254562,0.2282556742429733) * MODEL2_texOff(vec2(-1,1));
res += mat4(0.1304119229316711,-0.1310023069381714,-0.1879419535398483,-0.1534926742315292,0.0867782682180405,-0.1649359315633774,0.1634290069341660,0.0068767536431551,-0.0467854514718056,0.1089409291744232,0.0465519055724144,0.2068714201450348,-0.0290457345545292,0.2391352653503418,-0.0619399435818195,0.1424463242292404) * MODEL3_texOff(vec2(-1,1));
res += mat4(-0.0018676006002352,0.1332158446311951,0.3071989119052887,0.0174633916467428,-0.0699404776096344,0.1084066629409790,0.1364846229553223,0.1159763559699059,-0.0480275079607964,-0.4437184333801270,0.1823548525571823,-0.1592775881290436,0.0239598173648119,0.0776209533214569,-0.3734119832515717,0.0483766272664070) * MODEL4_texOff(vec2(-1,1));
res += mat4(0.3958072364330292,0.4064818620681763,0.1182176992297173,-0.0630514547228813,-0.2958301305770874,0.2158587723970413,0.1844703406095505,0.0829237923026085,0.0300246998667717,-0.0076577407307923,-0.1118960455060005,0.0657947883009911,0.1468003392219543,0.1012594997882843,-0.1200218871235847,0.0575959905982018) * MODEL1_texOff(vec2(0,-1));
res += mat4(-0.0439574532210827,-0.0342512875795364,0.1198491603136063,0.0569071359932423,-0.2773189544677734,0.0276473425328732,0.0503465831279755,-0.0294683892279863,-0.1125778257846832,-0.1835590004920959,-0.2119190990924835,0.0135993221774697,0.3683224320411682,-0.6543045043945312,0.0588777251541615,-0.0644268468022346) * MODEL2_texOff(vec2(0,-1));
res += mat4(-0.6709493994712830,-0.0510004945099354,-0.0327867940068245,-0.0542119666934013,0.5428741574287415,-0.2171358913183212,-0.1788071691989899,-0.0115239555016160,0.0560156069695950,-0.0389721207320690,-0.2194385826587677,-0.0730813071131706,0.2017922103404999,-0.3187334835529327,0.1126372441649437,0.0659322142601013) * MODEL3_texOff(vec2(0,-1));
res += mat4(-0.0853002369403839,-0.5523035526275635,-0.0062804054468870,-0.1822048574686050,-0.1589933186769485,0.2936513423919678,0.3282754123210907,-0.0821304619312286,0.3000006377696991,0.0232181232422590,0.0296038947999477,-0.2985506653785706,0.1611278057098389,-0.3611412644386292,0.2865517735481262,-0.1553557664155960) * MODEL4_texOff(vec2(0,-1));
res += mat4(-0.1738335639238358,0.3487513065338135,-0.1364589333534241,-0.3615652024745941,0.4185519814491272,0.5301572680473328,-0.9419437646865845,-0.8370573520660400,0.0375004485249519,-0.0669632777571678,0.1191441267728806,0.1945374906063080,-0.2194370031356812,0.6181265115737915,0.3488807082176208,0.2756504416465759) * MODEL1_texOff(vec2(0,0));
res += mat4(0.3569741845130920,-0.2014349699020386,-0.7833114266395569,-0.2818526327610016,0.1310144215822220,-0.1745538711547852,-0.3036801218986511,0.7271450757980347,0.0465441606938839,-0.4831406474113464,-0.3451803624629974,-0.1129988580942154,-0.0218575540930033,0.2799502015113831,0.3072584867477417,0.2912150621414185) * MODEL2_texOff(vec2(0,0));
res += mat4(0.2870803773403168,0.1482480764389038,0.1605004072189331,-0.1584322750568390,-0.3893961906433105,-0.7580126523971558,0.5952653884887695,-0.0874569267034531,-0.0303031001240015,-0.0761542543768883,-0.2135511636734009,0.1952854841947556,0.0925365984439850,-0.4599846601486206,0.2825924754142761,-0.7044473290443420) * MODEL3_texOff(vec2(0,0));
res += mat4(-0.0922626033425331,-0.0603037066757679,-0.4493271410465240,-0.5298621058464050,-0.2890153825283051,0.0927275121212006,-1.0531142950057983,-0.6113587617874146,-0.1618873625993729,0.0476957969367504,-0.0018244569655508,-0.5462905168533325,0.1010603010654449,-0.2124905884265900,-0.2762548327445984,-0.2766358852386475) * MODEL4_texOff(vec2(0,0));
res += mat4(0.1988933831453323,0.0994351357221603,-0.4228837788105011,0.0489445999264717,-0.1829699128866196,0.2394288927316666,0.5436335206031799,-0.1593505591154099,-0.0227949935942888,-0.2940272092819214,0.0947608277201653,-0.0181172564625740,0.1085731834173203,-0.1314677298069000,0.3206368088722229,-0.2062132954597473) * MODEL1_texOff(vec2(0,1));
res += mat4(-0.2541041076183319,0.2557089924812317,-0.4808665215969086,-0.2363691478967667,0.1692509800195694,-0.0390186458826065,0.0974366217851639,0.2243825048208237,-0.4363555014133453,-0.3497348129749298,-0.6913013458251953,0.0185462776571512,-0.3049576282501221,-0.3033468425273895,-0.4316872358322144,-0.1699993610382080) * MODEL2_texOff(vec2(0,1));
res += mat4(0.3071744740009308,0.3621467053890228,-0.1005984172224998,0.0747817009687424,-0.0433912649750710,-0.3260292410850525,0.0102246813476086,0.0993230938911438,-0.4786410927772522,0.1699418127536774,-0.3136234283447266,-0.3366701900959015,-0.2117681652307510,-0.2202868908643723,-0.3204817771911621,-0.2898558378219604) * MODEL3_texOff(vec2(0,1));
res += mat4(0.0263315960764885,-0.3030783832073212,0.5731752514839172,0.0163164157420397,0.0994879081845284,0.0459609739482403,0.0356153398752213,0.3358831703662872,-0.2208869010210037,0.3033982813358307,0.0253771729767323,-0.3519003093242645,-0.0202707070857286,-0.1821469962596893,-0.3992060422897339,0.0346953496336937) * MODEL4_texOff(vec2(0,1));
res += mat4(0.3334394693374634,-0.1968406885862350,0.1701373010873795,0.1021427288651466,-0.0147269601002336,0.0701922625303268,0.0501354150474072,-0.0238048546016216,-0.0242276247590780,-0.3706024587154388,0.0057721352204680,0.0673455297946930,0.1210014969110489,0.2068747729063034,-0.0184159558266401,-0.1844947785139084) * MODEL1_texOff(vec2(1,-1));
res += mat4(-0.0711980611085892,-0.1646527200937271,-0.0348984114825726,0.0458331070840359,-0.0592295564711094,0.0429804362356663,0.0633668527007103,-0.0887297615408897,0.0591199062764645,0.2785882353782654,0.1546631008386612,0.0576921850442886,0.1357407271862030,0.0261168684810400,-0.2746448218822479,0.0076845628209412) * MODEL2_texOff(vec2(1,-1));
res += mat4(-0.2072208076715469,0.1141251027584076,0.0491079241037369,-0.0414020381867886,0.2520525753498077,-0.0095078833401203,0.0605663172900677,-0.0657160580158234,0.2095283269882202,0.1218301057815552,-0.0085758138448000,-0.0047799674794078,0.0383018031716347,-0.1704875975847244,-0.0236699488013983,-0.0657273232936859) * MODEL3_texOff(vec2(1,-1));
res += mat4(-0.0391417890787125,-0.0950736999511719,-0.0867062881588936,-0.1508761197328568,-0.0721105113625526,0.3227547705173492,0.1170788034796715,0.1071276441216469,0.3144429326057434,0.1505455076694489,0.2037825584411621,0.2058983594179153,0.2463132888078690,0.0262015853077173,0.1655953228473663,0.0284772794693708) * MODEL4_texOff(vec2(1,-1));
res += mat4(-0.2142096757888794,-0.3336849510669708,0.1100151464343071,0.1912226378917694,-0.0637261494994164,-0.0036669168621302,-0.0317040383815765,0.0309900958091021,0.0629468336701393,-0.0138057358562946,0.0198006369173527,0.0468734242022038,-0.1184963062405586,0.2932909131050110,0.1430784016847610,-0.2738595008850098) * MODEL1_texOff(vec2(1,0));
res += mat4(0.0263565480709076,-0.2182097584009171,0.0248852483928204,0.0806952863931656,0.0411778949201107,0.0462260097265244,0.2508244514465332,-0.2604519128799438,0.1782611757516861,-0.0552900508046150,-0.0188052784651518,0.1505897045135498,0.1071805506944656,0.1933152079582214,0.0772838443517685,-0.3518147766590118) * MODEL2_texOff(vec2(1,0));
res += mat4(-0.3039082586765289,0.2085517495870590,0.1073516756296158,0.0792794078588486,0.0139703052118421,0.1793562620878220,-0.0779549032449722,-0.4413506090641022,-0.0154337212443352,0.1998108625411987,-0.1112744733691216,-0.0729703530669212,0.0364848375320435,-0.1272945255041122,0.2254590988159180,-0.2005347013473511) * MODEL3_texOff(vec2(1,0));
res += mat4(-0.0273634362965822,0.2264695465564728,0.1658903509378433,0.2102769166231155,-0.1478670835494995,0.2959378957748413,-0.1816536337137222,0.2262745201587677,-0.0842936486005783,0.2780936658382416,-0.1769950538873672,-0.1050595194101334,0.0085508283227682,0.2996675074100494,0.1085069105029106,0.0264055654406548) * MODEL4_texOff(vec2(1,0));
res += mat4(0.0275089219212532,-0.0199142079800367,-0.1471563428640366,0.0359929502010345,-0.0232283771038055,-0.2136822640895844,0.3263385593891144,-0.0078923916444182,-0.0089772054925561,-0.2155348360538483,0.0575222708284855,-0.0584659241139889,-0.1102655529975891,0.0794615447521210,0.0324593000113964,-0.0505253821611404) * MODEL1_texOff(vec2(1,1));
res += mat4(-0.0989244282245636,-0.1169452443718910,-0.0588202178478241,0.2295041233301163,-0.0500692725181580,0.1185398548841476,0.2176976650953293,-0.0961228460073471,-0.3480427563190460,0.3826696872711182,-0.2737647891044617,0.3211134970188141,-0.0960477218031883,-0.2945753335952759,-0.1037626191973686,-0.1685638427734375) * MODEL2_texOff(vec2(1,1));
res += mat4(-0.0226573441177607,0.2182911187410355,0.0424330383539200,-0.0281616933643818,-0.0349009595811367,-0.1639105528593063,0.2685182988643646,-0.2577687799930573,-0.2169789373874664,-0.0619792789220810,-0.0216093808412552,-0.0641317814588547,0.0200322512537241,0.0781936794519424,0.1579122543334961,-0.0302272662520409) * MODEL3_texOff(vec2(1,1));
res += mat4(-0.0130745423957705,-0.0074001727625728,-0.4127369225025177,-0.1832849383354187,-0.0191794950515032,-0.1459515541791916,0.0506785213947296,-0.0798520520329475,-0.1798611879348755,0.0208102259784937,-0.0432562939822674,0.0866297408938408,-0.1733963042497635,0.3829587697982788,-0.1485795825719833,0.0457934252917767) * MODEL4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.2022365331649780,0.0257512368261814,0.0406768731772900,0.2374598830938339) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 3_4
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!SAVE MODEL24
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.1615822762250900,-0.3181393742561340,-0.1999485045671463,-0.3559705018997192);
res += mat4(-0.1974588930606842,-0.0361125282943249,0.0272251442074776,0.3330465853214264,0.1987139582633972,0.2116202712059021,0.0364080779254436,0.0950169339776039,-0.0183155369013548,0.1389241069555283,0.0915704816579819,0.0289167705923319,-0.1128599345684052,-0.0840830653905869,0.0487023331224918,-0.0443631745874882) * MODEL1_texOff(vec2(-1,-1));
res += mat4(0.0031848836224526,0.1297396570444107,-0.0644683688879013,0.0848719477653503,0.3124601542949677,0.4512622654438019,0.0452612601220608,0.1563718467950821,0.0617647059261799,0.0545460805296898,-0.0145732900127769,-0.1544342786073685,0.3531651198863983,-0.0244909264147282,-0.0518489591777325,0.0819958001375198) * MODEL2_texOff(vec2(-1,-1));
res += mat4(0.3703565895557404,0.3106299340724945,-0.0596154928207397,-0.0143657997250557,-0.1106218844652176,-0.2220201492309570,-0.0493395030498505,-0.0209231022745371,-0.0452506951987743,-0.0562542080879211,0.0413091406226158,0.1060889288783073,-0.1341663300991058,-0.2745214104652405,0.0044015492312610,0.1632619202136993) * MODEL3_texOff(vec2(-1,-1));
res += mat4(-0.0422523096203804,-0.1062318906188011,-0.0942376032471657,0.0562276653945446,0.2332727015018463,-0.0921145454049110,0.1994942575693130,-0.0289016347378492,-0.3205979466438293,-0.0989910215139389,-0.0473002642393112,-0.0369105041027069,0.1293666362762451,-0.3146778047084808,-0.0866488367319107,-0.0980222001671791) * MODEL4_texOff(vec2(-1,-1));
res += mat4(-0.0427063852548599,-0.1648644804954529,0.0379024669528008,-0.0208045244216919,-0.1719881892204285,0.3812213838100433,0.1619504541158676,0.0470844097435474,0.1719943434000015,-0.2370854169130325,0.0481606535613537,0.0425046421587467,0.0846692100167274,-0.1100198403000832,-0.2590966522693634,0.0026085490826517) * MODEL1_texOff(vec2(-1,0));
res += mat4(-0.2735429108142853,0.1730803400278091,0.3100599348545074,0.0985910445451736,0.1110698357224464,0.6594412326812744,0.7377954721450806,-0.2639446258544922,-0.0634758099913597,-0.1699009984731674,-0.1212719082832336,0.0028376460541040,-0.1164819374680519,-1.0320463180541992,-0.0450741462409496,-0.1320651471614838) * MODEL2_texOff(vec2(-1,0));
res += mat4(-0.0713348165154457,0.2158897370100021,0.0068049891851842,0.2112420648336411,0.1104797795414925,-0.1926867812871933,-0.2347638309001923,-0.0045262179337442,-0.1009434685111046,-0.0155510986223817,0.1563263982534409,0.0713946446776390,0.0621294677257538,-0.6294711828231812,0.1566622406244278,-0.0091994525864720) * MODEL3_texOff(vec2(-1,0));
res += mat4(-0.3112075030803680,-0.6678212881088257,-0.2279316931962967,0.0975699722766876,0.0887780785560608,-0.6464394330978394,0.4730529189109802,-0.1636635661125183,0.3923094570636749,-0.2109929919242859,-0.0590078011155128,0.1201331168413162,0.0747839882969856,-0.6923506855964661,-0.1845218688249588,-0.6314243078231812) * MODEL4_texOff(vec2(-1,0));
res += mat4(0.1466641724109650,-0.0201342832297087,0.0536496415734291,-0.1008828654885292,-0.0157332532107830,0.1040282845497131,-0.1103689000010490,0.0703886225819588,0.0615994036197662,0.1226205825805664,0.0363954119384289,0.0492972880601883,-0.0888964235782623,-0.4082735776901245,-0.0756086632609367,0.0448960103094578) * MODEL1_texOff(vec2(-1,1));
res += mat4(0.0087998807430267,-0.1445795148611069,0.1685708165168762,-0.2043169140815735,0.0506292805075645,0.1092414259910583,-0.0573321618139744,0.2661716639995575,0.2547429502010345,0.5587040781974792,0.5166037082672119,-0.2281772345304489,0.5585767030715942,-0.3029598295688629,0.0948151722550392,-0.2011469453573227) * MODEL2_texOff(vec2(-1,1));
res += mat4(0.0988581106066704,-0.0050347773358226,0.0214924830943346,0.0934388861060143,-0.0946071669459343,0.0599846467375755,-0.1351220011711121,0.1020606458187103,-0.2519436478614807,-0.0515622273087502,0.0842102542519569,0.0880617350339890,0.0549225658178329,-0.0714932754635811,0.0816045850515366,0.0435110107064247) * MODEL3_texOff(vec2(-1,1));
res += mat4(-0.0891644656658173,0.2382436543703079,-0.0550603754818439,-0.1067416295409203,0.1685477197170258,0.0988656878471375,0.1751660406589508,0.1592041403055191,-0.0025217381771654,-0.0715155899524689,-0.1038656681776047,0.0117675382643938,-0.0858341678977013,0.1848066747188568,0.0730907768011093,0.1294896751642227) * MODEL4_texOff(vec2(-1,1));
res += mat4(0.1480890065431595,0.1093944683670998,0.0273557640612125,0.0978048443794250,-0.1570419818162918,-0.0844203978776932,-0.1055161878466606,0.0666613504290581,0.0353829339146614,0.1729962825775146,0.1570480465888977,0.1071970239281654,0.0467069819569588,-0.0041125947609544,-0.1477214992046356,-0.0558170601725578) * MODEL1_texOff(vec2(0,-1));
res += mat4(-0.0766604617238045,-0.0088386107236147,-0.1634499430656433,0.0254724863916636,-0.1766208857297897,0.1404360383749008,0.1722287982702255,0.0101510491222143,-0.1669355183839798,0.0280846152454615,-0.0156840607523918,-0.0646581575274467,0.5041709542274475,0.1393980532884598,-0.0197534523904324,0.0634621903300285) * MODEL2_texOff(vec2(0,-1));
res += mat4(-0.1562757045030594,-0.1491460204124451,-0.1293769925832748,-0.0993995070457458,0.0518447905778885,-0.0883174687623978,-0.3151679337024689,0.0233054235577583,0.0155591340735555,0.2825752496719360,0.0820059627294540,0.1270603984594345,0.1299761980772018,-0.3897947967052460,-0.0983077734708786,0.1207662671804428) * MODEL3_texOff(vec2(0,-1));
res += mat4(0.0201731696724892,0.5210286974906921,-0.0586822256445885,-0.0883760228753090,-0.0129213891923428,0.5142046809196472,0.1718618422746658,0.2975693345069885,-0.3396313786506653,0.1059687063097954,0.0777886360883713,-0.0071464977227151,0.1728369146585464,0.3824301362037659,-0.0833638533949852,-0.2928820848464966) * MODEL4_texOff(vec2(0,-1));
res += mat4(0.0064954073168337,0.1674818545579910,0.0887469202280045,-0.7010315060615540,0.3658912777900696,-0.4067452549934387,0.4187158048152924,0.3783641755580902,0.1789065748453140,0.1189458966255188,0.0024689293932170,-0.0299046002328396,-0.2898829281330109,0.4775104820728302,0.1953880339860916,0.0813034474849701) * MODEL1_texOff(vec2(0,0));
res += mat4(-0.0485714860260487,-0.5938887000083923,0.4764872193336487,0.1407720744609833,0.0093602379783988,0.1419454663991928,-0.4671202898025513,0.1723480522632599,-0.7166591882705688,0.4574638009071350,-0.0326357334852219,-0.0583588704466820,-0.0941323116421700,0.4582560956478119,0.1340586692094803,-0.3326202929019928) * MODEL2_texOff(vec2(0,0));
res += mat4(-0.0684696584939957,-0.0358825363218784,-0.2395974695682526,0.0954800844192505,0.1807143390178680,0.4913621544837952,-0.0526139996945858,-0.6320487856864929,-0.0204235855489969,0.1250404417514801,0.2128109931945801,-0.0169341322034597,0.0350728556513786,-0.0781793445348740,0.0091825509443879,0.0751496478915215) * MODEL3_texOff(vec2(0,0));
res += mat4(-0.4747851788997650,0.3133098781108856,-0.3814404308795929,0.1067867875099182,0.1430086493492126,0.1043839082121849,0.2127566039562225,-0.4224065542221069,0.0955729708075523,-0.3406157791614532,0.1246647760272026,0.1407596766948700,-0.2837055027484894,0.7860319614410400,-0.2027616798877716,-0.4297810494899750) * MODEL4_texOff(vec2(0,0));
res += mat4(0.0459526479244232,0.2253930121660233,-0.1006621196866035,-0.3292084634304047,0.0446605868637562,-0.2177486866712570,-0.0548334866762161,-0.2977205514907837,0.1104483753442764,0.0816389992833138,0.1431364119052887,0.0702833682298660,-0.2710016071796417,-0.1197729110717773,-0.0982481837272644,0.2712083756923676) * MODEL1_texOff(vec2(0,1));
res += mat4(-0.2157401442527771,-0.0775162652134895,0.4440428316593170,-0.6906740069389343,0.2072909325361252,-0.0245185904204845,-0.0075218183919787,-0.2698760926723480,-0.1381023973226547,-0.5785195231437683,0.6836381554603577,-0.2779017984867096,0.1575073450803757,-0.0533783882856369,0.1232813969254494,0.3853336870670319) * MODEL2_texOff(vec2(0,1));
res += mat4(0.2543635964393616,-0.1031905189156532,-0.1863321214914322,0.1541504561901093,0.0573079325258732,-0.0309962946921587,-0.0597893632948399,0.1371916234493256,-0.1392024308443069,-0.1404805779457092,-0.0184998251497746,-0.3532753884792328,0.1169531121850014,-0.1732151508331299,0.1489966958761215,-0.3539541065692902) * MODEL3_texOff(vec2(0,1));
res += mat4(-0.1335048824548721,-0.0026021120138466,-0.2061898857355118,-0.0614206343889236,0.1404600590467453,-0.0945246815681458,0.0452495291829109,0.1688058525323868,-0.0646559670567513,0.4283471107482910,0.1381076723337173,-0.1573742926120758,0.1510650962591171,0.1086952090263367,0.1548220962285995,0.0828442424535751) * MODEL4_texOff(vec2(0,1));
res += mat4(-0.0242201369255781,0.0997985452413559,-0.1483216881752014,0.1901189386844635,-0.0716479793190956,0.1051960438489914,-0.0346695780754089,0.0622938871383667,0.1448462009429932,0.1205437332391739,0.0731006562709808,0.0288040526211262,-0.0466316454112530,-0.2884612679481506,0.0575182922184467,0.1197100803256035) * MODEL1_texOff(vec2(1,-1));
res += mat4(0.0110533563420177,0.1390976607799530,-0.0671180188655853,0.0268602054566145,0.0147142149507999,-0.1020987257361412,0.0262565556913614,0.0969162508845329,-0.0498718880116940,-0.1287681758403778,0.0755067318677902,0.0858733430504799,0.1504770666360855,-0.1764158755540848,0.0081835035234690,0.0668434947729111) * MODEL2_texOff(vec2(1,-1));
res += mat4(-0.0589775331318378,0.1392201185226440,-0.0361892916262150,-0.2372763007879257,0.1082609817385674,0.0466561466455460,0.0278300307691097,0.0998477637767792,0.0669115632772446,-0.2091742604970932,0.1381004750728607,0.0766300112009048,0.1446924954652786,0.1631669253110886,-0.0644430965185165,0.0767935365438461) * MODEL3_texOff(vec2(1,-1));
res += mat4(0.0524473711848259,-0.1524970829486847,0.1444454789161682,-0.1205128729343414,0.0662038400769234,0.1602598577737808,0.0945349857211113,0.2149742394685745,-0.0533903911709785,0.3189899027347565,-0.1177339255809784,0.0019386430503801,0.1200195476412773,-0.2956101298332214,0.1650701165199280,0.0415289178490639) * MODEL4_texOff(vec2(1,-1));
res += mat4(-0.0486291609704494,0.3953767120838165,-0.1255990713834763,-0.3293313086032867,0.1416009515523911,0.1239224448800087,0.2408447265625000,0.2534500956535339,0.1353967189788818,0.0096069956198335,0.0511887893080711,-0.1374846547842026,-0.2171303778886795,-0.0621167272329330,0.0551748014986515,-0.1582599282264709) * MODEL1_texOff(vec2(1,0));
res += mat4(-0.1558980643749237,0.2135347872972488,-0.0382786728441715,0.0563892051577568,0.2865737378597260,-0.2930139899253845,0.1893816143274307,0.0373828299343586,0.1701010316610336,-0.1615521311759949,-0.0457543432712555,0.0079989656805992,0.4211249053478241,-0.2294072806835175,0.0191718637943268,-0.2165979892015457) * MODEL2_texOff(vec2(1,0));
res += mat4(-0.0352835580706596,0.0126804132014513,0.1060079634189606,0.0810654908418655,0.0728891044855118,-0.0235399026423693,0.0480183027684689,-0.5944545269012451,0.0423041731119156,0.0811937302350998,0.1780243217945099,-0.3017739951610565,0.0543744824826717,0.0653476417064667,0.0503508001565933,0.0260920189321041) * MODEL3_texOff(vec2(1,0));
res += mat4(-0.4671322107315063,-0.0928015857934952,0.2024582177400589,-0.2208473086357117,0.2275488525629044,0.1748902946710587,0.1170512139797211,-0.2093700170516968,-0.1567525714635849,0.7000426650047302,0.1178150996565819,0.0175986383110285,0.0477720387279987,-0.6606707572937012,0.2863810062408447,-0.3851889967918396) * MODEL4_texOff(vec2(1,0));
res += mat4(0.2252556532621384,-0.2217492759227753,-0.0934017598628998,-0.0658233538269997,0.0241077225655317,-0.1290224492549896,0.0603329613804817,-0.0828618034720421,0.1114495173096657,0.0259773936122656,0.1097635626792908,0.0774067267775536,0.0278273224830627,-0.0860898271203041,-0.0221626814454794,-0.1882199347019196) * MODEL1_texOff(vec2(1,1));
res += mat4(-0.1687875241041183,0.0478606447577477,-0.0516307912766933,-0.3704669475555420,0.1190483495593071,-0.1301420480012894,0.1876411139965057,0.0759634152054787,-0.0653661862015724,-0.0197278223931789,0.1632201224565506,0.1205626502633095,0.1190266013145447,0.2711841762065887,0.0045819743536413,-0.3520955741405487) * MODEL2_texOff(vec2(1,1));
res += mat4(0.0539962351322174,-0.0687875524163246,0.0390589311718941,0.3079180121421814,-0.1250923424959183,-0.1496006846427917,0.0689963996410370,0.1750945746898651,-0.1237833872437477,0.2568069696426392,-0.0401086509227753,-0.6318426728248596,0.2254602909088135,0.1945572644472122,0.1131982803344727,0.2567225992679596) * MODEL3_texOff(vec2(1,1));
res += mat4(-0.2952269017696381,-0.0350491218268871,-0.0263390596956015,0.0551356598734856,0.1985633224248886,-0.1453243643045425,0.0687370896339417,0.2197585701942444,-0.2182653546333313,0.2905139923095703,-0.0267444811761379,-0.2130593657493591,0.0779621079564095,-0.1403796523809433,0.2053179889917374,0.3907326459884644) * MODEL4_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.1542360335588455,0.1412342339754105,0.2793002426624298,-0.0122240018099546) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 4_1
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL1
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.4017260372638702,-0.2961334884166718,-0.1361677497625351,-0.0893436446785927);
res += mat4(0.2097381800413132,0.0455209799110889,0.0259832218289375,-0.0885811075568199,-0.0067618829198182,-0.0790565013885498,-0.1110692024230957,-0.0180842950940132,0.0158209800720215,-0.0187969636172056,-0.0204427260905504,-0.2228807806968689,-0.0711185410618782,-0.0127975698560476,0.0209482349455357,0.0492094419896603) * MODEL21_texOff(vec2(-1,-1));
res += mat4(0.0825126916170120,0.0142949596047401,0.0014128192560747,0.1430399119853973,-0.1104710847139359,0.0465638190507889,-0.0133922407403588,-0.1491267383098602,-0.0963994413614273,-0.0794140994548798,-0.0114508774131536,0.2101793587207794,0.0521571338176727,0.0200386326760054,0.0641321614384651,-0.0391873233020306) * MODEL22_texOff(vec2(-1,-1));
res += mat4(-0.1520352214574814,0.0362231470644474,-0.1735580861568451,-0.0480187125504017,0.0255993194878101,0.0021788808517158,0.0240470990538597,-0.0222435146570206,0.0286579951643944,0.0400702878832817,0.0619828291237354,0.1402423828840256,-0.0478758364915848,-0.0099906520918012,-0.0750462785363197,-0.0264946576207876) * MODEL23_texOff(vec2(-1,-1));
res += mat4(-0.0258351694792509,0.0523434728384018,-0.0001439041661797,-0.4302446544170380,0.2808142602443695,0.0586529597640038,0.0233658440411091,0.0250332076102495,-0.1439442187547684,0.0323054641485214,0.0306089632213116,-0.0787173062562943,0.2927255332469940,-0.0432015433907509,0.1597368568181992,0.0631633177399635) * MODEL24_texOff(vec2(-1,-1));
res += mat4(-0.0406202860176563,0.0948056876659393,-0.0016681901179254,0.0702174976468086,0.1148841306567192,-0.1661987155675888,0.0636739060282707,-0.0837402492761612,0.1120814383029938,-0.0271764490753412,-0.0322991609573364,-0.1166550219058990,-0.1365866363048553,-0.0204168818891048,-0.0006664992542937,-0.0552206113934517) * MODEL21_texOff(vec2(-1,0));
res += mat4(-0.2642927765846252,0.0292292218655348,-0.0285296738147736,-0.0599881522357464,-0.0689995810389519,-0.1233489960432053,-0.1328419595956802,-0.2746882438659668,-0.2931686937808990,0.1162078306078911,-0.0205998104065657,-0.2093065381050110,0.4624252617359161,0.1201894655823708,0.1537899672985077,-0.1396795362234116) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.0468857064843178,0.0680844113230705,-0.0621197260916233,-0.1120299324393272,0.2493423074483871,-0.0360720269382000,0.1085719913244247,0.0258240625262260,0.0603066310286522,-0.0100611504167318,0.0094873001798987,0.0243063438683748,-0.0421180427074432,0.0433366373181343,-0.0360187962651253,-0.0118739269673824) * MODEL23_texOff(vec2(-1,0));
res += mat4(0.0021250096615404,0.0066482825204730,0.0012090024538338,-0.0424312166869640,-0.2473762929439545,0.0487834848463535,-0.0168533548712730,-0.0338227190077305,0.1850264370441437,0.1778176277875900,0.0584322102367878,-0.0196400973945856,0.0880245119333267,-0.0483354441821575,-0.0032457294873893,0.3941470980644226) * MODEL24_texOff(vec2(-1,0));
res += mat4(0.1407747119665146,0.0285373218357563,-0.0326111093163490,-0.0126952938735485,-0.0986694246530533,-0.1084323599934578,0.2191060334444046,0.0870947688817978,-0.4361937344074249,-0.0923902466893196,-0.0366748645901680,-0.0339165031909943,-0.3207955658435822,0.0006921324529685,0.0325197428464890,-0.0059981741942465) * MODEL21_texOff(vec2(-1,1));
res += mat4(0.0493194982409477,0.0047612232156098,-0.0501776710152626,0.0761292353272438,0.0440238378942013,-0.0962646976113319,-0.0159055087715387,-0.0891461148858070,-0.0807150751352310,0.1511806398630142,-0.0009086466743611,0.0526818148791790,0.0227832496166229,0.0163672640919685,0.1001215651631355,-0.0190013367682695) * MODEL22_texOff(vec2(-1,1));
res += mat4(0.1284213811159134,0.0020348706748337,-0.0224223677068949,0.0618590824306011,-0.0182180218398571,-0.1362143009901047,-0.0246695056557655,-0.0094380369409919,0.0524647533893585,0.0233174934983253,-0.0424746274948120,-0.0974605008959770,0.0615278035402298,-0.0220964886248112,-0.0383524969220161,-0.0995529666543007) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.0797834247350693,0.0756283625960350,-0.0404821448028088,-0.1541213095188141,0.2288120239973068,0.0381797179579735,-0.0554104149341583,-0.0191117413341999,0.1889799833297729,0.0610259659588337,-0.0413142666220665,-0.0681122764945030,-0.2335439771413803,0.0230415090918541,0.0580160096287727,-0.0376873239874840) * MODEL24_texOff(vec2(-1,1));
res += mat4(0.1205652803182602,0.0567708238959312,0.0532078668475151,0.0023451852612197,0.0004279239219613,0.1615711599588394,0.0226642377674580,0.0061074844561517,0.0973163396120071,0.0454865433275700,0.0075657670386136,-0.0291110761463642,-0.2150427550077438,-0.0380354188382626,0.0195998251438141,0.0733001306653023) * MODEL21_texOff(vec2(0,-1));
res += mat4(-0.0121162114664912,0.0026517154183239,0.1457572430372238,0.1338728964328766,0.0548631958663464,-0.0518958866596222,0.1171092316508293,0.1558521389961243,-0.1996449083089828,0.0507291331887245,-0.0580380372703075,-0.0554652661085129,0.1130587980151176,-0.0673785731196404,0.0412916131317616,0.0101153869181871) * MODEL22_texOff(vec2(0,-1));
res += mat4(-0.0724401921033859,0.1120468005537987,-0.2719030678272247,-0.0212808307260275,0.2433746457099915,-0.0861721932888031,0.0562748312950134,-0.0693661868572235,-0.2198645323514938,-0.0902982130646706,0.0976229459047318,-0.0972380563616753,-0.1861834973096848,-0.0242842808365822,0.0934249460697174,-0.0893250033259392) * MODEL23_texOff(vec2(0,-1));
res += mat4(0.1657098382711411,0.0126938382163644,-0.0438225679099560,-0.0742039903998375,0.2963215410709381,-0.0713309645652771,0.0827048197388649,0.0660631582140923,-0.1251822412014008,-0.0499160476028919,-0.2584874331951141,-0.1251225322484970,0.1618934273719788,-0.1064148470759392,0.1819295287132263,0.2171864509582520) * MODEL24_texOff(vec2(0,-1));
res += mat4(0.1569976806640625,0.3101954758167267,0.0150568205863237,-0.0887403264641762,0.0229867883026600,0.4311129748821259,-0.1446330398321152,-0.1213236078619957,-0.0203808881342411,0.2042820155620575,-0.0433217436075211,-0.0179664622992277,-0.2846025526523590,-0.0990165472030640,0.0056579820811749,-0.0683584734797478) * MODEL21_texOff(vec2(0,0));
res += mat4(-0.0853557437658310,-0.0774037018418312,-0.0415960364043713,-0.1887119114398956,-0.5862891077995300,0.0278921741992235,0.0256915763020515,-0.0210970006883144,0.2069407552480698,-0.1677509099245071,-0.0279460810124874,0.0731252431869507,0.5933819413185120,-0.1151936426758766,-0.0640015155076981,-0.0522294752299786) * MODEL22_texOff(vec2(0,0));
res += mat4(-0.1260266751050949,-0.2648131549358368,-0.1370221376419067,0.2285791039466858,0.2001305967569351,0.1079795658588409,0.2466328740119934,0.0457031726837158,-0.0482302606105804,0.0922641381621361,0.1157679036259651,0.0874616578221321,-0.2405085563659668,0.2206059396266937,-0.1060627028346062,-0.1089278236031532) * MODEL23_texOff(vec2(0,0));
res += mat4(-0.1133070364594460,0.0483875982463360,0.0714892596006393,-0.1741379052400589,-0.0075362133793533,-0.1605125516653061,-0.0356721058487892,-0.1034936383366585,-0.3046982884407043,-0.2816949784755707,0.1567458659410477,0.0703221932053566,-0.3049350976943970,0.0748891606926918,-0.3223647773265839,0.3255655467510223) * MODEL24_texOff(vec2(0,0));
res += mat4(0.2866676747798920,0.0061847539618611,-0.0146162826567888,-0.0140134487301111,-0.0492958836257458,0.2509532868862152,0.2757189273834229,0.0991292446851730,-0.0792517438530922,0.2112044692039490,0.0271733049303293,0.0229198448359966,-0.1673509776592255,-0.1144836321473122,-0.0379185862839222,-0.1211301758885384) * MODEL21_texOff(vec2(0,1));
res += mat4(0.3355725407600403,0.0442647859454155,-0.0838595926761627,0.1079318448901176,-0.2963336408138275,0.0576937161386013,-0.1598837226629257,0.0096225263550878,0.1108556762337685,-0.0730845928192139,0.0671025812625885,-0.0082114962860942,0.2242141515016556,0.1097397506237030,0.0286945737898350,0.1402641087770462) * MODEL22_texOff(vec2(0,1));
res += mat4(0.0355083383619785,0.0025727578904480,0.0215286500751972,0.0641032680869102,0.1199254021048546,0.2343555688858032,-0.1932496577501297,-0.0099069811403751,0.2384359985589981,-0.0141440071165562,-0.1757063120603561,-0.0082274377346039,-0.0970101431012154,-0.0258587580174208,-0.1223197653889656,-0.0665969997644424) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.5002747178077698,-0.1544622480869293,0.0256742816418409,0.1729249954223633,-0.0812580212950706,-0.0510701090097427,0.0390088669955730,0.0295602343976498,-0.1957711130380630,-0.1831477880477905,-0.0720937699079514,0.0142635153606534,-0.2937955260276794,0.0205176435410976,0.0880671143531799,-0.0333128981292248) * MODEL24_texOff(vec2(0,1));
res += mat4(0.0517796464264393,-0.0542778223752975,0.0063309129327536,0.0192148517817259,-0.1953081041574478,-0.0495741665363312,-0.0320096313953400,0.0262839626520872,0.1965485662221909,0.0579232648015022,0.0040284935384989,0.0084932213649154,-0.0804616361856461,-0.0339209511876106,-0.0477394163608551,-0.0912244990468025) * MODEL21_texOff(vec2(1,-1));
res += mat4(0.1388270705938339,-0.0794934481382370,-0.0060276612639427,0.0195973459631205,0.1203104034066200,-0.0191927794367075,0.0834798216819763,-0.0049274601042271,-0.2150519788265228,-0.0466494448482990,-0.1428831666707993,-0.0850805714726448,0.1603372097015381,0.0740652829408646,0.0193773657083511,-0.1526438742876053) * MODEL22_texOff(vec2(1,-1));
res += mat4(-0.3676199316978455,-0.0407186113297939,-0.0791402086615562,0.0401397943496704,-0.2821306586265564,0.1057764440774918,-0.0107554029673338,0.0340133756399155,-0.0502954721450806,0.1529730111360550,0.0264162663370371,-0.0219731032848358,-0.0581691265106201,0.0023856244515628,-0.0353333987295628,0.0176197551190853) * MODEL23_texOff(vec2(1,-1));
res += mat4(-0.6594786643981934,-0.1180216446518898,-0.0536138117313385,-0.0736580863595009,0.3629510402679443,-0.0126025620847940,0.0704809352755547,0.0210348665714264,0.0380675010383129,0.1170240938663483,-0.0444464273750782,-0.0492949001491070,0.0362430326640606,0.0684820264577866,0.0186503622680902,0.0150468759238720) * MODEL24_texOff(vec2(1,-1));
res += mat4(0.1482787728309631,-0.0365413613617420,0.0086090015247464,-0.0034506188239902,0.1712284833192825,-0.3256959319114685,-0.0199483390897512,-0.0377518758177757,-0.4051332771778107,-0.0191734265536070,-0.0113983657211065,0.0821225270628929,-0.4675072133541107,-0.2551299333572388,0.0303181782364845,-0.0401000455021858) * MODEL21_texOff(vec2(1,0));
res += mat4(-0.3577684164047241,-0.1069141551852226,-0.0075849895365536,0.0423410274088383,-0.2249272912740707,0.1607808619737625,-0.0434508286416531,-0.0630646347999573,0.0467253662645817,-0.0850183889269829,0.0327854491770267,0.2028924971818924,0.4897454082965851,-0.0970613285899162,0.0489688776433468,-0.0030162953771651) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.0016830641543493,0.0805390849709511,-0.1892860084772110,-0.1161972433328629,-0.0632022395730019,0.1641979813575745,0.0994559228420258,-0.2015440464019775,0.0025371038354933,0.0016705504385754,0.0146092707291245,0.0851408392190933,-0.1325370669364929,0.0693494006991386,-0.0077681690454483,0.0221750363707542) * MODEL23_texOff(vec2(1,0));
res += mat4(0.1509591937065125,0.0103544639423490,-0.0993898361921310,-0.1025217771530151,-0.3009583950042725,-0.0696848407387733,-0.0247161574661732,0.0697777643799782,-0.0050856992602348,-0.1217825189232826,0.0495748966932297,0.1007262021303177,-0.3699915111064911,0.0564243532717228,0.0082164555788040,0.0585284866392612) * MODEL24_texOff(vec2(1,0));
res += mat4(0.0351840443909168,-0.0647222995758057,-0.0100252823904157,-0.0335104949772358,-0.2296986281871796,-0.1618685126304626,0.0621194280683994,-0.0818901062011719,0.1464237421751022,0.0368709973990917,-0.0003796320233960,-0.0569860376417637,-0.2498854845762253,-0.1455738246440887,0.0041685332544148,-0.0121320234611630) * MODEL21_texOff(vec2(1,1));
res += mat4(0.2348484843969345,0.0012038116110489,-0.0960916578769684,0.1704002171754837,-0.2120207697153091,0.0348598435521126,-0.0052639539353549,0.0917042419314384,-0.7559375166893005,-0.2539097964763641,0.0407256148755550,-0.1221201717853546,0.3407650887966156,-0.1105026379227638,-0.0182420276105404,-0.0694810226559639) * MODEL22_texOff(vec2(1,1));
res += mat4(-0.0135694928467274,-0.0555824525654316,-0.0049720159731805,-0.0731092318892479,-0.2569287121295929,0.2798099219799042,-0.0756197869777679,-0.0065567190758884,0.1923488527536392,-0.0026427132543176,-0.0308974441140890,0.0103814210742712,0.1518303751945496,0.0891486555337906,-0.0057648457586765,-0.0346083641052246) * MODEL23_texOff(vec2(1,1));
res += mat4(-0.1657511144876480,0.0101053500548005,0.0973210036754608,-0.0716674402356148,0.2944849431514740,0.0328244790434837,-0.0530092269182205,-0.0151719739660621,0.1255925446748734,0.0991518944501877,0.0034502455964684,0.0031958257313818,-0.0669909268617630,0.0833601877093315,-0.0631546378135681,0.0264812838286161) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0738428458571434,-0.0537280328571796,0.1541616767644882,0.0600824654102325) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 4_2
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL2
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-1.3576488494873047,-1.2308499813079834,-0.0150942681357265,-0.1689438074827194);
res += mat4(0.0002222305047326,0.2126581817865372,-0.4436426460742950,-0.0265662744641304,0.0120948767289519,0.2213644683361053,-0.1760943531990051,0.1429262906312943,-0.2877714037895203,-0.0088296765461564,-1.9501984119415283,0.0885886475443840,-0.1727663576602936,-0.1734728217124939,-1.9370113611221313,-0.0425419993698597) * MODEL21_texOff(vec2(-1,-1));
res += mat4(-0.0526014566421509,0.0003678515495267,0.2852052450180054,-0.0790593400597572,-0.3033583164215088,-0.1894276589155197,-1.5888235569000244,-0.0376820005476475,0.0662743598222733,-0.4705247879028320,-0.8843554258346558,0.0803821012377739,0.1606564372777939,-0.1361556947231293,0.0592208355665207,0.0616206489503384) * MODEL22_texOff(vec2(-1,-1));
res += mat4(-0.0321790128946304,0.2487015426158905,-0.3988892734050751,0.0128471786156297,-0.0173364486545324,-0.1853401660919189,-0.2320190221071243,-0.0286743044853210,-0.0776202753186226,0.0980081930756569,0.0480991043150425,0.0124340718612075,-0.0705425217747688,0.0209217481315136,-0.5196899771690369,-0.0973696857690811) * MODEL23_texOff(vec2(-1,-1));
res += mat4(-0.0016310828505084,-0.1694957464933395,-3.7118730545043945,-0.0495798103511333,-0.0887507721781731,-0.1900598108768463,0.1969994455575943,-0.1086452603340149,-0.0323995985090733,-0.1345285028219223,0.1391065418720245,0.0422845482826233,0.5854858160018921,-0.8024836182594299,-1.3573205471038818,0.1715474575757980) * MODEL24_texOff(vec2(-1,-1));
res += mat4(-0.5026074051856995,0.9941442608833313,-0.1181278079748154,-0.1071377545595169,-0.3640037477016449,0.1423653513193130,0.1483183354139328,0.1491519063711166,0.4714116454124451,-0.6614524722099304,0.0689334198832512,0.4130813181400299,-0.2428199052810669,-0.5482697486877441,-0.0643231868743896,0.0820593982934952) * MODEL21_texOff(vec2(-1,0));
res += mat4(0.3884255290031433,0.0864198803901672,0.0709599480032921,-0.0727549865841866,-0.0210617538541555,-0.5082446336746216,0.0696677193045616,-0.0653665512800217,-0.3965116739273071,-0.5612360239028931,-0.0430528111755848,-0.1742940098047256,-0.0391180962324142,0.0120964674279094,0.0278037898242474,-0.1474379450082779) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.0801782086491585,-0.3312005102634430,-0.0722291469573975,0.1868390589952469,-0.1296129226684570,-0.0983095318078995,0.1288020163774490,0.0442728921771049,-0.1188574805855751,-0.2784206569194794,0.0334004350006580,0.0193342156708241,-0.2584644556045532,0.2669636309146881,-0.0028693764470518,-0.1062500998377800) * MODEL23_texOff(vec2(-1,0));
res += mat4(0.0388953760266304,0.0024954907130450,-0.1337166726589203,-0.1613133698701859,0.1160835772752762,0.1638180911540985,-0.0579901784658432,0.0131390430033207,-0.2732858955860138,-0.3843875527381897,-0.0702876299619675,-0.1991503983736038,-0.6187487840652466,0.1528591811656952,0.0061654588207603,-0.2680108845233917) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.2792676091194153,0.0347407497465611,-0.0249916408210993,-0.0471252836287022,0.0655104964971542,0.2337010949850082,0.0092136999592185,0.0498593896627426,0.2532851994037628,-0.3329302668571472,0.0197737384587526,0.2485453784465790,-0.0320697724819183,-0.2859528362751007,-0.0262277740985155,-0.0102716153487563) * MODEL21_texOff(vec2(-1,1));
res += mat4(-0.1766127049922943,-0.2082416713237762,0.0884197950363159,0.0531922541558743,0.0156908091157675,0.0239643827080727,0.0414093174040318,0.0693400129675865,-0.0447647050023079,0.0395914763212204,0.0231642629951239,-0.0426138713955879,-0.1834529191255569,0.0084871575236320,-0.0274198353290558,-0.0644422397017479) * MODEL22_texOff(vec2(-1,1));
res += mat4(-0.0741052180528641,0.0246290937066078,-0.0369153693318367,0.0561013817787170,0.1028454825282097,0.0061585321091115,-0.0537896417081356,-0.0337303876876831,-0.0662548840045929,-0.0498280376195908,0.0457142703235149,0.0811578556895256,-0.1037622764706612,-0.0888546183705330,-0.0436059087514877,-0.0936727076768875) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.2277279943227768,-0.1982262581586838,-0.0134356319904327,-0.2890455722808838,-0.0378793254494667,0.0101268338039517,-0.0035741112660617,-0.0955145284533501,-0.0813091322779655,-0.0232999380677938,0.0124657666310668,0.0689150840044022,0.0433216728270054,0.2974031269550323,0.0363154485821724,0.0258811712265015) * MODEL24_texOff(vec2(-1,1));
res += mat4(-0.0491647906601429,0.0150416148826480,0.0893379226326942,0.1105656847357750,-0.1163008585572243,-0.1098743379116058,0.0009594966541044,-0.0562435500323772,0.0399161949753761,0.0971821621060371,0.0255073197185993,0.0342289730906487,-0.1388117969036102,-0.2983616590499878,-0.0290130954235792,-0.0430332459509373) * MODEL21_texOff(vec2(0,-1));
res += mat4(0.1405151784420013,-0.1738028973340988,0.0729382410645485,0.0060116075910628,-0.1093452870845795,-0.3609048128128052,0.0800551176071167,-0.1479738205671310,-0.0661064237356186,0.0784058421850204,0.0276903901249170,-0.1308635324239731,-0.3087964355945587,0.2989252507686615,0.0413251183927059,0.0298706330358982) * MODEL22_texOff(vec2(0,-1));
res += mat4(-0.4313424229621887,-0.0101253967732191,-0.0788659304380417,0.1731674820184708,-0.0627171993255615,-0.0078195510432124,0.0234318710863590,-0.1402248293161392,-1.7050009965896606,-0.1074014008045197,0.0621128939092159,0.0886992216110229,0.1283528059720993,-0.0102964043617249,-0.0357159823179245,0.0694401115179062) * MODEL23_texOff(vec2(0,-1));
res += mat4(-0.2309935092926025,-0.3976728916168213,-0.1636141389608383,-0.0505089759826660,0.0542949028313160,-0.0111915767192841,0.0006312167388387,0.1045704483985901,-0.0083215739578009,0.0779492780566216,-0.1483388245105743,-0.1207443773746490,0.5473612546920776,-0.0428715869784355,0.0853060111403465,-0.3940364718437195) * MODEL24_texOff(vec2(0,-1));
res += mat4(-0.0491685457527637,-0.4690579175949097,0.0852821841835976,0.1396847814321518,0.3277880549430847,0.0143328038975596,0.1600318551063538,-0.0773719325661659,-2.0900523662567139,-0.8753762245178223,-0.0359358787536621,0.5931379199028015,-1.8106154203414917,-1.9298766851425171,-0.0305595826357603,-0.2771121561527252) * MODEL21_texOff(vec2(0,0));
res += mat4(-0.5724825263023376,-0.3126274943351746,-0.1602590829133987,-0.1358845680952072,-0.3762953877449036,0.4733247160911560,-0.1556626856327057,-0.1226351782679558,0.3881927132606506,-0.7162722349166870,0.0828518494963646,-0.1600222438573837,0.3124102056026459,-0.2831121385097504,0.1034529954195023,0.1893790364265442) * MODEL22_texOff(vec2(0,0));
res += mat4(0.5791679620742798,0.4442782700061798,-0.0131130153313279,-0.0340854935348034,-0.5826350450515747,0.3008985519409180,0.1346484422683716,-0.0789088234305382,0.2625213563442230,-0.2921890914440155,-0.0083887400105596,-0.0039507765322924,-0.3452711403369904,-1.0642710924148560,0.1451635956764221,0.6255943775177002) * MODEL23_texOff(vec2(0,0));
res += mat4(-0.5329001545906067,-0.2816036939620972,0.1381849050521851,0.1182930096983910,-0.5080990195274353,-0.4889704585075378,0.1049989685416222,0.3051874935626984,0.7868168354034424,-0.4957133829593658,-0.0782789364457130,0.1021046563982964,-1.4790620803833008,-0.4282301962375641,0.0350809842348099,0.1706625968217850) * MODEL24_texOff(vec2(0,0));
res += mat4(-0.1630038321018219,-0.1386075019836426,-0.0036164813209325,0.1390982419252396,-0.0548254437744617,0.2364829033613205,-0.0585732832551003,0.0257268603891134,-0.4578105807304382,0.2689254581928253,-0.0008447229629382,0.1336311846971512,-0.2541263699531555,-0.9333946108818054,-0.0084364973008633,-0.1582275032997131) * MODEL21_texOff(vec2(0,1));
res += mat4(-0.0611987821757793,0.3971358239650726,0.0519041791558266,-0.2514325678348541,-0.4202302098274231,0.1293289810419083,0.0303316470235586,-0.1522188931703568,-0.3939264118671417,-0.8553654551506042,0.0072963964194059,0.0974675714969635,-0.2082433849573135,-0.0826819464564323,-0.0346855260431767,-0.0538582429289818) * MODEL22_texOff(vec2(0,1));
res += mat4(-0.3731344044208527,-0.3428409397602081,-0.0580359585583210,0.0011560770217329,-0.4720404148101807,0.0411235652863979,-0.0730860307812691,-0.1378994882106781,-0.2114659398794174,-0.2510804831981659,0.0324120186269283,-0.0588292889297009,-0.0750492289662361,0.0516041405498981,0.0142624052241445,0.0762141942977905) * MODEL23_texOff(vec2(0,1));
res += mat4(0.2003266066312790,-0.3097744882106781,-0.0497338101267815,0.1900421231985092,0.2505185008049011,0.2198565602302551,0.0431300476193428,0.0684944465756416,-0.5235838890075684,0.0500761978328228,0.0365656577050686,-0.0031358739361167,-0.2059436887502670,0.1846282482147217,0.0071397400461137,0.0693401098251343) * MODEL24_texOff(vec2(0,1));
res += mat4(-0.0042014140635729,-0.0525740236043930,-0.0171905551105738,-0.0581245087087154,0.0485358685255051,-0.0782260224223137,-0.0030551524832845,-0.0716038197278976,-0.0489421710371971,-0.0497942827641964,0.0204748343676329,-0.0116019900888205,-0.1027395874261856,-0.2276215404272079,-0.0065505700185895,0.0101102003827691) * MODEL21_texOff(vec2(1,-1));
res += mat4(-0.0748871713876724,-0.1956935524940491,0.0010277481051162,-0.0725164115428925,-0.1371487826108932,-0.2153946757316589,0.0289711598306894,0.0479902103543282,-0.3926549851894379,-0.3859789967536926,-0.0123246852308512,0.0445899255573750,-0.0373382009565830,-0.0602863170206547,-0.0710507780313492,-0.0711589530110359) * MODEL22_texOff(vec2(1,-1));
res += mat4(0.0720328018069267,0.2373535484075546,-0.0241738017648458,-0.0539755597710609,-0.0287363287061453,0.1945647597312927,-0.0113422973081470,0.2388608008623123,0.1582005470991135,0.4138346910476685,-0.0016715164529160,0.0711019933223724,-0.1226481050252914,-0.0764425471425056,-0.0585050545632839,-0.0245702769607306) * MODEL23_texOff(vec2(1,-1));
res += mat4(-0.2826507687568665,-0.1364578604698181,-0.0561215952038765,-0.0743082463741302,-0.2760685682296753,-0.0331254787743092,0.0283021926879883,0.1009528338909149,0.0032031354494393,0.0542680397629738,-0.0284216683357954,-0.0048767263069749,-0.3685995340347290,-0.1592012792825699,0.0067512779496610,0.1387375891208649) * MODEL24_texOff(vec2(1,-1));
res += mat4(0.0073975622653961,0.2009483426809311,-0.0117812231183052,-0.0740807130932808,-0.2477743327617645,-0.3778422772884369,0.0459524206817150,-0.0773427635431290,0.1540841013193130,0.3211053013801575,-0.0188168492168188,-0.0615393407642841,0.0032952076289803,-0.2650936841964722,-0.0279312487691641,-0.1892956048250198) * MODEL21_texOff(vec2(1,0));
res += mat4(-0.0320254303514957,0.0943216234445572,-0.0224026683717966,-0.1085841134190559,-0.8607506155967712,-0.9446119070053101,0.0583956837654114,0.0846797972917557,-0.3580646812915802,-0.1429646909236908,0.0066589307971299,0.0307449307292700,0.3498374819755554,0.0596029423177242,-0.0778255090117455,-0.2372472286224365) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.3538910746574402,-0.5438384413719177,0.0300271715968847,0.0259353835135698,-0.0217854585498571,0.1497974097728729,0.0079162567853928,0.1637305915355682,-0.1231346353888512,-0.0285450499504805,-0.0020361966453493,0.0748025998473167,-0.1468269675970078,0.0726128518581390,0.0329792387783527,-0.0343051739037037) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.3467789888381958,-0.6177062988281250,-0.0004547669668682,-0.0695421993732452,0.0771730020642281,0.4323795735836029,-0.0108288945630193,-0.2320528030395508,-0.3504230678081512,-0.2344139665365219,-0.0060447426512837,0.0424748435616493,-0.3702187836170197,-0.1867645382881165,0.0227929949760437,-0.0589118450880051) * MODEL24_texOff(vec2(1,0));
res += mat4(-0.1212871819734573,-0.0925505831837654,-0.0210698843002319,-0.1102557256817818,0.0964596942067146,-0.1762590408325195,-0.0260235387831926,-0.0322984941303730,-0.2268410772085190,-0.1099716052412987,0.0028596802148968,-0.0435424409806728,0.0338655002415180,-0.0084998104721308,0.0110553447157145,-0.0637936368584633) * MODEL21_texOff(vec2(1,1));
res += mat4(-0.3963612020015717,-0.7054618597030640,0.0888577476143837,0.0486618503928185,-0.2505936920642853,-0.0695356801152229,0.0166353881359100,0.0361196286976337,0.1280656009912491,0.1052540093660355,-0.0460976138710976,-0.4243462979793549,-0.1481497287750244,-0.3150199055671692,-0.0155357057228684,-0.0100513044744730) * MODEL22_texOff(vec2(1,1));
res += mat4(0.0335134156048298,-0.0727859139442444,-0.0133455023169518,0.0521334595978260,-0.1833966523408890,0.1802965402603149,0.0792936831712723,0.4655365049839020,0.1774647384881973,0.1161453500390053,0.0228213164955378,0.0274636540561914,0.0343310683965683,-0.0128710521385074,-0.0213328227400780,-0.0579575076699257) * MODEL23_texOff(vec2(1,1));
res += mat4(0.0513603501021862,0.0107538942247629,-0.0082096224650741,-0.0443236157298088,0.1392785608768463,0.3404515385627747,0.0024068458005786,0.0242234971374273,0.1059209108352661,0.1276680678129196,0.0005027093575336,0.0201072059571743,-0.1857346147298813,-0.1753924787044525,-0.0199812017381191,-0.0288379266858101) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.0588584952056408,0.0545518882572651,0.0072807688266039,0.1775767654180527) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 4_3
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL3
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.1500374227762222,-0.5942718982696533,-0.2223509401082993,-0.7379623055458069);
res += mat4(0.0377564951777458,-0.0878159105777740,-0.0640691071748734,-0.1205077320337296,0.0063348636031151,-0.0615546405315399,0.0725330412387848,0.0315341800451279,0.0305612366646528,-0.1050232648849487,0.0199433136731386,-0.0293507445603609,0.0054702782072127,-0.1033336594700813,-0.0246256664395332,-0.0293234679847956) * MODEL21_texOff(vec2(-1,-1));
res += mat4(0.0960297584533691,0.0489416979253292,0.0456786714494228,-0.0304410420358181,-0.0264467485249043,-0.1808978915214539,0.0002239939494757,0.0978726968169212,0.0576720982789993,0.0627044662833214,0.1644076406955719,-0.1149405092000961,-0.0502514913678169,0.0530369617044926,-0.0983912944793701,-0.0911485180258751) * MODEL22_texOff(vec2(-1,-1));
res += mat4(0.0192345343530178,0.0737345293164253,-0.0694067627191544,-0.1192083954811096,-0.0153750851750374,-0.0094519695267081,0.0430041737854481,-0.0007860237383284,0.0574510805308819,-0.0099295461550355,-0.0037663441617042,-0.0417793281376362,-0.0447106771171093,0.0573733784258366,-0.0056610680185258,-0.1495522707700729) * MODEL23_texOff(vec2(-1,-1));
res += mat4(0.0020685896743089,-0.1271421909332275,-0.0915819332003593,-0.1303324252367020,-0.0046015819534659,-0.0537667907774448,-0.0757439434528351,-0.1034274026751518,-0.0360045954585075,0.1330265849828720,-0.1028348729014397,0.0029844422824681,-0.1337770670652390,0.0038527846336365,0.1660691797733307,-0.1233417540788651) * MODEL24_texOff(vec2(-1,-1));
res += mat4(0.1424528658390045,-0.3160114586353302,0.1415333896875381,0.3533829748630524,-0.0286452919244766,-0.3519482910633087,-0.0720888450741768,0.0498850271105766,-0.0992853417992592,-0.1978190243244171,0.1384896934032440,-0.9744571447372437,-0.0627422258257866,0.0621821247041225,-0.0077503439970315,-0.6523983478546143) * MODEL21_texOff(vec2(-1,0));
res += mat4(0.1006538048386574,0.2699738442897797,-0.0071857841685414,0.1695696413516998,0.0032719045411795,-0.6151775121688843,0.0345238298177719,-0.2692067325115204,0.0156748909503222,0.0570620149374008,-0.1344172209501266,-0.1108755916357040,0.0470011979341507,0.1119287982583046,0.0036730696447194,0.0595798902213573) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.0951662063598633,-0.1915390044450760,0.0358977876603603,-0.0575600825250149,0.0578359439969063,-0.1603155881166458,-0.0611245594918728,-0.0717436149716377,-0.0712571591138840,-0.0973955020308495,-0.0607430003583431,-0.2901412248611450,-0.0458060204982758,-0.0617536008358002,0.0254287105053663,0.1835725605487823) * MODEL23_texOff(vec2(-1,0));
res += mat4(0.0369277596473694,0.1574100255966187,-0.1701986193656921,-0.0723235905170441,-0.0370706990361214,0.0901095569133759,0.0174682717770338,0.1185340285301208,-0.0318144150078297,0.1076717376708984,0.0036862681154162,0.2513314783573151,-0.0918712839484215,0.0061007686890662,-0.0271367914974689,0.0996778458356857) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.2165136039257050,-0.1521220058202744,0.0699792578816414,-0.3011166453361511,0.0376400910317898,0.0138800414279103,-0.0751532092690468,0.2856407761573792,-0.0486437380313873,-0.4256193339824677,-0.0754015594720840,0.1991343349218369,0.0650824233889580,0.0828495621681213,-0.0835029110312462,-0.0316090695559978) * MODEL21_texOff(vec2(-1,1));
res += mat4(-0.0260196980088949,-0.1864022314548492,-0.0310866907238960,-0.0623466856777668,-0.0642979294061661,-0.1373288780450821,-0.0159831158816814,-0.0124002248048782,0.0798067525029182,0.1961414515972137,0.1806756108999252,-0.1208630427718163,-0.0814799442887306,0.0403802730143070,-0.0328070558607578,-0.1056066974997520) * MODEL22_texOff(vec2(-1,1));
res += mat4(-0.0299819316715002,-0.0889745429158211,0.0569998808205128,0.0332611165940762,0.0115742832422256,0.1793977320194244,0.0184927303344011,0.2229049056768417,-0.0112913632765412,-0.0566435828804970,0.0235551521182060,-0.0210226234048605,-0.0147442752495408,-0.0738831833004951,-0.0232846438884735,-0.2047595083713531) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.0327938608825207,-0.0907200723886490,-0.0786106139421463,-0.1022977158427238,-0.0338565595448017,0.0219198167324066,0.0460100173950195,-0.0048057329840958,0.0835243389010429,-0.1593090891838074,0.0768458098173141,-0.2045104503631592,0.0142094166949391,0.0893841013312340,0.0081078819930553,0.0187870431691408) * MODEL24_texOff(vec2(-1,1));
res += mat4(0.0743091925978661,0.1794881671667099,-0.0103652523830533,-0.0236152894794941,0.0288069024682045,0.0337621532380581,-0.2239373475313187,-0.2287402004003525,0.0656228065490723,-0.1356081217527390,-0.0215050932019949,-0.0495702549815178,-0.0080893067643046,-0.0129955671727657,-0.0376574248075485,-0.1526909023523331) * MODEL21_texOff(vec2(0,-1));
res += mat4(0.1155378967523575,0.0461832843720913,0.0694100186228752,0.0977504998445511,0.1158053204417229,-0.4835779368877411,-0.1165023297071457,-0.3830997645854950,-0.0268404856324196,0.1766329109668732,-0.0935022532939911,0.2643847167491913,0.1049658805131912,-0.2734475135803223,0.1369055956602097,-0.1859778463840485) * MODEL22_texOff(vec2(0,-1));
res += mat4(0.0853447467088699,-0.2528608143329620,0.1267696619033813,-0.2803182601928711,-0.0168390404433012,-0.0977839827537537,-0.0200390461832285,-0.0927241444587708,0.2636003494262695,-0.3587063848972321,0.0953568816184998,-0.2884494066238403,0.0479793325066566,-0.0213569868355989,0.1081461161375046,0.1447212696075439) * MODEL23_texOff(vec2(0,-1));
res += mat4(0.0436067730188370,-0.1798084676265717,-0.0948345884680748,-0.2366777062416077,0.0355512723326683,0.0659205242991447,0.0968739762902260,0.0681645944714546,-0.0963704809546471,-0.2047032862901688,0.0296659562736750,0.2185016721487045,0.0729882717132568,-0.2979782521724701,0.0987690463662148,0.1509135216474533) * MODEL24_texOff(vec2(0,-1));
res += mat4(-0.3182998895645142,0.3356809318065643,0.0111110834404826,0.0150333689525723,0.1041853725910187,0.4490790963172913,0.0896795317530632,-0.0866959914565086,0.0392647124826908,-0.1925222277641296,0.1741016954183578,-0.4646819829940796,0.0497794710099697,-0.5663666725158691,-0.2714867889881134,-0.0592256747186184) * MODEL21_texOff(vec2(0,0));
res += mat4(0.1111427769064903,-0.1000821515917778,-0.0178503897041082,-0.1479834318161011,-0.1389848440885544,-1.0152058601379395,0.0488378591835499,-0.9044187664985657,-0.0814175009727478,0.1881174147129059,0.1010084003210068,-0.0512255541980267,-0.2274746447801590,0.1815966516733170,0.1712158620357513,0.4774157404899597) * MODEL22_texOff(vec2(0,0));
res += mat4(-0.0059305485337973,-0.1144885420799255,-0.2710224986076355,-0.1402731090784073,0.1813898980617523,-0.2947344481945038,-0.1376086026430130,0.0725278779864311,-0.3061678409576416,-0.5112835168838501,0.0217667482793331,-0.8153681159019470,-0.0844952687621117,-0.2149795889854431,0.1889654546976089,-1.2212493419647217) * MODEL23_texOff(vec2(0,0));
res += mat4(-0.0341001749038696,-0.1420918703079224,0.1134353876113892,-0.4964024424552917,-0.1400564312934875,-0.1850375086069107,-0.0509905591607094,-0.3107085227966309,-0.1972130686044693,-0.2262127101421356,-0.2440759539604187,-0.9205277562141418,0.0067904163151979,-0.1521847695112228,-0.0305872578173876,-0.1767082661390305) * MODEL24_texOff(vec2(0,0));
res += mat4(0.1605410724878311,0.3388625383377075,0.0714963674545288,-0.1148637980222702,-0.0052194483578205,-0.0250399727374315,0.0900572389364243,-0.2010394185781479,-0.0373205728828907,0.2243118286132812,0.0030151007231325,-0.2477314919233322,-0.0448656566441059,-0.1584238708019257,-0.0071867620572448,-0.1099929586052895) * MODEL21_texOff(vec2(0,1));
res += mat4(0.2631414830684662,0.1322173625230789,0.0458182729780674,-0.3096752762794495,-0.0986642092466354,-0.0550793372094631,0.0348238013684750,-0.1960585862398148,0.0001171030016849,-0.0951457470655441,-0.0208438690751791,0.3503931760787964,-0.1294434219598770,-0.2129892706871033,-0.0337771810591221,-0.3645725846290588) * MODEL22_texOff(vec2(0,1));
res += mat4(0.0230048038065434,-0.3137907087802887,-0.0455664396286011,-0.3168298602104187,-0.1254154592752457,-0.3636295497417450,0.0555187463760376,-0.5812803506851196,0.0968207567930222,0.0430275276303291,0.0260681677609682,0.0166934933513403,-0.0593838915228844,-0.0298860482871532,-0.0491982251405716,0.1096109300851822) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.0425861254334450,0.2389982491731644,-0.2154820412397385,0.0344516113400459,0.0133962258696556,0.1938802748918533,-0.0303258616477251,0.1895022094249725,0.1505155861377716,-0.2698439359664917,0.0434911847114563,-0.0383978523313999,-0.0998124107718468,-0.0785168483853340,0.0346746817231178,-0.3279105126857758) * MODEL24_texOff(vec2(0,1));
res += mat4(-0.0323498025536537,0.0846708193421364,0.0160553399473429,0.0838855579495430,0.0505255311727524,0.0333184413611889,0.0966457277536392,-0.0295467507094145,0.0452348515391350,-0.0351583436131477,-0.0023901220411062,-0.0617642849683762,-0.1099836751818657,0.0652595907449722,-0.1435693353414536,0.0057237530127168) * MODEL21_texOff(vec2(1,-1));
res += mat4(-0.0193974375724792,0.0016734238015488,0.0061322576366365,0.1420889347791672,0.1173601076006889,-0.2071816623210907,-0.0622596442699432,-0.1906256228685379,-0.0246932730078697,-0.0615690983831882,0.1726177930831909,-0.2643700242042542,-0.0333817377686501,0.0129060298204422,0.0331733487546444,-0.1577276885509491) * MODEL22_texOff(vec2(1,-1));
res += mat4(0.0801763385534286,-0.0372839346528053,-0.0168425142765045,-0.2399083971977234,-0.0189349614083767,0.0942898318171501,-0.0729247778654099,-0.0238776616752148,0.1150797605514526,0.1397802680730820,-0.0183684974908829,0.1276283115148544,-0.0157978404313326,-0.0528203174471855,-0.1145365387201309,0.1804308444261551) * MODEL23_texOff(vec2(1,-1));
res += mat4(0.0500828027725220,-0.0335871949791908,-0.2075745761394501,-0.1354399025440216,-0.0421485789120197,-0.1626830250024796,-0.0355155467987061,0.2916752696037292,0.0702783986926079,0.1286368221044540,0.0692304298281670,-0.0455261133611202,-0.0741670653223991,-0.0544008165597916,-0.0917922481894493,-0.0997074395418167) * MODEL24_texOff(vec2(1,-1));
res += mat4(-0.0355155616998672,-0.0909207761287689,-0.1253741830587387,0.1635140925645828,0.1276675611734390,-0.0806095600128174,-0.1514761596918106,0.0043431958183646,0.0002952353679575,-0.0139419650658965,0.0475891306996346,0.0351057685911655,-0.0728895291686058,-0.1997010409832001,-0.0971152633428574,-0.1916919946670532) * MODEL21_texOff(vec2(1,0));
res += mat4(0.1372255682945251,-0.0207272171974182,0.0889865458011627,-0.2631049454212189,-0.2188265025615692,0.0158922318369150,0.1334166079759598,-0.0689261108636856,0.0453482381999493,-0.0496409982442856,-0.2181027680635452,0.1843331903219223,-0.1296746879816055,0.0919201672077179,-0.1342144906520844,0.1672039926052094) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.1896142363548279,-0.0512465536594391,0.0234036892652512,-0.1613356769084930,0.0824260115623474,0.1054236441850662,0.0918725058436394,-0.3392824828624725,0.1978214532136917,0.0938010141253471,0.0898380726575851,-0.0236080754548311,-0.0496704280376434,-0.2935241758823395,0.0667751133441925,-0.0413334220647812) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.2518352568149567,-0.0967062264680862,-0.0311718937009573,-0.1696653813123703,0.0618922710418701,-0.1388243883848190,-0.1375103592872620,-0.0170210711658001,-0.1778676807880402,-0.0918823927640915,0.0683643892407417,0.1721435934305191,-0.0004981383099221,-0.0015442923177034,0.0468944981694221,-0.2256978154182434) * MODEL24_texOff(vec2(1,0));
res += mat4(0.0285391937941313,-0.0687587484717369,-0.0310993380844593,0.0689143836498260,-0.0630959719419479,-0.0410000756382942,0.0744176656007767,0.1270437687635422,-0.0114579461514950,-0.1284157335758209,0.0115379542112350,-0.2296856939792633,-0.0008102712454274,0.0451832450926304,0.0238849166780710,-0.1001020148396492) * MODEL21_texOff(vec2(1,1));
res += mat4(0.1745711863040924,-0.1091389134526253,0.1056216657161713,-0.2693535089492798,0.0516469962894917,-0.0944463908672333,-0.1669354140758514,-0.2559992372989655,-0.1755313277244568,0.0471935942769051,0.1343710720539093,-0.0531820692121983,-0.0740357264876366,0.0620074383914471,0.0233539957553148,0.1963060945272446) * MODEL22_texOff(vec2(1,1));
res += mat4(0.0198090206831694,-0.0145830921828747,0.0248054042458534,0.0190177466720343,0.0270872525870800,0.1001457944512367,-0.1013614386320114,-0.2797769010066986,0.0309396479278803,-0.0560803562402725,-0.0174046792089939,0.0804931297898293,0.0086273970082402,0.1054844632744789,-0.0108949420973659,0.0660903900861740) * MODEL23_texOff(vec2(1,1));
res += mat4(-0.0267767459154129,-0.2279723435640335,0.0914289280772209,0.0536161959171295,-0.1565176099538803,-0.1910002529621124,0.0184659957885742,-0.0085408445447683,0.1435611546039581,0.0478647537529469,-0.0153546296060085,-0.1074507609009743,-0.0590481050312519,-0.0880034863948822,-0.0324065126478672,-0.1419066786766052) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(0.1263981312513351,0.1096418797969818,0.0206240471452475,0.0498061478137970) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) mapping 4_4
//!BIND MODEL21
//!BIND MODEL22
//!BIND MODEL23
//!BIND MODEL24
//!SAVE MODEL4
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.6117309331893921,-0.2601747810840607,-0.1224166676402092,-0.0921374112367630);
res += mat4(0.0588301829993725,0.1117252707481384,0.0290296375751495,-0.0075088986195624,-0.2325710505247116,-0.0747735947370529,0.0284211989492178,0.0291971098631620,-0.0733436122536659,-0.0913104042410851,0.0549855045974255,-0.0942513719201088,-0.1460192650556564,0.1396849751472473,0.0367813184857368,-0.1054962798953056) * MODEL21_texOff(vec2(-1,-1));
res += mat4(-0.0784313306212425,-0.0461387373507023,-0.0727669522166252,0.0118116578087211,-0.1512983143329620,-0.0355164147913456,0.0369271598756313,-0.0068201655521989,-0.2708147764205933,-0.1983853131532669,-0.3019596636295319,-0.1962331533432007,0.0822714418172836,-0.0831912979483604,-0.0377775803208351,0.0309812836349010) * MODEL22_texOff(vec2(-1,-1));
res += mat4(-0.3031086027622223,-0.2022219151258469,0.0690917819738388,0.0061479001305997,-0.0775924474000931,0.0018291157903150,0.0206548795104027,0.0031519813928753,-0.0045580794103444,0.1408297717571259,0.0968878120183945,-0.0543158203363419,-0.0320595875382423,-0.0856794491410255,-0.0074029173702002,-0.0381582640111446) * MODEL23_texOff(vec2(-1,-1));
res += mat4(0.0502191707491875,-0.0144976442679763,-0.0172777995467186,0.0511240437626839,-0.1379772424697876,0.0781990662217140,-0.0490357093513012,0.0095915235579014,0.0698529779911041,-0.1821251213550568,0.0341909043490887,0.0522364303469658,0.3007288575172424,0.5696339011192322,0.0366077609360218,0.1034736111760139) * MODEL24_texOff(vec2(-1,-1));
res += mat4(-0.0080737425014377,-0.0355745144188404,0.0014717100420967,0.0775283500552177,0.0521322488784790,0.0694085732102394,-0.0287078022956848,0.0724895447492599,-0.3758259117603302,0.2388086169958115,-0.2982285916805267,0.0783643573522568,-0.3888894319534302,-0.1828081458806992,0.0064303274266422,-0.0228065531700850) * MODEL21_texOff(vec2(-1,0));
res += mat4(0.1062617301940918,-0.1536732017993927,0.1790993064641953,-0.1221694126725197,-0.0649711787700653,-0.0404628328979015,0.0378675349056721,0.0112943490967155,-0.1770968586206436,-0.0647308602929115,0.0703201144933701,-0.0830667614936829,0.1437005847692490,0.2010622769594193,-0.1075596585869789,0.0721796378493309) * MODEL22_texOff(vec2(-1,0));
res += mat4(-0.4432499110698700,0.0662404224276543,-0.0012972981203347,-0.0641796439886093,-0.1632681190967560,0.2097074985504150,0.0027037130203098,0.0656440407037735,-0.1145439520478249,-0.0657788291573524,0.0632528811693192,0.0139947058632970,-0.3886598050594330,0.0857761129736900,-0.1246560290455818,-0.0749224871397018) * MODEL23_texOff(vec2(-1,0));
res += mat4(-0.1543783098459244,-0.0005317142349668,0.0304446890950203,-0.0185355897992849,-0.0794916823506355,-0.0090007977560163,0.0349782891571522,-0.0200218036770821,-0.0618562102317810,-0.0984001308679581,-0.0182003285735846,-0.0028434169944376,0.2633704543113708,0.1335592716932297,0.0175556372851133,0.0097391176968813) * MODEL24_texOff(vec2(-1,0));
res += mat4(-0.1916415244340897,0.0176885668188334,-0.0010301425354555,-0.0303842704743147,0.4026271402835846,0.0028871756512672,0.0946683585643768,0.0258910451084375,-0.2777474820613861,-0.1369234770536423,0.1530053317546844,0.0188194774091244,0.0261684823781252,-0.0732094198465347,0.0251430086791515,-0.0204035751521587) * MODEL21_texOff(vec2(-1,1));
res += mat4(-0.2784962654113770,0.0650645866990089,-0.0385713949799538,0.0038350508548319,0.1441659182310104,0.0722042471170425,-0.0898543149232864,0.0076085105538368,-0.1453610211610794,-0.1651353538036346,-0.0508589819073677,0.0093160448595881,0.0937918201088905,-0.0456123910844326,0.0581589378416538,0.0176383275538683) * MODEL22_texOff(vec2(-1,1));
res += mat4(-0.0702055096626282,-0.0406810194253922,-0.0525443106889725,0.0150361964479089,0.1566798388957977,-0.0621452368795872,0.0586791262030602,-0.0347721055150032,-0.1604612320661545,0.1239183172583580,-0.0497633032500744,0.0080846343189478,-0.0567909032106400,0.0014030648162588,0.0475553460419178,-0.0038453373126686) * MODEL23_texOff(vec2(-1,1));
res += mat4(-0.1280421465635300,-0.0095578841865063,-0.0669014528393745,0.0325631424784660,-0.0902950242161751,-0.0520857498049736,-0.0410674624145031,0.0060283262282610,-0.2110912352800369,0.2167985439300537,-0.0017860599327832,0.0106685347855091,0.0589333102107048,0.0673409774899483,0.1835579872131348,-0.0222739614546299) * MODEL24_texOff(vec2(-1,1));
res += mat4(0.3193575441837311,0.1526530683040619,0.0688570886850357,-0.0523017607629299,-0.0355069674551487,-0.0414056740701199,0.0593797154724598,-0.1457111537456512,0.1123095601797104,0.0547662116587162,-0.0618266090750694,0.0241949036717415,-0.5081633329391479,0.2198492884635925,-0.2311547696590424,0.0886767283082008) * MODEL21_texOff(vec2(0,-1));
res += mat4(0.0350187979638577,0.1337995529174805,-0.1493063867092133,-0.0603591017425060,0.2146350592374802,0.0859285071492195,-0.1323813050985336,-0.0390987657010555,-0.2041820734739304,-0.1156193763017654,0.0565129481256008,0.0598160736262798,-0.0166044365614653,-0.0735203996300697,0.0949761494994164,0.0783202648162842) * MODEL22_texOff(vec2(0,-1));
res += mat4(-0.2893728017807007,-0.2627750039100647,0.3722718954086304,-0.0792744681239128,-0.2059971690177917,0.0250780824571848,-0.0059698885306716,0.0627116337418556,-0.2310166954994202,0.1220641285181046,0.4420708715915680,-0.0523065738379955,0.6394421458244324,0.0480617098510265,-0.1123329624533653,-0.1512102782726288) * MODEL23_texOff(vec2(0,-1));
res += mat4(-0.3148698806762695,-0.2718702256679535,0.0451150685548782,-0.0301917884498835,-0.1496489495038986,0.1856218129396439,-0.0316816195845604,-0.0149062424898148,0.1320873796939850,-0.4058004319667816,0.0752313062548637,-0.0841734260320663,0.0650784373283386,0.2807834744453430,0.1322926729917526,0.2572420537471771) * MODEL24_texOff(vec2(0,-1));
res += mat4(-0.5741783976554871,0.0708733573555946,-0.0278440415859222,0.0807770118117332,-0.4908486306667328,-0.0314228646457195,-0.2657569348812103,0.3589760959148407,0.2063553035259247,-0.1892435550689697,0.0999130755662918,-0.0633614584803581,-1.3165725469589233,-0.2463347613811493,-0.0429119206964970,-0.0830666646361351) * MODEL21_texOff(vec2(0,0));
res += mat4(-0.6296326518058777,0.0223524719476700,0.3363357186317444,-0.0321827568113804,0.1343389004468918,-0.0002569323114585,0.3277089595794678,-0.0482071489095688,-0.7526341080665588,-0.4833517670631409,-0.1878197491168976,0.0168213583528996,0.5115908384323120,0.3069213628768921,-0.0195354912430048,0.2755083739757538) * MODEL22_texOff(vec2(0,0));
res += mat4(0.4816035926342010,-0.0118750659748912,-0.5715824961662292,0.3641453385353088,-0.2267543822526932,0.3607449531555176,0.1609801650047302,0.0312804840505123,-1.1321628093719482,-0.0340943932533264,0.5982204079627991,-0.0645050927996635,-0.9616246819496155,-0.0790921300649643,0.0994648709893227,-0.0525478385388851) * MODEL23_texOff(vec2(0,0));
res += mat4(-0.1681258827447891,0.3006833493709564,-0.1290128231048584,0.0994041785597801,0.0419847816228867,-0.0162974465638399,0.0750185772776604,0.0067303152754903,-0.5632289052009583,-0.6013663411140442,0.1094968020915985,-0.0669717490673065,-0.0433492772281170,0.1537660658359528,0.2179587930440903,0.2389836013317108) * MODEL24_texOff(vec2(0,0));
res += mat4(-0.1355514526367188,0.0764053314924240,0.0782326161861420,0.0052023138850927,-0.0493257232010365,-0.0347116813063622,0.2622268795967102,-0.0836203470826149,0.2588089704513550,0.0903544947504997,-0.1340770274400711,-0.0735411271452904,-0.8339405655860901,-0.3164103925228119,0.0937255769968033,0.0183939673006535) * MODEL21_texOff(vec2(0,1));
res += mat4(-0.0299103204160929,0.2381526976823807,-0.0743641108274460,0.0692583620548248,0.2554559111595154,0.0813719108700752,-0.1800950467586517,-0.0378679186105728,-0.7257626652717590,-0.1854881495237350,-0.0862643644213676,-0.0597154051065445,-0.2556095719337463,-0.1928845345973969,0.0932397618889809,-0.0223879218101501) * MODEL22_texOff(vec2(0,1));
res += mat4(-0.3263361155986786,-0.0260708797723055,-0.1460820287466049,-0.0375549383461475,-0.6202657222747803,0.0670073628425598,0.1381717473268509,-0.0525274127721786,0.0015859459526837,0.0923536643385887,-0.0649344399571419,0.0501156300306320,0.1358997970819473,0.1016764789819717,-0.0658142641186714,0.0008362260996364) * MODEL23_texOff(vec2(0,1));
res += mat4(-0.1045667529106140,-0.1845665425062180,0.1492197811603546,-0.0243269335478544,0.2153147906064987,0.0400264747440815,-0.0199366249144077,-0.0087428214028478,0.2773247361183167,0.2803338170051575,-0.3493885695934296,0.0705009847879410,-0.0007065620156936,0.0782219246029854,0.1402112096548080,-0.0266525372862816) * MODEL24_texOff(vec2(0,1));
res += mat4(-0.0687473416328430,-0.0976584330201149,-0.0204729977995157,0.0394477620720863,-0.0760568827390671,-0.1528743654489517,-0.0427904799580574,-0.0270075369626284,-0.0428314357995987,0.1161894425749779,0.0378351584076881,-0.0166105981916189,-0.3585070669651031,0.0260688569396734,-0.0470666438341141,-0.0668430775403976) * MODEL21_texOff(vec2(1,-1));
res += mat4(-0.2025795578956604,-0.1040630340576172,0.0077593000605702,-0.0085673155263066,0.2008401304483414,0.0450796410441399,-0.0514111481606960,0.0697687268257141,-0.8376560807228088,-0.0572007037699223,0.0195921938866377,-0.0302999522536993,0.1791645884513855,0.0291367080062628,0.0256281513720751,0.1226494833827019) * MODEL22_texOff(vec2(1,-1));
res += mat4(0.2643510997295380,-0.1555069983005524,-0.0438335798680782,-0.0753439068794250,-0.0654477328062057,-0.1468031555414200,0.0201415866613388,0.0347742103040218,0.4952626526355743,0.0354427844285965,0.1585405319929123,0.0533435493707657,-0.1004230752587318,-0.0073178131133318,-0.0025874432176352,-0.0168156363070011) * MODEL23_texOff(vec2(1,-1));
res += mat4(0.0305943284183741,-0.0923460796475410,0.2677863836288452,-0.1577823907136917,-0.1658991575241089,0.1487926542758942,-0.0842318758368492,0.1213353276252747,0.1446245312690735,0.1689673364162445,0.1651263386011124,0.0070332037284970,-0.1205493360757828,0.0841202288866043,0.0706500336527824,0.1018933504819870) * MODEL24_texOff(vec2(1,-1));
res += mat4(0.0058475290425122,-0.0147246504202485,-0.0711641162633896,0.0262836534529924,-0.1645931154489517,-0.0062692351639271,-0.0730468332767487,-0.0025198473595083,-0.0626813247799873,-0.0695614293217659,0.0290160402655602,-0.0316769331693649,-0.6183116436004639,-0.0400702990591526,-0.1214808225631714,0.0002649093512446) * MODEL21_texOff(vec2(1,0));
res += mat4(0.1040114238858223,0.0050341086462140,0.1487061679363251,-0.0124844061210752,-0.0512321032583714,-0.0299732834100723,0.0485554710030556,0.0502416752278805,-0.7323374152183533,0.0262728352099657,-0.2605053484439850,-0.0820339992642403,0.3148089647293091,0.0988902598619461,-0.0878399088978767,0.0049472432583570) * MODEL22_texOff(vec2(1,0));
res += mat4(-0.6670171618461609,-0.0419046916067600,-0.1335263699293137,-0.1558401286602020,0.3467949926853180,0.0999339222908020,0.0650746077299118,0.0115758376196027,0.2258281856775284,0.0860922858119011,0.0232560746371746,-0.0429502837359905,0.0903110504150391,-0.0678725913167000,-0.0120888268575072,-0.0215729400515556) * MODEL23_texOff(vec2(1,0));
res += mat4(-0.9070100188255310,0.2937509715557098,-0.2831438779830933,0.1536857038736343,-0.3677567541599274,-0.0543512813746929,0.0991915985941887,-0.0454416386783123,-0.0357653610408306,0.0163458101451397,-0.0842088386416435,-0.0565353184938431,-0.3366691768169403,0.1085810437798500,0.0516485534608364,0.0113117303699255) * MODEL24_texOff(vec2(1,0));
res += mat4(-0.0568292513489723,0.0104662915691733,0.0623478703200817,-0.0014252853579819,-0.0979081839323044,0.0609358027577400,0.1053483039140701,0.0708121657371521,-0.1396476030349731,0.0478940345346928,-0.0240719709545374,0.0486258938908577,-0.0907382741570473,-0.0414548330008984,0.0288387108594179,-0.0126393558457494) * MODEL21_texOff(vec2(1,1));
res += mat4(-0.5088644623756409,0.1501386016607285,-0.0918121039867401,-0.0677468329668045,-0.0786677002906799,-0.1030455604195595,0.0109195560216904,-0.0461675822734833,-0.4709203541278839,-0.2292010337114334,0.1345106065273285,-0.0504489876329899,0.0237664654850960,-0.0646439492702484,-0.0267701372504234,0.0238957721740007) * MODEL22_texOff(vec2(1,1));
res += mat4(-0.0895369723439217,-0.0949736088514328,-0.0357055142521858,0.0383817180991173,0.1084862425923347,-0.0324429087340832,-0.0470693334937096,0.0320119112730026,-0.0884663164615631,0.0110423937439919,-0.0695655867457390,-0.0641552731394768,-0.0534201189875603,0.1069035902619362,-0.0068280585110188,-0.0280597191303968) * MODEL23_texOff(vec2(1,1));
res += mat4(0.0298939421772957,-0.2368630617856979,0.1043336987495422,-0.0642990842461586,0.1983366906642914,0.0042332601733506,-0.0626417845487595,0.0139195146039128,-0.0387627035379410,0.0920238122344017,-0.0391244664788246,-0.0123970182612538,-0.0278437342494726,-0.0243430268019438,0.0272651109844446,-0.0030155780259520) * MODEL24_texOff(vec2(1,1));
res = max(res, vec4(0.0)) + vec4(-0.0744055807590485,0.0582032799720764,0.1600257009267807,0.2022268623113632) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) sub-band residuals 1
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!BIND FEATURE1
//!SAVE RES1
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0218873005360365,-0.0149576151743531,-0.0256180185824633,-0.0858701169490814);
res += mat4(0.0221681538969278,-0.2356450855731964,0.0643408298492432,-1.1138032674789429,0.1064624637365341,-0.8914715647697449,-0.0294173005968332,-0.0022653567139059,-0.0252699330449104,-0.1230333074927330,-0.0858245044946671,0.0581396929919720,0.0181231293827295,0.1111536994576454,0.0935193970799446,-0.0742835476994514) * MODEL1_texOff(0);
res += mat4(0.0736283138394356,0.0147979715839028,0.0464740432798862,-0.2148900032043457,0.4483453333377838,0.2830028533935547,0.0562076941132545,0.3613960742950439,0.0668433532118797,-0.2692199349403381,0.0970326364040375,0.1248507574200630,0.0208180323243141,0.0532030761241913,-0.0098368674516678,0.0498967394232750) * MODEL2_texOff(0);
res += mat4(-0.0427469126880169,0.1918861865997314,-0.0468214377760887,-0.1154606193304062,-0.8018212318420410,0.3941400647163391,0.0562537945806980,0.2459305673837662,-0.0034576300531626,-0.4044605493545532,0.0631769001483917,0.2570861279964447,0.3880051076412201,0.2102442532777786,0.1035031601786613,-0.1845092624425888) * MODEL3_texOff(0);
res += mat4(-0.0736504569649696,-0.4329134225845337,-0.0331883579492569,0.4859155714511871,0.0300663169473410,-0.1431413143873215,0.0900689288973808,0.0027509836945683,-0.0178727619349957,-0.1037448570132256,-0.0429062619805336,0.0104557601734996,-0.0787484720349312,0.0334280952811241,-0.0210850816220045,-0.2790249288082123) * MODEL4_texOff(0);
res += FEATURE1_texOff(0);
res = max(res, vec4(0.0)) + vec4(-0.0009421827271581,0.0372365266084671,0.5457454919815063,-0.0045580286532640) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) sub-band residuals 2
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!BIND FEATURE2
//!SAVE RES2
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0132746873423457,0.0731124207377434,0.0296694040298462,-0.0570529401302338);
res += mat4(0.0329166017472744,0.0485021844506264,-0.4523101150989532,-0.0322404317557812,-0.0172702632844448,-0.0456021204590797,-0.3700943291187286,0.0706288889050484,-0.0264692343771458,0.0057114795781672,0.1072568818926811,-0.0367026627063751,0.0059698573313653,0.0111432811245322,-0.1592733412981033,-0.0146981095895171) * MODEL1_texOff(0);
res += mat4(-0.0338360369205475,-0.1407372504472733,0.8440989255905151,0.2665281593799591,-0.0766022056341171,0.1776377707719803,0.6822218894958496,-0.2348744422197342,-0.0140444673597813,-0.0049600838683546,-0.1120925694704056,0.0485411062836647,0.0048136659897864,-0.0084126451984048,0.0507854782044888,0.0059754410758615) * MODEL2_texOff(0);
res += mat4(0.0534943863749504,-0.0054587344639003,-0.2227865755558014,0.0236868932843208,0.0262969471514225,0.1232359185814857,0.1288655251264572,-0.1138820722699165,-0.0812139436602592,-0.0455541759729385,0.0849144086241722,0.0463144332170486,-0.1888351738452911,-0.4850543141365051,-0.1564003974199295,0.2618831992149353) * MODEL3_texOff(0);
res += mat4(-0.0221897140145302,0.0031840829178691,0.1487526446580887,-0.0075739510357380,-0.0042014098726213,0.0185069050639868,-0.0972303748130798,-0.0048297117464244,-0.0396384298801422,-0.0136362798511982,0.1502435356378555,0.0022969150450081,0.0987038090825081,-0.0011944774305448,-0.3419188559055328,0.0331442765891552) * MODEL4_texOff(0);
res += FEATURE2_texOff(0);
res = max(res, vec4(0.0)) + vec4(1.1018482446670532,0.9337472915649414,0.0558062084019184,1.0061426162719727) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) sub-band residuals 3
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!BIND FEATURE3
//!SAVE RES3
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0231755860149860,-0.0123003274202347,-0.0431877225637436,-0.0482062324881554);
res += mat4(0.0061688339337707,-0.3225260674953461,-0.1020668447017670,0.0756559520959854,0.0190322343260050,0.0429529212415218,0.0133566455915570,-0.0357269980013371,-0.0511975735425949,0.0205178000032902,0.0802695825695992,-0.0699724704027176,0.0727552399039268,-0.0051232990808785,-0.0231811776757240,0.0385252349078655) * MODEL1_texOff(0);
res += mat4(0.0003796273667831,-0.1514156907796860,-0.0766110196709633,0.0278693865984678,0.3816023766994476,0.1842953413724899,-0.3427250981330872,-0.0513318441808224,0.0783963724970818,0.1034169569611549,0.1413960307836533,0.1308334171772003,0.0067153824493289,0.0158144067972898,-0.0463985614478588,0.1229471415281296) * MODEL2_texOff(0);
res += mat4(0.1385668069124222,-0.3332454562187195,-0.0325091183185577,-0.0500471331179142,0.0109276790171862,0.1346410959959030,-0.2194238454103470,-0.3841372132301331,0.2030243873596191,0.0367027409374714,0.0746235847473145,0.0858945399522781,-0.0915820300579071,0.4482104778289795,-0.3705481290817261,-0.4631932377815247) * MODEL3_texOff(0);
res += mat4(0.0772577896714211,-0.4344681203365326,-0.5865671634674072,-0.9034788608551025,0.0337008647620678,-0.0119147822260857,0.0028720106929541,0.0309769921004772,-0.0911888480186462,0.2908170223236084,0.0235594492405653,0.0098438179120421,0.0186014920473099,-0.0568258389830589,-0.0455871261656284,-0.1069583073258400) * MODEL4_texOff(0);
res += FEATURE3_texOff(0);
res = max(res, vec4(0.0)) + vec4(0.0984692946076393,-0.0528433769941330,0.1861927509307861,-0.0793913379311562) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) sub-band residuals 4
//!BIND MODEL1
//!BIND MODEL2
//!BIND MODEL3
//!BIND MODEL4
//!BIND FEATURE4
//!SAVE RES4
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(-0.0254043601453304,-0.0337074063718319,0.0073674134910107,-0.0777111053466797);
res += mat4(-0.0152108408510685,-0.0290673710405827,0.0152149023488164,0.0001182962441817,-0.0191980488598347,0.0593055188655853,-0.1341477930545807,-0.0611830428242683,-0.0543372966349125,0.0298834946006536,0.1418028175830841,-0.2027935534715652,0.0062750629149377,0.0106279915198684,0.0231198258697987,-0.0041293469257653) * MODEL1_texOff(0);
res += mat4(0.1140645742416382,-0.1693866401910782,-0.5153092145919800,-0.1875651776790619,-0.0672051906585693,0.6262952089309692,0.5045496225357056,-0.0827279761433601,0.0161168053746223,-0.1674159020185471,-0.1741122007369995,0.0655852109193802,-0.0021867123432457,-0.1953728497028351,-0.0054047326557338,-0.0233427695930004) * MODEL2_texOff(0);
res += mat4(0.0293430704623461,-0.0239756125956774,-0.0894790217280388,-0.3600888848304749,0.0042837061919272,0.0316841900348663,0.1484906524419785,0.0149612911045551,0.0249301753938198,-0.0022203570697457,-0.0415629185736179,0.0302883405238390,0.0327147059142590,-0.1360170692205429,-0.1607593148946762,-0.6076013445854187) * MODEL3_texOff(0);
res += mat4(-0.0638960301876068,0.0897183865308762,0.0621560215950012,-0.5748775005340576,0.0110273323953152,-0.0082545885816216,-0.0169698987156153,0.0448103360831738,-0.0238428302109241,-0.0090155471116304,0.0205770675092936,-0.0579754747450352,0.0513568818569183,0.0123459398746490,-0.1044728681445122,0.1379940360784531) * MODEL4_texOff(0);
res += FEATURE4_texOff(0);
res = max(res, vec4(0.0)) + vec4(0.9187455177307129,0.3813512325286865,1.0033930540084839,0.1104508787393570) * min(res, vec4(0.0));
return res;
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!DESC (FSRCNNX_x2_16-0-4-1) sub-pixel convolution 1
//!BIND RES1
//!BIND RES2
//!BIND RES3
//!BIND RES4
//!SAVE SUBCONV1
//!COMPONENTS 4
vec4 hook()
{
vec4 res = vec4(0.2004896253347397,0.1965623348951340,0.2031263858079910,0.1992818266153336);
res += mat4x4(-0.0094980411231518,0.0023788863327354,-0.0022216471843421,0.0003509943489917,-0.0552016757428646,0.0855648964643478,0.0698453187942505,-0.0073109264485538,-0.0066510867327452,0.0147740254178643,0.0113036027178168,0.0048131505027413,-0.0040690936148167,0.0065816720016301,-0.0004572885518428,-0.0090634562075138) * RES1_texOff(vec2(-1,-1));
res += mat4x4(-0.0134373474866152,0.0051314681768417,0.0116530936211348,0.0104887820780277,0.0247752983123064,-0.0160156358033419,-0.0261716526001692,-0.0161977726966143,0.0369832850992680,-0.1506783068180084,0.0486416928470135,-0.0316048339009285,-0.0061850538477302,0.0044224648736417,0.0053729196079075,0.0004756637790706) * RES2_texOff(vec2(-1,-1));
res += mat4x4(0.0010956295300275,-0.0006739810341969,-0.0023001984227449,-0.0046076728031039,-0.0086221992969513,-0.0076229758560658,-0.0009145328658633,-0.0054856799542904,0.0039743827655911,-0.0010353162651882,-0.0013344871113077,-0.0032652264926583,0.0075248428620398,-0.0015257894992828,-0.0042923530563712,0.0093235671520233) * RES3_texOff(vec2(-1,-1));
res += mat4x4(-0.0021727732382715,0.0007165882270783,-0.0062267961911857,0.0109751019626856,0.0139423953369260,-0.0074228323064744,-0.0275850314646959,-0.0084508210420609,0.0104034338146448,0.0014346154639497,0.0112520074471831,0.0052605904638767,0.0638059675693512,-0.0249607227742672,-0.0104660186916590,-0.0186718292534351) * RES4_texOff(vec2(-1,-1));
res += mat4x4(0.0265536569058895,0.0001271427026950,-0.0261117573827505,-0.0235340055078268,0.3512704372406006,0.0999423563480377,0.0193040892481804,0.1757085025310516,0.0103672035038471,-0.0012839237460867,0.0179779101163149,0.0041811168193817,0.0040395306423306,-0.0499604344367981,0.0245391409844160,0.0226321499794722) * RES1_texOff(vec2(-1,0));
res += mat4x4(0.0384991914033890,-0.0450659804046154,-0.0101390583440661,0.0220608171075583,0.0418405607342720,0.0510034635663033,-0.0249340515583754,-0.0456024855375290,-0.1545022726058960,0.2145315408706665,-0.1191349253058434,-0.0326999053359032,-0.0053544868715107,-0.0073985042981803,0.0037008037324995,0.0099292118102312) * RES2_texOff(vec2(-1,0));
res += mat4x4(-0.0202872715890408,0.0307369828224182,-0.0144446128979325,0.0071235611103475,-0.0376118794083595,0.0325335487723351,-0.0112367551773787,0.0102629121392965,-0.0383120849728584,0.0423947423696518,0.0243418365716934,0.0210620071738958,0.0132888518273830,0.0360053405165672,0.0100925499573350,-0.0135364001616836) * RES3_texOff(vec2(-1,0));
res += mat4x4(-0.0057181096635759,-0.0204568132758141,-0.0183743461966515,-0.0151624437421560,0.0028684337157756,0.0245951302349567,-0.0505386032164097,-0.0526789799332619,-0.0125096822157502,-0.0006854855455458,0.0087874904274940,0.0151118943467736,-0.0449581444263458,0.0157140661031008,0.0004651887866203,0.0124214673414826) * RES4_texOff(vec2(-1,0));
res += mat4x4(-0.0024702695664018,0.0064441123977304,0.0018684890819713,-0.0075190430507064,-0.0822586268186569,0.0438106693327427,0.0218858793377876,-0.0781861469149590,-0.0030735647305846,-0.0170502737164497,0.0035027237609029,0.0147414589300752,-0.0028982846997678,0.0342733748257160,-0.0081898812204599,-0.0086565474048257) * RES1_texOff(vec2(-1,1));
res += mat4x4(-0.0035721133463085,0.0204634200781584,-0.0043158503249288,-0.0032766335643828,-0.0237986985594034,0.0068355891853571,-0.0162488855421543,-0.0227953065186739,0.0675579383969307,-0.0396639332175255,-0.0059354491531849,0.0051652374677360,0.0041596912778914,-0.0034006051719189,0.0025730042252690,0.0046709501184523) * RES2_texOff(vec2(-1,1));
res += mat4x4(0.0174455400556326,-0.0353569723665714,0.0072374437004328,0.0190037265419960,0.0095157930627465,0.0083068385720253,0.0079982848837972,-0.0021254434250295,0.0199435707181692,-0.0410243608057499,0.0019970838911831,-0.0007492507575080,-0.0055135628208518,-0.0148889161646366,0.0085017476230860,0.0147673422470689) * RES3_texOff(vec2(-1,1));
res += mat4x4(0.0040913843549788,0.0095514366403222,0.0025204438716173,-0.0062991455197334,-0.0084351906552911,-0.0107593908905983,-0.0031122143846005,-0.0152742723003030,0.0180264879018068,0.0035381091292948,0.0072233397513628,0.0141055267304182,-0.0047497055493295,0.0139257498085499,0.0008672008989379,0.0056309537030756) * RES4_texOff(vec2(-1,1));
res += mat4x4(-0.0205192342400551,0.0035032271407545,0.0511485636234283,-0.0024385969154537,-0.0881214737892151,0.3079357743263245,-0.3256671428680420,0.2675876915454865,0.0045523792505264,0.0296388268470764,-0.0116298887878656,0.0326066017150879,-0.0258616954088211,-0.0029669052455574,0.0351182892918587,0.0021836776286364) * RES1_texOff(vec2(0,-1));
res += mat4x4(0.0273221414536238,-0.0257267896085978,-0.0050437781028450,-0.0224122107028961,0.0542206130921841,-0.0279902089387178,0.0579320825636387,-0.0361812375485897,0.1095771044492722,-0.1980792731046677,0.0754484012722969,-0.2903145253658295,-0.0108189834281802,0.0070500555448234,-0.0098569672554731,0.0098409783095121) * RES2_texOff(vec2(0,-1));
res += mat4x4(0.0182558707892895,-0.0004734874528367,-0.0078873941674829,-0.0000882323365659,-0.0150029920041561,-0.0083330124616623,-0.0198020357638597,-0.0081914011389017,-0.0084193097427487,0.0029257496353239,-0.0043335305526853,0.0031402623280883,-0.0062353843823075,0.0042604114860296,-0.0014385635731742,-0.0153938829898834) * RES3_texOff(vec2(0,-1));
res += mat4x4(-0.0146446321159601,-0.0020139440894127,-0.0195920094847679,0.0131280329078436,-0.0573658235371113,0.0003872774250340,0.0434953272342682,-0.0096412943676114,0.0132301421836019,-0.0086105931550264,-0.0038419184274971,0.0006242461386137,-0.0479317568242550,0.0343790166079998,0.0496469177305698,0.0063778031617403) * RES4_texOff(vec2(0,-1));
res += mat4x4(-0.0886482372879982,-0.1149815395474434,0.0364607945084572,0.1096290275454521,0.1008122637867928,0.0281752888113260,0.3008427619934082,0.0804056376218796,0.2204556763172150,-0.2482117563486099,0.1546043306589127,-0.0760536938905716,0.0558703318238258,0.0110450601205230,-0.0682374238967896,0.0286046285182238) * RES1_texOff(vec2(0,0));
res += mat4x4(0.0509124360978603,-0.1266279220581055,0.2212082296609879,-0.1488939523696899,0.3209297955036163,0.4181137681007385,0.2016167342662811,0.3663260638713837,-0.0981808155775070,0.1554665118455887,-0.1419739574193954,0.1935243159532547,0.5998122692108154,0.5774222612380981,0.6332547664642334,0.5999547839164734) * RES2_texOff(vec2(0,0));
res += mat4x4(-0.0132361799478531,-0.0487179905176163,0.0883441641926765,-0.0214207563549280,-0.0519132018089294,0.0597040131688118,-0.0639006718993187,0.0623196884989738,0.0265893898904324,-0.0472132489085197,-0.1152362823486328,-0.0002589400392026,0.1015622764825821,0.0238978657871485,-0.0931206196546555,-0.0433236174285412) * RES3_texOff(vec2(0,0));
res += mat4x4(0.1458993703126907,0.0153151275590062,-0.1496266722679138,-0.3040931522846222,-0.1793874502182007,-0.2153502255678177,0.2235168665647507,0.2049497067928314,0.1524304300546646,0.1716024577617645,0.1148274764418602,0.0788738727569580,0.0443262755870819,-0.0094674434512854,0.0095163015648723,-0.0466275624930859) * RES4_texOff(vec2(0,0));
res += mat4x4(-0.0046434928663075,-0.0003897719143424,0.0028130675200373,-0.0085096163675189,-0.1916470676660538,0.2195042073726654,-0.2039673179388046,0.1004208773374557,-0.0287556014955044,0.0299344193190336,-0.0242406297475100,-0.0310826431959867,-0.0059730121865869,0.0066875112242997,0.0053000268526375,-0.0125830061733723) * RES1_texOff(vec2(0,1));
res += mat4x4(0.0447437874972820,-0.0225228350609541,0.0237912647426128,0.0244589075446129,-0.0828435197472572,0.0348524712026119,-0.0545933209359646,0.0271499827504158,0.0855012536048889,0.0196409244090319,0.0961431562900543,-0.0927204564213753,0.0164071917533875,-0.0032793551217765,0.0095342965796590,-0.0037637823261321) * RES2_texOff(vec2(0,1));
res += mat4x4(-0.0116172991693020,0.0510076172649860,-0.0091573577374220,-0.0473218895494938,0.0069195278920233,0.0125233512371778,0.0044246641919017,0.0228615943342447,0.0027514654211700,0.0754077881574631,0.0371949858963490,-0.0247637983411551,-0.0058305920101702,0.0521190911531448,0.0077110137790442,-0.0160914603620768) * RES3_texOff(vec2(0,1));
res += mat4x4(-0.0023388352710754,-0.0146656855940819,0.0021010492928326,-0.0042505273595452,-0.0047369911335409,-0.0313913896679878,0.0011872148606926,0.0643994882702827,0.0725545957684517,-0.0238730907440186,0.0550865903496742,-0.0257390290498734,0.0021659301128238,-0.0376078188419342,-0.0114223891869187,0.0003648806596175) * RES4_texOff(vec2(0,1));
res += mat4x4(0.0165412686765194,0.0023022976238281,-0.0271380208432674,0.0095817185938358,0.0084499921649694,-0.0126049844548106,0.0269258525222540,0.0366241224110126,0.0071499678306282,0.0176498852670193,0.0088612614199519,0.0117251062765718,0.0062044579535723,-0.0003486862697173,0.0034539531916380,0.0026289536617696) * RES1_texOff(vec2(1,-1));
res += mat4x4(-0.0072817839682102,-0.0031623679678887,0.0006788446917199,-0.0174324437975883,-0.0143718319013715,-0.0093826102092862,0.0221808739006519,-0.0059602400287986,-0.0524991862475872,-0.0554307326674461,-0.0234730504453182,-0.0944415479898453,0.0027662173379213,-0.0000003128636763,-0.0070756948553026,0.0003757302765734) * RES2_texOff(vec2(1,-1));
res += mat4x4(-0.0059956023469567,-0.0109885698184371,0.0131031777709723,-0.0064099249430001,-0.0007332267705351,-0.0054377247579396,-0.0042348760180175,-0.0079171815887094,0.0042275548912585,0.0038190928753465,0.0012226465623826,-0.0091538941487670,-0.0047898464836180,0.0020623977761716,0.0052864491008222,-0.0035777383018285) * RES3_texOff(vec2(1,-1));
res += mat4x4(0.0133276600390673,0.0030601196922362,-0.0000833513477119,0.0117228757590055,0.0180890634655952,0.0006835858803242,0.0155890220776200,0.0023330044932663,0.0016764352330938,-0.0001878916082205,0.0077882641926408,0.0030453875660896,0.0007069727871567,-0.0032804955262691,-0.0258806515485048,0.0120186852291226) * RES4_texOff(vec2(1,-1));
res += mat4x4(0.0138642648234963,0.0450335033237934,0.0573485493659973,-0.0283165313303471,-0.0353950075805187,-0.0246198587119579,0.1079513281583786,-0.0786227360367775,-0.0199374537914991,-0.0203778892755508,0.0989598408341408,-0.1151264309883118,-0.0075402003712952,0.0069887228310108,-0.0005508214817382,-0.0211458336561918) * RES1_texOff(vec2(1,0));
res += mat4x4(-0.0173939410597086,-0.0076088067144156,-0.0270000118762255,0.0400075353682041,-0.0209513846784830,-0.0395910814404488,0.0813595503568649,0.0521225370466709,-0.1410388797521591,-0.0733730420470238,0.0030183335766196,0.2795495092868805,0.0052713518962264,0.0093284752219915,-0.0111799864098430,-0.0086231678724289) * RES2_texOff(vec2(1,0));
res += mat4x4(-0.0051672095432878,0.0126797044649720,-0.0475894063711166,0.0283157788217068,-0.0130900656804442,0.0079299174249172,-0.0232257433235645,0.0235086344182491,-0.0172755066305399,-0.0176396835595369,0.0426433272659779,-0.0097808614373207,-0.0175288487225771,-0.0215636640787125,-0.0089064724743366,0.0157484728842974) * RES3_texOff(vec2(1,0));
res += mat4x4(0.0398572608828545,0.0358022972941399,-0.0244492460042238,-0.0299847554415464,0.0384783037006855,0.0354996435344219,-0.0414791777729988,0.0031456071883440,0.0217112209647894,0.0295640993863344,-0.0574064217507839,-0.0089215245097876,-0.0100018810480833,0.0062383566983044,-0.0062790168449283,0.0353761576116085) * RES4_texOff(vec2(1,0));
res += mat4x4(0.0005601430893876,-0.0111780380830169,-0.0034504993818700,0.0335592329502106,-0.0091825602576137,-0.0629493743181229,-0.0673106834292412,0.0803333818912506,-0.0166647452861071,-0.0052054836414754,-0.0284464918076992,0.0311517249792814,-0.0081933317705989,-0.0097267255187035,0.0085491342470050,0.0063192397356033) * RES1_texOff(vec2(1,1));
res += mat4x4(0.0045089237391949,0.0023073307238519,0.0163356605917215,-0.0106160407885909,-0.0110078146681190,-0.0141240349039435,-0.0408387668430805,0.0008771637803875,-0.0169897880405188,-0.0579932145774364,0.0061155906878412,-0.0052699390798807,-0.0005207836511545,0.0013564876280725,0.0064209848642349,-0.0011977740796283) * RES2_texOff(vec2(1,1));
res += mat4x4(0.0042469059117138,-0.0113333491608500,-0.0050657880492508,0.0154049899429083,0.0083776470273733,-0.0045062573626637,0.0149497529491782,-0.0006315388600342,-0.0074721821583807,-0.0056236772798002,-0.0164248198270798,0.0365500412881374,0.0061139329336584,0.0037679118104279,-0.0104186907410622,-0.0330689847469330) * RES3_texOff(vec2(1,1));
res += mat4x4(0.0021872087381780,0.0173248164355755,0.0193927604705095,-0.0043931179679930,0.0088961208239198,0.0238487515598536,0.0053819441236556,-0.0194583926349878,0.0060333325527608,0.0123941889032722,0.0321498438715935,-0.0068496093153954,0.0071646152064204,0.0009137570741586,0.0105294361710548,-0.0256906449794769) * RES4_texOff(vec2(1,1));
return vec4(res);
}

//!HOOK LUMA
//!WHEN OUTPUT.w LUMA.w / 1.200 > OUTPUT.h LUMA.h / 1.200 > *
//!WIDTH LUMA.w 2 *
//!HEIGHT LUMA.h 2 *
//!DESC (FSRCNNX_x2_16-0-4-1) aggregation
//!BIND SUBCONV1
vec4 hook()
{
vec2 fcoord = fract(SUBCONV1_pos * SUBCONV1_size);
vec2 base = SUBCONV1_pos + (vec2(0.5) - fcoord) * SUBCONV1_pt;
ivec2 index = ivec2(fcoord * vec2(2));
vec4 res = SUBCONV1_tex(base);
return vec4(res[index.x * 2 + index.y], 0, 0, 1);
}
